/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.converter;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.OrderPositionTransactionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderAcceptationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderPositionMutationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderRecipientTransactionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderRejectionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderTransactionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderAcceptationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderPositionMutationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderRecipientTransactionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderRejectionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderSupplierTransactionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderTransactionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.AFlightStockTransactionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockCheckinComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockCheckoutComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockCheckoutCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockIrregularityCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockIrregularityMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockOutCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockOutMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockReturnCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockReturnMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockWasteCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockWasteMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockCheckinComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockCheckoutComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockInventoryComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockTransactionComplete;

public class StockTransactionStoreConverter
implements Converter<StockTransactionComplete, String> {
    @Override
    public String convert(StockTransactionComplete o, Node<StockTransactionComplete> currentNode, Object ... param) {
        if (o == null) {
            return NULL_RETURN;
        }
        String retString = "";
        if (o instanceof StockCheckinComplete) {
            StockCheckinComplete t = (StockCheckinComplete)o;
            retString = t.getStorePosition() != null ? t.getStorePosition().getStore().getCode() + " - " + t.getStorePosition().getName() : NULL_RETURN;
        } else if (o instanceof StockCheckoutComplete) {
            StockCheckoutComplete t = (StockCheckoutComplete)o;
            retString = t.getStorePosition() != null ? t.getStorePosition().getStore().getCode() + " - " + t.getStorePosition().getName() : NULL_RETURN;
        } else if (o instanceof StockInventoryComplete) {
            StockInventoryComplete t = (StockInventoryComplete)o;
            retString = t.getStorePosition().getStore().getCode() + " - " + t.getStorePosition().getName();
        } else if (o instanceof ManualStockMovementComplete) {
            ManualStockMovementComplete t = (ManualStockMovementComplete)o;
            retString = t.getOriginPosition().getStore().getCode() + " - " + t.getOriginPosition().getName() + " to " + t.getDestinationPosition().getStore().getCode() + " - " + t.getDestinationPosition().getName();
        } else if (o instanceof AFlightStockTransactionComplete) {
            if (o instanceof FlightStockCheckoutComplete) {
                FlightStockCheckoutComplete t = (FlightStockCheckoutComplete)o;
                retString = "";
            } else if (o instanceof FlightStockOutCorrectionComplete) {
                FlightStockOutCorrectionComplete t = (FlightStockOutCorrectionComplete)o;
                retString = t.getRealStorePosition().getStore().getCode() + " - " + t.getRealStorePosition().getName();
            } else if (o instanceof FlightStockIrregularityMovementComplete) {
                FlightStockIrregularityMovementComplete t = (FlightStockIrregularityMovementComplete)o;
                retString = "";
            } else if (o instanceof FlightStockOutMovementComplete) {
                FlightStockOutMovementComplete t = (FlightStockOutMovementComplete)o;
                retString = t.getRealStorePosition().getStore().getCode() + " - " + t.getRealStorePosition().getName();
            } else if (o instanceof FlightStockReturnMovementComplete) {
                FlightStockReturnMovementComplete t = (FlightStockReturnMovementComplete)o;
                retString = t.getRealStorePosition().getStore().getCode() + " - " + t.getRealStorePosition().getName();
            } else if (o instanceof FlightStockWasteMovementComplete) {
                FlightStockWasteMovementComplete t = (FlightStockWasteMovementComplete)o;
                retString = t.getRealStorePosition().getStore().getCode() + " - " + t.getRealStorePosition().getName();
            } else if (o instanceof FlightStockCheckoutCorrectionComplete) {
                retString = "";
            } else if (o instanceof FlightStockIrregularityCorrectionComplete) {
                retString = "";
            } else if (o instanceof FlightStockReturnCorrectionComplete) {
                FlightStockReturnCorrectionComplete t = (FlightStockReturnCorrectionComplete)o;
                retString = t.getRealStorePosition().getStore().getCode() + " - " + t.getRealStorePosition().getName();
            } else if (o instanceof FlightStockWasteCorrectionComplete) {
                FlightStockWasteCorrectionComplete t = (FlightStockWasteCorrectionComplete)o;
                retString = t.getRealStorePosition().getStore().getCode() + " - " + t.getRealStorePosition().getName();
            } else if (o instanceof FlightStockCheckinComplete) {
                FlightStockCheckinComplete c = (FlightStockCheckinComplete)o;
                retString = c.getRealStorePosition().getStore().getCode() + " - " + c.getRealStorePosition().getName();
            }
        } else if (o instanceof OrderPositionTransactionComplete) {
            if (o instanceof PurchaseOrderTransactionComplete) {
                if (o instanceof PurchaseOrderPositionMutationComplete) {
                    retString = "";
                } else if (o instanceof PurchaseOrderRecipientTransactionComplete) {
                    if (o instanceof PurchaseOrderAcceptationComplete) {
                        PurchaseOrderAcceptationComplete t = (PurchaseOrderAcceptationComplete)o;
                        retString = t.getDestinationPosition().getStore().getCode() + " - " + t.getDestinationPosition().getName();
                    } else if (o instanceof PurchaseOrderRejectionComplete) {
                        retString = "";
                    }
                }
            } else if (o instanceof RequisitionOrderTransactionComplete) {
                if (o instanceof RequisitionOrderPositionMutationComplete) {
                    retString = "";
                } else if (o instanceof RequisitionOrderRecipientTransactionComplete) {
                    if (o instanceof RequisitionOrderAcceptationComplete) {
                        RequisitionOrderAcceptationComplete t = (RequisitionOrderAcceptationComplete)o;
                        retString = t.getDestinationPosition().getStore().getCode() + " - " + t.getDestinationPosition().getName();
                    } else if (o instanceof RequisitionOrderRejectionComplete) {
                        retString = null;
                    }
                } else if (o instanceof RequisitionOrderSupplierTransactionComplete) {
                    retString = "";
                }
            }
        }
        return retString;
    }

    @Override
    public Class<? extends StockTransactionComplete> getParameterClass() {
        return StockTransactionComplete.class;
    }
}

