/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.flight;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.node.ServiceReturn;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientActionOnServerException;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightParameterConfig;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.StowagePositionIdentifier;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.importer.FlightImportComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.importer.FlightImportReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountFlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountParameterConfig;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliverySpaceComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.wagon.FlightWagonComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.wagon.ReturnWagonComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.wagon.WagonStockComplete;
import ch.icit.pegasus.server.core.dtos.invoice.FlightInvoiceData;
import ch.icit.pegasus.server.core.dtos.masterdata.AlaCarteMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.ALoadingGroupComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceLight;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.report.FlightCustomsSupplySheetReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.FlightDataReportConfig;
import ch.icit.pegasus.server.core.dtos.retailinmotion.RetailInMotionTransactionDataComplete;
import ch.icit.pegasus.server.core.dtos.search.GalleyEquipmentSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.tracking.FlightSealsComplete;
import ch.icit.pegasus.server.core.dtos.tracking.SealComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.MapWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TrackableItemWrapper;
import ch.icit.pegasus.server.core.services.flight.FlightService;
import ch.icit.pegasus.server.core.services.report.FlightReportService;
import ch.icit.pegasus.server.core.util.ServiceReturnWithMessage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FlightServiceManagerImpl
implements FlightServiceManager {
    @Override
    public ListWrapper<FlightScheduleComplete> getFlightSchedules(ListWrapper<FlightScheduleReference> wrapper, boolean onlyActive) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getFlightSchedules(wrapper, onlyActive);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public ListWrapper<String> getGalleys(FlightReference flightReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getGalleys(flightReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public void addReturnWagon(ListWrapper<ReturnWagonComplete> wagons) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getStatelessService(FlightService.class).addReturnWagon(wagons);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public ListWrapper<WagonStockComplete> getWagonStock() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getWagonStock();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public ListWrapper<FlightWagonComplete> getFlightWagons(FlightReference flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getFlightWagons(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public void updateFlightWagons(FlightReference flight, ListWrapper<FlightWagonComplete> flightWagons) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getStatelessService(FlightService.class).updateFlightWagons(flight, flightWagons);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public void uploadCounts(PegasusFileComplete uploaded, FlightReference flightReference) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getStatelessService(FlightService.class).uploadCounts(uploaded, flightReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<FlightLight> revertAndRecalculateTransaction(FlightReference flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).revertAndRecalculateTransaction(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public void resetRevisedAmount(ListWrapper<FlightReference> flights) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getStatelessService(FlightService.class).resetRevisedAmount(flights);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<FlightComplete> updateInvoicedFlight(FlightComplete flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).updateInvoicedFlight(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public Boolean canCreateFlight(String outBound, TimestampWrapper std, String inbound, TimestampWrapper sta, FlightReference flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).canCreateFlight(outBound, std, inbound, sta, flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public Boolean canCreate(String outBound, TimestampWrapper std, String inbound, TimestampWrapper sta) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).canCreate(outBound, std, inbound, sta);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public TrackableItemWrapper getAssociatedEquipment(SealComplete seal) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getAssociatedEquipment(seal);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<FlightLight> getAssociatedFlight(SealComplete seal) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getAssociatedFlight(seal);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public void updateRiMTransactionsForFlight(ListWrapper<RetailInMotionTransactionDataComplete> transactions) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getStatelessService(FlightService.class).updateRiMTransactionsForFlight(transactions);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public ListWrapper<RetailInMotionTransactionDataComplete> getRiMTransactionsForFlight(FlightReference flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getRiMTransactionsForFlight(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public ListWrapper<CateringServiceLight> getMappedServices(FlightComplete flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getMappedServices(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<FlightScheduleLight> getFlightScheduleLight(FlightScheduleReference flightSchedule) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getFlightScheduleLight(flightSchedule);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ReportFileComplete> getFlightDeliverySlipReportFile(FlightReference flightReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getFlightDeliverySlipReportFile(flightReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<FlightLight> setFlightBackOpen(FlightReference flightReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).setFlightBackOpen(flightReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<FlightLight> reloadFlightData(FlightReference flightReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).reloadFlightData(flightReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public StowingListLight switchStowingList(StowingListLight stowingList, FlightReference flight, List<String> warnings, boolean fromUpdater) throws ClientServerCallException {
        return (StowingListLight)this.switchStowingListFromPersistedFlight(new FlightParameterConfig(new StowingListTemplateReference(stowingList.getTemplate().getId()), null, new FlightReference(flight.getId()), stowingList.getMatriculation(), warnings, fromUpdater)).getValue();
    }

    @Override
    public OptionalWrapper<FlightComplete> createWithAircraft(FlightComplete flight, StowingListTemplateReference stowingList, AircraftReference aircraft, MapWrapper<StowagePositionIdentifier, StowagePositionIdentifier> aircraftMapping, MapWrapper<StowingListTemplateLegComplete, FlightLegComplete> legMapping, ListWrapper<String> warnings) throws ClientServerCallException {
        try {
            OptionalWrapper fw = EjbContextFactory.getInstance().getStatelessService(FlightService.class).createWithAircraft(flight, stowingList, aircraft, aircraftMapping, legMapping, warnings);
            FlightComplete f = (FlightComplete)fw.getValue();
            if (f != null && !f.getFlightState().equals((Object)FlightStateE.PLANNED)) {
                this.performStockCheckouts(new FlightReference(f.getId()), false);
            }
            return fw;
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public FlightComplete create(FlightComplete flight, List<String> warnings) throws ClientServerCallException {
        return (FlightComplete)this.create(flight, (ListWrapper<String>)new ListWrapper(warnings), flight.getActiveStowingList().getAircraft().getMatriculation()).getValue();
    }

    @Override
    public OptionalWrapper<FlightScheduleComplete> createScheduleFromTemplate(FlightScheduleReference template) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).createScheduleFromTemplate(template);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public ListWrapper<FlightScheduleLight> findDuplicateFlightSchedule(FlightScheduleComplete schedule) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).findDuplicateFlightSchedule(schedule);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<FlightScheduleComplete> createFlightSchedule(FlightScheduleComplete schedule) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).createFlightSchedule(schedule);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<FlightScheduleComplete> updateFlightSchedule(FlightScheduleComplete schedule) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).updateFlightSchedule(schedule);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<FlightScheduleComplete> getFlightSchedule(FlightScheduleReference schedule) throws ClientServerCallException {
        try {
            if (schedule == null) {
                throw new ClientGetFromServerException("");
            }
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getFlightSchedule(schedule);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<FlightComplete> create(FlightComplete flight, ListWrapper<String> warnings, String overrideMatriculation) throws ClientServerCallException {
        try {
            flight.setCustomsDocuments(ServiceManagerRegistry.getService(OrderServiceManager.class).mergeCustomsDocuments((ListWrapper<CustomsDocumentComplete>)new ListWrapper(flight.getCustomsDocuments()), true).getList());
            OptionalWrapper fw = EjbContextFactory.getInstance().getStatelessService(FlightService.class).create(flight, warnings, overrideMatriculation);
            FlightComplete f = (FlightComplete)fw.getValue();
            if (f != null && !f.getFlightState().equals((Object)FlightStateE.PLANNED)) {
                this.performStockCheckouts(new FlightReference(f.getId()), false);
            }
            return fw;
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public ServiceReturnWithMessage<FlightComplete> update(FlightComplete flight, ListWrapper<String> warnings, boolean fromUpdater, boolean isDeletedStowinglist, boolean ignoreTransaction, boolean anonymous) throws ClientServerCallException {
        try {
            FlightComplete f = flight;
            List checkoutWarnings = new ArrayList();
            HashSet docs = new HashSet();
            docs.addAll(flight.getCustomsDocuments());
            flight.getCustomsDocuments().clear();
            flight.getCustomsDocuments().addAll(docs);
            List customsDocumentCompletes = ServiceManagerRegistry.getService(OrderServiceManager.class).mergeCustomsDocuments((ListWrapper<CustomsDocumentComplete>)new ListWrapper(flight.getCustomsDocuments()), true).getList();
            flight.setCustomsDocuments(customsDocumentCompletes);
            SystemSettingsComplete settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            if (!Boolean.TRUE.equals(flight.getIsInvoiceClosed()) || Boolean.TRUE.equals(settings.getRetailAutoCloseInvoice()) || fromUpdater) {
                ServiceReturnWithMessage update = EjbContextFactory.getInstance().getService(FlightService.class).update(flight, warnings, fromUpdater, isDeletedStowinglist, ignoreTransaction, anonymous);
                if (update != null) {
                    f = (FlightComplete)update.getObject();
                }
            } else {
                f = (FlightComplete)EjbContextFactory.getInstance().getService(FlightService.class).updateInvoicedFlight(flight).getValue();
            }
            if (!ignoreTransaction && f != null && !f.getFlightState().equals((Object)FlightStateE.PLANNED)) {
                checkoutWarnings = this.performStockCheckouts((FlightReference)f, fromUpdater).getList();
            }
            return new ServiceReturnWithMessage((Object)f, checkoutWarnings);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public ListWrapper<String> performStockCheckouts(FlightReference flight, boolean fromUpdater) throws ClientServerCallException {
        SystemSettingsComplete settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).performStockCheckouts(new FlightReference(flight.getId()), fromUpdater);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<FlightComplete> getFlight(FlightReference flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getFlight(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<FlightComplete> getPlannedFlightComplete(FlightLight flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getPlannedFlightComplete(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<StowingListLight> switchStowingListFromPersistedFlight(FlightParameterConfig config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).switchStowingListFromPersistedFlight(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<FlightComplete> switchStowingList(FlightParameterConfig config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).switchStowingList(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public ListWrapper<DeliverySpaceComplete> getAdditionalOrderSpaces(FlightReference flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getAdditionalOrderSpaces(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<DeliverySpaceComplete> getAdditionalSPMLOrderSpaces(FlightReference flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getAdditionalSPMLOrderSpaces(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<FlightSealsComplete> getFlightSeals(GalleyEquipmentSearchConfiguration searchConfig) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getFlightSeals(searchConfig);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<FlightSealsComplete> updateSeals(FlightSealsComplete flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).updateSeals(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ReturnsCountFlightComplete> getCountItems(FlightReference flight, ReturnsCountParameterConfig config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getCountItems(flight, config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ReturnsCountFlightComplete> updateCountItems(ReturnsCountFlightComplete flight, boolean includeOtherSide, boolean fromUpdater) throws ClientServerCallException {
        try {
            OptionalWrapper rcfw = EjbContextFactory.getInstance().getStatelessService(FlightService.class).updateCountItems(flight, includeOtherSide, fromUpdater);
            ReturnsCountFlightComplete rcf = (ReturnsCountFlightComplete)rcfw.getValue();
            this.performStockCheckouts((FlightReference)rcf.getFlight(), fromUpdater);
            return rcfw;
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public FlightInvoiceData getCostData(FlightDataReportConfig config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getCostData(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public FlightInvoiceData getFlightOverviewCost(FlightDataReportConfig config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getFlightOverviewCost(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public FlightInvoiceData getReturnsCountData(FlightDataReportConfig config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getReturnsCountData(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public FlightInvoiceData getProductCostData(FlightDataReportConfig config, TimestampWrapper validityDate) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getProductCostData(config, validityDate);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public FlightInvoiceData getHandlingCostData(FlightDataReportConfig config, TimestampWrapper validityDate) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getHandlingCostData(config, validityDate);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<FlightImportComplete> createFlightImport(FlightImportComplete data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).createFlightImport(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<FlightImportComplete> updateFlightImport(FlightImportComplete data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).updateFlightImport(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<FlightImportComplete> getFlightImport(FlightImportReference ref) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getFlightImport(ref);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public boolean isFlightDeleteable(FlightComplete flight) {
        return flight.isInvoiced() == false;
    }

    @Override
    public ServiceReturn<PegasusFileComplete> printFlightCustomsSupplySheet(FlightCustomsSupplySheetReportConfiguration config) {
        try {
            return new ServiceReturn<ADTO>(EjbContextFactory.getInstance().getService(FlightReportService.class).createFlightCustomsSupplySheetReport(config).getValue());
        }
        catch (Exception e) {
            return new ServiceReturn<PegasusFileComplete>("<b>Unable to print Flight Customs Supply Sheet:</b><br/>" + e.getMessage());
        }
    }

    @Override
    public MapWrapper<ALegComplete, Map<CabinClassComplete, Map<ProductComplete, Integer>>> getDeliveredProducts(FlightReference flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getDeliveredProducts(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public MapWrapper<CabinClassComplete, ListWrapper<AlaCarteMenuTypeComplete>> getChoosableALaCarteMenuTypes(FlightLight flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getChoosableALaCarteMenuTypes(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public MapWrapper<CabinClassComplete, ListWrapper<SpecialMenuTypeComplete>> getChoosableSpecialMenuTypes(FlightLight flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getChoosableSpecialMenuTypes(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public void recalculateIrregularities(FlightReference flight) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getStatelessService(FlightService.class).recalculateIrregularities(new FlightReference(flight.getId()));
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ReturnsCountFlightComplete> getManualSalesItems(FlightReference flight, ReturnsCountParameterConfig config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getManualSalesItems(flight, config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ReturnsCountFlightComplete> updateManualSalesItem(ReturnsCountFlightComplete flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).updateManualSalesItem(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ReturnsCountFlightComplete> getCountAndManualSalesItems(FlightReference flight, ReturnsCountParameterConfig config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getCountAndManualSalesItems(flight, config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ReturnsCountFlightComplete> updateCountAndManualSalesItem(ReturnsCountFlightComplete flight, boolean fromUpdater) throws ClientServerCallException {
        try {
            OptionalWrapper tw = EjbContextFactory.getInstance().getStatelessService(FlightService.class).updateCountAndManualSalesItem(flight, fromUpdater);
            ReturnsCountFlightComplete t = (ReturnsCountFlightComplete)tw.getValue();
            this.performStockCheckouts((FlightReference)t.getFlight(), fromUpdater);
            return tw;
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public ListWrapper<FlightLegComplete> getForeCastPax(FlightReference flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getForeCastPax(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<FlightLight> approveFlightSubstitutions(FlightReference flightReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).approveFlightSubstitutions(new FlightReference(flightReference.getId()));
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<FlightComplete> recalculateFlight(FlightReference flightReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).recalculateFlight(flightReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<FlightLight> getFlightLight(FlightReference f) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getFlightLight(f);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public ListWrapper<ALoadingGroupComplete> getFlightLoadingGroups(FlightReference flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FlightService.class).getFlightLoadingGroups(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void performTransactionReturnsCountData(FlightReference flight) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getStatelessService(FlightService.class).performTransactionReturnsCountData(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void fixInOutBound(ListWrapper<FlightReference> flightReferenceListWrapper) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getStatelessService(FlightService.class).fixInOutBound(flightReferenceListWrapper);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void unFixInOutBound(ListWrapper<FlightReference> flightReferenceListWrapper) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getStatelessService(FlightService.class).unFixInOutBound(flightReferenceListWrapper);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void addScanDocument(FlightReference flightReference, DocumentScanComplete document) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getStatelessService(FlightService.class).addScanDocument(flightReference, document);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }
}

