/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.report;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientCreateReportException;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.DailyOpsSheetTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.GeneralInfoSheetComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.InfoSheetE;
import ch.icit.pegasus.server.core.dtos.flightschedule.importer.FlightImportReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.LanguageCodeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxFigureTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogReference;
import ch.icit.pegasus.server.core.dtos.report.DeliverySlipReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.FlightCountReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.FlightCustomsSupplySheetReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.FlightDataReportConfig;
import ch.icit.pegasus.server.core.dtos.report.FlightImporterChangesReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.FlightProductionResourceTypeE;
import ch.icit.pegasus.server.core.dtos.report.InvoiceReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.LoadingSheetReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ProductionSheetReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.ReturnsCountReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.SalesOnBoardDiscrepancyOverviewReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.SalesOnBoardPredefinedSealsReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.SalesOnBoardProductsReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.SalesOnBoardReconciliationOverviewReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.SalesOnBoardSealsReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.SearchReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.SingleDTOReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.StowingListReportConfiguration;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StowingListTemplateSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsLight;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.MapWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.services.report.FlightReportService;
import java.util.ArrayList;

public class FlightReportServiceManagerImpl
implements FlightReportServiceManager {
    @Override
    public OptionalWrapper<PegasusFileComplete> generateProductivityMeasureReport(PeriodComplete period) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).generateProductivityMeasureReport(period);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createGuddPickUpList(DateWrapper date) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createGuddPickUpList(date);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createTruckTourReport(FlightReference flight, ReportFileComplete styleSheet, ReportingOutputFormatE format) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createTruckTourReport(flight, styleSheet, format);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createWagonLabel(ReportFileComplete styleSheet, FlightReference flightReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createWagonLabel(styleSheet, flightReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> generateCatalogAllergenErrorLogReport(ProductCatalogReference productCatalogReference, DateWrapper dueDate, ReportingOutputFormatE outputFormatE, ReportFileComplete styleSheet) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).generateCatalogAllergenErrorLogReport(productCatalogReference, dueDate, outputFormatE, styleSheet);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getDutyFreeRetailInMotionDailyOps(DateWrapper dueDate, boolean includeStock) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getDutyFreeRetailInMotionDailyOps(dueDate, includeStock);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getFlightsCustomsTransactionReport(ListWrapper<FlightReference> list, boolean historyIrregularity) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getFlightsCustomsTransactionReport(list, historyIrregularity);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createCountSheet(ReturnsCountReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createCountSheet(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createBoxLabels(SingleDTOReportConfiguration<FlightLight> flightConfig) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createBoxLabels(flightConfig);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getEquipmentList(ListWrapper<FlightReference> flights) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getEquipmentList(flights);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> validateRimDataByVectorSales(ListWrapper<FlightReference> references, FlightSearchConfiguration fc, PegasusFileComplete value) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).validateRimDataByVectorSales(references, fc, value);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    public OptionalWrapper<PegasusFileComplete> getStowageWeightSheet(ListWrapper<FlightReference> flights, boolean showMeals, boolean showSPML, boolean showAlaCarte, boolean showAdditional, boolean showStandards, boolean showArticles) throws ServiceException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getStowageWeightSheet(flights, showMeals, showSPML, showAlaCarte, showAdditional, showStandards, showArticles);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> generateArticleLoadingSheetFromStowingList(StowingListTemplateReference flight, FlightDataReportConfig config, ReportFileComplete selectedReport, boolean isPdf, DateWrapper dueDate) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).generateArticleLoadingSheetFromStowingList(flight, config, selectedReport, isPdf, dueDate);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getArticleLoadingSheet(ListWrapper<FlightReference> flights, boolean showMeals, boolean showSPML, boolean showAlaCarte, boolean showAdditional, boolean showStandards, boolean showArticles) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getArticleLoadingSheet(flights, showMeals, showSPML, showAlaCarte, showAdditional, showStandards, showArticles);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createPaxOverview(ListWrapper<FlightReference> flights, boolean includeNotMain, boolean splitNotMain, boolean groupHaulTypes) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createPaxOverview(flights, includeNotMain, splitNotMain, groupHaulTypes);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSobPaymentDetails(ListWrapper<FlightReference> flights, ReportFileComplete report) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createSobPaymentDetails(flights, report);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getPurchaseMatch(ListWrapper<FlightReference> flights, TimestampPeriodComplete purchasePeriod) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getPurchaseMatch(flights, purchasePeriod);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> generateManualLabels(ListWrapper<FlightReference> flights, MapWrapper<String, Integer> manualLabels, String equipmentCode) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).generateManualLabels(flights, manualLabels, equipmentCode);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> generateManualSealLabels(ListWrapper<FlightReference> flight, boolean autoGenerate, boolean includeBoundSeals, MapWrapper<ColorComplete, Integer> seals) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).generateManualSealLabels(flight, autoGenerate, includeBoundSeals, seals);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createStowingListSwitchHistory(ListWrapper<FlightReference> flights) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createStowingListSwitchHistory(flights);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createPlannedTransactionReport(ListWrapper<FlightReference> flights) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createPlannedTransactionReport(flights);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getAISSheets(ListWrapper<FlightReference> getAISSheets) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getAISSheets(getAISSheets);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<GeneralInfoSheetComplete> getPrintedFlightDeliverySlips(FlightReference flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getPrintedFlightDeliverySlips(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getFlightsTransactionReport(ListWrapper<FlightReference> flights, boolean includeHistoryIrregularity) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getFlightsTransactionReport(flights, includeHistoryIrregularity);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getArticleSummarySheet(ListWrapper<FlightReference> references, FlightDataReportConfig config, boolean showMeals, boolean showSPML, boolean showAlaCarte, boolean showAdditional, boolean showStandards, boolean showArticles, boolean asExcel) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getArticleSummarySheet(references, config, showMeals, showSPML, showAlaCarte, showAdditional, showStandards, showArticles, asExcel);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> generateArticleLoadingSheet(FlightReference flightReference, FlightDataReportConfig config, ReportFileComplete selectedReport, boolean isPdf, boolean showMeals, boolean showSPML, boolean showAlaCarte, boolean showAdditional, boolean showStandards, boolean showArticles) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).generateArticleLoadingSheet(flightReference, config, selectedReport, isPdf, showMeals, showSPML, showAlaCarte, showAdditional, showStandards, showArticles);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> generateLoadingSheet(FlightDataReportConfig config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).generateLoadingSheet(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getArticlesInStowingList(ListWrapper<FlightReference> flights, FlightSearchConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getArticlesInStowingList(flights, config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<GeneralInfoSheetComplete> getPrintedLabelSheets(FlightReference flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getPrintedLabelSheets(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<GeneralInfoSheetComplete> getPrintedFlightCheckerSheets(FlightReference flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getPrintedFlightCheckerSheets(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getFlightProductionResources(ListWrapper<FlightReference> s, FlightProductionResourceTypeE type, boolean includeCrew, boolean includeHandlings, boolean includeProducts, boolean calculateManMinutesForOneProduct, ASearchConfiguration<FlightLight, ?> fc) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getFlightProductionResources(s, type, includeCrew, includeHandlings, includeProducts, calculateManMinutesForOneProduct, fc);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getValidateVariantsReport(ListWrapper<FlightReference> flights) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getValidateVariantsReport(flights);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> exportFlightSobData(ListWrapper<FlightReference> flights) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).exportFlightSobData(flights);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getAISArticleSheet(ListWrapper<FlightReference> flights, boolean groupArticles) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getAISArticleSheet(flights, groupArticles);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getAllergenSheetsCombinded(ListWrapper<FlightReference> flights, boolean groupedVersion, boolean includeAIS, boolean includeErrorLog, boolean includeDeliverySlip) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getAllergenSheetsCombinded(flights, groupedVersion, includeAIS, includeErrorLog, includeDeliverySlip);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<GeneralInfoSheetComplete> getPrintedAllergenSheets(FlightReference flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getPrintedAllergenSheets(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void printScanningReport(FlightReference ref, PegasusFileComplete file) throws ClientGetFromServerException {
        try {
            EjbContextFactory.getInstance().getService(FlightReportService.class).printScanningReport(ref, file);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createReturnsCountSheet(ReturnsCountReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createReturnsCountSheet(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createFlightDailyOpsReport(SearchReportConfiguration<FlightSearchConfiguration> reportConfig, boolean groupOutbound, boolean hideFlightsFromToNSDS, boolean isChrono, boolean showAllClasses, boolean includeAddtitionals, ListWrapper<FlightLight> fs, DailyOpsSheetTypeE type, boolean showEmptyLines, boolean dailySheet) throws ClientServerCallException {
        try {
            FlightSearchConfiguration config = new FlightSearchConfiguration();
            config.setCustomer(((FlightSearchConfiguration)reportConfig.getSearchConfig()).getCustomer());
            config.setCategory(((FlightSearchConfiguration)reportConfig.getSearchConfig()).getCategory());
            config.setDeliveryAirport(((FlightSearchConfiguration)reportConfig.getSearchConfig()).getDeliveryAirport());
            if (((FlightSearchConfiguration)reportConfig.getSearchConfig()).getDayPeriod() != null) {
                config.setDayPeriod(((FlightSearchConfiguration)reportConfig.getSearchConfig()).getDayPeriod());
            } else if (((FlightSearchConfiguration)reportConfig.getSearchConfig()).getDayTimePeriod() != null) {
                config.setDayTimePeriod(((FlightSearchConfiguration)reportConfig.getSearchConfig()).getDayTimePeriod());
            }
            ArrayList<FlightLight> flights = new ArrayList<FlightLight>();
            SearchResultIterator sri = new SearchResultIterator(config);
            for (FlightLight f : sri) {
                if (f.getFlightState() == FlightStateE.CANCELLED) continue;
                if (f.getId() != null) {
                    if (((FlightSearchConfiguration)reportConfig.getSearchConfig()).getDayTimePeriod() != null) {
                        if (!CalendarUtil.isBetween(((FlightSearchConfiguration)reportConfig.getSearchConfig()).getDayTimePeriod(), f.getStd()) && !CalendarUtil.isBetween(((FlightSearchConfiguration)reportConfig.getSearchConfig()).getDayTimePeriod(), f.getSta())) continue;
                        flights.add(f);
                        continue;
                    }
                    if (((FlightSearchConfiguration)reportConfig.getSearchConfig()).getDayPeriod() == null || !CalendarUtil.isBetween(((FlightSearchConfiguration)reportConfig.getSearchConfig()).getDayPeriod(), f.getStd()) && !CalendarUtil.isBetween(((FlightSearchConfiguration)reportConfig.getSearchConfig()).getDayPeriod(), f.getSta())) continue;
                    flights.add(f);
                    continue;
                }
                if (((FlightSearchConfiguration)reportConfig.getSearchConfig()).getOnlyOpenFlights().booleanValue()) continue;
                flights.add(f);
            }
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createFlightDailyOpsReport(reportConfig, groupOutbound, hideFlightsFromToNSDS, isChrono, showAllClasses, includeAddtitionals, new ListWrapper(flights), type, showEmptyLines, dailySheet);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createFlightLoadingSheet(LoadingSheetReportConfiguration<FlightReference, ?> config, ListWrapper<String> warnings) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createFlightLoadingSheet(config, warnings);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createFlightScheduleLoadingSheet(LoadingSheetReportConfiguration<FlightScheduleReference, FlightScheduleLegComplete> config, ListWrapper<String> warningsCallBack) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createFlightScheduleLoadingSheet(config, warningsCallBack);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createStowingListLoadingSheet(LoadingSheetReportConfiguration<StowingListTemplateReference, StowingListTemplateLegComplete> config, ListWrapper<String> warningsCallBack) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createStowingListLoadingSheet(config, warningsCallBack);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createFlightStowingListReportWithSealOption(StowingListReportConfiguration<FlightReference, ?> config, ListWrapper<String> warningsCallBack, Boolean includeSeals) throws ClientCreateReportException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createFlightStowingListReportWithSealOption(config, warningsCallBack, includeSeals);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientCreateReportException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createFlightStowingListReport(StowingListReportConfiguration<FlightReference, ?> config, ListWrapper<String> warningsCallBack) throws ClientCreateReportException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createFlightStowingListReport(config, warningsCallBack);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientCreateReportException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createFlightScheduleStowingListReport(StowingListReportConfiguration<FlightScheduleReference, FlightScheduleLegComplete> config, ListWrapper<String> warningsCallBack) throws ClientCreateReportException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createFlightScheduleStowingListReport(config, warningsCallBack);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientCreateReportException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createFlightDeliverySlipReport(DeliverySlipReportConfiguration<FlightReference, ?> config, ListWrapper<String> warningsCallBack) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createFlightDeliverySlipReport(config, warningsCallBack);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createFlightScheduleDeliverySlipReport(DeliverySlipReportConfiguration<FlightScheduleReference, FlightScheduleLegComplete> config, ListWrapper<String> warningsCallBack) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createFlightScheduleDeliverySlipReport(config, warningsCallBack);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createStowingListTemplateDeliverySlipReport(DeliverySlipReportConfiguration<StowingListTemplateReference, StowingListTemplateLegComplete> config, ListWrapper<String> warningsCallBack) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createStowingListTemplateDeliverySlipReport(config, warningsCallBack);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createFlightScheduleProductionSheet(ProductionSheetReportConfiguration<FlightScheduleReference, FlightScheduleLegComplete> config, ListWrapper<String> warningsCallBack) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createFlightScheduleProductionSheet(config, warningsCallBack);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createStowingListProductionSheet(ProductionSheetReportConfiguration<StowingListTemplateReference, StowingListTemplateLegComplete> config, ListWrapper<String> warningsCallBack) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createStowingListProductionSheet(config, warningsCallBack);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createFlightProductionSheet(ProductionSheetReportConfiguration<FlightReference, ?> config, ListWrapper<String> warningsCallBack) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createFlightProductionSheet(config, warningsCallBack);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createFlightCountReport(FlightCountReportConfiguration s) throws ClientCreateReportException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createFlightCountReport(s);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientCreateReportException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSobSealsReport(SalesOnBoardSealsReportConfiguration s) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createSobSealsReport(s);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSobPredefinedSealsReport(SalesOnBoardPredefinedSealsReportConfiguration s) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createSobPredefinedSealsReport(s);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> printFlightUpdaterChanges(FlightImporterChangesReportConfiguration<FlightImportReference> config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).printFlightUpdaterChanges(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createFlightCustomsSupplySheetReport(FlightCustomsSupplySheetReportConfiguration s) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createFlightCustomsSupplySheetReport(s);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createReturnsCountExport(ReturnsCountReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createReturnsCountExport(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createArticleByStowingListExport(StowingListTemplateSearchConfiguration config, TimestampWrapper validityDate) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createArticleByStowingListExport(config, validityDate);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createFlightMatDispo(FlightLight config, double defaultLoad, boolean useTender) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createFlightMatDispo(config, defaultLoad, useTender);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSobReconciliationOverview(SalesOnBoardReconciliationOverviewReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createSobReconciliationOverview(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSobReconciliationDetails(FlightReference flightReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createSobReconciliationDetails(flightReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSobDiscrepanciesDetails(FlightReference flightReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createSobDiscrepanciesDetails(flightReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSobDiscrepancyOverview(SalesOnBoardDiscrepancyOverviewReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createSobDiscrepancyOverview(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createInOutValidation(ReturnsCountReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createInOutValidation(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSobCommissionInvoice(InvoiceReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createSobCommissionInvoice(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSobFreeSobInvoice(InvoiceReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createSobFreeSobInvoice(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSobSummary(ListWrapper<FlightReference> references, PeriodComplete period, boolean includeFlightState, boolean splitLegs) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createSobSummary(references, period, includeFlightState, splitLegs);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSobCommissionSummary(ListWrapper<FlightReference> references, PeriodComplete period) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createSobCommissionSummary(references, period);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSobCommissionSingleCrewSlides(ListWrapper<FlightReference> references, PeriodComplete period, ReportFileComplete styleSheet, ReportTypeE reportType) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createSobCommissionSingleCrewSlides(references, period, styleSheet, reportType);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSobCrewCommissionSummary(ListWrapper<FlightReference> references, PeriodComplete period) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createSobCrewCommissionSummary(references, period);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSobCommissionSingleCrewSummary(ListWrapper<FlightReference> references, PeriodComplete period) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createSobCommissionSingleCrewSummary(references, period);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSobSalesPerFlightExport(ListWrapper<FlightReference> references) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createSobSalesPerFlightExport(references);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createPaxExport(ListWrapper<FlightReference> references, boolean onlySelected, ListWrapper<PaxFigureTypeComplete> usedTypes, FlightProductionResourceTypeE type, ASearchConfiguration<FlightLight, ?> fc, boolean splitSPML, boolean splitAlaCarte, boolean splitAdditional, boolean sortByDate) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createPaxExport(references, onlySelected, usedTypes, type, fc, splitSPML, splitAlaCarte, splitAdditional, sortByDate);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSobProductSales(ListWrapper<FlightReference> references, PeriodComplete date, boolean includeDetails, boolean showByProduct) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createSobProductSales(references, date, includeDetails, showByProduct);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSobComplementaryInvoice(InvoiceReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createSobComplementaryInvoice(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSobInvoice(InvoiceReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createSobInvoice(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> generateAllergenIndexReport(ReportingOutputFormatE format, ReportFileComplete styleSheet, ListWrapper<LanguageCodeComplete> codes) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).generateAllergenIndexReport(format, styleSheet, codes);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> generateAllergenInfoSheetReport(FlightReference flight, ReportingOutputFormatE format, ReportFileComplete styleSheet, boolean includeSPML, boolean includeAlaCarte, boolean includeAddionals, boolean includeStandard, boolean sortByMealPlan, boolean includeAllergenCodeIndex) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).generateAllergenInfoSheetReport(flight, format, styleSheet, includeSPML, includeAlaCarte, includeAddionals, includeStandard, sortByMealPlan, includeAllergenCodeIndex);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    public OptionalWrapper<PegasusFileComplete> generateAllergenInfoSheetMultiReport(ListWrapper<FlightReference> flights, ReportingOutputFormatE format, ReportFileComplete styleSheet, boolean includeSPML, boolean includeAlaCarte, boolean includeAddionals, boolean includeStandard, boolean sortByMealPlan) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).generateAllergenInfoSheetMultiReport(flights, format, styleSheet, includeSPML, includeAlaCarte, includeAddionals, includeStandard, sortByMealPlan);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> generateSubstitutionChangeLog(FlightReference flight, boolean includeAIS, ReportingOutputFormatE format, ReportFileComplete styleSheet) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).generateSubstitutionChangeLog(flight, includeAIS, format, styleSheet);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> generateFlightAllergenErrorLogReport(FlightReference flight, ReportingOutputFormatE format, ReportFileComplete styleSheet) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).generateFlightAllergenErrorLogReport(flight, format, styleSheet);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createFlightCheckerSheet(SingleDTOReportConfiguration<FlightReference> config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createFlightCheckerSheet(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getFlightMealPlanReport(ListWrapper<FlightReference> flights, boolean showCosts, Boolean showProductive, boolean includeFactSheets, boolean resolveRecipesToArticle, TimestampWrapper validity) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getFlightMealPlanReport(flights, showCosts, showProductive, includeFactSheets, resolveRecipesToArticle, validity);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createFlightUpdaterInfoExport(FlightImportReference fi, boolean addFinishedImports, boolean addUnprocessedImports) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createFlightUpdaterInfoExport(fi, addFinishedImports, addUnprocessedImports);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getFlightSubstitutions(ListWrapper<FlightReference> flights) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getFlightSubstitutions(flights);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getFlightPaxChangeReport(ListWrapper<FlightReference> flights, ReportingOutputFormatE format, ReportFileComplete styleSheet) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getFlightPaxChangeReport(flights, format, styleSheet);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getFlightChangeReport(ListWrapper<FlightReference> flights, ReportingOutputFormatE format, ReportFileComplete styleSheet) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getFlightChangeReport(flights, format, styleSheet);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    public ListWrapper<GeneralInfoSheetComplete> getPrintedGeneralInfoSheetSheets(InfoSheetE infoSheet, FlightReference flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getPrintedGeneralInfoSheetSheets(infoSheet, flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getFlightSobProductsReport(SalesOnBoardProductsReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).getFlightSobProductsReport(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createFlightTradeGoodsValidationExport(ListWrapper<FlightReference> flight, ListWrapper<TradeGoodsLight> tradeGoodsList) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createFlightTradeGoodsValidationExport(flight, tradeGoodsList);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    public OptionalWrapper<PegasusFileComplete> createFlightReturnsCountExport(ListWrapper<FlightReference> flightRefs, FlightDataReportConfig config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createFlightReturnsCountExport(flightRefs, config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    public OptionalWrapper<PegasusFileComplete> createArticleHalalCertifications(ListWrapper<FlightReference> flights) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightReportService.class).createArticleHalalCertifications(flights);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }
}

