/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util;

import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import java.text.DecimalFormat;

public class PriceToolkit {
    public static Double convertPrice(Double oldPrice) {
        oldPrice = PriceToolkit.ensureDoubleFinite(oldPrice);
        String t = "" + oldPrice;
        t = new DecimalFormat("#.00").format(oldPrice);
        t = t.replaceAll(",", ".");
        return Double.valueOf(t);
    }

    public static Double ensureDoubleFinite(Double d) {
        if (d == null || d != null && (d.isInfinite() || d.isNaN())) {
            return 0.0;
        }
        return d;
    }

    public static double getAveragePrice(QuantityComplete q, PriceComplete p) {
        double d = p.getPrice() / q.getQuantity();
        return d;
    }
}

