/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.search;

import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.exception.SearchException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.general.IUniversal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public abstract class SearchAlgorithm<T extends IUniversal> {
    private static int numberOfShownResults = 30;
    private List<ADTO> doNotMerge;

    public int getNumberOfShownResults() {
        return numberOfShownResults;
    }

    public void setDoNotMergeDTOs(List<ADTO> adto) {
        this.doNotMerge = adto;
    }

    public ViewNode<SearchResult<T>> search(ASearchConfiguration<T, ? extends Enum<?>> conf) throws SearchException, ClientServerCallException {
        ViewNode rets = new ViewNode("returns");
        SearchResult b = null;
        if (conf instanceof ADtoSearchConfiguration) {
            b = ServiceManagerRegistry.getService(SearchServiceManager.class).search((ADtoSearchConfiguration)conf);
        }
        rets.setValue(b, 0L);
        return rets;
    }

    public void addNodeToAll(Node newNode) {
    }

    public void setNode(Node allElements) {
    }

    public void mergeValues(Node<List<T>> node, List<T> searchResult) {
        long currentID = System.currentTimeMillis();
        ArrayList<T> nL = new ArrayList<T>();
        if (searchResult != null) {
            nL.addAll(searchResult);
        }
        Iterator<Node<?>> it = node.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node<?> i = it.next();
            if (i == null) continue;
            if (nL.contains(i.getValue())) {
                if (i.isManuallyAdded()) {
                    node.removeChild(i, currentID);
                }
                nL.remove(i.getValue());
                continue;
            }
            if (i.isManuallyAdded()) continue;
            node.removeChild(i, currentID);
        }
        ArrayList childs2Add = new ArrayList();
        if (searchResult != null) {
            for (IUniversal l : searchResult) {
                Node<IUniversal> nArticle;
                boolean haveFound = false;
                Iterator<Node<?>> it2 = node.getFailSafeChildIterator();
                while (it2.hasNext() && !haveFound) {
                    Node<?> i = it2.next();
                    if (!l.equals(i.getValue())) continue;
                    haveFound = true;
                }
                if (!haveFound && (this.doNotMerge == null || this.doNotMerge != null && !this.doNotMerge.contains(l))) {
                    nArticle = INodeCreator.getDefaultImpl().getNode4DTO(l, false, false);
                    nArticle.removeExitingValueWhenMatchingIsEquals(l.getClass());
                    nArticle.setValueSilent(l, true, 0L, null);
                    nArticle.updateNode();
                    childs2Add.add(nArticle);
                    continue;
                }
                if (!haveFound || l.equals(this.doNotMerge)) continue;
                nArticle = INodeCreator.getDefaultImpl().getNode4DTO(l, false, false);
                nArticle.removeExitingValueWhenMatchingIsEquals(l.getClass());
                nArticle.setValueSilent(l, true, 0L, null);
                nArticle.updateNode();
                childs2Add.add(nArticle);
            }
        }
        NodeComparator comp = new NodeComparator(searchResult);
        node.addChildSorted(childs2Add, comp);
    }

    public abstract <E extends Enum<E>> ASearchConfiguration<T, E> getSearchConfiguration();

    private class NodeComparator
    implements Comparator<Node<?>> {
        private List<?> refNode;

        public NodeComparator(List<T> node) {
            this.refNode = node;
        }

        @Override
        public int compare(Node o1, Node o2) {
            Integer i1 = this.refNode.indexOf(o1.getValue());
            Integer i2 = this.refNode.indexOf(o2.getValue());
            if (i1 == -1 || i2 == -1) {
                // empty if block
            }
            return i1.compareTo(i2);
        }
    }
}

