/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.report;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.SkypexReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientCreateReportException;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.dataexchange.SkypexMappingComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.SkypexSettingsComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.report.skypex.SkypexArticleConfig;
import ch.icit.pegasus.server.core.dtos.report.skypex.SkypexContractConfig;
import ch.icit.pegasus.server.core.dtos.report.skypex.SkypexGoodsReceiptConfig;
import ch.icit.pegasus.server.core.dtos.report.skypex.SkypexInvoiceConfig;
import ch.icit.pegasus.server.core.dtos.report.skypex.SkypexPurchaseOrderConfig;
import ch.icit.pegasus.server.core.dtos.report.skypex.SkypexSupplierConfig;
import ch.icit.pegasus.server.core.dtos.search.ArticlePriceContractSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.PurchaseOrderSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StockTransactionSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.SupplierSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.services.report.SkypexReportService;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SkypexReportServiceManagerImpl
implements SkypexReportServiceManager {
    @Override
    public Map<String, PegasusFileComplete> createSkypexData(SkypexSettingsComplete config, List<String> warnings) throws ClientCreateReportException {
        HashMap<String, PegasusFileComplete> list = new HashMap<String, PegasusFileComplete>();
        Timestamp validityDate = new Timestamp(System.currentTimeMillis());
        try {
            PegasusFileComplete file;
            SkypexContractConfig s;
            if (!this.validateSkypexDownloadSettings(config)) {
                throw new ClientCreateReportException("Unable to read skypex data. Ensure all parameter (Mapping: Unit kg and ST) are set.", null);
            }
            if (config.getIncludeContracts().booleanValue()) {
                s = new SkypexContractConfig();
                s.setContractSearchConfig(new ArticlePriceContractSearchConfiguration());
                s.getContractSearchConfig().setPeriod(config.getPeriod());
                s.setMap(this.mapData(config));
                s.setFormat(config.getFormat());
                s.setPeriod(config.getPeriod());
                file = (PegasusFileComplete)this.createSkypexContractExport(s, (ListWrapper<String>)new ListWrapper(warnings), new TimestampWrapper(validityDate)).getValue();
                list.put("Contracts", file);
            }
            if (config.getIncludeAcceptations().booleanValue()) {
                s = new SkypexGoodsReceiptConfig();
                s.setSearchConfig(new StockTransactionSearchConfiguration());
                s.getSearchConfig().setPeriod(config.getPeriod());
                s.setMap(this.mapData(config));
                s.setFormat(config.getFormat());
                s.setPeriod(config.getPeriod());
                file = (PegasusFileComplete)this.createSkypexGoodsReceiptExport((SkypexGoodsReceiptConfig)s, (ListWrapper<String>)new ListWrapper(warnings)).getValue();
                list.put("GoodsReceipt", file);
            }
            if (config.getIncludeArticle().booleanValue()) {
                s = new SkypexArticleConfig();
                s.setArticleSearchConfig(new BasicArticleSearchConfiguration());
                s.getArticleSearchConfig().setInUse(null);
                s.setMap(this.mapData(config));
                s.setFormat(config.getFormat());
                s.setPeriod(config.getPeriod());
                file = (PegasusFileComplete)this.createSkypexArticleExport((SkypexArticleConfig)s, (ListWrapper<String>)new ListWrapper(warnings)).getValue();
                list.put("Article", file);
            }
            if (config.getIncludeInvoice().booleanValue()) {
                // empty if block
            }
            if (config.getIncludePurchase().booleanValue()) {
                s = new SkypexPurchaseOrderConfig();
                s.setPoConfig(new PurchaseOrderSearchConfiguration());
                s.getPoConfig().setPeriod(config.getPeriod());
                s.setMap(this.mapData(config));
                s.setFormat(config.getFormat());
                s.setPeriod(config.getPeriod());
                file = (PegasusFileComplete)this.createSkypexPurchaseOrderExport((SkypexPurchaseOrderConfig)s, (ListWrapper<String>)new ListWrapper(warnings), new TimestampWrapper(validityDate)).getValue();
                list.put("Purchase", file);
            }
            if (config.getIncludeSupplier().booleanValue()) {
                s = new SkypexSupplierConfig();
                s.setSupplierSearchConfig(new SupplierSearchConfiguration());
                s.setFormat(config.getFormat());
                s.setPeriod(config.getPeriod());
                file = (PegasusFileComplete)this.createSkypexSupplierExport((SkypexSupplierConfig)s).getValue();
                list.put("Supplier", file);
            }
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, "Unable to create Skypex Export: " + e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientCreateReportException(e.getMessage(), null);
        }
        return list;
    }

    private Map<UnitComplete, String> mapData(SkypexSettingsComplete config) {
        HashMap<UnitComplete, String> data = new HashMap<UnitComplete, String>();
        if (config.getMapping() != null) {
            for (SkypexMappingComplete smc : config.getMapping()) {
                data.put(smc.getUnit(), smc.getMappingName());
            }
        }
        return data;
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSkypexArticleExport(SkypexArticleConfig config, ListWrapper<String> warnings) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SkypexReportService.class).createSkypexArticleExport(config, warnings);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSkypexSupplierExport(SkypexSupplierConfig config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SkypexReportService.class).createSkypexSupplierExport(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSkypexContractExport(SkypexContractConfig config, ListWrapper<String> warnings, TimestampWrapper validityDate) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SkypexReportService.class).createSkypexContractExport(config, warnings, validityDate);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSkypexPurchaseOrderExport(SkypexPurchaseOrderConfig config, ListWrapper<String> warnings, TimestampWrapper validityDate) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SkypexReportService.class).createSkypexPurchaseOrderExport(config, warnings, validityDate);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSkypexGoodsReceiptExport(SkypexGoodsReceiptConfig config, ListWrapper<String> warnings) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SkypexReportService.class).createSkypexGoodsReceiptExport(config, warnings);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createSkypexInvoiceExport(SkypexInvoiceConfig config, ListWrapper<String> warnings, TimestampWrapper validityDate) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SkypexReportService.class).createSkypexInvoiceExport(config, warnings, validityDate);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<SkypexSettingsComplete> getSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SkypexReportService.class).getSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public boolean validateSkypexDownloadSettings(SkypexSettingsComplete config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SkypexReportService.class).validateSkypexDownloadSettings(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }
}

