/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.supply;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.InventoryWithBarcodeServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreComplete;
import ch.icit.pegasus.server.core.dtos.store.StorePositionComplete;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.IStockInventoryWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.supply.InventoryWithBarcodeService;
import ch.icit.utils.BarcodeType;

public class InventoryWithBarcodeServiceManagerImpl
implements InventoryWithBarcodeServiceManager {
    @Override
    public OptionalWrapper<StoreComplete> getStoreForBarcode(BarcodeType barcodeType, String barcode) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InventoryWithBarcodeService.class).getStoreForBarcode(barcodeType, barcode);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<StorePositionComplete> getStorePositionForBarcode(BarcodeType barcodeType, String barcode) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InventoryWithBarcodeService.class).getStorePositionForBarcode(barcodeType, barcode);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ArticleChargeComplete> getChargeForBarcode(BarcodeType barcodeType, String barcode, StoreReference store, StorePositionLight position) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InventoryWithBarcodeService.class).getChargeForBarcode(barcodeType, barcode, store, position);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ArticleChargeBatchComplete> getArticleForBarcode(String barcode, StoreReference store, StorePositionLight position) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InventoryWithBarcodeService.class).getArticleForBarcode(barcode, store, position);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void correctChargebased(IStockInventoryWrapper wrapped, boolean fromPlanner) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(InventoryWithBarcodeService.class).correctChargebased(wrapped, fromPlanner);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void correctPositionbased(IStockInventoryWrapper wrapped, boolean fromPlanner) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(InventoryWithBarcodeService.class).correctPositionbased(wrapped, fromPlanner);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }
}

