/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.supply;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientExceptionType;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete;
import ch.icit.pegasus.server.core.dtos.ordering.ManualPurchaseOrderPreviewComplete;
import ch.icit.pegasus.server.core.dtos.ordering.ManualPurchaseOrderPreviewReference;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReference;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderReference;
import ch.icit.pegasus.server.core.dtos.ordering.approval.PurchaseApprovalStateE;
import ch.icit.pegasus.server.core.dtos.ordering.haccp.PurchaseOrderPositionHACCPLogComplete;
import ch.icit.pegasus.server.core.dtos.ordering.template.GroupCheckinoutTemplateComplete;
import ch.icit.pegasus.server.core.dtos.ordering.template.OrderTemplateReference;
import ch.icit.pegasus.server.core.dtos.ordering.template.PurchaseOrderTemplateComplete;
import ch.icit.pegasus.server.core.dtos.ordering.template.RequisitionOrderTemplateComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderAcceptationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderRecipientTransactionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderRecipientTransactionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderSupplierTransactionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderTransactionComplete;
import ch.icit.pegasus.server.core.dtos.report.OrderInvoiceReportConfiguration;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeReference;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupComplete;
import ch.icit.pegasus.server.core.dtos.store.StockCheckoutGroupComplete;
import ch.icit.pegasus.server.core.dtos.store.StockMovementGroupComplete;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockTransactionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockTransactionReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceAndUnitComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.MapWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.supply.OrderService;
import ch.icit.pegasus.server.core.util.Triple;
import ch.icit.pegasus.server.core.util.Tuple;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OrderServiceManagerImpl
implements OrderServiceManager {
    @Override
    public OptionalWrapper<PurchaseOrderComplete> approveOrder(PurchaseOrderReference order, PurchaseApprovalStateE approvalState, String comment) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).approveOrder(order, approvalState, comment);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void notifyPurchaseReleaseOverdue() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(OrderService.class).notifyPurchaseReleaseOverdue();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<DocumentScanComplete> findScanDocument(ArticleChargeReference reference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).findScanDocument(reference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<RequisitionOrderReference> getGlobalPrintServicesOrders(CostCenterComplete forDepartment) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).getGlobalPrintServicesOrders(forDepartment);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createKanbanReport(ListWrapper<BasicArticleReference> articleReferences, PeriodComplete periodComplete) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).createKanbanReport(articleReferences, periodComplete);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void saveHACCPCheck(ArticleChargeReference charge, PurchaseOrderPositionHACCPLogComplete dto) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(OrderService.class).saveHACCPCheck(charge, dto);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void saveOPRPCheck(ArticleChargeReference charge, PurchaseOrderPositionHACCPLogComplete dto) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(OrderService.class).saveOPRPCheck(charge, dto);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RequisitionOrderComplete> sendDeliverNotificationCancel(RequisitionOrderReference requisitionOrderReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).sendDeliverNotificationCancel(requisitionOrderReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RequisitionOrderComplete> sendDeliverNotificationClose(RequisitionOrderReference requisitionOrderReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).sendDeliverNotificationClose(requisitionOrderReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void sendMessageToSupervisorByOrder(RequisitionOrderReference ref, String value) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(OrderService.class).sendMessageToSupervisorByOrder(ref, value);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void sendMessageToSupervisor(RequisitionOrderPositionComplete ref, String value) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(OrderService.class).sendMessageToSupervisor(ref, value);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RequisitionOrderComplete> sendDeliverNotification(RequisitionOrderReference requisitionOrderReference, boolean secondDelivery) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).sendDeliverNotification(requisitionOrderReference, secondDelivery);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<StockCheckinGroupComplete> getCreationCheckinGroup(CustomsDocumentComplete docs) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).getCreationCheckinGroup(docs);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<StockCheckoutGroupComplete> getCreationCheckoutGroup(CustomsDocumentComplete docs) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).getCreationCheckoutGroup(docs);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<StockMovementGroupComplete> getCreationMovementGroup(CustomsDocumentComplete docs) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).getCreationMovementGroup(docs);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<FlightLight> getCreationFlight(CustomsDocumentComplete doc) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).getCreationFlight(doc);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<StockTransactionComplete> getCreationTransaction(CustomsDocumentComplete doc) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).getCreationTransaction(doc);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<CustomsDocumentComplete> mergeCustomsDocuments(ListWrapper<CustomsDocumentComplete> docs, boolean forFlight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).mergeCustomsDocuments(docs, forFlight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<CustomsDocumentComplete> createCustomsDocuments(ListWrapper<CustomsDocumentComplete> docs) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).createCustomsDocuments(docs);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<CustomsDocumentComplete> updateCustomsDocuments(ListWrapper<CustomsDocumentComplete> docs) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).updateCustomsDocuments(docs);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<CustomsDocumentComplete> createCustomsDocument(CustomsDocumentComplete doc) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).createCustomsDocument(doc);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<CustomsDocumentComplete> getCustomsDocument(CustomsDocumentComplete doc) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).getCustomsDocument(doc);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<CustomsDocumentComplete> updateCustomsDocument(CustomsDocumentComplete doc) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).updateCustomsDocument(doc);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<PurchaseOrderComplete> findPurchaseOrders(OrderInvoiceReportConfiguration configuration) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).findPurchaseOrders(configuration);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<RequisitionOrderComplete> findRequisitionOrders(OrderInvoiceReportConfiguration configuration) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).findRequisitionOrders(configuration);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ManualPurchaseOrderPreviewComplete> createManualPurchaseOrderPreview(ManualPurchaseOrderPreviewComplete order) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).createManualPurchaseOrderPreview(order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ManualPurchaseOrderPreviewComplete> getManualPurchaseOrderPreview(ManualPurchaseOrderPreviewReference order) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).getManualPurchaseOrderPreview(order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ManualPurchaseOrderPreviewComplete> updateManualPurchaseOrderPreview(ManualPurchaseOrderPreviewComplete order) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).updateManualPurchaseOrderPreview(order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<PurchaseOrderComplete> findInvoicablePurchaseOrders(OrderInvoiceReportConfiguration configuration) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).findInvoicablePurchaseOrders(configuration);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<RequisitionOrderComplete> findInvoicableRequisitionOrders(OrderInvoiceReportConfiguration configuration) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).findInvoicableRequisitionOrders(configuration);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public MapWrapper<Tuple<BasicArticleComplete, CostCenterComplete>, Triple<QuantityComplete, QuantityComplete, QuantityComplete>> getArticles(PegasusFileComplete file) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).getArticles(file);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public Map<PurchaseOrderRecipientTransactionComplete, String> processPurchaseRecipientTransactions(List<PurchaseOrderRecipientTransactionComplete> transactions, PurchaseOrderReference purchaseOrder, Map<PurchaseOrderRecipientTransactionComplete, StorePositionLight> originPosition) throws ClientServerCallException {
        HashMap<PurchaseOrderRecipientTransactionComplete, String> ret = new HashMap<PurchaseOrderRecipientTransactionComplete, String>();
        for (PurchaseOrderRecipientTransactionComplete t : transactions) {
            StorePositionLight destinationPosition = null;
            if (t instanceof PurchaseOrderAcceptationComplete) {
                PurchaseOrderAcceptationComplete acceptation = (PurchaseOrderAcceptationComplete)t;
                destinationPosition = acceptation.getDestinationPosition();
            }
            PurchaseOrderRecipientTransactionComplete nt = (PurchaseOrderRecipientTransactionComplete)this.processPurchaseRecipientTransaction(t).getValue();
            if (destinationPosition != null) {
                originPosition.put(nt, destinationPosition);
            }
            ret.put(nt, "");
        }
        return ret;
    }

    @Override
    public ListWrapper<RequisitionOrderLight> finishPurchaseRecipientTransaction(ListWrapper<StockTransactionReference> purchaseOrderRecipientTransactionCompletes, PurchaseOrderReference purchaseOrder, MapWrapper<PurchaseOrderRecipientTransactionComplete, StorePositionLight> originPosition) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).finishPurchaseRecipientTransaction(purchaseOrderRecipientTransactionCompletes, purchaseOrder, originPosition);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public Map<RequisitionOrderRecipientTransactionComplete, String> processRequisitionRecipientTransactions(List<RequisitionOrderRecipientTransactionComplete> transactions) throws ClientServerCallException {
        HashMap<RequisitionOrderRecipientTransactionComplete, String> ret = new HashMap<RequisitionOrderRecipientTransactionComplete, String>();
        for (RequisitionOrderRecipientTransactionComplete t : transactions) {
            RequisitionOrderRecipientTransactionComplete nt = (RequisitionOrderRecipientTransactionComplete)this.processRequisitionRecipientTransaction(t).getValue();
            ret.put(nt, "");
        }
        return ret;
    }

    @Override
    public Map<RequisitionOrderTransactionComplete, String> processRequisitionSupplierTransactions(List<RequisitionOrderSupplierTransactionComplete> transactions, boolean isChargeBased) throws ClientServerCallException {
        HashMap<RequisitionOrderTransactionComplete, String> ret = new HashMap<RequisitionOrderTransactionComplete, String>();
        for (RequisitionOrderSupplierTransactionComplete t : transactions) {
            List nt = this.processRequisitionSupplierTransaction((RequisitionOrderTransactionComplete)t, isChargeBased).getList();
            for (RequisitionOrderTransactionComplete ntt : nt) {
                ret.put(ntt, "");
            }
        }
        return ret;
    }

    @Override
    public OptionalWrapper<PurchaseOrderComplete> createPurchaseOrder(PurchaseOrderComplete order) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).createPurchaseOrder(order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RequisitionOrderComplete> createRequisitionOrder(RequisitionOrderComplete order) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).createRequisitionOrder(order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PurchaseOrderComplete> recalculateAssociatedDocuments(PurchaseOrderReference order) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).recalculateAssociatedDocuments(order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PurchaseOrderComplete> updatePurchaseOrder(PurchaseOrderComplete order) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).updatePurchaseOrder(order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RequisitionOrderComplete> updateRequisitionOrder(RequisitionOrderComplete order) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).updateRequisitionOrder(order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PurchaseOrderRecipientTransactionComplete> processPurchaseRecipientTransaction(PurchaseOrderRecipientTransactionComplete transaction) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).processPurchaseRecipientTransaction(transaction);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RequisitionOrderRecipientTransactionComplete> processRequisitionRecipientTransaction(RequisitionOrderRecipientTransactionComplete transaction) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).processRequisitionRecipientTransaction(transaction);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PurchaseOrderComplete> getPurchaseOrderByReference(PurchaseOrderReference order) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).getPurchaseOrderByReference(order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e, ClientExceptionType.LOAD);
        }
    }

    @Override
    public OptionalWrapper<RequisitionOrderComplete> getRequisitionOrderByReference(RequisitionOrderReference order) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).getRequisitionOrderByReference(order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e, ClientExceptionType.LOAD);
        }
    }

    @Override
    public OptionalWrapper<RequisitionOrderComplete> getRequisitionOrderByReferenceForDeliver(RequisitionOrderReference order) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).getRequisitionOrderByReferenceForDeliver(order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e, ClientExceptionType.LOAD);
        }
    }

    @Override
    public OptionalWrapper<RequisitionOrderComplete> getRequisitionOrder(RequisitionOrderLight order) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).getRequisitionOrder(order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PurchaseOrderComplete> closePurchaseOrder(PurchaseOrderReference order) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).closePurchaseOrder(order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RequisitionOrderComplete> closeRequisitionOrder(RequisitionOrderReference order) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).closeRequisitionOrder(order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PurchaseOrderComplete> cancelPurchaseOrder(PurchaseOrderReference order) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).cancelPurchaseOrder(order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RequisitionOrderComplete> cancelRequisitionOrder(RequisitionOrderReference order) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).cancelRequisitionOrder(order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PurchaseOrderTemplateComplete> createPurchaseOrderTemplate(PurchaseOrderTemplateComplete temp) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).createPurchaseOrderTemplate(temp);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RequisitionOrderTemplateComplete> getRequisitionOrderTemplate(OrderTemplateReference temp) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).getRequisitionOrderTemplate(temp);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PurchaseOrderTemplateComplete> getPurchaseOrderTemplate(OrderTemplateReference temp) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).getPurchaseOrderTemplate(temp);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PurchaseOrderTemplateComplete> updatePurchaseOrderTemplate(PurchaseOrderTemplateComplete temp) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).updatePurchaseOrderTemplate(temp);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RequisitionOrderTemplateComplete> createRequisitionOrderTemplate(RequisitionOrderTemplateComplete temp) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).createRequisitionOrderTemplate(temp);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RequisitionOrderTemplateComplete> updateRequisitionOrderTemplate(RequisitionOrderTemplateComplete temp) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).updateRequisitionOrderTemplate(temp);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PurchaseOrderComplete> getPurchaseOrder(PurchaseOrderReference order) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).getPurchaseOrder(order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PurchaseOrderPositionComplete> getPurchaseOrderPosition(Long id) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).getPurchaseOrderPosition(id);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<RequisitionOrderTransactionComplete> processRequisitionSupplierTransaction(RequisitionOrderTransactionComplete transaction, boolean isChargeBased) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).processRequisitionSupplierTransaction(transaction, isChargeBased);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public PriceAndUnitComplete getArticlePrice(BasicArticleReference article, SupplierReference supplier, DateWrapper orderDate, QuantityComplete quantity, Boolean useTaxZone, TaxZoneComplete taxZone, SupplierConditionComplete specifiedSupplierCondition) throws ClientServerCallException {
        try {
            BasicArticleLight artL;
            if (useTaxZone == null && taxZone == null) {
                useTaxZone = false;
            }
            taxZone = taxZone == null ? new TaxZoneComplete() : taxZone;
            specifiedSupplierCondition = specifiedSupplierCondition == null ? new SupplierConditionComplete() : specifiedSupplierCondition;
            PriceAndUnitComplete n = EjbContextFactory.getInstance().getService(OrderService.class).getArticlePrice(new BasicArticleReference(article.getId()), supplier, orderDate, quantity, useTaxZone, taxZone, specifiedSupplierCondition);
            if (n != null) {
                return n;
            }
            BasicArticleLight basicArticleLight = artL = article instanceof BasicArticleLight ? (BasicArticleLight)article : null;
            if (artL != null) {
                throw new ClientGetFromServerException("No Price/Contract found for " + artL.getNumber() + " - " + artL.getName() + " on " + orderDate.toString() + ". Please check your contract configuration.", false);
            }
            throw new ClientGetFromServerException("No Price/Contract found on " + orderDate.toString() + ". Please check your contract configuration.");
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<GroupCheckinoutTemplateComplete> createGroupCheckinoutTemplate(GroupCheckinoutTemplateComplete temp) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).createGroupCheckinoutTemplate(temp);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<GroupCheckinoutTemplateComplete> updateGroupCheckinoutTemplate(GroupCheckinoutTemplateComplete temp) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).updateGroupCheckinoutTemplate(temp);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<GroupCheckinoutTemplateComplete> getGroupCheckinoutTemplate(OrderTemplateReference temp) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).getGroupCheckinoutTemplate(temp);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    public ListWrapper<StockTransactionComplete> getTransactionsForCharge(ArticleChargeComplete batch) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).getTransactionsForCharge(batch);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    public ListWrapper<ArticleChargeComplete> getActiveChargesForArticle(BasicArticleComplete article) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).getActiveChargesForArticle(article);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    public ListWrapper<ArticleChargeComplete> getUsedChargesForArticle(BasicArticleComplete article, Boolean isUsedCharge) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).getUsedChargesForArticle(article, isUsedCharge);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    public OptionalWrapper<ArticleChargeComplete> getArticleCharge(ArticleChargeReference id) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).getArticleCharge(id);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PurchaseOrderPositionComplete> saveAllergenCheck(PurchaseOrderPositionComplete position) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).saveAllergenCheck(position);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PurchaseOrderPositionComplete> saveHalalCheck(PurchaseOrderPositionComplete fromClient) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderService.class).saveHalalCheck(fromClient);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }
}

