/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.toolkits;

import ch.icit.pegasus.client.comparators.LegObjectComparator;
import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.LegInfoConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.ILegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.LegTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.APassengerSetComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.DeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.LinearFunctionComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.LinearFunctionSetQuantityCalculationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.PassengerSetTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.StepFunctionQuantityCalculationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.IStowingListLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.MealPlanConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListConfigurationVariantComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListConfigurationVariantComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateLegComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLegComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantReference;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegToolkit {
    static Logger log = LoggerFactory.getLogger(LegToolkit.class);

    public static AirportComplete getOutboundTOAirport(List<? extends ALegComplete> legs, SystemSettingsComplete settings) {
        for (ILegComplete iLegComplete : legs) {
            if (!iLegComplete.getDepartureAirport().equals((Object)settings.getHomeBase()) || iLegComplete.getArrivalAirport().equals((Object)settings.getNightStop()) || iLegComplete.getArrivalAirport().equals((Object)settings.getNightStop())) continue;
            return iLegComplete.getArrivalAirport();
        }
        return null;
    }

    public static boolean areLegsSynced(StowingListTemplateComplete template, StowingListTemplateVariantLight variant) {
        HashSet allLegs = new HashSet(variant.getLegs());
        HashSet allConfigs = new HashSet();
        for (StowingListTemplateLegComplete templateLeg : template.getLegs()) {
            boolean found = false;
            for (StowingListTemplateVariantLegComplete variantLeg : variant.getLegs()) {
                if (!templateLeg.getDepartureAirport().equals((Object)variantLeg.getDepartureAirport()) || !templateLeg.getArrivalAirport().equals((Object)variantLeg.getArrivalAirport()) || !templateLeg.getNumber().equals(variantLeg.getNumber()) || !templateLeg.getLegType().equals((Object)variantLeg.getLegType())) continue;
                if (found) {
                    return false;
                }
                allLegs.remove(variantLeg);
                found = true;
            }
            boolean foundConfig = false;
            for (StowingListConfigurationVariantComplete config : variant.getStowingListConfigs()) {
                if (!config.getLegMapping().containsValue(templateLeg)) continue;
                allConfigs.remove(config);
                foundConfig = true;
            }
            if (!found) {
                return false;
            }
            if (foundConfig) continue;
            return false;
        }
        if (!allLegs.isEmpty()) {
            return false;
        }
        return allConfigs.isEmpty();
    }

    public static void syncLegs(StowingListTemplateComplete template, StowingListTemplateVariantLight variant, boolean isComplete) {
        HashSet allLegs = new HashSet(variant.getLegs());
        HashSet allConfigs = new HashSet(variant.getStowingListConfigs());
        Collections.sort(template.getLegs());
        Collections.sort(variant.getLegs());
        for (Object templateLeg : template.getLegs()) {
            StowingListTemplateVariantLegComplete variantLeg;
            StowingListConfigurationVariantComplete config;
            Object leg22;
            boolean bl = false;
            ArrayList<StowingListTemplateVariantLegComplete> legsToRemoveFromVariant = new ArrayList<StowingListTemplateVariantLegComplete>();
            StowingListTemplateVariantLegComplete matchingLeg = null;
            for (Object leg22 : variant.getLegs()) {
                if (leg22.getNumber() != templateLeg.getNumber()) continue;
                if (bl) {
                    legsToRemoveFromVariant.add((StowingListTemplateVariantLegComplete)leg22);
                    continue;
                }
                bl = true;
                matchingLeg = leg22;
                matchingLeg.setLegType(templateLeg.getLegType());
                matchingLeg.setArrivalAirport(templateLeg.getArrivalAirport());
                matchingLeg.setDepartureAirport(templateLeg.getDepartureAirport());
            }
            variant.getLegs().removeAll(legsToRemoveFromVariant);
            if (!bl) {
                StowingListTemplateVariantLegComplete newLeg = new StowingListTemplateVariantLegComplete();
                newLeg.setClientOId(Long.valueOf(ADTO.getNextId()));
                newLeg.setArrivalAirport(templateLeg.getArrivalAirport());
                newLeg.setDepartureAirport(templateLeg.getDepartureAirport());
                newLeg.setNumber(templateLeg.getNumber());
                newLeg.setLegType(templateLeg.getLegType());
                newLeg.setStowingList((StowingListTemplateVariantReference)variant);
                matchingLeg = newLeg;
                variant.getLegs().add(newLeg);
            }
            allLegs.removeAll(legsToRemoveFromVariant);
            allLegs.remove(matchingLeg);
            boolean foundConfig = false;
            leg22 = variant.getStowingListConfigs().iterator();
            while (leg22.hasNext()) {
                StowingListConfigurationVariantComplete config2 = (StowingListConfigurationVariantComplete)leg22.next();
                if (!config2.getLegMapping().containsValue(templateLeg)) continue;
                Iterator it3 = config2.getLegMapping().entrySet().iterator();
                while (it3.hasNext()) {
                    Map.Entry mapping = it3.next();
                    if (!((StowingListTemplateLegComplete)mapping.getValue()).equals(templateLeg)) continue;
                    it3.remove();
                }
                config2.getLegMapping().put(matchingLeg, templateLeg);
                allConfigs.remove(config2);
                foundConfig = true;
            }
            if (foundConfig) continue;
            StowingListConfigurationVariantComplete stowingListConfigurationVariantComplete = config = variant.getStowingListConfigs().isEmpty() ? null : (StowingListConfigurationVariantComplete)variant.getStowingListConfigs().get(0);
            if (config == null) {
                config = new StowingListConfigurationVariantComplete();
                config.setVariant(variant);
                config.setClientOId(Long.valueOf(ADTO.getNextId()));
                variant.getStowingListConfigs().add(config);
            }
            if ((variantLeg = matchingLeg) == null) {
                throw new IllegalStateException("No mapping leg found!!!");
            }
            config.getLegMapping().put(variantLeg, templateLeg);
        }
        variant.getLegs().removeAll(allLegs);
        if (variant.getMealplan() != null && variant.getMealplan().getLegMapping() != null) {
            HashMap newMapping = new HashMap();
            for (Map.Entry entry : variant.getMealplan().getLegMapping().entrySet()) {
                StowingListTemplateVariantLegComplete value = (StowingListTemplateVariantLegComplete)entry.getValue();
                boolean foundLeg = false;
                for (Object leg : variant.getLegs()) {
                    if (leg.getNumber() != value.getNumber()) continue;
                    if (!foundLeg) {
                        newMapping.put(entry.getKey(), leg);
                        continue;
                    }
                    foundLeg = true;
                }
            }
            variant.getMealplan().setLegMapping((Map)newMapping);
        }
        for (StowingListTemplateVariantLegComplete leg : allLegs) {
            for (StowingListConfigurationVariantComplete config : variant.getStowingListConfigs()) {
                config.getLegMapping().remove(leg);
            }
        }
        if (isComplete) {
            StowingListTemplateVariantComplete vc = (StowingListTemplateVariantComplete)variant;
            for (DeliverableComplete deliverableComplete : vc.getDeliverables()) {
                LinearFunctionSetQuantityCalculationComplete lin;
                if (deliverableComplete.getQuantityCalculation() instanceof LinearFunctionSetQuantityCalculationComplete) {
                    lin = (LinearFunctionSetQuantityCalculationComplete)deliverableComplete.getQuantityCalculation();
                    for (LinearFunctionComplete f : lin.getFunctions()) {
                        for (Object paxKeySet2 : f.getPaxKeySets()) {
                            ArrayList<IStowingListLegComplete> legsToRemove = new ArrayList<IStowingListLegComplete>();
                            for (IStowingListLegComplete leg : paxKeySet2.getLegs()) {
                                if (variant.getLegs().contains(leg)) continue;
                                legsToRemove.add(leg);
                            }
                            paxKeySet2.getLegs().removeAll(legsToRemove);
                            if (!paxKeySet2.getLegs().isEmpty()) continue;
                            PassengerSetTemplateComplete temp = (PassengerSetTemplateComplete)paxKeySet2;
                            StowingListTemplateVariantLegComplete newLeg = (StowingListTemplateVariantLegComplete)variant.getLegs().get(0);
                            temp.getLegs().add(newLeg);
                        }
                    }
                }
                if (!(deliverableComplete.getQuantityCalculation() instanceof StepFunctionQuantityCalculationComplete)) continue;
                lin = (StepFunctionQuantityCalculationComplete)deliverableComplete.getQuantityCalculation();
                for (APassengerSetComplete paxKeySet : lin.getPaxKeySets()) {
                    Object paxKeySet2;
                    ArrayList<IStowingListLegComplete> legsToRemove = new ArrayList<IStowingListLegComplete>();
                    paxKeySet2 = paxKeySet.getLegs().iterator();
                    while (paxKeySet2.hasNext()) {
                        IStowingListLegComplete leg = (IStowingListLegComplete)paxKeySet2.next();
                        if (variant.getLegs().contains(leg)) continue;
                        legsToRemove.add(leg);
                    }
                    paxKeySet.getLegs().removeAll(legsToRemove);
                    if (!paxKeySet.getLegs().isEmpty()) continue;
                    PassengerSetTemplateComplete temp = (PassengerSetTemplateComplete)paxKeySet;
                    StowingListTemplateVariantLegComplete newLeg = (StowingListTemplateVariantLegComplete)variant.getLegs().get(0);
                    temp.getLegs().add(newLeg);
                }
            }
        }
    }

    public static void syncLegsNodebased(Node<StowingListTemplateComplete> template, Node<StowingListTemplateVariantLight> variant) {
        HashSet allLegs = new HashSet();
        HashSet allConfigs = new HashSet();
        Iterator<Node<?>> it = variant.getChildNamed(StowingListTemplateVariantLight_.legs).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node<?> leg = it.next();
            allLegs.add(leg.getValue());
        }
        Iterator<Node<?>> it2 = variant.getChildNamed(StowingListTemplateVariantLight_.stowingListConfigs).getFailSafeChildIterator();
        while (it2.hasNext()) {
            Node<?> config = it2.next();
            allConfigs.add(config.getValue());
        }
        int templateIndex = 0;
        it = template.getChildNamed(StowingListTemplateComplete_.legs).getFailSafeChildIterator();
        while (it.hasNext()) {
            StowingListTemplateVariantLegComplete variantLeg;
            StowingListConfigurationVariantComplete config;
            Node<?> templateLeg = it.next();
            boolean foundMatchingLeg = false;
            ArrayList legsToRemoveFromVariant = new ArrayList();
            Node<Object> matchingLeg = null;
            it2 = variant.getChildNamed(StowingListTemplateVariantLight_.legs).getFailSafeChildIterator();
            while (it2.hasNext()) {
                Node<?> leg = it2.next();
                if ((Integer)leg.getChildNamed(StowingListTemplateVariantLegComplete_.number).getValue() != templateIndex) continue;
                if (foundMatchingLeg) {
                    legsToRemoveFromVariant.add(leg);
                    continue;
                }
                foundMatchingLeg = true;
                matchingLeg = leg;
                matchingLeg.getChildNamed(StowingListTemplateVariantLegComplete_.arrivalAirport).setValue(templateLeg.getChildNamed(StowingListTemplateLegComplete_.arrivalAirport).getValue(), 0L);
                matchingLeg.getChildNamed(StowingListTemplateVariantLegComplete_.departureAirport).setValue(templateLeg.getChildNamed(StowingListTemplateLegComplete_.departureAirport).getValue(), 0L);
                matchingLeg.getChildNamed(StowingListTemplateVariantLegComplete_.legType).setValue(templateLeg.getChildNamed(StowingListTemplateLegComplete_.legType).getValue(), 0L);
            }
            legsToRemoveFromVariant.forEach(stowingListTemplateVariantLegCompleteNode -> variant.getChildNamed(StowingListTemplateVariantLight_.legs).removeChild((Node<?>)stowingListTemplateVariantLegCompleteNode, 0L));
            if (!foundMatchingLeg) {
                StowingListTemplateVariantLegComplete newLeg = new StowingListTemplateVariantLegComplete();
                newLeg.setClientOId(Long.valueOf(ADTO.getNextId()));
                newLeg.setArrivalAirport((AirportComplete)templateLeg.getChildNamed(StowingListTemplateLegComplete_.arrivalAirport).getValue());
                newLeg.setDepartureAirport((AirportComplete)templateLeg.getChildNamed(StowingListTemplateLegComplete_.departureAirport).getValue());
                newLeg.setNumber((Integer)templateLeg.getChildNamed(StowingListTemplateLegComplete_.number).getValue());
                newLeg.setLegType((LegTypeE)templateLeg.getChildNamed(StowingListTemplateLegComplete_.legType).getValue());
                newLeg.setStowingList((StowingListTemplateVariantReference)variant.getValue());
                matchingLeg = INodeCreator.getDefaultImpl().getNode4DTO(newLeg, true, false);
                variant.getChildNamed(StowingListTemplateVariantLight_.legs).addChild(matchingLeg, 0L);
            }
            allLegs.removeAll(legsToRemoveFromVariant);
            allLegs.remove(matchingLeg);
            ++templateIndex;
            boolean foundConfig = false;
            it2 = variant.getChildNamed(StowingListTemplateVariantLight_.stowingListConfigs).getFailSafeChildIterator();
            while (it2.hasNext()) {
                config = it2.next();
                if (!((Map)config.getChildNamed(StowingListConfigurationVariantComplete_.legMapping).getValue()).containsValue(templateLeg)) continue;
                Iterator it3 = ((Map)config.getChildNamed(StowingListConfigurationVariantComplete_.legMapping).getValue()).entrySet().iterator();
                while (it3.hasNext()) {
                    Map.Entry mapping = it3.next();
                    if (!((StowingListTemplateLegComplete)mapping.getValue()).equals(templateLeg)) continue;
                    it3.remove();
                }
                ((Map)config.getChildNamed(StowingListConfigurationVariantComplete_.legMapping).getValue()).put(matchingLeg.getValue(), templateLeg.getValue());
                allConfigs.remove(config);
                foundConfig = true;
            }
            if (foundConfig) continue;
            StowingListConfigurationVariantComplete stowingListConfigurationVariantComplete = config = variant.getChildNamed(StowingListTemplateVariantLight_.stowingListConfigs).getChildCount() == 0 ? null : (StowingListConfigurationVariantComplete)variant.getChildNamed(StowingListTemplateVariantLight_.stowingListConfigs).getChildAt(0).getValue();
            if (config == null) {
                config = new StowingListConfigurationVariantComplete();
                config.setVariant(variant.getValue());
                config.setClientOId(Long.valueOf(ADTO.getNextId()));
                Node<StowingListConfigurationVariantComplete> confNode = INodeCreator.getDefaultImpl().getNode4DTO(config, true, false);
                variant.getChildNamed(StowingListTemplateVariantLight_.stowingListConfigs).addChild(confNode, 0L);
            }
            if ((variantLeg = (StowingListTemplateVariantLegComplete)matchingLeg.getValue()) == null) {
                throw new IllegalStateException("No mapping leg found!!!");
            }
            config.getLegMapping().put(variantLeg, templateLeg.getValue());
        }
        if (variant.getChildNamed(StowingListTemplateVariantLight_.mealplan).getValue() != null && variant.getChildNamed(StowingListTemplateVariantLight_.mealplan, MealPlanConfigurationComplete_.legMapping).getValue() != null) {
            HashMap newMapping = new HashMap();
            for (Map.Entry entry : ((Map)variant.getChildNamed(StowingListTemplateVariantLight_.mealplan, MealPlanConfigurationComplete_.legMapping).getValue()).entrySet()) {
                StowingListTemplateVariantLegComplete value = (StowingListTemplateVariantLegComplete)entry.getValue();
                boolean foundLeg = false;
                Iterator<Node<?>> it4 = variant.getChildNamed(StowingListTemplateVariantLight_.legs).getFailSafeChildIterator();
                while (it4.hasNext()) {
                    Node<?> leg = it4.next();
                    if (leg.getChildNamed(StowingListTemplateVariantLegComplete_.number).getValue() != value.getNumber()) continue;
                    if (!foundLeg) {
                        newMapping.put(entry.getKey(), leg.getValue());
                        continue;
                    }
                    foundLeg = true;
                }
            }
            variant.getChildNamed(StowingListTemplateVariantLight_.mealplan, MealPlanConfigurationComplete_.legMapping).setValue(newMapping, 0L);
        }
    }

    public static boolean showLegInPaxTable(ALegComplete leg, SystemSettingsComplete settings) {
        boolean useLeg = true;
        boolean cateringLeg = false;
        if (leg instanceof FlightLegComplete) {
            useLeg = cateringLeg = ((FlightLegComplete)leg).getCateringLeg().booleanValue();
        }
        if (!cateringLeg) {
            useLeg &= !leg.getArrivalAirport().equals((Object)settings.getNightStop());
            useLeg &= !leg.getArrivalAirport().equals((Object)settings.getDayStop());
            useLeg &= !leg.getDepartureAirport().equals((Object)settings.getNightStop());
            useLeg &= !leg.getDepartureAirport().equals((Object)settings.getDayStop());
        }
        return useLeg;
    }

    public static AirportComplete getInboundFROMAirport(List<? extends ALegComplete> legs, SystemSettingsComplete settings) {
        for (ILegComplete iLegComplete : legs) {
            if (!iLegComplete.getArrivalAirport().equals((Object)settings.getHomeBase()) || iLegComplete.getDepartureAirport().equals((Object)settings.getNightStop()) || iLegComplete.getDepartureAirport().equals((Object)settings.getNightStop())) continue;
            return iLegComplete.getDepartureAirport();
        }
        return null;
    }

    public static String createLegSelectionText(List<? extends ALegComplete> legs, boolean withAirport) {
        String t = "";
        ArrayList<ALegComplete> list = new ArrayList<ALegComplete>();
        for (ALegComplete aLegComplete : legs) {
            list.add(aLegComplete);
        }
        if (list.size() > 0) {
            Collections.sort(list, ComparatorRegistry.getComparator(LegObjectComparator.class));
            t = "Leg " + (((ALegComplete)list.get(0)).getNumber() + 1);
            if (withAirport) {
                t = t + " (" + ((ALegComplete)list.get(0)).getDepartureAirport().getCode() + ")";
            }
            t = t + " - ";
            t = t + "Leg " + (((ALegComplete)list.get(list.size() - 1)).getNumber() + 1);
            if (withAirport) {
                t = t + " (" + ((ALegComplete)list.get(list.size() - 1)).getArrivalAirport().getCode() + ")";
            }
        }
        return t;
    }

    public static Node<List<ALegComplete>> getFlightLegsWithoutDSorNS(Node<List<ALegComplete>> snode) {
        ViewNode<List<ALegComplete>> legs = new ViewNode<List<ALegComplete>>("");
        SystemSettingsComplete settigs = NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (snode != null && snode.getValue() != null) {
            for (ALegComplete l : snode.getValue()) {
                if (l.getArrivalAirport().equals((Object)settigs.getNightStop()) || l.getArrivalAirport().equals((Object)settigs.getDayStop()) || l.getDepartureAirport().equals((Object)settigs.getNightStop()) || l.getDepartureAirport().equals((Object)settigs.getDayStop()) || l instanceof FlightLegComplete && !((FlightLegComplete)l).getCateringLeg().booleanValue()) continue;
                legs.addChild(INodeCreator.getDefaultImpl().getNode4DTO(l, true, true), 0L);
            }
        }
        return legs;
    }

    public static void printLegMapping(Map<? extends ALegComplete, ? extends ALegComplete> savedLegs) {
        log.debug("<======== LEG MAPPING ========>");
        LegInfoConverter l = ConverterRegistry.getConverter(LegInfoConverter.class);
        for (ALegComplete aLegComplete : savedLegs.keySet()) {
            ALegComplete t = savedLegs.get(aLegComplete);
            log.debug("[" + l.convert(aLegComplete, (Node<ALegComplete>)null, new Object[0]) + "] ==> [" + l.convert(t, (Node<ALegComplete>)null, new Object[0]) + "]");
        }
        log.debug("<========  ========>");
    }

    public static List<ScreenValidationObject> validateLegsMapping(Node<List<? extends ALegComplete>> sourceLeg, Node<List<? extends ALegComplete>> destinationLegs, Node<Map<? extends ALegComplete, ? extends ALegComplete>> mapping, String type) {
        return LegToolkit.validateLegsMapping(sourceLeg, destinationLegs, mapping, false, type);
    }

    public static List<ScreenValidationObject> validateLegsMapping(Node<List<? extends ALegComplete>> sourceLeg, Node<List<? extends ALegComplete>> destinationLegs, Node<Map<? extends ALegComplete, ? extends ALegComplete>> mapping, boolean isFS, String type) {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        if (mapping != null && mapping.getValue() != null) {
            Map<? extends ALegComplete, ? extends ALegComplete> map = mapping.getValue();
            for (ILegComplete iLegComplete : map.keySet()) {
                boolean aF = false;
                Iterator<Node<?>> it = sourceLeg.getFailSafeChildIterator();
                while (it.hasNext() && !aF) {
                    Node<?> node = it.next();
                    if (!((ALegComplete)node.getValue()).equals((Object)iLegComplete)) continue;
                    aF = true;
                }
                if (aF) continue;
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, type + "Destination Leg " + iLegComplete.getDepartureAirport().getCode() + " - " + iLegComplete.getArrivalAirport().getCode() + " is used in Mapping Table but removed from Leg Table."));
            }
            if (destinationLegs != null) {
                Iterator<Node<?>> it = destinationLegs.getFailSafeChildIterator();
                while (it.hasNext()) {
                    FlightScheduleLegComplete l;
                    boolean bl = false;
                    Node<?> leg = it.next();
                    if (leg.getValue() instanceof FlightScheduleLegComplete && !Boolean.TRUE.equals((l = (FlightScheduleLegComplete)leg.getValue()).getCateringLeg())) continue;
                    for (ILegComplete iLegComplete : map.values()) {
                        if (!iLegComplete.equals(leg.getValue())) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, type + "Source Leg " + ((ALegComplete)leg.getValue()).getDepartureAirport().getCode() + " - " + ((ALegComplete)leg.getValue()).getArrivalAirport().getCode() + " is not mapped for Meal Plan (but marked as catering leg)"));
                }
            } else {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, type + "No Target Legs defined"));
            }
        }
        return a;
    }

    public static List<ScreenValidationObject> validateLegMapping(Map<ALegComplete, ALegComplete> mt, List<ALegComplete> sourceGroup, List<ALegComplete> targetGroup) {
        return LegToolkit.validateLegMapping(mt, sourceGroup, targetGroup, false);
    }

    public static List<ScreenValidationObject> validateLegMapping(Map<ALegComplete, ALegComplete> mt, List<ALegComplete> sourceGroup, List<ALegComplete> targetGroup, boolean isTargetOptional) {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        LegInfoConverter converter = ConverterRegistry.getConverter(LegInfoConverter.class);
        if (!isTargetOptional) {
            for (ALegComplete t : targetGroup) {
                if (mt.containsValue(t)) continue;
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Target Leg " + converter.convert(t, (Node<ALegComplete>)null, new Object[0]) + " has no source"));
            }
        }
        return a;
    }

    public static String createLegMappingText(Node<FlightLegComplete> node) {
        Node<?> s = NodeToolkit.getAffixNamed("usedLegServices");
        HashSet<CateringServiceLight> services = new HashSet<CateringServiceLight>();
        if (s != null && s.getValue() != null) {
            try {
                for (CateringServiceLight n : (List)s.getValue()) {
                    if (!n.getLegs().contains(node.getValue())) continue;
                    services.add(n);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String tt = "";
        if (services.isEmpty()) {
            tt = "nothing mapped from meal plan";
        } else {
            for (CateringServiceLight ss : services) {
                tt = tt + "Mapped to service " + ss.getCabinClass().getCode() + " " + ss.getType().getCode() + "<br/>";
            }
            tt = tt.substring(0, tt.length() - 5);
        }
        return tt;
    }
}

