/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.converter;

import ch.icit.pegasus.client.converter.InternationalizedConverter;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.util.TimeUtil;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DayTimeConverter
extends InternationalizedConverter {
    public DayTimeConverter() {
        this("{**$hour}:{**$minute}#HH:MM$0123456789HM$0123456789");
    }

    public DayTimeConverter(String pattern) {
        super(pattern);
    }

    @Override
    public String convert(Object o, Node currentNode, Object ... param) {
        if (o instanceof Timestamp) {
            Timestamp d = (Timestamp)o;
            Calendar c = TimeUtil.createCalendar();
            c.setTime(d);
            String retString = "";
            for (String pat : this.getAllPatterns()) {
                if (pat.contains("$")) {
                    String hS;
                    int h;
                    if (pat.equals("$hour")) {
                        h = c.get(11);
                        hS = "" + h;
                        if (hS.length() == 1) {
                            hS = "0" + hS;
                        }
                        retString = retString + hS;
                        continue;
                    }
                    if (!pat.equals("$minute")) continue;
                    h = c.get(12);
                    hS = "" + h;
                    if (hS.length() == 1) {
                        hS = "0" + hS;
                    }
                    retString = retString + hS;
                    continue;
                }
                retString = retString + pat;
            }
            return retString;
        }
        if (o instanceof Time) {
            Time d = (Time)o;
            Calendar c = TimeUtil.createCalendar();
            c.setTime(d);
            String retString = "";
            for (String pat : this.getAllPatterns()) {
                if (pat.contains("$")) {
                    String hS;
                    int h;
                    if (pat.equals("$hour")) {
                        h = c.get(11);
                        hS = "" + h;
                        if (hS.length() == 1) {
                            hS = "0" + hS;
                        }
                        retString = retString + hS;
                        continue;
                    }
                    if (!pat.equals("$minute")) continue;
                    h = c.get(12);
                    hS = "" + h;
                    if (hS.length() == 1) {
                        hS = "0" + hS;
                    }
                    retString = retString + hS;
                    continue;
                }
                retString = retString + pat;
            }
            return retString;
        }
        if (o instanceof java.sql.Date) {
            Time d = new Time(((java.sql.Date)o).getTime());
            Calendar c = TimeUtil.createCalendar();
            c.setTime(d);
            String retString = "";
            for (String pat : this.getAllPatterns()) {
                if (pat.contains("$")) {
                    String hS;
                    int h;
                    if (pat.equals("$hour")) {
                        h = c.get(11);
                        hS = "" + h;
                        if (hS.length() == 1) {
                            hS = "0" + hS;
                        }
                        retString = retString + hS;
                        continue;
                    }
                    if (!pat.equals("$minute")) continue;
                    h = c.get(12);
                    hS = "" + h;
                    if (hS.length() == 1) {
                        hS = "0" + hS;
                    }
                    retString = retString + hS;
                    continue;
                }
                retString = retString + pat;
            }
            return retString;
        }
        return "";
    }

    @Override
    public Object inverseConvert(Object o, Object userObj) {
        if (userObj instanceof Timestamp) {
            Timestamp d = (Timestamp)userObj;
            String dString = (String)o;
            if (dString == null || dString.trim().equals("")) {
                return null;
            }
            String h = this.getStringValueOfGroupNamed("hour", dString);
            String m = this.getStringValueOfGroupNamed("minute", dString);
            try {
                int hour = Integer.valueOf(h);
                int minute = Integer.valueOf(m);
                Calendar c = TimeUtil.createCalendar();
                if (d != null) {
                    c.setTimeInMillis(d.getTime());
                }
                c.set(11, hour);
                c.set(12, minute);
                return new Timestamp(c.getTimeInMillis());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (userObj instanceof Time) {
            Time d = (Time)userObj;
            String dString = (String)o;
            if (dString == null || dString.trim().equals("")) {
                return null;
            }
            String h = this.getStringValueOfGroupNamed("hour", dString);
            String m = this.getStringValueOfGroupNamed("minute", dString);
            try {
                int hour = Integer.valueOf(h);
                int minute = Integer.valueOf(m);
                Calendar c = TimeUtil.createCalendar();
                if (d != null) {
                    c.setTimeInMillis(d.getTime());
                }
                c.set(11, hour);
                c.set(12, minute);
                return new Time(c.getTimeInMillis());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (userObj instanceof java.sql.Date) {
            Time d = new Time(((java.sql.Date)userObj).getTime());
            String dString = (String)o;
            if (dString == null || dString.trim().equals("")) {
                return null;
            }
            String h = this.getStringValueOfGroupNamed("hour", dString);
            String m = this.getStringValueOfGroupNamed("minute", dString);
            try {
                int hour = Integer.valueOf(h);
                int minute = Integer.valueOf(m);
                Calendar c = TimeUtil.createCalendar();
                if (d != null) {
                    c.setTimeInMillis(d.getTime());
                }
                c.set(11, hour);
                c.set(12, minute);
                return new Timestamp(c.getTimeInMillis());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean validateInput(Object input) {
        String dString = (String)input;
        String h = this.getStringValueOfGroupNamed("hour", dString);
        String m = this.getStringValueOfGroupNamed("minute", dString);
        try {
            int hour = Integer.valueOf(h);
            int minute = Integer.valueOf(m);
            if (hour < 0 || hour > 23) {
                return false;
            }
            if (minute < 0 || minute > 59) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static Integer getHours(Time reportTime) {
        Integer value = new Integer(-1);
        Calendar c = TimeUtil.createCalendar();
        c.setTimeInMillis(reportTime.getTime());
        value = c.get(11);
        return value;
    }

    public static Integer getMinutes(Time reportTime) {
        Integer value = new Integer(-1);
        Calendar c = TimeUtil.createCalendar();
        c.setTimeInMillis(reportTime.getTime());
        value = c.get(12);
        return value;
    }

    public static Time mapTime(String text) {
        Time ppstime = null;
        try {
            SimpleDateFormat format = new SimpleDateFormat("HH:mm");
            Date d1 = format.parse(text);
            ppstime = new Time(d1.getTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ppstime;
    }
}

