/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.converter;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.IStowingListLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;

public class StowingListNameConverter
implements Converter<IStowingListLight, String> {
    @Override
    public String convert(IStowingListLight o, Node<IStowingListLight> currentNode, Object ... param) {
        if (o == null) {
            return NULL_RETURN;
        }
        if (o instanceof StowingListTemplateVariantLight) {
            StowingListTemplateVariantLight t = (StowingListTemplateVariantLight)o;
            String ret = t.getBase().getNumber() + " - " + t.getName();
            if (t.getMealplan() != null && t.getMealplan().getMealplan() != null) {
                ret = ret + " (MP: " + t.getMealplan().getMealplan().getNumber() + " - " + t.getMealplan().getMealplan().getName() + ")";
            }
            return ret;
        }
        if (o instanceof StowingListLight) {
            StowingListLight t = (StowingListLight)o;
            String ret = ((StowingListLight)o).getTemplateNumber() + " - " + t.getName();
            if (t.getMealPlanNumber() != null) {
                ret = ret + " (MP: " + t.getMealPlanNumber() + ")";
            }
            return ret;
        }
        if (o instanceof StowingListTemplateComplete) {
            StowingListTemplateVariantLight t = ((StowingListTemplateComplete)o).getCurrentVariant();
            String ret = t.getBase().getNumber() + " - " + t.getName();
            if (t.getMealplan() != null && t.getMealplan().getMealplan() != null) {
                ret = ret + " (MP: " + t.getMealplan().getMealplan().getNumber() + " - " + t.getMealplan().getMealplan().getName() + ")";
            }
            return ret;
        }
        return o.getName();
    }

    @Override
    public Class<? extends IStowingListLight> getParameterClass() {
        return IStowingListLight.class;
    }
}

