/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.print;

import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PrinterToolkitConfiguration {
    private final List<String[]> properties = new ArrayList<String[]>();
    protected static String currentPath;

    public PrinterToolkitConfiguration() {
        File f;
        if (currentPath == null && !(f = new File(currentPath = System.getProperty("user.home") + File.separator + ".catit" + File.separator)).exists()) {
            f.mkdirs();
            f.setWritable(true);
        }
    }

    public void addProperty(String name, String value) {
        String[] t = new String[]{name, value};
        this.properties.add(t);
    }

    public void updateProperty(String name, String value) {
        for (String[] t : this.properties) {
            if (!t[0].equals(name)) continue;
            t[1] = value;
            return;
        }
        this.addProperty(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrinterToolkitConfiguration loadConfiguration(UserLight currentUser) {
        PrinterToolkitConfiguration c = new PrinterToolkitConfiguration();
        String t = currentPath + currentUser.getUserName() + "_printer_config.catit";
        File f = new File(t);
        if (f.exists()) {
            try (BufferedReader input = new BufferedReader(new FileReader(f));){
                String line = null;
                while ((line = input.readLine()) != null) {
                    String[] a = line.split("%");
                    if (a.length != 2) continue;
                    c.addProperty(a[0], a[1]);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return c;
        }
        return null;
    }

    public static void saveConfiguration(UserLight currentUser, PrinterToolkitConfiguration conf) {
        Iterator<String[]> it = conf.getProperties().iterator();
        String t = "";
        String linefeed = System.getProperty("line.separator");
        while (it.hasNext()) {
            String[] e = it.next();
            t = t + e[0] + "%" + e[1];
            if (e[1] == null) {
                return;
            }
            if (!it.hasNext()) continue;
            t = t + linefeed;
        }
        String fn = currentUser.getUserName() + "_printer_config.catit";
        PrinterToolkitConfiguration.writeFile(t, fn);
    }

    public static void writeFile(String t, String path) {
        String p = currentPath + path;
        File f = new File(p);
        if (f.exists()) {
            f.delete();
        }
        try {
            f.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (BufferedWriter output = new BufferedWriter(new FileWriter(f));){
            output.write(t);
            ((Writer)output).flush();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public String getProperty(String name) {
        for (String[] t : this.properties) {
            if (!t[0].equals(name)) continue;
            return t[1];
        }
        return null;
    }

    public List<String[]> getProperties() {
        return this.properties;
    }
}

