/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.exchange.migros;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.exchange.migros.MigrosExchangeServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosArticleImportComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosArticleImportReference;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosInvoiceAvisImportComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosInvoiceAvisImportReference;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosInvoiceExportComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosInvoiceExportReference;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosOrderAvisExportComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosOrderAvisExportReference;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosOrderImportComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosOrderImportReference;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosStoreImportComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosStoreImportReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.exchange.migros.MigrosExchangeService;

public class MigrosExchangeServiceManagerImpl
implements MigrosExchangeServiceManager {
    @Override
    public void readFromFTP() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(MigrosExchangeService.class).readFromFTP();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MigrosArticleImportComplete> getArticleImport(MigrosArticleImportReference ref) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MigrosExchangeService.class).getArticleImport(ref);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MigrosOrderImportComplete> generateOrderAvis(MigrosOrderImportReference order) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MigrosExchangeService.class).generateOrderAvis(order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MigrosInvoiceExportComplete> closeAndSendInvoice(MigrosInvoiceExportReference invoice) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MigrosExchangeService.class).closeAndSendInvoice(invoice);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MigrosOrderImportComplete> createInvoice(MigrosOrderImportReference order) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MigrosExchangeService.class).createInvoice(order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MigrosInvoiceExportComplete> cancelInvoice(MigrosInvoiceExportReference invoice) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MigrosExchangeService.class).cancelInvoice(invoice);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void checkForInvoicesToSend() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(MigrosExchangeService.class).checkForInvoicesToSend();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MigrosStoreImportComplete> createStoreImport(MigrosStoreImportComplete ref) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MigrosExchangeService.class).createStoreImport(ref);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MigrosStoreImportComplete> getStoreImport(MigrosStoreImportReference ref) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MigrosExchangeService.class).getStoreImport(ref);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MigrosStoreImportComplete> resolveStoreImport(MigrosStoreImportReference ref) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MigrosExchangeService.class).resolveStoreImport(ref);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MigrosArticleImportComplete> createArticleImport(MigrosArticleImportComplete articleImport) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MigrosExchangeService.class).createArticleImport(articleImport);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MigrosArticleImportComplete> resolveArticleImport(MigrosArticleImportReference ref) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MigrosExchangeService.class).resolveArticleImport(ref);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public Node<MigrosSettingsComplete> getSettingsCached() throws ClientServerCallException {
        Node<MigrosSettingsComplete> settings = NodeToolkit.getAffixClass(MigrosSettingsComplete.class);
        if (settings != null) {
            INodeCreator.getDefaultImpl().addToAllNodes(settings);
        } else {
            MigrosSettingsComplete dto = (MigrosSettingsComplete)this.getSettings().getValue();
            settings = INodeCreator.getDefaultImpl().getNode4DTO(dto, false, false);
            settings.setName(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(MigrosSettingsComplete.class));
            NodeToolkit.addAffix(settings);
        }
        return settings;
    }

    @Override
    public OptionalWrapper<MigrosOrderImportComplete> getOrder(MigrosOrderImportReference ref) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MigrosExchangeService.class).getOrder(ref);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MigrosSettingsComplete> getSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MigrosExchangeService.class).getSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MigrosOrderAvisExportComplete> getOrderAvis(MigrosOrderAvisExportReference ref) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MigrosExchangeService.class).getOrderAvis(ref);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MigrosInvoiceExportComplete> getInvoice(MigrosInvoiceExportReference ref) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MigrosExchangeService.class).getInvoice(ref);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MigrosInvoiceAvisImportComplete> getInvoiceAvis(MigrosInvoiceAvisImportReference ref) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MigrosExchangeService.class).getInvoiceAvis(ref);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MigrosOrderImportComplete> resolveOrder(MigrosOrderImportReference ref) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MigrosExchangeService.class).resolveOrder(ref);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MigrosOrderAvisExportComplete> resolveOrderAvis(MigrosOrderAvisExportReference ref) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MigrosExchangeService.class).resolveOrderAvis(ref);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MigrosInvoiceExportComplete> resolveInvoice(MigrosInvoiceExportReference ref) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MigrosExchangeService.class).resolveInvoice(ref);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MigrosInvoiceAvisImportComplete> resolveInvoiceAvis(MigrosInvoiceAvisImportReference ref) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MigrosExchangeService.class).resolveInvoiceAvis(ref);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }
}

