/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.supply;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.JimdoServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.dataexchange.JimdoSettingsComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.jimdo.JimdoOrderImportComplete;
import ch.icit.pegasus.server.core.dtos.jimdo.JimdoOrderImportReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.supply.JimdoService;

public class JimdoServiceManagerImpl
implements JimdoServiceManager {
    @Override
    public OptionalWrapper<JimdoOrderImportComplete> update(JimdoOrderImportComplete order) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(JimdoService.class).update(order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> sendInvoice(JimdoOrderImportReference order, Boolean generateOnly) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(JimdoService.class).sendInvoice(order, generateOnly);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void sendQRCode(JimdoOrderImportReference order) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(JimdoService.class).sendQRCode(order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<JimdoOrderImportComplete> moveOrderToToday(JimdoOrderImportReference order) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(JimdoService.class).moveOrderToToday(order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<JimdoOrderImportComplete> orderDelivered(JimdoOrderImportReference order) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(JimdoService.class).orderDelivered(order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void readMails() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(JimdoService.class).readMails();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<JimdoOrderImportComplete> get(JimdoOrderImportReference data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(JimdoService.class).get(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<JimdoOrderImportComplete> getOrderForQRCode(String qrCode) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(JimdoService.class).getOrderForQRCode(qrCode);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void resolveImport(ListWrapper<JimdoOrderImportReference> data) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(JimdoService.class).resolveImport(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<JimdoSettingsComplete> getSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(JimdoService.class).getSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<JimdoSettingsComplete> updateSettings(JimdoSettingsComplete settings) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(JimdoService.class).updateSettings(settings);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }
}

