/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client;

import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;

public class CSVFileTool {
    public static void main(String ... xargs) {
        System.out.println("choose source file with all entries");
        File inputFile = FileChooserUtil.loadFile();
        System.out.println("choose destination folder");
        File outputFile = FileChooserUtil.saveFile("csv");
        File baseDirectory = outputFile.getParentFile();
        int maxRow = 3000;
        File file = inputFile;
        try {
            String st;
            int currentRow = 0;
            int currentSheet = 0;
            BufferedReader brIn = new BufferedReader(new FileReader(file));
            String postfix = "" + currentSheet;
            while (postfix.length() < 6) {
                postfix = "0" + postfix;
            }
            String fileName = "lsgfc_transactions_20190801_062530_WK18_20190701_" + postfix + ".csv";
            BufferedWriter brOut = new BufferedWriter(new FileWriter(baseDirectory.getAbsolutePath() + File.separator + fileName));
            while ((st = brIn.readLine()) != null) {
                brOut.write(st + "\n");
                if (++currentRow != maxRow) continue;
                currentRow = 0;
                brOut.close();
                postfix = "" + ++currentSheet;
                while (postfix.length() < 6) {
                    postfix = "0" + postfix;
                }
                fileName = "lsgfc_transactions_20190801_062530_WK18_20190701_" + postfix + ".csv";
                brOut = new BufferedWriter(new FileWriter(baseDirectory.getAbsolutePath() + File.separator + fileName));
            }
            brOut.close();
            brIn.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("all done");
    }

    public static void writeToFile(File targetFile, Set<String> entries) {
        File parentFile = targetFile.getParentFile();
        int currentFile = 1;
        int entryCount = 0;
        try {
            BufferedWriter brOut = new BufferedWriter(new FileWriter(parentFile.getAbsolutePath() + File.separator + "entries_" + currentFile + ".csv"));
            for (String entry : entries) {
                brOut.write(entry + "\n");
                if (++entryCount != 1000000) continue;
                brOut.close();
                entryCount = 0;
                brOut = new BufferedWriter(new FileWriter(parentFile.getAbsolutePath() + File.separator + "entries_" + ++currentFile + ".csv"));
            }
            brOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String formatDate(String s) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("MM.dd.yyyy HH:mm");
            Date date = formatter.parse(s);
            formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            s = formatter.format(date);
            return s;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

