/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.session.SessionListener;
import ch.icit.pegasus.client.session.SessionManager;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManagerImpl
implements SessionManager {
    private static final Logger logger = LoggerFactory.getLogger(SessionManagerImpl.class);
    private ArrayList<SessionListener> listeners = new ArrayList();
    private boolean isValid = false;
    private MainFrame currentApplication;
    public static final int TITLE_ICON_TYPE_EXIT = 3;
    public static final int TITLE_ICON_TYPE_HOME = 5;
    public static final int TITLE_ICON_TYPE_HUD = 7;
    public static final int TITLE_ICON_TYPE_USER = 11;
    public static final int TITLE_ICON_TYPE_HELP = 13;

    public void setApplication(MainFrame frame) {
        this.currentApplication = frame;
    }

    public MainFrame getApplication() {
        return this.currentApplication;
    }

    public void setSessionValid() {
        this.isValid = true;
    }

    @Override
    public boolean isSessionValid() {
        return this.isValid;
    }

    public void addSessionListener(SessionListener l) {
        this.listeners.add(l);
    }

    public void removeSessionListener(SessionListener l) {
        this.listeners.remove(l);
    }

    private void fireEvent() {
        for (SessionListener l : this.listeners) {
            l.sessionChanged(this);
        }
    }

    @Override
    public boolean isTitleIconAllowed(int type) {
        if (!this.isValid) {
            switch (type) {
                case 3: {
                    return true;
                }
                case 5: {
                    return false;
                }
                case 7: {
                    return false;
                }
                case 11: {
                    return false;
                }
                case 13: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public boolean logout() {
        this.isValid = false;
        logger.info("User " + ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser() + " logged out");
        this.fireEvent();
        return true;
    }
}

