/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.debug;

import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.ServiceState;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DebugCheckBoxLine
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JLabel label;
    private JCheckBox checkBox;
    private Method method;
    private Class<?> clazz;

    public DebugCheckBoxLine(Method method, Class<?> clazz) {
        this.method = method;
        this.clazz = clazz;
        this.checkBox = new JCheckBox();
        String parameters = " [";
        for (Class<?> param : method.getParameterTypes()) {
            if (!parameters.equals(" [")) {
                parameters = parameters + ", ";
            }
            parameters = parameters + param.getSimpleName();
        }
        parameters = parameters + "]";
        this.label = new JLabel(method.getName() + parameters);
        this.add(this.checkBox);
        this.add(this.label);
        this.label.setVisible(true);
        this.checkBox.setVisible(true);
        if (ServiceManagerRegistry.getMethodState((String)clazz.getName(), (String)method.getName()) == ServiceState.DEBUG) {
            this.checkBox.setSelected(true);
        }
        this.checkBox.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.checkBox) {
            if (this.checkBox.isSelected()) {
                ServiceManagerRegistry.setMethodState((String)this.clazz.getName(), (String)this.method.getName(), (ServiceState)ServiceState.DEBUG);
            } else {
                ServiceManagerRegistry.setMethodState((String)this.clazz.getName(), (String)this.method.getName(), (ServiceState)ServiceState.IMPL);
            }
        }
    }
}

