/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.hud.view;

import ch.icit.pegasus.client.gui.hud.HUDPanel;
import ch.icit.pegasus.client.gui.hud.view.HUDButtonBackgroundSkin;
import ch.icit.pegasus.client.gui.hud.view.HUDButtonIconSkin;
import ch.icit.pegasus.client.gui.modules.AppModules;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.TypedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.TypedSkin3Field;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class HUDButton
extends Button
implements LafListener {
    private static final long serialVersionUID = 1L;
    protected TextLabel textlabel;
    protected int border = 6;
    protected String viewClass;
    protected TypedSkin3Field skin;
    protected TypedSkin1Field iconSkin;
    private AppModules screenType;
    protected int iconWidth = 0;
    protected HUDPanel parentHUD;
    protected TextLabel attributesText;

    protected HUDButton(String text, HUDPanel parent, AppModules screenType) {
        this.init(text, parent, screenType);
        this.screenType = screenType;
    }

    protected HUDButton(boolean focus) {
        super(focus);
    }

    protected void init(String text, HUDPanel parent, AppModules screenType) {
        this.parentHUD = parent;
        this.skin = SkinRegistry.getSkin(HUDButtonBackgroundSkin.class);
        this.iconSkin = SkinRegistry.getSkin(HUDButtonIconSkin.class);
        BufferedImage i = this.iconSkin.getImage(this.state, screenType);
        this.iconWidth = i != null ? i.getWidth() : -1;
        this.setOpaque(true);
        this.setLayout(new HUDButtonLayout());
        this.textlabel = new TextLabel(text);
        this.textlabel.setAlignment(7);
        this.textlabel.setLineWrap(true, 110);
        this.textlabel.setEmbossed(true);
        this.add(this.textlabel);
        this.lafAttributeChanged("All attribues changed");
    }

    public String getText() {
        return this.textlabel.getText();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.getState() == Button.ButtonState.DISABLED) {
            this.changeState(Button.ButtonState.DOWN);
        }
        if (this.getState() == Button.ButtonState.FOCUS) {
            this.changeState(Button.ButtonState.UP);
        }
        this.repaint(32L);
    }

    @Override
    public void setState(Button.ButtonState newState) {
        super.setState(newState);
        if (this.getState() == Button.ButtonState.DISABLED) {
            this.state = Button.ButtonState.DOWN;
        }
        if (this.getState() == Button.ButtonState.FOCUS) {
            this.state = Button.ButtonState.UP;
        }
        this.repaint(32L);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        this.skin.paint(g2, 0, 0, this.getWidth(), this.state, HudButtonType.User);
        this.iconSkin.paint(g2, 0, 0, this.state, this.screenType);
        if (this.iconWidth != -1) {
            g2.setColor(new Color(255, 255, 255, 64));
            g2.drawLine(this.iconWidth, this.border, this.iconWidth, this.getHeight() - this.border);
        }
        this.paintChildren(g2);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.skin != null) {
            return new Dimension(200, this.skin.getImageLeft(this.state, HudButtonType.User).getHeight());
        }
        return new Dimension(200, 52);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.textlabel.kill();
        this.textlabel = null;
        this.parentHUD = null;
        this.skin = null;
        this.iconSkin = null;
        this.screenType = null;
        if (this.attributesText != null) {
            this.attributesText.kill();
        }
        this.attributesText = null;
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.textlabel.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("hud_font_size"), LafLoader.getLafLoader().getAttribute("hud_font_type")));
        if (this.attributesText != null) {
            this.attributesText.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("hud_attributes_font_size"), LafLoader.getLafLoader().getAttribute("hud_attributes_font_type")));
        }
    }

    public AppModules getScreenType() {
        return this.screenType;
    }

    protected class HUDButtonLayout
    extends DefaultLayout {
        protected HUDButtonLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            int h = parent.getHeight();
            int innerVerticalBorder = 0;
            int inset = 0;
            if (HUDButton.this.attributesText != null) {
                inset = -7;
            }
            if (HUDButton.this.iconWidth == -1) {
                HUDButton.this.textlabel.setLocation(HUDButton.this.border, (int)(((double)h - HUDButton.this.textlabel.getPreferredSize().getHeight()) / 2.0 + (double)inset));
                HUDButton.this.textlabel.setSize(w - 2 * HUDButton.this.border, (int)HUDButton.this.textlabel.getPreferredSize().getHeight());
            } else {
                HUDButton.this.textlabel.setLocation(HUDButton.this.iconWidth + HUDButton.this.border, (int)(((double)h - HUDButton.this.textlabel.getPreferredSize().getHeight()) / 2.0 + (double)inset));
                HUDButton.this.textlabel.setSize(w - (2 * HUDButton.this.border + HUDButton.this.iconWidth), (int)HUDButton.this.textlabel.getPreferredSize().getHeight());
            }
            if (HUDButton.this.attributesText != null) {
                HUDButton.this.attributesText.setSize(HUDButton.this.textlabel.getWidth(), (int)HUDButton.this.attributesText.getPreferredSize().getHeight());
                HUDButton.this.attributesText.setLocation(HUDButton.this.textlabel.getX(), HUDButton.this.textlabel.getY() + HUDButton.this.textlabel.getHeight() + innerVerticalBorder);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }

    public static enum HudButtonType {
        Smart,
        User;

    }
}

