/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.admin.inserts;

import ch.icit.pegasus.client.gui.modules.masterdata.AbstractDataInsertModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.AdministrationServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.TimeUtil;
import ch.icit.pegasus.server.core.util.Triple;
import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class ActiveSessions
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private JTable table;
    private JScrollPane scrollPane;
    private TextButton refreshButton;
    private TextButton autoRefreshButton;
    private boolean autoRefresh = false;
    private Timer timer = new Timer();

    public ActiveSessions(AbstractDataInsertModule parent) {
        super(parent);
        this.refreshButton = new TextButton(Words.REFRESH);
        this.refreshButton.addButtonListener(this);
        this.add(this.refreshButton);
        this.autoRefreshButton = new TextButton(Words.SWITCH_AUTO_REFRESH_ON);
        this.autoRefreshButton.addButtonListener(this);
        this.add(this.autoRefreshButton);
        this.table = new JTable(new MyTableModel());
        final TableCellRenderer cellRenderer = this.table.getDefaultRenderer(Object.class);
        this.table.setDefaultRenderer(Object.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel lbl = (JLabel)cellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                lbl.setBackground(new Color(0x393939));
                lbl.setForeground(new Color(0xC8C8C8));
                Border border = BorderFactory.createLineBorder(new Color(0x646464), 1, false);
                Border paddingBorder = BorderFactory.createEmptyBorder(2, 5, 2, 0);
                lbl.setBorder(BorderFactory.createCompoundBorder(border, paddingBorder));
                lbl.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("button_default_font_size"), LafLoader.getLafLoader().getAttribute("button_default_font_type")));
                lbl.setHorizontalAlignment(2);
                return lbl;
            }
        });
        final TableCellRenderer headerRenderer = this.table.getTableHeader().getDefaultRenderer();
        this.table.getTableHeader().setDefaultRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel lbl = (JLabel)headerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                lbl.setForeground(new Color(0xC8C8C8));
                lbl.setBackground(new Color(0x353535));
                Border border = BorderFactory.createLineBorder(new Color(0x646464), 1, true);
                Border paddingBorder = BorderFactory.createEmptyBorder(2, 5, 2, 0);
                lbl.setBorder(BorderFactory.createCompoundBorder(border, paddingBorder));
                lbl.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("button_default_font_size"), LafLoader.getLafLoader().getAttribute("button_default_font_type")));
                lbl.setHorizontalAlignment(2);
                return lbl;
            }
        });
        this.table.setOpaque(true);
        this.table.setFillsViewportHeight(true);
        this.table.setBackground(new Color(0x1C1C1C));
        this.table.setShowGrid(false);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setBackground(new Color(0x1C1C1C));
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add(this.scrollPane);
        this.setLayout(new Layout());
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public void loadData() {
    }

    @Override
    public void saveIt() {
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.scrollPane != null) {
            this.scrollPane.setEnabled(isEnabled);
        }
        if (this.refreshButton != null) {
            this.refreshButton.setEnabled(isEnabled);
        }
        this.refreshData();
    }

    @Override
    public void insertElements() {
    }

    @Override
    public String getInsertName() {
        return Words.ACTIVE_SESSIONS;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.refreshButton) {
            this.refreshData();
        } else if (source == this.autoRefreshButton) {
            if (this.autoRefresh) {
                this.autoRefresh = false;
                this.autoRefreshButton.setText("Switch Auto Refresh ON");
            } else {
                this.refreshData();
                this.autoRefresh = true;
                this.startTimer();
                this.autoRefreshButton.setText("Switch Auto Refresh OFF");
            }
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.timer = null;
    }

    private void startTimer() {
        if (this.timer != null) {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (ActiveSessions.this.autoRefresh) {
                        ActiveSessions.this.refreshData();
                        ActiveSessions.this.startTimer();
                    }
                }
            }, 2000L);
        }
    }

    public void refreshData() {
        List sessions = new ArrayList();
        try {
            sessions = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).getSessions().getList();
        }
        catch (ClientServerCallException e) {
            e.printStackTrace();
        }
        ((MyTableModel)this.table.getModel()).clear();
        Collections.sort(sessions, Ordering.natural().onResultOf((Function)new Function<Triple<String, String, Timestamp>, Timestamp>(){

            public Timestamp apply(Triple<String, String, Timestamp> input) {
                return (Timestamp)input.getU();
            }
        }));
        for (Triple entry : sessions) {
            String time = TimeUtil.createDateFormat((String)"dd.MM.yyyy HH:mm:ss").format((Date)entry.getU());
            ((MyTableModel)this.table.getModel()).addSilent((Triple<String, String, String>)new Triple(entry.getS(), entry.getT(), (Object)time));
        }
        ((MyTableModel)this.table.getModel()).refreshTable();
    }

    class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private String[] columnNames = new String[]{"Session ID", "Username", "Last Time Used"};
        private ArrayList<Triple<String, String, String>> data = new ArrayList();

        MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row <= this.data.size()) {
                Triple<String, String, String> tuple = this.data.get(row);
                if (col == 0) {
                    return tuple.getS();
                }
                if (col == 1) {
                    return tuple.getT();
                }
                if (col == 2) {
                    return tuple.getU();
                }
            }
            return null;
        }

        public Class getColumnClass(int col) {
            if (col == 0) {
                return String.class;
            }
            if (col == 1) {
                return String.class;
            }
            if (col == 2) {
                return String.class;
            }
            return null;
        }

        public void clear() {
            int size = this.data.size();
            this.data.clear();
            this.fireTableRowsDeleted(0, size);
        }

        public void add(Triple<String, String, String> tuple) {
            this.data.add(tuple);
            this.fireTableRowsInserted(this.data.size(), this.data.size());
        }

        public void addSilent(Triple<String, String, String> tuple) {
            this.data.add(tuple);
        }

        public void refreshTable() {
            this.fireTableRowsInserted(0, this.data.size());
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border;
            int currentY = border = 10;
            if (ActiveSessions.this.scrollPane != null) {
                ActiveSessions.this.scrollPane.setLocation(border, border);
                ActiveSessions.this.scrollPane.setSize(parent.getWidth() - 2 * border, parent.getHeight() - 4 * border - ActiveSessions.this.refreshButton.getHeight() - ActiveSessions.this.autoRefreshButton.getHeight());
                currentY = ActiveSessions.this.scrollPane.getY() + ActiveSessions.this.scrollPane.getHeight();
            }
            if (ActiveSessions.this.refreshButton != null) {
                ActiveSessions.this.refreshButton.setLocation(border, currentY + border);
                ActiveSessions.this.refreshButton.setSize(parent.getWidth() - 2 * border, ((ActiveSessions)ActiveSessions.this).refreshButton.getPreferredSize().height);
                currentY = ActiveSessions.this.refreshButton.getY() + ActiveSessions.this.refreshButton.getHeight();
            }
            if (ActiveSessions.this.autoRefreshButton != null) {
                ActiveSessions.this.autoRefreshButton.setLocation(border, currentY + border);
                ActiveSessions.this.autoRefreshButton.setSize(parent.getWidth() - 2 * border, ((ActiveSessions)ActiveSessions.this).autoRefreshButton.getPreferredSize().height);
            }
        }
    }
}

