/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.admin.inserts;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.SequenceConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.admin.util.SequenceLocalizerPopup;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DataInsert;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.system.CustomSequenceComplete;
import ch.icit.pegasus.server.core.dtos.system.CustomSequenceComplete_;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.dtos.system.SequenceIdentifierE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CustomSequenceInsert
extends DataInsert<SequenceIdentifierE>
implements FileTransferListener {
    private static final long serialVersionUID = 1L;

    public CustomSequenceInsert() {
        super((MasterDataModule)null);
    }

    @Override
    public void insertElements() {
    }

    @Override
    public SequenceIdentifierE getNewObject() {
        return null;
    }

    @Override
    public Class<? extends SequenceIdentifierE> getMasterDataClass() {
        return SequenceIdentifierE.class;
    }

    @Override
    public DetailsPanel getDetails() {
        return new SequenceIdentifierInsertPanelConfig();
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArrayList<SequenceIdentifierE> list = new ArrayList<SequenceIdentifierE>();
                for (SequenceIdentifierE s : SequenceIdentifierE.values()) {
                    list.add(s);
                }
                Node r = INodeCreator.getDefaultImpl().createNodes(list, false);
                Iterator it = r.getChilds();
                while (it.hasNext()) {
                    try {
                        SequenceIdentifierE s;
                        Node sn = (Node)it.next();
                        s = (SequenceIdentifierE)sn.getValue();
                        CustomSequenceComplete cs = (CustomSequenceComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getCurrentCustomSequence(s).getValue();
                        Node csn = INodeCreator.getDefaultImpl().getNode4DTO((Object)cs, false, false);
                        csn.setName(DtoFieldConstants.location);
                        sn.addChild(csn, 0L);
                    }
                    catch (Exception exception) {}
                }
                return r;
            }

            @Override
            public RemoteLoader getInvoker() {
                return CustomSequenceInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void saveIt() {
        super.saveIt();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return CustomSequenceInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void statusChanged(File file, FileTransferState state) {
    }

    public void exceptionOccurred(Exception exception) {
    }

    @Override
    public String getInsertName() {
        return Words.LOCATIONS;
    }

    private class SequenceIdentifierInsertPanelConfig
    extends DetailsPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private Node<?> node;
        private TitledItem<CheckBox> localized;

        public SequenceIdentifierInsertPanelConfig() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.localized = new TitledItem<CheckBox>(new CheckBox(), Words.LOCALIZED, TitledItem.TitledItemOrientation.EAST);
            this.localized.getElement().addButtonListener(this);
            this.setLayout(new AALayout());
            this.add(this.localized);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            a.addAll(this.localized.getFocusComponents());
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.localized.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.localized.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.localized != null) {
                this.localized.kill();
            }
            this.localized = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            this.localized.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(SequenceConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.node = node;
            LocationComplete cs = (LocationComplete)node.getChildAt(0).getChildNamed(CustomSequenceComplete_.location).getValue();
            if (cs == null) {
                this.localized.getElement().setChecked(false);
            } else {
                this.localized.getElement().setChecked(true);
            }
            this.revalidate();
            CustomSequenceInsert.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.localized.getElement()) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(source, true, true, Words.LOCALIZE_CUSTOM_SEQUENCE);
                SequenceLocalizerPopup v = new SequenceLocalizerPopup(this.localized.getElement().isChecked(), (SequenceIdentifierE)this.node.getValue());
                popUp.setView(v);
                popUp.showPopUpWithinScreenMiddle(450, 250, new InnerPopUpListener2(){

                    @Override
                    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                    }
                }, source, PopupType.NORMAL);
            }
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                SequenceIdentifierInsertPanelConfig.this.localized.setLocation(CustomSequenceInsert.this.masterDataTable.getCellPadding(), CustomSequenceInsert.this.masterDataTable.getCellPadding());
                SequenceIdentifierInsertPanelConfig.this.localized.setSize(250, (int)SequenceIdentifierInsertPanelConfig.this.localized.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

