/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.admin.inserts;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.gui.modules.masterdata.AbstractDataInsertModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.ScrollableTextArea;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.LoggingServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelToolkit;
import ch.icit.utils.ExcelToolkitException;
import ch.icit.utils.StyledWorkbook;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;

public class EmailInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = -7712145562057077226L;
    private TitledItem<TextField> recipient;
    private TitledItem<TextField> title;
    private TitledItem<ScrollableTextArea> message;
    private Button send;
    private Button bugmail = new TextButton("Send Bugmail");
    private Button serverBugmail;
    private Button mailingList;

    public EmailInsert(AbstractDataInsertModule parent) {
        super(parent);
        this.bugmail.addButtonListener(this);
        this.serverBugmail = new TextButton("Send Server Bugmail");
        this.serverBugmail.addButtonListener(this);
        this.recipient = new TitledItem<TextField>(new TextField(), "Recipient", TitledItem.TitledItemOrientation.NORTH);
        this.title = new TitledItem<TextField>(new TextField(), "Title", TitledItem.TitledItemOrientation.NORTH);
        this.message = new TitledItem<ScrollableTextArea>(new ScrollableTextArea(), "Message", TitledItem.TitledItemOrientation.NORTH);
        this.message.setIgnorePrefHeight(true);
        this.send = new TextButton("Send");
        this.send.addButtonListener(this);
        this.mailingList = new TextButton("Mailing List");
        this.mailingList.addButtonListener(this);
        this.add(this.bugmail);
        this.add(this.serverBugmail);
        this.add(this.recipient);
        this.add(this.title);
        this.add(this.message);
        this.add(this.send);
        this.add(this.mailingList);
        this.setLayout(new Layout());
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public void loadData() {
    }

    @Override
    public void saveIt() {
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.bugmail != null) {
            this.bugmail.setEnabled(isEnabled);
            this.serverBugmail.setEnabled(isEnabled);
            this.recipient.setEnabled(isEnabled);
            this.title.setEnabled(isEnabled);
            this.message.setEnabled(isEnabled);
            this.send.setEnabled(isEnabled);
            this.mailingList.setEnabled(isEnabled);
        }
    }

    @Override
    public void insertElements() {
    }

    @Override
    public String getInsertName() {
        return Words.E_MAIL;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.bugmail) {
            try {
                String server;
                UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
                String bugMailAddress = ((SystemSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings().getValue()).getDefaultBugMailAddress();
                String userName = user == null ? "<unknown user>" : user.getUserName();
                String hostName = "<unknown host>";
                try {
                    hostName = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                try {
                    server = EjbContextFactory.getInstance().getOrbConfig().getName();
                }
                catch (IOException e2) {
                    server = "unresolved_server";
                }
                ((LoggingServiceManager)ServiceManagerRegistry.getService(LoggingServiceManager.class)).sendBugMail("Test [C: " + userName + "@" + hostName + ", " + server + "]", "Test", "Test", null, null);
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
            }
        } else if (source == this.serverBugmail) {
            try {
                ((LoggingServiceManager)ServiceManagerRegistry.getService(LoggingServiceManager.class)).sendServerBugMail("Test", "Test", "Test");
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
            }
        } else if (source == this.send) {
            try {
                ((LoggingServiceManager)ServiceManagerRegistry.getService(LoggingServiceManager.class)).sendEmail(this.title.getElement().getText(), this.message.getElement().getText(), this.recipient.getElement().getText());
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
            }
        } else if (source == this.mailingList) {
            try {
                List addresses = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getAllUserEmailAddress().getList();
                StyledWorkbook wb = ExcelToolkit.createFastWorkbook();
                Sheet sheet = ExcelToolkit.insertSheet((StyledWorkbook)wb, (String)"Contacts");
                ExcelRow h = new ExcelRow();
                h.addCell((Object)"First Name", new String[0]);
                h.addCell((Object)"Last Name", new String[0]);
                h.addCell((Object)"EMail Address", new String[0]);
                int cr = 0;
                cr = h.writeRow(wb, sheet, true, cr);
                for (String s : addresses) {
                    String[] splits = s.split(";");
                    ExcelRow r = new ExcelRow();
                    r.addCell((Object)splits[0], new String[0]);
                    r.addCell((Object)splits[1], new String[0]);
                    r.addCell((Object)splits[2], new String[0]);
                    cr = r.writeRow(wb, sheet, false, cr);
                }
                File file = FileChooserUtil.saveFile(".xlsx");
                ExcelToolkit.writeWorkBook((File)file, (StyledWorkbook)wb);
            }
            catch (ServiceException | ExcelToolkitException e) {
                InnerPopupFactory.showErrorDialog((Exception)e, (Component)this);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (EmailInsert.this.bugmail != null) {
                EmailInsert.this.bugmail.setLocation(border, border);
                EmailInsert.this.bugmail.setSize(EmailInsert.this.bugmail.getPreferredSize());
                EmailInsert.this.serverBugmail.setLocation(border, (int)(EmailInsert.this.bugmail.getLocation().getY() + (double)EmailInsert.this.bugmail.getHeight() + (double)border));
                EmailInsert.this.serverBugmail.setSize(EmailInsert.this.serverBugmail.getPreferredSize());
                EmailInsert.this.title.setLocation(border, (int)(EmailInsert.this.serverBugmail.getLocation().getY() + (double)EmailInsert.this.serverBugmail.getHeight() + (double)border));
                EmailInsert.this.title.setSize(200, (int)EmailInsert.this.title.getPreferredSize().getHeight());
                EmailInsert.this.recipient.setLocation(border, (int)(EmailInsert.this.title.getLocation().getY() + (double)EmailInsert.this.title.getHeight() + (double)border));
                EmailInsert.this.recipient.setSize(200, (int)EmailInsert.this.recipient.getPreferredSize().getHeight());
                EmailInsert.this.message.setLocation(border, (int)(EmailInsert.this.recipient.getLocation().getY() + (double)EmailInsert.this.recipient.getHeight() + (double)border));
                EmailInsert.this.message.setSize(350, 200);
                EmailInsert.this.send.setLocation(border, (int)(EmailInsert.this.message.getLocation().getY() + (double)EmailInsert.this.message.getHeight() + (double)border));
                EmailInsert.this.send.setSize(EmailInsert.this.send.getPreferredSize());
                EmailInsert.this.mailingList.setLocation(border, EmailInsert.this.send.getY() + EmailInsert.this.send.getHeight() + border * 2);
                EmailInsert.this.mailingList.setSize(EmailInsert.this.mailingList.getPreferredSize());
            }
        }
    }
}

