/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.article.details;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.gui.modules.article.details.rows.ContentDetailsTableRowImpl;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantTableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.tables.comparators.SequenceNumberComparator;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.AdditiveCharacteristicComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AllergenCharacteristicComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ContentCharacteristicComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.OtherCharacteristicComplete;
import ch.icit.pegasus.server.core.dtos.recipe.AdditiveDeclarationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.AllergenDeclarationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.AllergenDeclarationStateE;
import ch.icit.pegasus.server.core.dtos.recipe.ContentDeclarationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.ContentDeclarationComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.OtherDeclarationComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class ContentDetailsPanel<T extends ADTO, V extends ContentDeclarationComplete, C extends ContentCharacteristicComplete>
extends StateDependantTableDetailsPanel<T> {
    private static final long serialVersionUID = 1L;
    private DeclarationType type;
    private DtoField<C> characteristicField;
    private DtoField<ModificationStateE> stateField;

    public ContentDetailsPanel(RowEditor<T> editor, RDProvider provider, DtoField<ModificationStateE> stateField, DtoField<C> characteristicField, String title, DeclarationType type, boolean expandable) {
        super(editor, provider, true, true, expandable, true);
        this.stateField = stateField;
        this.characteristicField = characteristicField;
        this.type = type;
        this.setTitleText(title);
    }

    public abstract DtoField<List<V>> getAttribute();

    public abstract Class<C> getAllAttributeName();

    public abstract DtoField<Boolean> getTracesAttribute();

    @Override
    public boolean hasExpandableContent() {
        return this.table.getRowCount() > 0;
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return this.stateField;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(this.getAttribute()));
        this.table.getModel().allInitiated();
        this.validateComboContent();
    }

    private void relayoutTable() {
        this.table.updateOrder();
        this.table.relayoutRequested();
    }

    private Node<ContentCharacteristicComplete> getFreeContentCharacteristic() {
        Iterator it = NodeToolkit.getAffixList(this.getAllAttributeName()).getChilds();
        while (it.hasNext()) {
            Node contentCharacteristic = (Node)it.next();
            boolean found = false;
            for (Table2RowPanel rowPanel : this.table.getRows()) {
                ContentCharacteristicComplete cc2 = (ContentCharacteristicComplete)rowPanel.getModel().getNode().getChildNamed(this.characteristicField).getValue();
                if (!((ContentCharacteristicComplete)contentCharacteristic.getValue()).equals((Object)cc2)) continue;
                found = true;
            }
            if (found) continue;
            return contentCharacteristic;
        }
        return null;
    }

    @Override
    public List<TableColumnInfo> getColumns() {
        int deleteW = TableColumnInfo.getSortableColumnWidth(this.table);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.PRINT, null, null, null, "", 65, 65, 65));
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 100, 100, 100));
        if (this.getTracesAttribute() != null) {
            columns.add(new TableColumnInfo(Words.TRACES, null, null, null, "", 70, 70, 70));
        }
        columns.add(new TableColumnInfo("", null, null, null, "", deleteW, deleteW, deleteW));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
        if (this.getTracesAttribute() != null) {
            ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        } else {
            ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        }
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setMaxRows(NodeToolkit.getAffixList(this.getAllAttributeName()).getChildCount(), false);
        table.setProvider(this.provider);
        table.setRequestFocusOnAdd(true);
        table.setComparator(ComparatorRegistry.getComparator(SequenceNumberComparator.class));
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        AllergenDeclarationComplete newDto = null;
        Node<ContentCharacteristicComplete> freeContentCharacteristic = this.getFreeContentCharacteristic();
        if (freeContentCharacteristic != null) {
            switch (this.type) {
                case ALLERGEN: {
                    newDto = new AllergenDeclarationComplete();
                    newDto.setCharacteristic((AllergenCharacteristicComplete)freeContentCharacteristic.getValue());
                    newDto.setState(AllergenDeclarationStateE.SPECIFICATION_APPROVED);
                    newDto.setContainsTraces(Boolean.valueOf(false));
                    break;
                }
                case ADDITIVE: {
                    newDto = new AdditiveDeclarationComplete();
                    ((AdditiveDeclarationComplete)newDto).setCharacteristic((AdditiveCharacteristicComplete)freeContentCharacteristic.getValue());
                    break;
                }
                case OTHER: {
                    newDto = new OtherDeclarationComplete();
                    ((OtherDeclarationComplete)newDto).setCharacteristic((OtherCharacteristicComplete)freeContentCharacteristic.getValue());
                }
            }
            if (newDto != null) {
                newDto.setSequenceNumber(Integer.valueOf(this.table.getRowCount()));
                newDto.setDeclare(((ContentCharacteristicComplete)freeContentCharacteristic.getValue()).getDeclareDefault());
                Node newDtoNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)newDto, true, false);
                this.node.getChildNamed(this.getAttribute()).addChild(newDtoNode, System.currentTimeMillis());
            }
            this.validateComboContent();
            this.relayoutTable();
            this.editor.revalidate();
        } else {
            this.table.enableAddButton(false);
        }
    }

    @Override
    public void childRemoved() {
        this.validateComboContent();
        this.table.writeNumber(ContentDeclarationComplete_.sequenceNumber, 0);
        this.relayoutTable();
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        ContentDetailsTableRowImpl p = new ContentDetailsTableRowImpl(model, this, this.provider, this.table.getModel().isOrderChangable(), this.table.getModel().isDeletable(), this.getTracesAttribute(), this.getAllAttributeName(), this.characteristicField);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.THREE);
        return p;
    }

    public void validateComboContent() {
        List<Node<C>> list = this.getUsedDeclarations();
        for (Table2RowPanel p : this.table.getRows()) {
            ContentDetailsTableRowImpl pi = (ContentDetailsTableRowImpl)p;
            pi.updateContentCombo(list);
        }
    }

    private List<Node<C>> getUsedDeclarations() {
        ArrayList<Node<C>> list = new ArrayList<Node<C>>();
        if (this.node != null && this.node.getChildNamed(this.getAttribute()) != null) {
            Iterator it = this.node.getChildNamed(this.getAttribute()).getChilds();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                Node cc = n.getChildNamed(this.characteristicField);
                if (cc.getValue() == null) continue;
                list.add(cc);
            }
        }
        return list;
    }

    public static enum DeclarationType {
        ALLERGEN,
        ADDITIVE,
        OTHER;

    }
}

