/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.article.details;

import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.FileCommitter;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.tables.KanbanConfigurationTable;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.kanban.ArticleKanbanConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.supply.kanban.ArticleKanbanConfigurationComplete_;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class KanbanDetailsPanel
extends DefaultDetailsPanel<BasicArticleLight> {
    private static final long serialVersionUID = 1L;
    private KanbanConfigurationTable table;
    private Node storeUnitSelectionNode;

    public KanbanDetailsPanel(RowEditor<BasicArticleLight> editor, Node storeUnitSelectionNode, RDProvider provider) {
        super(editor, provider);
        this.storeUnitSelectionNode = storeUnitSelectionNode;
        this.setTitleText("Kanban Configuration");
        this.table = new KanbanConfigurationTable(provider, storeUnitSelectionNode, (Node<BasicArticleComplete>)editor.getModel().getNode());
        this.setCustomLayouter(new Layout());
        this.addToView(this.table);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.editor.getModel().getNode().getChildNamed(BasicArticleComplete_.kanbanConfigurations).getFailSafeChildIterator();
        boolean positionNotSet = false;
        boolean cardQuantitySet = true;
        boolean dailyQuantitySet = true;
        boolean validityMissmatch = false;
        java.util.Date lastDate = null;
        while (it.hasNext()) {
            Node node = (Node)it.next();
            Date startDate = (Date)node.getChildNamed(new DtoField[]{ArticleKanbanConfigurationComplete_.validity, PeriodComplete_.startDate}).getValue();
            Date endDate = (Date)node.getChildNamed(new DtoField[]{ArticleKanbanConfigurationComplete_.validity, PeriodComplete_.endDate}).getValue();
            if (startDate.getTime() > endDate.getTime()) {
                validityMissmatch = true;
            }
            if (lastDate == null) {
                lastDate = new Date(endDate.getTime());
            } else if (lastDate.getTime() + 1L != startDate.getTime()) {
                validityMissmatch = true;
            }
            if (node.getChildNamed(ArticleKanbanConfigurationComplete_.storePosition).getValue() == null) {
                positionNotSet = true;
            }
            Node qty1Node = node.getChildNamed(ArticleKanbanConfigurationComplete_.quantityPerCard);
            qty1Node.commitThis();
            if (qty1Node.getValue() == null || ((StoreQuantityComplete)qty1Node.getValue()).getAmount() < 1L) {
                cardQuantitySet = false;
            }
            qty1Node = node.getChildNamed(ArticleKanbanConfigurationComplete_.averageDailyUsageQuantity);
            qty1Node.commitThis();
            if (qty1Node.getValue() != null && ((StoreQuantityComplete)qty1Node.getValue()).getAmount() >= 1L) continue;
            dailyQuantitySet = false;
        }
        if (positionNotSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Kanban: Ensure all Store Positions are set"));
        }
        if (!cardQuantitySet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Kanban: Ensure all Card Quantities are set"));
        }
        if (!dailyQuantitySet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Kanban: Ensure all Daily Quantities are set"));
        }
        if (validityMissmatch) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Kanban: Validity Date is correct"));
        }
        return a;
    }

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode(node.getChildNamed(BasicArticleComplete_.kanbanConfigurations));
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusComponents = new ArrayList<Component>();
        CheckedListAdder.addToList(focusComponents, this.table);
        return focusComponents;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        ArrayList<RemoteCommitter> commitList = new ArrayList<RemoteCommitter>();
        Iterator it = this.editor.getModel().getNode().getChildNamed(BasicArticleComplete_.kanbanConfigurations).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node kanbanConfigurationCompleteNode = (Node)it.next();
            Node imageNode = kanbanConfigurationCompleteNode.getChildNamed(ArticleKanbanConfigurationComplete_.image);
            PegasusFileComplete imageFile = (PegasusFileComplete)imageNode.getValue(PegasusFileComplete.class);
            if (imageFile == null || imageFile.getLocalFile() == null) continue;
            FileCommitter committer = new FileCommitter(imageFile.getLocalFile());
            committer.setWriteBackAlgorithm(reference -> {
                imageNode.setValue((Object)reference, 0L);
                ((ArticleKanbanConfigurationComplete)kanbanConfigurationCompleteNode.getValue()).setImage(reference);
            });
            commitList.add(committer);
        }
        return commitList;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            KanbanDetailsPanel.this.table.setLocation(0, 0);
            KanbanDetailsPanel.this.table.setSize(parent.getWidth(), parent.getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 400);
        }
    }
}

