/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.articlegroup.details;

import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.ordering.articlegroup.ArticleGroupComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.articlegroup.ArticleGroupEntryComplete;
import ch.icit.pegasus.server.core.dtos.ordering.articlegroup.ArticleGroupEntryComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.articlegroup.ArticleGroupLight;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ArticlesDetailsPanel
extends TableDetailsPanel<ArticleGroupLight> {
    private static final long serialVersionUID = 1L;

    public ArticlesDetailsPanel(RowEditor<ArticleGroupLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.ARTICLES);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.ARTICLE, "", String.class, null, "", 120, Integer.MAX_VALUE, 120));
        int tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo("", "", String.class, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setProvider(this.provider);
        table.setUseWriteAccessRight(true);
        table.setDontUseScrollBar(15);
        table.setRequestFocusOnAdd(true);
        table.setSortedColumn(0);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        ArticleGroupEntryComplete entryComplete = new ArticleGroupEntryComplete();
        entryComplete.setClientOId(Long.valueOf(ADTO.getNextId()));
        this.table.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)entryComplete, true, false), 0L);
    }

    @Override
    public void childRemoved() {
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        return new TableRowImpl(model);
    }

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode(node.getChildNamed(SafetyStockComplete_.articles));
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private RDSearchTextField2<BasicArticleLight> article;
        private DeleteButton deleteButton;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.article = new RDSearchTextField2(ArticlesDetailsPanel.this.provider, RDSearchTextField2.SearchTypes.ARTICLE, true);
            this.article.setOverrideName(ArticleGroupComplete_.articles);
            this.article.setNode(m.getNode().getChildNamed(ArticleGroupEntryComplete_.article));
            this.deleteButton = new DeleteButton();
            this.deleteButton.addButtonListener((source, x, y) -> ArticlesDetailsPanel.this.table.getModel().getNode().removeChild(this.model.getNode(), 0L));
            this.setLayout(new Layout());
            this.add(this.article);
            this.add(this.deleteButton);
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.article.requestFocusInWindowNow();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            if (ArticlesDetailsPanel.this.provider.isWritable(ArticleGroupComplete_.articles)) {
                this.deleteButton.setEnabled(isEnabled);
            } else {
                this.deleteButton.setEnabled(false);
            }
            this.article.setEnabled(isEnabled);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.article);
            CheckedListAdder.addToList(focusList, this.deleteButton);
            return focusList;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.article.kill();
            this.deleteButton.kill();
            this.article = null;
            this.deleteButton = null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = 0;
                currentX += w;
                w = ArticlesDetailsPanel.this.table.getModel().getColumnWidth(0);
                TableRowImpl.this.article.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.article.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.article.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.article.getPreferredSize().getHeight());
                currentX += w;
                w = ArticlesDetailsPanel.this.table.getModel().getColumnWidth(1);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.deleteButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.deleteButton.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.deleteButton.getPreferredSize().getHeight());
            }
        }
    }
}

