/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.articlepricecontract.details;

import ch.icit.pegasus.client.gui.modules.articlepricecontract.details.utils.ArticleContractExportPopup;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ArticlePriceContractAccess;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractComplete_;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractLight;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ActionDetailsPanel
extends DefaultDetailsPanel<ArticlePriceContractLight>
implements InnerPopUpListener2,
NodeListener {
    private static final long serialVersionUID = 1L;
    private TextButton exportB;
    private TextButton importB;
    private TextButton unlockB;
    private boolean isExported;
    private static final int STATE_IMPORT = 3;
    private static final int STATE_EXPORT = 5;
    private int newState;
    private final boolean canExport;
    private final boolean canImport;
    private final boolean canUnlock;

    public ActionDetailsPanel(RowEditor<ArticlePriceContractLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.ACTIONS);
        this.exportB = new TextButton(Words.EXPORT_SUPPLIER_SHEET);
        this.importB = new TextButton(Words.IMPORT_SUPPLIER_SHEET);
        this.unlockB = new TextButton(Words.UNLOCK_CONTRACT);
        this.canExport = provider.isWritable(ArticlePriceContractAccess.EXPORT);
        this.canImport = provider.isWritable(ArticlePriceContractAccess.IMPORT);
        this.canUnlock = provider.isWritable(ArticlePriceContractAccess.UNLOCK);
        this.exportB.addButtonListener(this);
        this.importB.addButtonListener(this);
        this.unlockB.addButtonListener(this);
        this.setCustomLayouter(new Layout());
        this.addToView(this.exportB);
        this.addToView(this.importB);
        this.addToView(this.unlockB);
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        Object exportedValue = node.getChildNamed(ArticlePriceContractComplete_.exported).getValue();
        if (exportedValue == null) {
            exportedValue = false;
        }
        this.isExported = (Boolean)exportedValue;
        node.getChildNamed(ArticlePriceContractComplete_.exported).addNodeListener((NodeListener)this);
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean isAccepted = this.editor.getModel().getNode().getChildNamed(ArticlePriceContractComplete_.state).getValue() == ArticlePriceContractStateE.ACCPTED;
        this.exportB.setEnabled(isEnabled && this.canExport && !isAccepted);
        this.importB.setEnabled(isEnabled && this.canImport && !isAccepted);
        this.unlockB.setEnabled(isEnabled && (this.isExported && this.canUnlock || isAccepted));
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.editor.getModel().getNode().getChildNamed(ArticlePriceContractComplete_.exported) != null) {
            this.editor.getModel().getNode().getChildNamed(ArticlePriceContractComplete_.exported).removeNodeListener((NodeListener)this);
        }
        this.importB.kill();
        this.exportB.kill();
        this.unlockB.kill();
        this.importB = null;
        this.exportB = null;
        this.unlockB = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.exportB);
        CheckedListAdder.addToList(focusList, this.importB);
        CheckedListAdder.addToList(focusList, this.unlockB);
        return focusList;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.exportB) {
            this.newState = 5;
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(source, true, true, Words.EXPORT);
            popUp.setView(new ArticleContractExportPopup(true, Words.STYLED_EXPORT_CONTRACT_TEXT, Words.EXPORT, "", this, true, this.editor.getModel().getNode()));
            popUp.showPopUp(x, y, 400, 150, this, source);
            popUp.setOkButtonText(Words.EXPORT);
            this.setEnabled(false);
        } else if (source == this.importB) {
            this.newState = 3;
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(source, true, true, Words.IMPORT);
            popUp.setView(new ArticleContractExportPopup(true, Words.STYLED_IMPORT_CONTRACT_TEXT, Words.IMPORT, "", this, false, null));
            popUp.showPopUp(x, y, 400, 150, this, source);
            popUp.setOkButtonText(Words.IMPORT);
            this.setEnabled(false);
        } else if (source == this.unlockB) {
            this.editor.getModel().getNode().getChildNamed(ArticlePriceContractComplete_.exported).setValue((Object)false, System.currentTimeMillis());
            this.fireFocusCycleChanged(this);
        }
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        this.setEnabled(true);
        if (xargs == null) {
            return;
        }
        if (this.newState == 5) {
            this.editor.getModel().getNode().getChildNamed(ArticlePriceContractComplete_.exported).setValue((Object)true, System.currentTimeMillis());
            this.editor.getModel().getNode().getChildNamed(ArticlePriceContractComplete_.state).setValue((Object)ArticlePriceContractStateE.EXPORTED, 0L);
        } else if (this.newState == 3) {
            this.editor.getModel().getNode().getChildNamed(ArticlePriceContractComplete_.state).setValue((Object)ArticlePriceContractStateE.IMPORTED, 0L);
        } else {
            this.editor.getModel().getNode().getChildNamed(ArticlePriceContractComplete_.state).setValue((Object)ArticlePriceContractStateE.PLANNED, 0L);
        }
        this.fireFocusCycleChanged(this);
    }

    public void valueChanged(Node<?> node) {
        Object value = node.getValue();
        if (value == null) {
            value = false;
        }
        this.editor.getModel().getNode().getChildNamed(ArticlePriceContractComplete_.state).setValue((Object)ArticlePriceContractStateE.PLANNED, System.currentTimeMillis());
        this.isExported = (Boolean)value;
        this.editor.setEnabled(this.isEnabled());
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ActionDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ActionDetailsPanel.this.exportB.getPreferredSize().getHeight());
            h += ActionDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ActionDetailsPanel.this.importB.getPreferredSize().getHeight());
            return new Dimension(0, h += ActionDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            ActionDetailsPanel.this.exportB.setLocation(ActionDetailsPanel.this.horizontalBorder, ActionDetailsPanel.this.verticalBorder);
            ActionDetailsPanel.this.exportB.setSize(ActionDetailsPanel.this.exportB.getPreferredSize());
            ActionDetailsPanel.this.unlockB.setLocation(ActionDetailsPanel.this.exportB.getX() + ActionDetailsPanel.this.exportB.getWidth() + 10, ActionDetailsPanel.this.exportB.getY());
            ActionDetailsPanel.this.unlockB.setSize(ActionDetailsPanel.this.unlockB.getPreferredSize());
            ActionDetailsPanel.this.importB.setLocation(ActionDetailsPanel.this.horizontalBorder, ActionDetailsPanel.this.exportB.getY() + ActionDetailsPanel.this.exportB.getHeight() + ActionDetailsPanel.this.verticalBorder);
            ActionDetailsPanel.this.importB.setSize(ActionDetailsPanel.this.importB.getPreferredSize());
        }
    }
}

