/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.checkin.article.details;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.panels.documentscan.DocumentScanToolkit;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete_;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupComplete;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupComplete_;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupLight;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckinComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SpecificationDetailsPanel
extends DefaultDetailsPanel<StockCheckinGroupLight>
implements InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDTextField> name;
    private TitledItem<TextLabel> number;
    private TitledItem<RDComboBox> department;
    private TitledItem<RDDateChooser> dateChooser;
    private TitledItem<RDTextField> description;
    private TitledItem<EditButton> documents;
    private TitledItem<RDMultiLocationComboBox> locations;

    public SpecificationDetailsPanel(RowEditor<StockCheckinGroupLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.BASIC_DATA);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.number = new TitledItem<TextLabel>(new TextLabel(), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setReadOnlyTextField(true);
        this.department = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(CostCenterConverter.class)), Words.DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
        this.dateChooser = new TitledItem<RDDateChooser>(new RDDateChooser(provider), Words.CHECKIN_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.documents = new TitledItem<EditButton>(new EditButton(), Words.CUSTOMS_DOCUMENTS, TitledItem.TitledItemOrientation.WEST);
        this.description = new TitledItem<RDTextField>(new RDTextField(provider), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider, true), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        this.documents.getElement().addButtonListener(this);
        this.setCustomLayouter(new Layout());
        this.addToView(this.name);
        this.addToView(this.number);
        this.addToView(this.department);
        this.addToView(this.dateChooser);
        this.addToView(this.documents);
        this.addToView(this.description);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.locations);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.documents.getElement()) {
            InnerPopupFactory.showCustomsDocumentsEditPopup(source, this.editor.getModel().getNode().getChildNamed(StockCheckinGroupComplete_.documents), this.provider, true, x, y);
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        boolean hasBondedArticles = false;
        Iterator it = this.editor.getModel().getNode().getChildNamed(StockCheckinGroupComplete_.stockCheckins).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node next = (Node)it.next();
            BasicArticleLight article = (BasicArticleLight)next.getChildNamed(ManualStockCheckinComplete_.article).getValue(BasicArticleLight.class);
            if (!Boolean.TRUE.equals(article.getBonded())) continue;
            hasBondedArticles = true;
        }
        if (this.editor.getModel().getNode().getChildNamed(StockCheckinGroupComplete_.name).getValue() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NAME_IS_SET));
            this.name.getElement().setInvalid();
        }
        if (this.editor.getModel().getNode().getChildNamed(StockCheckinGroupComplete_.checkinDate).getValue() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_DATE_IS_SET));
            this.dateChooser.getElement().setInvalid();
        }
        if (this.editor.getModel().getNode().getChildNamed(StockCheckinGroupComplete_.costCenter).getValue() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_DEPARTMENT_IS_SET));
            this.department.getElement().setInvalid();
        }
        boolean hasDocument = false;
        it = this.editor.getModel().getNode().getChildNamed(StockCheckinGroupComplete_.documents).getFailSafeChildIterator();
        if (it.hasNext()) {
            hasDocument = true;
        }
        while (it.hasNext()) {
            ScreenValidationObject screenValidationObject;
            Node n = (Node)it.next();
            if (n.getChildNamed(CustomsDocumentComplete_.customsDocumentId).getValue() == null || ((String)n.getChildNamed(CustomsDocumentComplete_.customsDocumentId).getValue()).isEmpty()) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_CUSTOMS_DOCS_ID_IS_SET));
                continue;
            }
            String value = (String)n.getChildNamed(CustomsDocumentComplete_.customsDocumentId).getValue();
            try {
                Integer integer = Integer.valueOf(value);
                if (integer == 0) {
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_CUSTOMS_DOCS_ID_IS_SET));
                }
            }
            catch (Exception integer) {
                // empty catch block
            }
            if ((screenValidationObject = DocumentScanToolkit.validateDocumentNumber(value, null)) == null) continue;
            validationObjects.add(screenValidationObject);
        }
        if (Boolean.TRUE.equals(this.settings.getAllowPurchaseBondedRestriction())) {
            if (!hasDocument && hasBondedArticles) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ADD_CUSTOMS_DOCUMENTS_FOR_BONDED_ARTICLE));
            }
            if (hasDocument && !hasBondedArticles) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NO_CUSTOMS_DOCUMENT_IS_ADDED));
            }
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.locations.getElement().isWritable() && this.locations.getElement().getNode().getChildCount() != 1) {
            this.locations.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_EXCALTY_ONE_LOCATION_IS_SET));
        }
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.name.setEnabled(isEnabled);
        this.number.setEnabled(isEnabled);
        this.department.setEnabled(isEnabled);
        this.dateChooser.setEnabled(isEnabled);
        this.documents.setEnabled(isEnabled);
        this.description.setEnabled(isEnabled);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.name.kill();
        this.name = null;
        this.number.kill();
        this.number = null;
        this.department.kill();
        this.department = null;
        this.dateChooser.kill();
        this.dateChooser = null;
        this.documents.kill();
        this.documents = null;
        this.description.kill();
        this.description = null;
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.kill();
        }
        this.locations = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.department);
        CheckedListAdder.addToList(focusList, this.dateChooser);
        CheckedListAdder.addToList(focusList, this.description);
        CheckedListAdder.addToList(focusList, this.documents);
        CheckedListAdder.addToList(focusList, this.locations);
        return focusList;
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (node.getChildNamed(StockCheckinGroupComplete_.checkinDate).getValue() == null) {
            node.getChildNamed(StockCheckinGroupComplete_.checkinDate).setValue((Object)new Date(System.currentTimeMillis()), 0L);
        }
        if (this.editor.getModel().isAddRow()) {
            StockCheckinGroupComplete dto = (StockCheckinGroupComplete)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        this.name.getElement().setNode(node.getChildNamed(StockCheckinGroupComplete_.name));
        this.number.getElement().setNode(node.getChildNamed(StockCheckinGroupComplete_.number));
        this.dateChooser.getElement().setNode(node.getChildNamed(StockCheckinGroupComplete_.checkinDate));
        this.department.getElement().setNode(node.getChildNamed(StockCheckinGroupComplete_.costCenter));
        this.department.getElement().refreshPossibleValues(NodeToolkit.getAffixList(CostCenterComplete.class));
        this.description.getElement().setNode(node.getChildNamed(StockCheckinGroupComplete_.description));
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.getElement().setNode(node.getChildNamed(StockCheckinGroupComplete_.eligibleLocations));
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.dateChooser.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.department.getPreferredSize().getHeight());
            return new Dimension(0, h += SpecificationDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            SpecificationDetailsPanel.this.name.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            int wtl = (parent.getWidth() - 3 * SpecificationDetailsPanel.this.horizontalBorder) / 3;
            SpecificationDetailsPanel.this.name.setSize(wtl * 2, (int)SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.number.setLocation(SpecificationDetailsPanel.this.name.getX() + SpecificationDetailsPanel.this.name.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.name.getY());
            SpecificationDetailsPanel.this.number.setSize(parent.getWidth() - (SpecificationDetailsPanel.this.number.getX() + SpecificationDetailsPanel.this.horizontalBorder), (int)SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.dateChooser.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.name.getY() + SpecificationDetailsPanel.this.name.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.dateChooser.setSize(SpecificationDetailsPanel.this.dateChooser.getPreferredSize());
            SpecificationDetailsPanel.this.description.setLocation(SpecificationDetailsPanel.this.dateChooser.getX() + SpecificationDetailsPanel.this.dateChooser.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.dateChooser.getY());
            SpecificationDetailsPanel.this.description.setSize(parent.getWidth() - (SpecificationDetailsPanel.this.description.getX() + SpecificationDetailsPanel.this.horizontalBorder), (int)SpecificationDetailsPanel.this.description.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.documents.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.dateChooser.getY() + SpecificationDetailsPanel.this.dateChooser.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.documents.setSize(SpecificationDetailsPanel.this.documents.getPreferredSize());
            SpecificationDetailsPanel.this.department.setLocation(SpecificationDetailsPanel.this.documents.getX() + SpecificationDetailsPanel.this.documents.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.documents.getY());
            SpecificationDetailsPanel.this.department.setSize(220, (int)SpecificationDetailsPanel.this.department.getPreferredSize().getHeight());
            if (Boolean.TRUE.equals(SpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                SpecificationDetailsPanel.this.locations.setLocation(SpecificationDetailsPanel.this.department.getX() + SpecificationDetailsPanel.this.department.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.documents.getY());
                SpecificationDetailsPanel.this.locations.setSize(SpecificationDetailsPanel.this.locations.getPreferredSize());
            }
        }
    }
}

