/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.tables.UserSearchTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.exchange.HalalCertificationStateExchangeServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.ESpecsSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.report.especs.ESpecsConfig;
import ch.icit.pegasus.server.core.dtos.supply.halal.ArticleHalalStateSettingsComplete;
import ch.icit.pegasus.server.core.dtos.supply.halal.ArticleHalalStateSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.util.DailyTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class HalalCertificationStateExchangeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TitledItem<CheckBox> useAutoCheck;
    private TitledItem<TextField> recipients;
    private HorizontalSeparator sep1;
    private TablePanelAddSaveButton checkButton;
    private TablePanelAddSaveButton saveButton;
    private UserSearchTable usersToInform;
    private final DataExchangeModule module;
    private Node<ArticleHalalStateSettingsComplete> settings;

    public HalalCertificationStateExchangeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
        ESpecsConfig e = new ESpecsConfig();
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.useAutoCheck = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(ArticleHalalStateSettingsComplete_.useAutoCheck)), "Auto Check Article Halal State", TitledItem.TitledItemOrientation.EAST);
        this.useAutoCheck.getElement().addButtonListener(this);
        this.recipients = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(ArticleHalalStateSettingsComplete_.mailRecipients)), "Email Recipients", TitledItem.TitledItemOrientation.NORTH);
        this.sep1 = new HorizontalSeparator();
        this.usersToInform = new UserSearchTable();
        this.usersToInform.getModel().setNode(this.settings.getChildNamed(ESpecsSettingsComplete_.user));
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.checkButton = new TablePanelAddSaveButton();
        this.checkButton.setText(Words.CHECK_ALL);
        this.checkButton.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.useAutoCheck);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.sep1);
        this.configPanel.add(this.usersToInform);
        this.configPanel.add(this.recipients);
        this.sendPanel.add(this.checkButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllTimeDurations();
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                ArticleHalalStateSettingsComplete esc = null;
                try {
                    esc = (ArticleHalalStateSettingsComplete)((HalalCertificationStateExchangeServiceManager)ServiceManagerRegistry.getService(HalalCertificationStateExchangeServiceManager.class)).getHalalCertificationSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (esc == null) {
                    ArticleHalalStateSettingsComplete s = new ArticleHalalStateSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    esc = s;
                }
                if (esc.getHalalStateTimer() == null) {
                    esc.setHalalStateTimer(HalalCertificationStateExchangeInsert.this.createTimerServiceTime());
                }
                HalalCertificationStateExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)esc, false, false);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return HalalCertificationStateExchangeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createTimerServiceTime() {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        ts.setTimerServiceConfig((TimerServiceConfigComplete)new DailyTimeComplete(Integer.valueOf(20), Integer.valueOf(30)));
        ts.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return ts;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useAutoCheck.setEnabled(isEnabled);
            boolean b = isEnabled && this.useAutoCheck.getElement().isChecked();
            this.checkButton.setEnabled(b);
            this.sep1.setEnabled(b);
            this.saveButton.setEnabled(isEnabled);
            this.recipients.setEnabled(b);
            this.usersToInform.setEnabled(b);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.recipients.kill();
            this.recipients.kill();
            this.saveButton.kill();
            this.sep1.kill();
            this.useAutoCheck.kill();
            this.usersToInform.kill();
            this.usersToInform = null;
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.checkButton = null;
        this.saveButton = null;
        this.sep1 = null;
        this.useAutoCheck = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return Words.ARTICLE_HALAL_CERTIFICATION;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.checkButton || source == this.saveButton) {
            this.settings.commit();
            this.setEnabled(false);
            if (source == this.checkButton) {
                this.ensureAnimation(Words.EXCHANGE);
                this.processFiles(true);
            } else if (source == this.saveButton) {
                List<ScreenValidationObject> a = this.validateHalalConfig();
                if (a.isEmpty()) {
                    this.ensureAnimation(Words.SAVE_DATA);
                    this.saveConfig();
                } else {
                    InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
                    this.setEnabled(true);
                    return;
                }
            }
            this.module.started();
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private List<ScreenValidationObject> validateHalalConfig() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        return a;
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                HalalCertificationStateExchangeInsert.this.settings.commit(ArticleHalalStateSettingsComplete.class);
                ArticleHalalStateSettingsComplete halalSettings = (ArticleHalalStateSettingsComplete)HalalCertificationStateExchangeInsert.this.settings.getValue();
                if (halalSettings.getHalalStateTimer() == null) {
                    halalSettings.setHalalStateTimer(HalalCertificationStateExchangeInsert.this.createTimerServiceTime());
                }
                TimerServiceSettingsComplete checkerTs = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(halalSettings.getHalalStateTimer()).getValue();
                halalSettings = (ArticleHalalStateSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)halalSettings).getValue();
                ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.HALAL_CERTIFICATION, halalSettings.getUseAutoCheck().booleanValue(), checkerTs, -1L);
                HalalCertificationStateExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)halalSettings, false, false);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        HalalCertificationStateExchangeInsert.this.hideAnimation();
                        HalalCertificationStateExchangeInsert.this.module.ended();
                        HalalCertificationStateExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)HalalCertificationStateExchangeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFiles(boolean read) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ((HalalCertificationStateExchangeServiceManager)ServiceManagerRegistry.getService(HalalCertificationStateExchangeServiceManager.class)).checkArticleHalalState();
                ViewNode n = new ViewNode("");
                n.setValue((Object)true, 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        HalalCertificationStateExchangeInsert.this.hideAnimation();
                        HalalCertificationStateExchangeInsert.this.module.ended();
                        HalalCertificationStateExchangeInsert.this.setEnabled(true);
                        InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_PROCESSED, HalalCertificationStateExchangeInsert.this.checkButton);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, Words.UNABLE_TO_PROCESS, (Component)HalalCertificationStateExchangeInsert.this.checkButton);
                        HalalCertificationStateExchangeInsert.this.hideAnimation();
                        HalalCertificationStateExchangeInsert.this.setEnabled(true);
                        HalalCertificationStateExchangeInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            HalalCertificationStateExchangeInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            HalalCertificationStateExchangeInsert.this.useAutoCheck.setLocation(border, border + HalalCertificationStateExchangeInsert.this.configPanel.getTitleHeight());
            HalalCertificationStateExchangeInsert.this.useAutoCheck.setSize(HalalCertificationStateExchangeInsert.this.useAutoCheck.getPreferredSize());
            HalalCertificationStateExchangeInsert.this.sep1.setLocation(1, HalalCertificationStateExchangeInsert.this.useAutoCheck.getY() + HalalCertificationStateExchangeInsert.this.useAutoCheck.getHeight() + 1);
            HalalCertificationStateExchangeInsert.this.sep1.setSize(parent.getWidth() - 2, (int)HalalCertificationStateExchangeInsert.this.sep1.getPreferredSize().getHeight());
            HalalCertificationStateExchangeInsert.this.recipients.setLocation(border, HalalCertificationStateExchangeInsert.this.sep1.getY() + HalalCertificationStateExchangeInsert.this.sep1.getHeight() + border);
            HalalCertificationStateExchangeInsert.this.recipients.setSize(200, (int)HalalCertificationStateExchangeInsert.this.recipients.getPreferredSize().getHeight());
            HalalCertificationStateExchangeInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - HalalCertificationStateExchangeInsert.this.saveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ((double)border + HalalCertificationStateExchangeInsert.this.saveButton.getPreferredSize().getHeight())));
            HalalCertificationStateExchangeInsert.this.saveButton.setSize(HalalCertificationStateExchangeInsert.this.saveButton.getPreferredSize());
            HalalCertificationStateExchangeInsert.this.usersToInform.setLocation(border, HalalCertificationStateExchangeInsert.this.recipients.getY() + HalalCertificationStateExchangeInsert.this.recipients.getHeight() + border);
            HalalCertificationStateExchangeInsert.this.usersToInform.setSize(parent.getWidth() - 2 * HalalCertificationStateExchangeInsert.this.usersToInform.getX(), parent.getHeight() - HalalCertificationStateExchangeInsert.this.usersToInform.getY());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            HalalCertificationStateExchangeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            HalalCertificationStateExchangeInsert.this.checkButton.setLocation((int)((double)parent.getWidth() - HalalCertificationStateExchangeInsert.this.checkButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - (2.0 * HalalCertificationStateExchangeInsert.this.checkButton.getPreferredSize().getHeight() + (double)(2 * border))));
            HalalCertificationStateExchangeInsert.this.checkButton.setSize(HalalCertificationStateExchangeInsert.this.checkButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (HalalCertificationStateExchangeInsert.this.animation != null) {
                HalalCertificationStateExchangeInsert.this.animation.setLocation((int)((double)parent.getWidth() - HalalCertificationStateExchangeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - HalalCertificationStateExchangeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                HalalCertificationStateExchangeInsert.this.animation.setSize(HalalCertificationStateExchangeInsert.this.animation.getPreferredSize());
            }
            if (HalalCertificationStateExchangeInsert.this.isInserted) {
                HalalCertificationStateExchangeInsert.this.configPanel.setLocation(border, border);
                HalalCertificationStateExchangeInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                HalalCertificationStateExchangeInsert.this.sendPanel.setLocation(HalalCertificationStateExchangeInsert.this.configPanel.getX() + HalalCertificationStateExchangeInsert.this.configPanel.getWidth() + border, border);
                HalalCertificationStateExchangeInsert.this.sendPanel.setSize(HalalCertificationStateExchangeInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

