/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.incidentlog.IncidentLogServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentLogSettingsComplete;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentLogSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.util.DailyTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class IncidentLogReminderInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TitledItem<CheckBox> useIncidentLogReminder;
    private TitledItem<CheckBox> remind1Weeks;
    private TitledItem<CheckBox> remind2Days;
    private TitledItem<CheckBox> remind1Day;
    private TitledItem<CheckBox> remindOverdue;
    private TitledItem<TextField> notificationAddress;
    private TablePanelAddSaveButton saveButton;
    private TablePanelAddSaveButton sendButton;
    private final DataExchangeModule module;
    protected Node<IncidentLogSettingsComplete> settings;
    protected IncidentLogSettingsComplete arisc;

    public IncidentLogReminderInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.useIncidentLogReminder = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(IncidentLogSettingsComplete_.autoCheckIncidentReminder)), "Use Auto Incident Log Reminder", TitledItem.TitledItemOrientation.EAST);
        this.useIncidentLogReminder.getElement().addButtonListener(this);
        this.remind1Weeks = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(IncidentLogSettingsComplete_.remind1Week)), "Remind 1 Week", TitledItem.TitledItemOrientation.EAST);
        this.remind2Days = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(IncidentLogSettingsComplete_.remind2Days)), "Remind 2 Days", TitledItem.TitledItemOrientation.EAST);
        this.remind1Day = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(IncidentLogSettingsComplete_.remind1Day)), "Remind 1 Day", TitledItem.TitledItemOrientation.EAST);
        this.remindOverdue = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(IncidentLogSettingsComplete_.remindOverdue)), "Remind Overdue", TitledItem.TitledItemOrientation.EAST);
        this.notificationAddress = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(IncidentLogSettingsComplete_.overdueNotificationAddress)), "Overdue CC Address", TitledItem.TitledItemOrientation.EAST);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.sendButton = new TablePanelAddSaveButton();
        this.sendButton.setText(Words.CHECK_ALL);
        this.sendButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.useIncidentLogReminder);
        this.configPanel.add(this.remind1Weeks);
        this.configPanel.add(this.remind2Days);
        this.configPanel.add(this.remind1Day);
        this.configPanel.add(this.remindOverdue);
        this.configPanel.add(this.notificationAddress);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.sendButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                try {
                    IncidentLogReminderInsert.this.arisc = (IncidentLogSettingsComplete)((IncidentLogServiceManager)ServiceManagerRegistry.getService(IncidentLogServiceManager.class)).getSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (IncidentLogReminderInsert.this.arisc == null) {
                    IncidentLogSettingsComplete s = new IncidentLogSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    IncidentLogReminderInsert.this.arisc = s;
                }
                IncidentLogReminderInsert.this.arisc.setTimerServiceIncidentReminder(IncidentLogReminderInsert.this.createDailyTimerService());
                IncidentLogReminderInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)IncidentLogReminderInsert.this.arisc, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return IncidentLogReminderInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createDailyTimerService() {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        ts.setTimerServiceConfig((TimerServiceConfigComplete)new DailyTimeComplete(Integer.valueOf(7), Integer.valueOf(0), Integer.valueOf(0)));
        ts.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return ts;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useIncidentLogReminder.setEnabled(isEnabled);
            boolean b = isEnabled && this.useIncidentLogReminder.getElement().isChecked();
            this.remind1Weeks.setEnabled(b);
            this.remind2Days.setEnabled(b);
            this.remind1Day.setEnabled(b);
            this.remindOverdue.setEnabled(b);
            this.notificationAddress.setEnabled(b);
            this.saveButton.setEnabled(isEnabled);
            this.sendButton.setEnabled(b);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.saveButton.kill();
            this.sendButton.kill();
            this.useIncidentLogReminder.kill();
            this.remind1Weeks.kill();
            this.remind2Days.kill();
            this.remind1Day.kill();
            this.remindOverdue.kill();
            this.notificationAddress.kill();
        }
        this.remind1Weeks = null;
        this.remind2Days = null;
        this.remind1Day = null;
        this.remindOverdue = null;
        this.notificationAddress = null;
        this.sendPanel = null;
        this.configPanel = null;
        this.saveButton = null;
        this.sendButton = null;
        this.useIncidentLogReminder = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return Words.INCIDENT_LOG_REMINDER;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.saveButton) {
            this.setEnabled(false);
            this.ensureAnimation(Words.SAVE_DATA);
            this.saveConfig();
            this.module.started();
        } else if (source == this.sendButton) {
            this.performCheck();
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private void performCheck() {
        this.ensureAnimation("Check for reminders");
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                ((IncidentLogServiceManager)ServiceManagerRegistry.getService(IncidentLogServiceManager.class)).checkForReminders();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        InnerPopupFactory.showMessageDialog("Reminder Check successful", IncidentLogReminderInsert.this);
                        IncidentLogReminderInsert.this.hideAnimation();
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog("Reminder Check failed", (Component)IncidentLogReminderInsert.this);
                        IncidentLogReminderInsert.this.hideAnimation();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                IncidentLogReminderInsert.this.settings.commit(IncidentLogSettingsComplete.class);
                IncidentLogSettingsComplete arisc = (IncidentLogSettingsComplete)IncidentLogReminderInsert.this.settings.getValue();
                if (Boolean.TRUE.equals(arisc.getAutoCheckIncidentReminder())) {
                    arisc.setTimerServiceIncidentReminder(IncidentLogReminderInsert.this.createDailyTimerService());
                    TimerServiceSettingsComplete ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(arisc.getTimerServiceIncidentReminder()).getValue();
                    arisc.setTimerServiceIncidentReminder(ts);
                    arisc = (IncidentLogSettingsComplete)((IncidentLogServiceManager)ServiceManagerRegistry.getService(IncidentLogServiceManager.class)).updateSettings(arisc).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.INCIDENT_LOG_REMINDER, true, ts, -1L);
                    IncidentLogReminderInsert.this.settings.setValue((Object)arisc, 0L);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.INCIDENT_LOG_REMINDER);
                    arisc = (IncidentLogSettingsComplete)((IncidentLogServiceManager)ServiceManagerRegistry.getService(IncidentLogServiceManager.class)).updateSettings(arisc).getValue();
                    IncidentLogReminderInsert.this.settings.setValue((Object)arisc, 0L);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        IncidentLogReminderInsert.this.hideAnimation();
                        IncidentLogReminderInsert.this.module.ended();
                        IncidentLogReminderInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)IncidentLogReminderInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            IncidentLogReminderInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            IncidentLogReminderInsert.this.useIncidentLogReminder.setLocation(border, border + IncidentLogReminderInsert.this.configPanel.getTitleHeight());
            IncidentLogReminderInsert.this.useIncidentLogReminder.setSize(IncidentLogReminderInsert.this.useIncidentLogReminder.getPreferredSize());
            IncidentLogReminderInsert.this.remind1Weeks.setLocation(IncidentLogReminderInsert.this.useIncidentLogReminder.getX(), IncidentLogReminderInsert.this.useIncidentLogReminder.getY() + IncidentLogReminderInsert.this.useIncidentLogReminder.getHeight() + border * 2);
            IncidentLogReminderInsert.this.remind1Weeks.setSize(IncidentLogReminderInsert.this.remind1Weeks.getPreferredSize());
            IncidentLogReminderInsert.this.remind2Days.setLocation(IncidentLogReminderInsert.this.useIncidentLogReminder.getX(), IncidentLogReminderInsert.this.remind1Weeks.getY() + IncidentLogReminderInsert.this.remind1Weeks.getHeight() + border);
            IncidentLogReminderInsert.this.remind2Days.setSize(IncidentLogReminderInsert.this.remind2Days.getPreferredSize());
            IncidentLogReminderInsert.this.remind1Day.setLocation(IncidentLogReminderInsert.this.useIncidentLogReminder.getX(), IncidentLogReminderInsert.this.remind2Days.getY() + IncidentLogReminderInsert.this.remind2Days.getHeight() + border);
            IncidentLogReminderInsert.this.remind1Day.setSize(IncidentLogReminderInsert.this.remind1Day.getPreferredSize());
            IncidentLogReminderInsert.this.remindOverdue.setLocation(IncidentLogReminderInsert.this.useIncidentLogReminder.getX(), IncidentLogReminderInsert.this.remind1Day.getY() + IncidentLogReminderInsert.this.remind1Day.getHeight() + border);
            IncidentLogReminderInsert.this.remindOverdue.setSize(IncidentLogReminderInsert.this.remindOverdue.getPreferredSize());
            IncidentLogReminderInsert.this.notificationAddress.setLocation(IncidentLogReminderInsert.this.useIncidentLogReminder.getX(), IncidentLogReminderInsert.this.remindOverdue.getY() + IncidentLogReminderInsert.this.remindOverdue.getHeight() + border);
            IncidentLogReminderInsert.this.notificationAddress.setSize(300, (int)IncidentLogReminderInsert.this.remindOverdue.getPreferredSize().getHeight());
            IncidentLogReminderInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - IncidentLogReminderInsert.this.saveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ((double)border + IncidentLogReminderInsert.this.saveButton.getPreferredSize().getHeight())));
            IncidentLogReminderInsert.this.saveButton.setSize(IncidentLogReminderInsert.this.saveButton.getPreferredSize());
            IncidentLogReminderInsert.this.sendButton.setLocation((int)((double)parent.getWidth() - IncidentLogReminderInsert.this.sendButton.getPreferredSize().getWidth()) / 2, (int)((double)IncidentLogReminderInsert.this.saveButton.getY() - (IncidentLogReminderInsert.this.sendButton.getPreferredSize().getHeight() + (double)border)));
            IncidentLogReminderInsert.this.sendButton.setSize(IncidentLogReminderInsert.this.sendButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            IncidentLogReminderInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (IncidentLogReminderInsert.this.animation != null) {
                IncidentLogReminderInsert.this.animation.setLocation((int)((double)parent.getWidth() - IncidentLogReminderInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - IncidentLogReminderInsert.this.animation.getPreferredSize().getHeight()) / 2);
                IncidentLogReminderInsert.this.animation.setSize(IncidentLogReminderInsert.this.animation.getPreferredSize());
            }
            if (IncidentLogReminderInsert.this.isInserted) {
                IncidentLogReminderInsert.this.configPanel.setLocation(border, border);
                IncidentLogReminderInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                IncidentLogReminderInsert.this.sendPanel.setLocation(IncidentLogReminderInsert.this.configPanel.getX() + IncidentLogReminderInsert.this.configPanel.getWidth() + border, border);
                IncidentLogReminderInsert.this.sendPanel.setSize(IncidentLogReminderInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

