/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.converter.SpendCubeLastUpdateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.panels.SFTPDataExchangeSettingsPanel;
import ch.icit.pegasus.client.gui.utils.panels.TabbedItem;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.tabbed.TabButton;
import ch.icit.pegasus.client.gui.utils.tables.SkypexMappingTable;
import ch.icit.pegasus.client.gui.utils.tables.SpendCubeExchangeListTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.exchange.spendcube.SpendCubeExchangeServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataTransferProtocolE;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.spendcube.SpendCubeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.spendcube.SpendCubeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.DayOfMonthE;
import ch.icit.pegasus.server.core.dtos.util.DayOfMonthTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.EncryptedStringComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SpendCubeExchangeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private ScrollPane scrollPane;
    private SkypexMappingTable mappings;
    private SpendCubeExchangeListTable historyTable;
    private TitledItem<CheckBox> useSpendCubeExchange;
    private TitledItem<CheckBox> autoTransferActive;
    private TitledItem<CheckBox> withHeader;
    private TitledItem<CheckBox> includeInvoice;
    private TitledItem<CheckBox> ignoreDeletedItems;
    private TitledItem<TextField> notificationAddresses;
    private TitledItem<TextField> warehouseName;
    private TitledItem<TextField> hfmCode;
    private TitledItem<TextField> companyCode;
    private TabbedItem<SFTPDataExchangeSettingsPanel> ftpConfigurations;
    private TextLabel lastUpdates;
    private TablePanelAddSaveButton transferButton;
    private TablePanelAddSaveButton saveButton;
    private TextButton resetLastReceiveDate;
    private final DataExchangeModule module;
    protected Node<SpendCubeSettingsComplete> settings;
    protected SpendCubeSettingsComplete rimsc;

    public SpendCubeExchangeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.scrollPane = new ScrollPane();
        this.scrollPane.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
        this.scrollPane.getHorizontalScrollBar().setBackground(this.scrollPane.getBackground());
        this.scrollPane.getVerticalScrollBar().setBackground(this.scrollPane.getBackground());
        this.useSpendCubeExchange = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(SpendCubeSettingsComplete_.useSpendCube)), "Enable Spend Cube Exchange", TitledItem.TitledItemOrientation.EAST);
        this.useSpendCubeExchange.getElement().addButtonListener(this);
        this.autoTransferActive = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(SpendCubeSettingsComplete_.autoTransfer)), "Auto Transfer Active", TitledItem.TitledItemOrientation.EAST);
        this.withHeader = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(SpendCubeSettingsComplete_.withHeader)), "With Header", TitledItem.TitledItemOrientation.EAST);
        this.includeInvoice = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(SpendCubeSettingsComplete_.includeInvoices)), "Include Invoices", TitledItem.TitledItemOrientation.EAST);
        this.ignoreDeletedItems = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(SpendCubeSettingsComplete_.ignoreDeletedItems)), "Ignore deleted items", TitledItem.TitledItemOrientation.EAST);
        this.notificationAddresses = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(SpendCubeSettingsComplete_.notificationAddresses)), "Notification Addresses", TitledItem.TitledItemOrientation.NORTH);
        this.warehouseName = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(SpendCubeSettingsComplete_.warehouseName)), "Warehouse Name", TitledItem.TitledItemOrientation.NORTH);
        this.hfmCode = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(SpendCubeSettingsComplete_.hfmCode)), "HFM Code", TitledItem.TitledItemOrientation.NORTH);
        this.companyCode = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(SpendCubeSettingsComplete_.companyCode)), "Company Code", TitledItem.TitledItemOrientation.NORTH);
        this.mappings = new SkypexMappingTable();
        this.mappings.setTitleText("Unit Mapping");
        this.mappings.getModel().setNode(this.settings.getChildNamed(SpendCubeSettingsComplete_.mapping));
        this.ftpConfigurations = new TabbedItem<SFTPDataExchangeSettingsPanel>(){
            private static final long serialVersionUID = 1L;

            @Override
            public void updateFocusCycle() {
            }
        };
        int count = 1;
        Iterator it = this.settings.getChildNamed(SpendCubeSettingsComplete_.dataExchangeSettings).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node setting = (Node)it.next();
            SFTPDataExchangeSettingsPanel panel = new SFTPDataExchangeSettingsPanel();
            panel.setNode(setting);
            this.ftpConfigurations.addView(panel, new TabButton("Config " + count++));
        }
        this.lastUpdates = new TextLabel(this.settings, ConverterRegistry.getConverter(SpendCubeLastUpdateConverter.class));
        this.historyTable = new SpendCubeExchangeListTable();
        this.historyTable.setNode((Node)new ViewNode("TransferHistory"));
        this.resetLastReceiveDate = new TextButton("Reset last receive Date");
        this.resetLastReceiveDate.setProgress(1.0f);
        this.resetLastReceiveDate.addButtonListener(this);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText("Actions");
        this.sendPanel.setHasBackground(true);
        this.transferButton = new TablePanelAddSaveButton();
        this.transferButton.setText(Words.SEND);
        this.transferButton.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.useSpendCubeExchange);
        this.configPanel.add(this.autoTransferActive);
        this.configPanel.add(this.ftpConfigurations);
        this.configPanel.add(this.lastUpdates);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.resetLastReceiveDate);
        this.configPanel.add(this.withHeader);
        this.configPanel.add(this.includeInvoice);
        this.configPanel.add(this.ignoreDeletedItems);
        this.configPanel.add(this.notificationAddresses);
        this.configPanel.add(this.warehouseName);
        this.configPanel.add(this.hfmCode);
        this.configPanel.add(this.companyCode);
        this.configPanel.add(this.mappings);
        this.sendPanel.add(this.historyTable);
        this.sendPanel.add(this.transferButton);
        this.scrollPane.setViewportView(this.configPanel);
        this.add(this.scrollPane);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllTimeDurations();
                try {
                    SpendCubeExchangeInsert.this.rimsc = (SpendCubeSettingsComplete)((SpendCubeExchangeServiceManager)ServiceManagerRegistry.getService(SpendCubeExchangeServiceManager.class)).getSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (SpendCubeExchangeInsert.this.rimsc.getDataExchangeSettings().isEmpty()) {
                    SFTPDataExchangeSettingsComplete s = new SFTPDataExchangeSettingsComplete();
                    s.setClientOId(Long.valueOf(SFTPDataExchangeSettingsComplete.getNextId()));
                    s.setLastDataTransaction(new Timestamp(0L));
                    SpendCubeExchangeInsert.this.rimsc.getDataExchangeSettings().add(s);
                    s = new SFTPDataExchangeSettingsComplete();
                    s.setClientOId(Long.valueOf(SFTPDataExchangeSettingsComplete.getNextId()));
                    s.setLastDataTransaction(new Timestamp(0L));
                    SpendCubeExchangeInsert.this.rimsc.getDataExchangeSettings().add(s);
                }
                for (SFTPDataExchangeSettingsComplete ftpList : SpendCubeExchangeInsert.this.rimsc.getDataExchangeSettings()) {
                    if (ftpList.getLoginPwd() != null) continue;
                    ftpList.setLoginPwd(new EncryptedStringComplete());
                }
                SpendCubeExchangeInsert.this.rimsc.setTimerServiceSettings(SpendCubeExchangeInsert.this.createTimerService());
                SpendCubeExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)SpendCubeExchangeInsert.this.rimsc, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SpendCubeExchangeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createTimerService() {
        TimerServiceSettingsComplete s = new TimerServiceSettingsComplete();
        s.setClientOId(Long.valueOf(ADTO.getNextId()));
        s.setTimerServiceConfig((TimerServiceConfigComplete)new DayOfMonthTimeComplete(DayOfMonthE.FIRST, Integer.valueOf(2), Integer.valueOf(30), Integer.valueOf(0)));
        return s;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useSpendCubeExchange.setEnabled(isEnabled);
            boolean b = isEnabled && this.useSpendCubeExchange.getElement().isChecked();
            this.transferButton.setEnabled(b);
            this.autoTransferActive.setEnabled(b);
            this.ftpConfigurations.setEnabled(b);
            this.lastUpdates.setEnabled(b);
            this.saveButton.setEnabled(isEnabled);
            this.resetLastReceiveDate.setEnabled(b);
            this.mappings.setEnabled(b);
            this.historyTable.setEnabled(b);
            this.withHeader.setEnabled(b);
            this.includeInvoice.setEnabled(b);
            this.ignoreDeletedItems.setEnabled(b);
            this.notificationAddresses.setEnabled(b);
            this.warehouseName.setEnabled(b);
            this.hfmCode.setEnabled(b);
            this.companyCode.setEnabled(b);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.ftpConfigurations.kill();
            this.autoTransferActive.kill();
            this.lastUpdates.kill();
            this.saveButton.kill();
            this.useSpendCubeExchange.kill();
            this.resetLastReceiveDate.kill();
            this.resetLastReceiveDate = null;
            this.mappings.kill();
            this.mappings = null;
            this.historyTable.kill();
            this.withHeader.kill();
            this.includeInvoice.kill();
            this.ignoreDeletedItems.kill();
            this.notificationAddresses.kill();
            this.warehouseName.kill();
            this.hfmCode.kill();
            this.companyCode.kill();
        }
        this.historyTable = null;
        this.sendPanel = null;
        this.configPanel = null;
        this.transferButton = null;
        this.ftpConfigurations = null;
        this.autoTransferActive = null;
        this.lastUpdates = null;
        this.saveButton = null;
        this.useSpendCubeExchange = null;
        this.withHeader = null;
        this.includeInvoice = null;
        this.ignoreDeletedItems = null;
        this.notificationAddresses = null;
        this.warehouseName = null;
        this.hfmCode = null;
        this.companyCode = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return "Spend Cube Exchange";
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.transferButton || source == this.saveButton) {
            this.setEnabled(false);
            if (source == this.transferButton) {
                this.ensureAnimation("Send data to Spend Cube");
                this.processFiles();
            } else if (source == this.saveButton) {
                List<ScreenValidationObject> a = this.validateRetailinMotionConfig();
                if (a.isEmpty()) {
                    this.ensureAnimation(Words.SAVE_DATA);
                    this.saveConfig();
                } else {
                    InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
                    this.setEnabled(true);
                    return;
                }
            }
            this.module.started();
        } else if (source == this.resetLastReceiveDate) {
            Iterator it = this.settings.getChildNamed(SpendCubeSettingsComplete_.dataExchangeSettings).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                n.getChildNamed(SFTPDataExchangeSettingsComplete_.lastDataTransaction).setValue(null, 0L);
            }
            this.settings.getChildNamed(SpendCubeSettingsComplete_.lastTransfer).setValue(null, 0L);
            this.settings.commit();
            this.lastUpdates.setNode((Node)this.settings);
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private List<ScreenValidationObject> validateRetailinMotionConfig() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Node settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
        settings.commitThis(SystemSettingsComplete.class);
        return a;
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                SpendCubeExchangeInsert.this.settings.commit(SpendCubeSettingsComplete.class);
                SpendCubeSettingsComplete rimsc = (SpendCubeSettingsComplete)SpendCubeExchangeInsert.this.settings.getValue();
                for (SFTPDataExchangeSettingsComplete sftpDataExchangeSettingsComplete : rimsc.getDataExchangeSettings()) {
                    sftpDataExchangeSettingsComplete.setDataExchangeProtocol(DataTransferProtocolE.SFTP);
                }
                if (rimsc != null && Boolean.TRUE.equals(rimsc.getUseSpendCube())) {
                    rimsc.setTimerServiceSettings(SpendCubeExchangeInsert.this.createTimerService());
                    SpendCubeSettingsComplete spendCubeSettings = rimsc = (SpendCubeSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimsc).getValue();
                    TimerServiceSettingsComplete ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(spendCubeSettings.getTimerServiceSettings()).getValue();
                    spendCubeSettings.setTimerServiceSettings(ts);
                    spendCubeSettings = (SpendCubeSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)spendCubeSettings).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.SPEND_CUBE_EXCHANGE, spendCubeSettings.getAutoTransfer().booleanValue(), ts, -1L);
                    Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    Node settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)rimsc, false, false);
                    SpendCubeExchangeInsert.this.lastUpdates.setNode(settings);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.SPEND_CUBE_EXCHANGE);
                    rimsc = (SpendCubeSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimsc).getValue();
                    Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    Node settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)rimsc, false, false);
                    SpendCubeExchangeInsert.this.lastUpdates.setNode(settings);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        SpendCubeExchangeInsert.this.hideAnimation();
                        SpendCubeExchangeInsert.this.module.ended();
                        SpendCubeExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)SpendCubeExchangeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFiles() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = new Node();
                ((SpendCubeExchangeServiceManager)ServiceManagerRegistry.getService(SpendCubeExchangeServiceManager.class)).sendData();
                n.setValue((Object)true, 0L);
                SpendCubeExchangeInsert.this.rimsc = (SpendCubeSettingsComplete)((SpendCubeExchangeServiceManager)ServiceManagerRegistry.getService(SpendCubeExchangeServiceManager.class)).getSettings().getValue();
                SpendCubeExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)SpendCubeExchangeInsert.this.rimsc, false, false);
                SpendCubeExchangeInsert.this.lastUpdates.setNode((Node)SpendCubeExchangeInsert.this.settings);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        boolean read = (Boolean)node.getValue();
                        SpendCubeExchangeInsert.this.hideAnimation();
                        SpendCubeExchangeInsert.this.module.ended();
                        SpendCubeExchangeInsert.this.setEnabled(true);
                        if (read) {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_EXPORTED, SpendCubeExchangeInsert.this.transferButton);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, "Exchange failed", (Component)SpendCubeExchangeInsert.this.transferButton);
                        SpendCubeExchangeInsert.this.hideAnimation();
                        SpendCubeExchangeInsert.this.setEnabled(true);
                        SpendCubeExchangeInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            SpendCubeExchangeInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            SpendCubeExchangeInsert.this.useSpendCubeExchange.setLocation(border, border + SpendCubeExchangeInsert.this.configPanel.getTitleHeight());
            SpendCubeExchangeInsert.this.useSpendCubeExchange.setSize(SpendCubeExchangeInsert.this.useSpendCubeExchange.getPreferredSize());
            SpendCubeExchangeInsert.this.autoTransferActive.setLocation(border, SpendCubeExchangeInsert.this.useSpendCubeExchange.getY() + SpendCubeExchangeInsert.this.useSpendCubeExchange.getHeight());
            SpendCubeExchangeInsert.this.autoTransferActive.setSize(SpendCubeExchangeInsert.this.autoTransferActive.getPreferredSize());
            SpendCubeExchangeInsert.this.ftpConfigurations.setLocation(border, SpendCubeExchangeInsert.this.autoTransferActive.getY() + SpendCubeExchangeInsert.this.autoTransferActive.getHeight() + border);
            SpendCubeExchangeInsert.this.ftpConfigurations.setSize(parent.getWidth() - 2 * border, (int)SpendCubeExchangeInsert.this.ftpConfigurations.getPreferredSize().getHeight());
            SpendCubeExchangeInsert.this.withHeader.setLocation(border, SpendCubeExchangeInsert.this.ftpConfigurations.getY() + SpendCubeExchangeInsert.this.ftpConfigurations.getHeight() + border);
            SpendCubeExchangeInsert.this.withHeader.setSize(SpendCubeExchangeInsert.this.withHeader.getPreferredSize());
            SpendCubeExchangeInsert.this.includeInvoice.setLocation(border, SpendCubeExchangeInsert.this.withHeader.getY() + SpendCubeExchangeInsert.this.withHeader.getHeight() + border);
            SpendCubeExchangeInsert.this.includeInvoice.setSize(SpendCubeExchangeInsert.this.includeInvoice.getPreferredSize());
            SpendCubeExchangeInsert.this.ignoreDeletedItems.setLocation(border, SpendCubeExchangeInsert.this.includeInvoice.getY() + SpendCubeExchangeInsert.this.includeInvoice.getHeight() + border);
            SpendCubeExchangeInsert.this.ignoreDeletedItems.setSize(SpendCubeExchangeInsert.this.ignoreDeletedItems.getPreferredSize());
            SpendCubeExchangeInsert.this.notificationAddresses.setLocation(border, SpendCubeExchangeInsert.this.ignoreDeletedItems.getY() + SpendCubeExchangeInsert.this.ignoreDeletedItems.getHeight() + border);
            SpendCubeExchangeInsert.this.notificationAddresses.setSize(400, (int)SpendCubeExchangeInsert.this.notificationAddresses.getPreferredSize().getHeight());
            SpendCubeExchangeInsert.this.companyCode.setLocation(border, SpendCubeExchangeInsert.this.notificationAddresses.getY() + SpendCubeExchangeInsert.this.notificationAddresses.getHeight() + border);
            SpendCubeExchangeInsert.this.companyCode.setSize(400, (int)SpendCubeExchangeInsert.this.companyCode.getPreferredSize().getHeight());
            SpendCubeExchangeInsert.this.warehouseName.setLocation(border, SpendCubeExchangeInsert.this.companyCode.getY() + SpendCubeExchangeInsert.this.companyCode.getHeight() + border);
            SpendCubeExchangeInsert.this.warehouseName.setSize(400, (int)SpendCubeExchangeInsert.this.warehouseName.getPreferredSize().getHeight());
            SpendCubeExchangeInsert.this.hfmCode.setLocation(border, SpendCubeExchangeInsert.this.warehouseName.getY() + SpendCubeExchangeInsert.this.warehouseName.getHeight() + border);
            SpendCubeExchangeInsert.this.hfmCode.setSize(400, (int)SpendCubeExchangeInsert.this.hfmCode.getPreferredSize().getHeight());
            SpendCubeExchangeInsert.this.mappings.setLocation(SpendCubeExchangeInsert.this.ftpConfigurations.getX(), SpendCubeExchangeInsert.this.hfmCode.getY() + SpendCubeExchangeInsert.this.hfmCode.getHeight() + border);
            SpendCubeExchangeInsert.this.mappings.setSize(400, 300);
            SpendCubeExchangeInsert.this.lastUpdates.setLocation(border, SpendCubeExchangeInsert.this.mappings.getY() + SpendCubeExchangeInsert.this.mappings.getHeight() + border);
            SpendCubeExchangeInsert.this.lastUpdates.setSize(SpendCubeExchangeInsert.this.lastUpdates.getPreferredSize());
            SpendCubeExchangeInsert.this.resetLastReceiveDate.setLocation(SpendCubeExchangeInsert.this.lastUpdates.getX() + SpendCubeExchangeInsert.this.lastUpdates.getWidth() + border, SpendCubeExchangeInsert.this.lastUpdates.getY());
            SpendCubeExchangeInsert.this.resetLastReceiveDate.setSize(SpendCubeExchangeInsert.this.resetLastReceiveDate.getPreferredSize());
            SpendCubeExchangeInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - SpendCubeExchangeInsert.this.saveButton.getPreferredSize().getWidth()) / 2, SpendCubeExchangeInsert.this.resetLastReceiveDate.getY() + SpendCubeExchangeInsert.this.resetLastReceiveDate.getHeight() + border);
            SpendCubeExchangeInsert.this.saveButton.setSize(SpendCubeExchangeInsert.this.saveButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SpendCubeExchangeInsert.this.configPanel.getTitleHeight();
            int border = 10;
            h += border;
            h = (int)((double)h + SpendCubeExchangeInsert.this.useSpendCubeExchange.getPreferredSize().getHeight());
            h = (int)((double)h + SpendCubeExchangeInsert.this.autoTransferActive.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + SpendCubeExchangeInsert.this.ftpConfigurations.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + SpendCubeExchangeInsert.this.withHeader.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + SpendCubeExchangeInsert.this.includeInvoice.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + SpendCubeExchangeInsert.this.ignoreDeletedItems.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + SpendCubeExchangeInsert.this.notificationAddresses.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + SpendCubeExchangeInsert.this.companyCode.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + SpendCubeExchangeInsert.this.warehouseName.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + SpendCubeExchangeInsert.this.hfmCode.getPreferredSize().getHeight());
            h += border;
            h += 300;
            h += border;
            h = (int)((double)h + SpendCubeExchangeInsert.this.lastUpdates.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + SpendCubeExchangeInsert.this.saveButton.getPreferredSize().getHeight());
            return new Dimension(450, h += border);
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            SpendCubeExchangeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            SpendCubeExchangeInsert.this.transferButton.setLocation(border, (int)((double)parent.getHeight() - (SpendCubeExchangeInsert.this.transferButton.getPreferredSize().getHeight() + (double)border)));
            SpendCubeExchangeInsert.this.transferButton.setSize(SpendCubeExchangeInsert.this.transferButton.getPreferredSize());
            SpendCubeExchangeInsert.this.historyTable.setLocation(0, SpendCubeExchangeInsert.this.sendPanel.getTitleHeight() + border);
            SpendCubeExchangeInsert.this.historyTable.setSize(parent.getWidth(), parent.getHeight() - (SpendCubeExchangeInsert.this.historyTable.getY() + SpendCubeExchangeInsert.this.transferButton.getHeight() + 2 * border));
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (SpendCubeExchangeInsert.this.animation != null) {
                SpendCubeExchangeInsert.this.animation.setLocation((int)((double)parent.getWidth() - SpendCubeExchangeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - SpendCubeExchangeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                SpendCubeExchangeInsert.this.animation.setSize(SpendCubeExchangeInsert.this.animation.getPreferredSize());
            }
            if (SpendCubeExchangeInsert.this.isInserted) {
                SpendCubeExchangeInsert.this.scrollPane.setLocation(border, border);
                SpendCubeExchangeInsert.this.scrollPane.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                SpendCubeExchangeInsert.this.sendPanel.setLocation(SpendCubeExchangeInsert.this.scrollPane.getX() + SpendCubeExchangeInsert.this.scrollPane.getWidth() + border, border);
                SpendCubeExchangeInsert.this.sendPanel.setSize(SpendCubeExchangeInsert.this.scrollPane.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

