/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.gudd.jimdo.details;

import ch.icit.pegasus.client.converter.BooleanConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.ScrollableTextArea;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.jimdo.JimdoOrderImportComplete_;
import ch.icit.pegasus.server.core.dtos.jimdo.JimdoOrderImportLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends DefaultDetailsPanel<JimdoOrderImportLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> number;
    private TitledItem<TextLabel> importDate;
    private TitledItem<TextLabel> importUser;
    private TitledItem<TextLabel> state;
    private TitledItem<TextField> mail;
    private TitledItem<TextLabel> orderName;
    private TitledItem<DateChooser> deliveryDate;
    private TitledItem<ScrollableTextArea> comment;

    public SpecificationDetailsPanel(RowEditor<JimdoOrderImportLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        this.setOpaque(false);
        this.setCustomLayouter(new Layout());
        this.number = new TitledItem<TextLabel>(new TextLabel(), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.importDate = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(DateTimeConverter.class)), Words.DATE, TitledItem.TitledItemOrientation.NORTH);
        this.importUser = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(UserConverter.class)), Words.USER, TitledItem.TitledItemOrientation.NORTH);
        this.state = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(BooleanConverter.class)), Words.IMPORT_VALIDITY, TitledItem.TitledItemOrientation.NORTH);
        this.mail = new TitledItem<TextField>(new TextField(), "Order Mail", TitledItem.TitledItemOrientation.NORTH);
        this.orderName = new TitledItem<TextLabel>(new TextLabel(), "Order Name", TitledItem.TitledItemOrientation.NORTH);
        this.deliveryDate = new TitledItem<DateChooser>(new DateChooser(), "Delivery Date", TitledItem.TitledItemOrientation.NORTH);
        this.comment = new TitledItem<ScrollableTextArea>(new ScrollableTextArea(), "Comment", TitledItem.TitledItemOrientation.NORTH);
        this.comment.setIgnorePrefHeight(true);
        this.number.getElement().setReadOnlyTextField(true);
        this.state.getElement().setReadOnlyTextField(true);
        this.importDate.getElement().setReadOnlyTextField(true);
        this.importUser.getElement().setReadOnlyTextField(true);
        this.orderName.getElement().setReadOnlyTextField(true);
        this.addToView(this.importDate);
        this.addToView(this.importUser);
        this.addToView(this.state);
        this.addToView(this.number);
        this.addToView(this.mail);
        this.addToView(this.orderName);
        this.addToView(this.deliveryDate);
        this.addToView(this.comment);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.mail);
        CheckedListAdder.addToList(focusList, this.deliveryDate);
        CheckedListAdder.addToList(focusList, this.comment);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.importDate.kill();
        this.importUser.kill();
        this.state.kill();
        this.number.kill();
        this.mail.kill();
        this.orderName.kill();
        this.deliveryDate.kill();
        this.comment.kill();
        this.importDate = null;
        this.importUser = null;
        this.state = null;
        this.number = null;
        this.mail = null;
        this.orderName = null;
        this.deliveryDate = null;
        this.comment = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.importDate.setEnabled(isEnabled);
        this.importUser.setEnabled(isEnabled);
        this.state.setEnabled(isEnabled);
        this.number.setEnabled(isEnabled);
        this.mail.setEnabled(isEnabled);
        this.orderName.setEnabled(isEnabled);
        this.deliveryDate.setEnabled(isEnabled);
        this.comment.setEnabled(isEnabled);
    }

    @Override
    public void setNode(Node<?> node) {
        this.number.getElement().setNode(node.getChildNamed(JimdoOrderImportComplete_.externalOrderNumber));
        this.state.getElement().setNode(node.getChildNamed(JimdoOrderImportComplete_.validity));
        this.importDate.getElement().setNode(node.getChildNamed(JimdoOrderImportComplete_.creationDate));
        this.mail.getElement().setNode(node.getChildNamed(JimdoOrderImportComplete_.orderMail));
        this.orderName.getElement().setNode(node.getChildNamed(JimdoOrderImportComplete_.orderName));
        this.deliveryDate.getElement().setNode(node.getChildNamed(JimdoOrderImportComplete_.deliveryDate));
        this.comment.getElement().setNode(node.getChildNamed(JimdoOrderImportComplete_.orderComment));
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.editor.hideCommittingAnimation();
        this.editor.setEnabled(true);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            SpecificationDetailsPanel.this.number.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.number.setSize(120, (int)SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            int cx = SpecificationDetailsPanel.this.number.getX() + SpecificationDetailsPanel.this.number.getWidth();
            SpecificationDetailsPanel.this.state.setLocation(cx + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.state.setSize(180, (int)SpecificationDetailsPanel.this.state.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.importDate.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.number.getY() + SpecificationDetailsPanel.this.number.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.importDate.setSize(SpecificationDetailsPanel.this.importDate.getPreferredSize());
            SpecificationDetailsPanel.this.mail.setLocation(SpecificationDetailsPanel.this.state.getX() + SpecificationDetailsPanel.this.state.getWidth() + SpecificationDetailsPanel.this.inner_horizontalBorder, SpecificationDetailsPanel.this.state.getY());
            SpecificationDetailsPanel.this.mail.setSize(300, (int)SpecificationDetailsPanel.this.mail.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.importUser.setLocation(SpecificationDetailsPanel.this.importDate.getX() + SpecificationDetailsPanel.this.importDate.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.importDate.getY());
            SpecificationDetailsPanel.this.importUser.setSize(SpecificationDetailsPanel.this.importUser.getPreferredSize());
            SpecificationDetailsPanel.this.orderName.setLocation(SpecificationDetailsPanel.this.mail.getX(), SpecificationDetailsPanel.this.importUser.getY());
            SpecificationDetailsPanel.this.orderName.setSize(300, (int)SpecificationDetailsPanel.this.orderName.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.deliveryDate.setLocation(SpecificationDetailsPanel.this.importDate.getX(), SpecificationDetailsPanel.this.importDate.getY() + SpecificationDetailsPanel.this.importDate.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.deliveryDate.setSize(SpecificationDetailsPanel.this.deliveryDate.getPreferredSize());
            SpecificationDetailsPanel.this.comment.setLocation(SpecificationDetailsPanel.this.mail.getX() + SpecificationDetailsPanel.this.mail.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.mail.getY());
            SpecificationDetailsPanel.this.comment.setSize(200, SpecificationDetailsPanel.this.mail.getHeight() + SpecificationDetailsPanel.this.verticalBorder + SpecificationDetailsPanel.this.orderName.getHeight() + SpecificationDetailsPanel.this.verticalBorder + SpecificationDetailsPanel.this.deliveryDate.getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.importDate.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.deliveryDate.getPreferredSize().getHeight());
            return new Dimension(0, h += SpecificationDetailsPanel.this.verticalBorder);
        }
    }
}

