/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.incidentlog;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.incidentlog.IncidentLogServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.ExternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentLogComplete;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentLogLight;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentLogReference;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.IncidentErrorTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.spotcheck.halal.HalalSpotCheckReviewComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.sql.Timestamp;

public class IncidentLogModuleDataHandler
extends DefaultDataHandler<IncidentLogLight, IncidentLogComplete> {
    public IncidentLogModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                IncidentLogLight group = (IncidentLogLight)node.getValue(IncidentLogLight.class);
                IncidentLogComplete ngroup = (IncidentLogComplete)((IncidentLogServiceManager)ServiceManagerRegistry.getService(IncidentLogServiceManager.class)).getComplete((IncidentLogReference)group).getValue();
                node.removeExistingValues();
                node.setValue((Object)ngroup, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public void updateData(final Node<IncidentLogLight> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(IncidentLogComplete.class);
                IncidentLogComplete g = (IncidentLogComplete)node.getValue(IncidentLogComplete.class);
                if (g.getEligibleLocations().isEmpty()) {
                    g.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                IncidentLogComplete gn = (IncidentLogComplete)((IncidentLogServiceManager)ServiceManagerRegistry.getService(IncidentLogServiceManager.class)).update(g).getValue();
                node.removeExistingValues();
                node.setValue((Object)gn, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<IncidentLogComplete> createEmptyNode() {
        IncidentLogComplete r = new IncidentLogComplete();
        r.setCreationDate(new Timestamp(System.currentTimeMillis()));
        r.setCreationUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
        r.setIncidentDate(new Timestamp(System.currentTimeMillis()));
        r.setIncidentReportDate(new Timestamp(System.currentTimeMillis()));
        r.setPrpExpiryDate(new Date(System.currentTimeMillis()));
        r.setDeadline(new Timestamp(System.currentTimeMillis()));
        r.setPrpReceiveDate(new Timestamp(System.currentTimeMillis()));
        r.setFacFlightDate(new Timestamp(System.currentTimeMillis()));
        r.setState(IncidentStateE.OPEN);
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)r, false, false);
    }

    @Override
    public void createNewData(final Node<IncidentLogComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(IncidentLogComplete.class);
                IncidentLogComplete g = (IncidentLogComplete)node.getValue(IncidentLogComplete.class);
                if (g.getEligibleLocations().isEmpty()) {
                    g.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                IncidentLogComplete gn = (IncidentLogComplete)((IncidentLogServiceManager)ServiceManagerRegistry.getService(IncidentLogServiceManager.class)).create(g).getValue();
                node.removeExistingValues();
                node.setValue((Object)gn, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                IncidentLogModuleDataHandler.this.setCurrentLoadMaximum(8);
                StaticEnumServiceManager.getAllIncidentDecisions();
                StaticEnumServiceManager.getAllIncidentStates();
                StaticEnumServiceManager.getAllIncidentTypes();
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(IncidentErrorTypeComplete.class);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ExternalCostCenterComplete.class);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class);
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return IncidentLogModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<IncidentLogComplete> resetData(Node<IncidentLogComplete> node) {
        IncidentLogComplete n = new IncidentLogComplete();
        n.setClientOId(Long.valueOf(ADTO.getNextId()));
        n.setCreationDate(new Timestamp(System.currentTimeMillis()));
        n.setCreationUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
        n.setIncidentDate(new Timestamp(System.currentTimeMillis()));
        n.setIncidentReportDate(new Timestamp(System.currentTimeMillis()));
        n.setPrpExpiryDate(new Date(System.currentTimeMillis()));
        n.setDeadline(new Timestamp(System.currentTimeMillis()));
        n.setPrpReceiveDate(new Timestamp(System.currentTimeMillis()));
        n.setFacFlightDate(new Timestamp(System.currentTimeMillis()));
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)n, true, false);
    }

    @Override
    public Class<HalalSpotCheckReviewComplete> getCommittingClass() {
        return HalalSpotCheckReviewComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<IncidentLogLight> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

