/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.incidentlog.details;

import ch.icit.pegasus.client.converter.IncidentErrorTypeConverter;
import ch.icit.pegasus.client.converter.IncidentStateEConverter;
import ch.icit.pegasus.client.converter.IncidentTypeEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased.utils.DepartmentConverter;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextArea;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentLogComplete_;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentLogLight;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentStateE;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.IncidentErrorTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.IncidentLogAccess;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.StringUtil;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends StateDependantDetailsPanel<IncidentLogLight> {
    private TitledItem<TextLabel> number;
    private TitledItem<RDDateChooser> incidentDate;
    private TitledItem<RDDateChooser> incidentReportDate;
    private TitledItem<RDComboBox> state;
    private TitledItem<RDDateChooser> deadline;
    private TitledItem<RDComboBox> type;
    private TitledItem<RDComboBox> errorType;
    private TitledItem<RDTextArea> incidentDescription;
    private TitledItem<RDComboBox> causingDepartment;
    private TitledItem<RDTextArea> rootCause;
    private TitledItem<RDTextArea> measures;

    public SpecificationDetailsPanel(RowEditor<IncidentLogLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        this.number = new TitledItem<TextLabel>(new TextLabel(), "Number", TitledItem.TitledItemOrientation.NORTH);
        this.incidentDate = new TitledItem<RDDateChooser>(new RDDateChooser(provider), "Incident Date", TitledItem.TitledItemOrientation.NORTH);
        this.incidentReportDate = new TitledItem<RDDateChooser>(new RDDateChooser(provider), "Report Date", TitledItem.TitledItemOrientation.NORTH);
        this.state = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(IncidentStateEConverter.class)), "State", TitledItem.TitledItemOrientation.NORTH);
        this.deadline = new TitledItem<RDDateChooser>(new RDDateChooser(provider), "Deadline", TitledItem.TitledItemOrientation.NORTH);
        this.type = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(IncidentTypeEConverter.class)), "Type", TitledItem.TitledItemOrientation.NORTH);
        this.errorType = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(IncidentErrorTypeConverter.class)), "Error Type", TitledItem.TitledItemOrientation.NORTH);
        this.incidentDescription = new TitledItem<RDTextArea>(new RDTextArea(provider), "Description", TitledItem.TitledItemOrientation.NORTH);
        this.causingDepartment = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(DepartmentConverter.class), true), "Causing Department", TitledItem.TitledItemOrientation.NORTH);
        this.rootCause = new TitledItem<RDTextArea>(new RDTextArea(provider), "Root Cause", TitledItem.TitledItemOrientation.NORTH);
        this.measures = new TitledItem<RDTextArea>(new RDTextArea(provider), "Measures", TitledItem.TitledItemOrientation.NORTH);
        this.incidentDescription.setIgnorePrefHeight(true);
        this.rootCause.setIgnorePrefHeight(true);
        this.measures.setIgnorePrefHeight(true);
        this.setCustomLayouter(new Layout());
        this.addToView(this.number);
        this.addToView(this.incidentDate);
        this.addToView(this.incidentReportDate);
        this.addToView(this.state);
        this.addToView(this.deadline);
        this.addToView(this.type);
        this.addToView(this.errorType);
        this.addToView(this.incidentDescription);
        this.addToView(this.causingDepartment);
        this.addToView(this.rootCause);
        this.addToView(this.measures);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isSupervisor = this.provider.isWritable(IncidentLogAccess.INCIDENT_LOG_SUPERVISOR);
        boolean editable = false;
        IncidentStateE currentState = (IncidentStateE)this.node.getChildNamed(IncidentLogComplete_.state).getValue();
        if (currentState == IncidentStateE.CLOSED) {
            if (isSupervisor) {
                editable = true;
            }
        } else {
            editable = true;
        }
        boolean e = isEnabled && editable;
        super.setEnabled(e);
        this.number.setEnabled(e);
        this.incidentDate.setEnabled(e);
        this.incidentReportDate.setEnabled(e);
        this.state.setEnabled(isEnabled);
        this.deadline.setEnabled(e);
        this.type.setEnabled(e);
        this.errorType.setEnabled(e);
        this.incidentDescription.setEnabled(e);
        this.causingDepartment.setEnabled(e);
        this.rootCause.setEnabled(e);
        this.measures.setEnabled(e);
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.number.getElement().setNode(node.getChildNamed(IncidentLogComplete_.number));
        this.incidentDate.getElement().setNode(node.getChildNamed(IncidentLogComplete_.incidentDate));
        this.incidentReportDate.getElement().setNode(node.getChildNamed(IncidentLogComplete_.incidentReportDate));
        Node listStates = NodeToolkit.getAffixList(IncidentStateE.class);
        ArrayList<IncidentStateE> filteredStates = new ArrayList<IncidentStateE>();
        boolean isSupervisor = this.provider.isWritable(IncidentLogAccess.INCIDENT_LOG_SUPERVISOR);
        boolean isFac = this.provider.isWritable(IncidentLogAccess.INCIDENT_LOG_CLOSE_FAC);
        boolean isSupplier = this.provider.isWritable(IncidentLogAccess.INCIDENT_LOG_CLOSE_SUPPLIER);
        boolean isInternal = this.provider.isWritable(IncidentLogAccess.INCIDENT_LOG_CLOSE_INTERNAL);
        for (IncidentStateE stateE : (List)listStates.getValue()) {
            if (stateE == IncidentStateE.CLOSED) {
                if (isSupervisor) {
                    filteredStates.add(stateE);
                    continue;
                }
                IncidentTypeE incidentTypeE = (IncidentTypeE)node.getChildNamed(IncidentLogComplete_.type).getValue();
                switch (incidentTypeE) {
                    case INTERNAL: {
                        if (!isInternal) break;
                        filteredStates.add(stateE);
                        break;
                    }
                    case EXTERNAL: {
                        if (!isFac) break;
                        filteredStates.add(stateE);
                        break;
                    }
                    case SUPPLIER: {
                        if (!isSupplier) break;
                        filteredStates.add(stateE);
                    }
                }
                continue;
            }
            filteredStates.add(stateE);
        }
        this.state.getElement().refreshPossibleValues(INodeCreator.getDefaultImpl().createNodes(filteredStates, false));
        this.state.getElement().setNode(node.getChildNamed(IncidentLogComplete_.state));
        this.deadline.getElement().setNode(node.getChildNamed(IncidentLogComplete_.deadline));
        this.type.getElement().refreshPossibleValues(NodeToolkit.getAffixList(IncidentTypeE.class));
        this.type.getElement().setNode(node.getChildNamed(IncidentLogComplete_.type));
        this.errorType.getElement().refreshPossibleValues(NodeToolkit.getAffixList(IncidentErrorTypeComplete.class));
        this.errorType.getElement().setNode(node.getChildNamed(IncidentLogComplete_.errorType));
        this.incidentDescription.getElement().setNode(node.getChildNamed(IncidentLogComplete_.incidentDescription));
        Node list1 = NodeToolkit.getAffixList(CostCenterComplete.class);
        ArrayList<CostCenterComplete> filteredCenters = new ArrayList<CostCenterComplete>();
        for (CostCenterComplete costCenterComplete : (List)list1.getValue()) {
            if (StringUtil.isBlank((String)costCenterComplete.getIncidentNotificationAddress())) continue;
            filteredCenters.add(costCenterComplete);
        }
        this.causingDepartment.getElement().refreshPossibleValues(INodeCreator.getDefaultImpl().createNodes(filteredCenters, false));
        this.causingDepartment.getElement().setNode(node.getChildNamed(IncidentLogComplete_.causingDepartment));
        Node list = NodeToolkit.getAffixList(InternalCostCenterComplete.class);
        ArrayList<InternalCostCenterComplete> filteredCenters2 = new ArrayList<InternalCostCenterComplete>();
        for (InternalCostCenterComplete internalCostCenterComplete : (List)list.getValue()) {
            if (StringUtil.isBlank((String)internalCostCenterComplete.getIncidentNotificationAddress())) continue;
            filteredCenters2.add(internalCostCenterComplete);
        }
        this.rootCause.getElement().setNode(node.getChildNamed(IncidentLogComplete_.rootCause));
        this.measures.getElement().setNode(node.getChildNamed(IncidentLogComplete_.measures));
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.number);
        CheckedListAdder.addToList(focusList, this.incidentDate);
        CheckedListAdder.addToList(focusList, this.incidentReportDate);
        CheckedListAdder.addToList(focusList, this.state);
        CheckedListAdder.addToList(focusList, this.deadline);
        CheckedListAdder.addToList(focusList, this.type);
        CheckedListAdder.addToList(focusList, this.errorType);
        CheckedListAdder.addToList(focusList, this.incidentDescription);
        CheckedListAdder.addToList(focusList, this.causingDepartment);
        CheckedListAdder.addToList(focusList, this.rootCause);
        CheckedListAdder.addToList(focusList, this.measures);
        return focusList;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + (SpecificationDetailsPanel.this.number.getPreferredSize().getHeight() + (double)SpecificationDetailsPanel.this.verticalBorder));
            h = (int)((double)h + (SpecificationDetailsPanel.this.state.getPreferredSize().getHeight() + (double)SpecificationDetailsPanel.this.verticalBorder));
            h = (int)((double)h + (SpecificationDetailsPanel.this.type.getPreferredSize().getHeight() + (double)SpecificationDetailsPanel.this.verticalBorder));
            h += 200 + SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + (SpecificationDetailsPanel.this.causingDepartment.getPreferredSize().getHeight() + (double)SpecificationDetailsPanel.this.verticalBorder));
            return new Dimension(0, h += 200 + SpecificationDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            SpecificationDetailsPanel.this.number.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.number.setSize(150, (int)SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.incidentDate.setLocation(SpecificationDetailsPanel.this.number.getX() + SpecificationDetailsPanel.this.number.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.incidentDate.setSize(SpecificationDetailsPanel.this.incidentDate.getPreferredSize());
            SpecificationDetailsPanel.this.incidentReportDate.setLocation(SpecificationDetailsPanel.this.incidentDate.getX() + SpecificationDetailsPanel.this.incidentDate.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.incidentReportDate.setSize(SpecificationDetailsPanel.this.incidentReportDate.getPreferredSize());
            SpecificationDetailsPanel.this.state.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.number.getY() + SpecificationDetailsPanel.this.number.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.state.setSize(200, (int)SpecificationDetailsPanel.this.state.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.deadline.setLocation(SpecificationDetailsPanel.this.state.getX() + SpecificationDetailsPanel.this.state.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.number.getY() + SpecificationDetailsPanel.this.number.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.deadline.setSize(SpecificationDetailsPanel.this.deadline.getPreferredSize());
            SpecificationDetailsPanel.this.type.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.state.getY() + SpecificationDetailsPanel.this.state.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.type.setSize(200, (int)SpecificationDetailsPanel.this.type.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.errorType.setLocation(SpecificationDetailsPanel.this.type.getX() + SpecificationDetailsPanel.this.type.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.state.getY() + SpecificationDetailsPanel.this.state.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.errorType.setSize(200, (int)SpecificationDetailsPanel.this.errorType.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.incidentDescription.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.errorType.getY() + SpecificationDetailsPanel.this.errorType.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.incidentDescription.setSize(parent.getWidth() - 2 * SpecificationDetailsPanel.this.horizontalBorder, 200);
            SpecificationDetailsPanel.this.causingDepartment.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.incidentDescription.getY() + SpecificationDetailsPanel.this.incidentDescription.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.causingDepartment.setSize(200, (int)SpecificationDetailsPanel.this.causingDepartment.getPreferredSize().getHeight());
            int w2tl = (parent.getWidth() - 3 * SpecificationDetailsPanel.this.horizontalBorder) / 2;
            SpecificationDetailsPanel.this.rootCause.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.causingDepartment.getY() + SpecificationDetailsPanel.this.causingDepartment.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.rootCause.setSize(w2tl, 200);
            SpecificationDetailsPanel.this.measures.setLocation(SpecificationDetailsPanel.this.rootCause.getX() + SpecificationDetailsPanel.this.rootCause.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.causingDepartment.getY() + SpecificationDetailsPanel.this.causingDepartment.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.measures.setSize(w2tl, 200);
        }
    }
}

