/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.internalconsumption;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.NoProExchangeServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionComplete;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionComplete_;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionLight;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionMovementComplete;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionMovementComplete_;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionStateE;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.NoProExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockMovementComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class InternalConsumptionModuleDataHandler
extends DefaultDataHandler<InternalConsumptionLight, InternalConsumptionComplete> {
    public InternalConsumptionModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public void updateData(final Node<InternalConsumptionLight> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                InternalConsumptionComplete d = (InternalConsumptionComplete)node.getValue(InternalConsumptionComplete.class);
                Timestamp validity = new Timestamp(d.getConsumptionDate().getTime());
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                if (!CompanyUtil.isNoPro((SystemSettingsComplete)settings) && Boolean.TRUE.equals(d.getProcess())) {
                    ArrayList<InternalConsumptionMovementComplete> newMovements = new ArrayList<InternalConsumptionMovementComplete>();
                    Node moves = node.getChildNamed(InternalConsumptionComplete_.movementInformations);
                    Iterator it = moves.getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Boolean b;
                        Node doit;
                        Node m = (Node)it.next();
                        InternalConsumptionMovementComplete movementInfo = (InternalConsumptionMovementComplete)m.getValue();
                        if (Boolean.TRUE.equals(movementInfo.getTransactionPerformed()) || (doit = m.getChildNamed(new String[]{"performit"})) != null && !Boolean.TRUE.equals(b = (Boolean)doit.getValue())) continue;
                        BasicArticleLight artL = (BasicArticleLight)m.getChildNamed(InternalConsumptionMovementComplete_.article).getValue();
                        BasicArticleComplete artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(artL.getId())).getValue();
                        StoreQuantityComplete q = (StoreQuantityComplete)m.getChildNamed(InternalConsumptionMovementComplete_.quantity).getValue();
                        StorePositionLight originPosition = (StorePositionLight)m.getChildNamed(InternalConsumptionMovementComplete_.originPosition).getValue();
                        StorePositionLight destinationPosition = (StorePositionLight)m.getChildNamed(InternalConsumptionMovementComplete_.targetPosition).getValue();
                        boolean createMovement = true;
                        if (originPosition == null) {
                            createMovement = false;
                        }
                        if (destinationPosition == null) {
                            createMovement = false;
                        }
                        if (!createMovement) continue;
                        ManualStockMovementComplete move = new ManualStockMovementComplete();
                        move.setOriginPosition(originPosition);
                        move.setDestinationPosition(destinationPosition);
                        move.setAmount(new StoreQuantityComplete(q));
                        List charges = ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getBatches(new BasicArticleReference(artL.getId()), originPosition).getList();
                        if (charges.isEmpty()) continue;
                        move.setCharge((ArticleChargeLight)((ArticleChargeBatchComplete)charges.get(0)).getCharge());
                        QuantityComplete totalQuantity = new QuantityComplete(Double.valueOf(0.0), artL.getBaseUnit());
                        for (ArticleChargeBatchComplete charge : charges) {
                            double ca = UnitConversionToolkit.convertUnit((UnitComplete)charge.getQuantity().getUnit(), (UnitComplete)artC.getBaseUnit(), (double)charge.getQuantity().getAmount().doubleValue(), (BasicArticleLight)artC, (Timestamp)validity);
                            totalQuantity.setQuantity(Double.valueOf(totalQuantity.getQuantity() + ca));
                        }
                        double availableAmount = totalQuantity.getQuantity();
                        double usedAmountInStoreUnit = q.getAmount().longValue();
                        usedAmountInStoreUnit = UnitConversionToolkit.convertUnit((UnitComplete)q.getUnit(), (UnitComplete)artL.getBaseUnit(), (double)usedAmountInStoreUnit, (BasicArticleLight)artC, (Timestamp)validity);
                        if (!(availableAmount > usedAmountInStoreUnit)) {
                            double differenceInStoreUnit = usedAmountInStoreUnit - availableAmount;
                            usedAmountInStoreUnit = availableAmount;
                            StoreQuantityComplete sq = UnitConversionToolkit.convertToStoreQuantity((QuantityComplete)new QuantityComplete(Double.valueOf(usedAmountInStoreUnit), artL.getBaseUnit()), (BasicArticleLight)artC, (Timestamp)validity);
                            move.setAmount(sq);
                            movementInfo.setQuantity(sq);
                            InternalConsumptionMovementComplete newInfo = new InternalConsumptionMovementComplete();
                            newInfo.setArticle(artL);
                            newInfo.setClientOId(Long.valueOf(ADTO.getNextId()));
                            newInfo.setOriginPosition(movementInfo.getOriginPosition());
                            newInfo.setQuantity(UnitConversionToolkit.convertToStoreQuantity((QuantityComplete)new QuantityComplete(Double.valueOf(differenceInStoreUnit), artL.getBaseUnit()), (BasicArticleLight)artC, (Timestamp)validity));
                            newInfo.setTargetPosition(movementInfo.getTargetPosition());
                            newMovements.add(newInfo);
                        }
                        List nMoves = ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).move(move, false, false).getList();
                        if (!nMoves.isEmpty()) {
                            ((InternalConsumptionMovementComplete)m.getValue()).setTransaction((ManualStockMovementComplete)nMoves.get(0));
                        }
                        movementInfo.setTransactionPerformed(Boolean.valueOf(true));
                    }
                    d.getMovementInformations().addAll(newMovements);
                }
                InternalConsumptionComplete dto = (InternalConsumptionComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).updateInternalConsumption(d).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<InternalConsumptionComplete> createEmptyNode() {
        InternalConsumptionComplete d = new InternalConsumptionComplete();
        d.setClientOId(Long.valueOf(ADTO.getNextId()));
        d.setProcess(Boolean.valueOf(false));
        d.setTransactionState(InternalConsumptionStateE.NOTHING);
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)d, false, false);
        return n;
    }

    @Override
    public void createNewData(final Node<InternalConsumptionComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                InternalConsumptionComplete d = (InternalConsumptionComplete)node.getValue(InternalConsumptionComplete.class);
                d.setConsumptionUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
                d.setCreationDate(new Timestamp(System.currentTimeMillis()));
                Timestamp validity = new Timestamp(d.getConsumptionDate().getTime());
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                if (!CompanyUtil.isNoPro((SystemSettingsComplete)settings) && Boolean.TRUE.equals(d.getProcess())) {
                    ArrayList<InternalConsumptionMovementComplete> newMovements = new ArrayList<InternalConsumptionMovementComplete>();
                    Node moves = node.getChildNamed(InternalConsumptionComplete_.movementInformations);
                    Iterator it = moves.getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node m = (Node)it.next();
                        InternalConsumptionMovementComplete movementInfo = (InternalConsumptionMovementComplete)m.getValue();
                        BasicArticleLight artL = (BasicArticleLight)m.getChildNamed(InternalConsumptionMovementComplete_.article).getValue();
                        BasicArticleComplete artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(artL.getId())).getValue();
                        StoreQuantityComplete q = (StoreQuantityComplete)m.getChildNamed(InternalConsumptionMovementComplete_.quantity).getValue();
                        StorePositionLight originPosition = (StorePositionLight)m.getChildNamed(InternalConsumptionMovementComplete_.originPosition).getValue();
                        StorePositionLight destinationPosition = (StorePositionLight)m.getChildNamed(InternalConsumptionMovementComplete_.targetPosition).getValue();
                        boolean createMovement = true;
                        if (originPosition == null) {
                            createMovement = false;
                        }
                        if (destinationPosition == null) {
                            createMovement = false;
                        }
                        if (!createMovement) continue;
                        ManualStockMovementComplete move = new ManualStockMovementComplete();
                        move.setOriginPosition(originPosition);
                        move.setDestinationPosition(destinationPosition);
                        move.setAmount(new StoreQuantityComplete(q));
                        List charges = ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getBatches(new BasicArticleReference(artL.getId()), originPosition).getList();
                        if (charges.isEmpty()) continue;
                        move.setCharge((ArticleChargeLight)((ArticleChargeBatchComplete)charges.get(0)).getCharge());
                        QuantityComplete totalQuantity = new QuantityComplete(Double.valueOf(0.0), artL.getBaseUnit());
                        for (ArticleChargeBatchComplete charge : charges) {
                            double ca = UnitConversionToolkit.convertUnit((UnitComplete)charge.getQuantity().getUnit(), (UnitComplete)artC.getBaseUnit(), (double)charge.getQuantity().getAmount().doubleValue(), (BasicArticleLight)artC, (Timestamp)validity);
                            totalQuantity.setQuantity(Double.valueOf(totalQuantity.getQuantity() + ca));
                        }
                        double availableAmount = totalQuantity.getQuantity();
                        double usedAmountInStoreUnit = q.getAmount().longValue();
                        usedAmountInStoreUnit = UnitConversionToolkit.convertUnit((UnitComplete)q.getUnit(), (UnitComplete)artL.getBaseUnit(), (double)usedAmountInStoreUnit, (BasicArticleLight)artC, (Timestamp)validity);
                        if (!(availableAmount > usedAmountInStoreUnit)) {
                            double differenceInStoreUnit = usedAmountInStoreUnit - availableAmount;
                            usedAmountInStoreUnit = availableAmount;
                            StoreQuantityComplete sq = UnitConversionToolkit.convertToStoreQuantity((QuantityComplete)new QuantityComplete(Double.valueOf(usedAmountInStoreUnit), artL.getBaseUnit()), (BasicArticleLight)artC, (Timestamp)validity);
                            move.setAmount(sq);
                            movementInfo.setQuantity(sq);
                            InternalConsumptionMovementComplete newInfo = new InternalConsumptionMovementComplete();
                            newInfo.setArticle(artL);
                            newInfo.setClientOId(Long.valueOf(ADTO.getNextId()));
                            newInfo.setOriginPosition(movementInfo.getOriginPosition());
                            newInfo.setQuantity(UnitConversionToolkit.convertToStoreQuantity((QuantityComplete)new QuantityComplete(Double.valueOf(differenceInStoreUnit), artL.getBaseUnit()), (BasicArticleLight)artC, (Timestamp)validity));
                            newInfo.setTargetPosition(movementInfo.getTargetPosition());
                            newMovements.add(newInfo);
                        }
                        List nMoves = ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).move(move, false, false).getList();
                        if (!nMoves.isEmpty()) {
                            ((InternalConsumptionMovementComplete)m.getValue()).setTransaction((ManualStockMovementComplete)nMoves.get(0));
                        }
                        movementInfo.setTransactionPerformed(Boolean.valueOf(true));
                    }
                    d.getMovementInformations().addAll(newMovements);
                }
                InternalConsumptionComplete dto = (InternalConsumptionComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).createInternalConsumption(d).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                InternalConsumptionModuleDataHandler.this.setCurrentLoadMaximum(3);
                InternalConsumptionModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                InternalConsumptionModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                InternalConsumptionModuleDataHandler.this.showNextMessage(progressListener);
                OptionalWrapper noProSettings = ((NoProExchangeServiceManager)ServiceManagerRegistry.getService(NoProExchangeServiceManager.class)).getNoProSettings();
                Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)noProSettings.getValue(), false, false);
                node.setName(((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getAffixNameForClass(NoProExchangeSettingsComplete.class));
                NodeToolkit.addAffix((Node)node);
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return InternalConsumptionModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                InternalConsumptionLight air = (InternalConsumptionLight)node.getValue(InternalConsumptionLight.class);
                InternalConsumptionLight nair = (InternalConsumptionLight)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getInternalConsumption(air).getValue();
                node.removeExistingValues();
                node.setValue((Object)nair, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Node<InternalConsumptionComplete> resetData(Node<InternalConsumptionComplete> node) {
        CustomerLight cID = ((InternalConsumptionLight)node.getValue(InternalConsumptionLight.class)).getCustomer();
        InternalConsumptionComplete n = new InternalConsumptionComplete();
        n.setProcess(Boolean.valueOf(false));
        n.setTransactionState(InternalConsumptionStateE.NOTHING);
        n.setClientOId(Long.valueOf(ADTO.getNextId()));
        n.setCustomer(cID);
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)n, true, false);
    }

    @Override
    public Class<InternalConsumptionComplete> getCommittingClass() {
        return InternalConsumptionComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<InternalConsumptionLight> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

