/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.internalconsumption.details;

import ch.icit.pegasus.client.converter.BasicArticleConverter;
import ch.icit.pegasus.client.converter.QuantityConverter2Decimal;
import ch.icit.pegasus.client.converter.StorePositionConverter;
import ch.icit.pegasus.client.converter.StoreViewConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBox;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionComplete_;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionLight;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionMovementComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight_;
import ch.icit.pegasus.server.core.dtos.store.StoreTypeE;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ArticleCheckoutDetailsPanel
extends TableDetailsPanel<InternalConsumptionLight> {
    private static final long serialVersionUID = 1L;
    private boolean moveFromClosedStore = false;
    private Map<BasicArticleComplete, Map<StorePositionLight, StoreQuantityComplete>> stockHash = new HashMap<BasicArticleComplete, Map<StorePositionLight, StoreQuantityComplete>>();

    public ArticleCheckoutDetailsPanel(RowEditor<InternalConsumptionLight> editor, RDProvider provider) {
        super(editor, provider, true, true, false, false);
        this.setTitleText(Words.ARTICLE_CALCULATION);
        boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
        if (isNoPro) {
            this.moveFromClosedStore = true;
        }
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int th = InputComboBox2.getPreferredWidth(this, 11) + 2 * this.table.getCellPadding();
        int tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + this.table.getCellPadding() * 2;
        columns.add(new TableColumnInfo(0.4, 0.0, Words.ARTICLE, null, null, null, "", 200, 200, 200));
        columns.add(new TableColumnInfo(0.0, 0.0, Words.AMOUNT, null, null, null, "", th, th, th));
        columns.add(new TableColumnInfo(0.2, 0.0, Words.ORIGIN, null, null, null, "", 70, 70, 70));
        columns.add(new TableColumnInfo(0.2, 0.0, Words.ORIGIN_POSITION, null, null, null, "", 70, 70, 70));
        columns.add(new TableColumnInfo(0.0, 0.0, Words.STOCK, null, null, null, "", th, th, th));
        columns.add(new TableColumnInfo(0.2, 0.0, Words.DESTINATION, null, null, null, "", 70, 70, 70));
        columns.add(new TableColumnInfo(0.0, 0.0, "", null, null, null, "", tw, tw, tw));
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setProvider(this.provider);
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl p = new TableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        for (Table2RowPanel r : this.table.getRows()) {
            TableRowImpl i = (TableRowImpl)r;
            i.validateRow(a);
        }
        return a;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(InternalConsumptionComplete_.movementInformations));
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    ItemListener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private TextLabel articleName;
        private InputComboBox2 amount;
        private ComboBox originStore;
        private ComboBox originPosition;
        private StorePositionSearchBox destination;
        private InfoButton info;
        private TextLabel stock;
        private DeleteButton deleteButton;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.articleName = new TextLabel(m.getNode().getChildNamed(InternalConsumptionMovementComplete_.article), ConverterRegistry.getConverter(BasicArticleConverter.class));
            this.amount = new InputComboBox2(m.getNode().getChildNamed(new DtoField[]{InternalConsumptionMovementComplete_.quantity, StoreQuantityComplete_.amount}), m.getNode().getChildNamed(new DtoField[]{InternalConsumptionMovementComplete_.quantity, StoreQuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
            this.info = new InfoButton();
            Node dp = this.model.getNode().getChildNamed(InternalConsumptionMovementComplete_.targetPosition);
            Node os = this.model.getNode().getChildNamed(InternalConsumptionMovementComplete_.originPosition);
            os.setPermanent(true);
            os.setName(InternalConsumptionMovementComplete_.originPosition);
            m.getNode().addChild(os, 0L);
            this.originStore = new ComboBox((Node)new DTOProxyNode(), null, ConverterRegistry.getConverter(StoreViewConverter.class));
            this.originPosition = new ComboBox(os, null, ConverterRegistry.getConverter(StorePositionConverter.class));
            this.destination = new StorePositionSearchBox();
            this.destination.setNode((Node<StorePositionLight>)dp);
            ArticleCheckoutDetailsPanel.this.editor.getModel().getNode().getChildNamed(InternalConsumptionComplete_.consumptionDate).addNodeListener((NodeListener)this);
            this.stock = new TextLabel(null, ConverterRegistry.getConverter(QuantityConverter2Decimal.class));
            this.deleteButton = new DeleteButton();
            this.deleteButton.addButtonListener(this);
            this.setLayout(new Layout());
            this.loadArticleStore();
            this.add(this.articleName);
            this.add(this.info);
            this.add(this.amount);
            this.add(this.originStore);
            this.add(this.originPosition);
            this.add(this.stock);
            this.add(this.destination);
            this.add(this.deleteButton);
        }

        private void updateStore(Map<StorePositionLight, StoreQuantityComplete> map) {
            HashSet<StoreLight> stores = new HashSet<StoreLight>();
            for (StorePositionLight s : map.keySet()) {
                if (s.getStore().getStoreType() == StoreTypeE.IRREGULARITY) continue;
                stores.add(s.getStore());
            }
            ArrayList<StoreLight> ss = new ArrayList<StoreLight>();
            ss.addAll(stores);
            if (this.originPosition != null) {
                this.originPosition.addItemListener(this);
            }
            if (this.originStore != null) {
                this.originStore.addItemListener(this);
                this.originStore.refreshPossibleValues(INodeCreator.getDefaultImpl().createNodes(ss, true));
            }
            if (this.model.getNode().getChildNamed(InternalConsumptionMovementComplete_.originPosition).getValue() != null) {
                this.originStore.setSelectedItem(this.model.getNode().getChildNamed(new DtoField[]{InternalConsumptionMovementComplete_.originPosition, StorePositionLight_.store}));
            }
        }

        private void updatePosition() {
            if (this.originStore.getSelectedItem() != null && this.originStore.getSelectedItem() instanceof Node) {
                Node sn = (Node)this.originStore.getSelectedItem();
                Node article = this.model.getNode().getChildNamed(InternalConsumptionMovementComplete_.article);
                if (sn.getValue() != null) {
                    Map map = (Map)ArticleCheckoutDetailsPanel.this.stockHash.get(article.getValue());
                    ArrayList positions = new ArrayList();
                    for (Map.Entry e : map.entrySet()) {
                        if (((StorePositionLight)e.getKey()).getStore().getStoreType() == StoreTypeE.IRREGULARITY || !((StorePositionLight)e.getKey()).getStore().equals(sn.getValue())) continue;
                        positions.add(e.getKey());
                    }
                    this.originPosition.refreshPossibleValues(INodeCreator.getDefaultImpl().createNodes(positions, true));
                }
            }
            if (this.model.getNode().getChildNamed(InternalConsumptionMovementComplete_.originPosition).getValue() != null) {
                this.originPosition.setSelectedItem(this.model.getNode().getChildNamed(InternalConsumptionMovementComplete_.originPosition));
            }
        }

        private void updateStock() {
            if (this.originPosition.getSelectedItem() != null && this.originPosition.getSelectedItem() instanceof Node) {
                Node sn = (Node)this.originPosition.getSelectedItem();
                Node article = this.model.getNode().getChildNamed(InternalConsumptionMovementComplete_.article);
                if (sn.getValue() != null) {
                    Map map = (Map)ArticleCheckoutDetailsPanel.this.stockHash.get(article.getValue());
                    for (Map.Entry e : map.entrySet()) {
                        if (((StorePositionLight)e.getKey()).getStore().getStoreType() == StoreTypeE.IRREGULARITY || !((StorePositionLight)e.getKey()).equals(sn.getValue())) continue;
                        this.stock.setNode(INodeCreator.getDefaultImpl().getNode4DTO(e.getValue(), false, false));
                        return;
                    }
                }
            }
        }

        private void updatePackingUnitsAndInfoButton() {
            BasicArticleComplete article = (BasicArticleComplete)this.model.getNode().getChildNamed(InternalConsumptionMovementComplete_.article).getValue(BasicArticleComplete.class);
            Date date = (Date)ArticleCheckoutDetailsPanel.this.editor.getModel().getNode().getChildNamed(InternalConsumptionComplete_.consumptionDate).getValue();
            Timestamp validity = new Timestamp(date.getTime());
            this.info.installStringViewer(ArticleToolkit.getArticleInfoPopupString(article, validity, 4147, true));
            List possibleUnits = StoreToolkit.getPossibleUnits((BasicArticleLight)article, null, (Timestamp)validity, (TransactionType)TransactionType.INTERNAL_CONSUMPTION, (UserComplete)ArticleCheckoutDetailsPanel.this.currentUser, null, null, (SystemSettingsComplete)ArticleCheckoutDetailsPanel.this.settings);
            this.amount.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(possibleUnits));
            StoreQuantityComplete quantityValue = (StoreQuantityComplete)this.model.getNode().getChildNamed(InternalConsumptionMovementComplete_.quantity).getValue();
            this.amount.setSelectedUnit(quantityValue.getUnit());
        }

        private void loadArticleStore() {
            final BasicArticleComplete article = (BasicArticleComplete)this.model.getNode().getChildNamed(InternalConsumptionMovementComplete_.article).getValue(BasicArticleComplete.class);
            this.updatePackingUnitsAndInfoButton();
            Map map = (Map)ArticleCheckoutDetailsPanel.this.stockHash.get(article);
            if (map == null || map.isEmpty()) {
                ThreadSafeExecutable run = new ThreadSafeExecutable(){

                    @Override
                    public Node<?> loadData() throws Exception {
                        HashMap map2 = ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStockPerStorePosition((BasicArticleReference)article).getMap();
                        HashMap map3 = null;
                        if (ArticleCheckoutDetailsPanel.this.moveFromClosedStore) {
                            map3 = map2;
                        } else {
                            map3 = new HashMap();
                            for (Map.Entry e : map2.entrySet()) {
                                if (!((StorePositionLight)e.getKey()).getStore().getAutoCheckoutStore().booleanValue()) continue;
                                map3.put(e.getKey(), e.getValue());
                            }
                        }
                        Map filtered = StoreToolkit.filter(map3, (TransactionType)TransactionType.INTERNAL_CONSUMPTION, (UserComplete)ArticleCheckoutDetailsPanel.this.currentUser, (SystemSettingsComplete)ArticleCheckoutDetailsPanel.this.settings);
                        ArticleCheckoutDetailsPanel.this.stockHash.put(article, filtered);
                        ViewNode n = new ViewNode("");
                        n.setValue((Object)filtered, 0L);
                        return n;
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return new RemoteLoader(){

                            public void remoteObjectLoaded(Node<?> node) {
                                TableRowImpl.this.updateStore((Map)node.getValue());
                            }

                            public void errorOccurred(ClientException exception) {
                                InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ArticleCheckoutDetailsPanel.this);
                            }
                        };
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
            } else {
                this.updateStore(map);
            }
        }

        public boolean validateRow(List<ScreenValidationObject> a) {
            boolean storesSet = true;
            if (this.destination.getNode().getValue() == null) {
                this.destination.setInValid();
                storesSet = false;
            }
            StorePositionLight sourcePos = (StorePositionLight)this.originPosition.getNode().getValue();
            StorePositionLight destinationPos = (StorePositionLight)this.destination.getNode().getValue();
            if (sourcePos != null && destinationPos != null && sourcePos.equals((Object)destinationPos)) {
                BasicArticleLight article = (BasicArticleLight)this.articleName.getNode().getValue();
                this.originPosition.setInvalid();
                this.originStore.setInvalid();
                this.destination.setInValid();
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ENSURE_SOURCE_AND_DESTINATION_POSITION_ISNT_EQUALS, (Object[])new Object[]{article.getNumber(), article.getName()})));
                storesSet = false;
            }
            return storesSet;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.originStore);
            CheckedListAdder.addToList(a, this.originPosition);
            CheckedListAdder.addToList(a, this.destination);
            CheckedListAdder.addToList(a, this.deleteButton);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.info.setEnabled(isEnabled);
            this.articleName.setEnabled(isEnabled);
            this.amount.setEnabled(isEnabled);
            this.originStore.setEnabled(isEnabled);
            this.originPosition.setEnabled(isEnabled);
            this.destination.setEnabled(isEnabled);
            this.stock.setEnabled(isEnabled);
            this.deleteButton.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.articleName.kill();
            this.articleName = null;
            this.info.kill();
            this.info = null;
            this.amount.kill();
            this.amount = null;
            this.originPosition.kill();
            this.originPosition = null;
            this.originStore.kill();
            this.originStore = null;
            this.destination.kill();
            this.destination = null;
            this.stock.kill();
            this.stock = null;
            this.deleteButton.kill();
            this.deleteButton = null;
            ArticleCheckoutDetailsPanel.this.editor.getModel().getNode().getChildNamed(InternalConsumptionComplete_.consumptionDate).removeNodeListener((NodeListener)this);
        }

        public void valueChanged(Node<?> node) {
            this.updatePackingUnitsAndInfoButton();
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?>[] nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton) {
                ArticleCheckoutDetailsPanel.this.table.getModel().getNode().removeChild(this.model.getNode(), 0L);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            if (arg0.getStateChange() == 1) {
                if (arg0.getSource() == this.originStore) {
                    this.updatePosition();
                }
                if (arg0.getSource() == this.originPosition) {
                    this.updateStock();
                }
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.articleName.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.articleName.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.articleName.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.info.getPreferredSize().getWidth())), (int)TableRowImpl.this.articleName.getPreferredSize().getHeight());
                TableRowImpl.this.info.setLocation(TableRowImpl.this.articleName.getX() + TableRowImpl.this.articleName.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.info.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.info.setSize(TableRowImpl.this.info.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.amount.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.amount.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.amount.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.amount.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.originStore.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.originStore.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.originStore.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.originStore.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.originPosition.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.originPosition.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.originPosition.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.originPosition.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.stock.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.stock.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.stock.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.stock.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.destination.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.destination.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.destination.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.destination.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(6);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.deleteButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.deleteButton.setSize(TableRowImpl.this.deleteButton.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }
}

