/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.itemsubstitution;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.production.ItemSubstitutionComplete;
import ch.icit.pegasus.server.core.dtos.production.ItemSubstitutionComplete_;
import ch.icit.pegasus.server.core.dtos.production.ItemSubstitutionEntryComplete_;
import ch.icit.pegasus.server.core.dtos.production.ItemSubstitutionLight;
import ch.icit.pegasus.server.core.dtos.production.ItemSubstitutionReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.util.Iterator;

public class ItemSubstitutionModuleDataHandler
extends DefaultDataHandler<ItemSubstitutionReference, ItemSubstitutionComplete> {
    public ItemSubstitutionModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ItemSubstitutionLight sub = (ItemSubstitutionLight)node.getValue(ItemSubstitutionLight.class);
                ItemSubstitutionComplete ntruck = (ItemSubstitutionComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getItemSubstitution((ItemSubstitutionReference)sub).getValue();
                node.removeExistingValues();
                node.setValue((Object)ntruck, 0L);
                node.updateNode();
                Iterator it = node.getChildNamed(ItemSubstitutionComplete_.substitutions).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node entry = (Node)it.next();
                    ItemSubstitutionModuleDataHandler.this.ensureArticle((Node<BasicArticleLight>)entry.getChildNamed(ItemSubstitutionEntryComplete_.originArticle));
                    ItemSubstitutionModuleDataHandler.this.ensureArticle((Node<BasicArticleLight>)entry.getChildNamed(ItemSubstitutionEntryComplete_.newArticle));
                }
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    private void ensureArticle(Node<BasicArticleLight> articleNode) throws ClientServerCallException {
        if (articleNode == null) {
            return;
        }
        if (articleNode.getValue() == null) {
            return;
        }
        BasicArticleComplete artC = (BasicArticleComplete)articleNode.getValue(BasicArticleComplete.class);
        if (artC == null) {
            BasicArticleLight artL = (BasicArticleLight)articleNode.getValue();
            artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(artL.getId())).getValue();
            articleNode.removeExistingValues();
            articleNode.setValue((Object)artC, 0L);
        }
    }

    @Override
    public void updateData(final Node<ItemSubstitutionReference> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit();
                ItemSubstitutionComplete d = (ItemSubstitutionComplete)node.getValue(ItemSubstitutionComplete.class);
                ItemSubstitutionComplete dto = (ItemSubstitutionComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateItemSubstitution(d).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<ItemSubstitutionComplete> createEmptyNode() {
        ItemSubstitutionComplete d = new ItemSubstitutionComplete();
        d.setClientOId(Long.valueOf(ADTO.getNextId()));
        d.setDate(new Date(System.currentTimeMillis()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)d, false, false);
        return n;
    }

    @Override
    public void createNewData(final Node<ItemSubstitutionComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ItemSubstitutionComplete d = (ItemSubstitutionComplete)node.getValue(ItemSubstitutionComplete.class);
                ItemSubstitutionComplete dto = (ItemSubstitutionComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).createItemSubstitution(d).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ItemSubstitutionModuleDataHandler.this.setCurrentLoadMaximum(6);
                ItemSubstitutionModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                ItemSubstitutionModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                ItemSubstitutionModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class);
                ItemSubstitutionModuleDataHandler.this.showNextMessage(progressListener);
                UnitToolkit.loadUnits();
                ItemSubstitutionModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                ItemSubstitutionModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllItemSubstitutionTypes();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return ItemSubstitutionModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<ItemSubstitutionComplete> resetData(Node<ItemSubstitutionComplete> node) {
        ItemSubstitutionComplete n = new ItemSubstitutionComplete();
        n.setClientOId(Long.valueOf(ADTO.getNextId()));
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)n, true, false);
    }

    @Override
    public Class<ItemSubstitutionComplete> getCommittingClass() {
        return ItemSubstitutionComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<ItemSubstitutionReference> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

