/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.ProductCategoryConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.CategoryConfig;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.AMasterDataComplete;
import ch.icit.pegasus.server.core.dtos.supply.ProductCategoryComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ProductCategoryConfig
extends CategoryConfig<ProductCategoryComplete> {
    private static final long serialVersionUID = 1L;

    public ProductCategoryConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public int getMaxDepth() {
        return ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getProductCategoryDepth();
    }

    @Override
    public String getInsertName() {
        return Words.PRODUCT_CATEGORIES;
    }

    private void ensureParentReference(ProductCategoryComplete parent) {
        for (ProductCategoryComplete child : parent.getSubCategories()) {
            child.setParent(parent);
            this.ensureParentReference(child);
        }
    }

    private Set<ProductCategoryComplete> getCategoriesToDeleteRecursive(ProductCategoryComplete categoryComplete) {
        HashSet<ProductCategoryComplete> cats = new HashSet<ProductCategoryComplete>();
        if (Boolean.TRUE.equals(categoryComplete.getIsDeleted()) && categoryComplete.getParent() != null && categoryComplete.getDeleteUser() == null && categoryComplete.getId() != null) {
            cats.add(categoryComplete);
        }
        for (ProductCategoryComplete articleCategoryComplete : categoryComplete.getSubCategories()) {
            cats.addAll(this.getCategoriesToDeleteRecursive(articleCategoryComplete));
        }
        return cats;
    }

    private Set<ProductCategoryComplete> getCategoriesToRestoreRecursive(ProductCategoryComplete categoryComplete) {
        HashSet<ProductCategoryComplete> cats = new HashSet<ProductCategoryComplete>();
        if (Boolean.FALSE.equals(categoryComplete.getIsDeleted()) && categoryComplete.getParent() != null && categoryComplete.getDeleteUser() != null && categoryComplete.getId() != null) {
            cats.add(categoryComplete);
        }
        for (ProductCategoryComplete articleCategoryComplete : categoryComplete.getSubCategories()) {
            cats.addAll(this.getCategoriesToRestoreRecursive(articleCategoryComplete));
        }
        return cats;
    }

    @Override
    public Node saveDataImpl(Node<?> node) throws ClientServerCallException {
        Iterator it = node.getChilds();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            n.commitThis(ProductCategoryComplete.class);
            ProductCategoryComplete cat = (ProductCategoryComplete)n.getValue(ProductCategoryComplete.class);
            this.ensureParentReference(cat);
            Set<ProductCategoryComplete> innerDelete = this.getCategoriesToDeleteRecursive(cat);
            Set<ProductCategoryComplete> innerRestore = this.getCategoriesToRestoreRecursive(cat);
            for (ProductCategoryComplete articleCategoryComplete : innerDelete) {
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).delete((AMasterDataComplete)articleCategoryComplete);
            }
            for (ProductCategoryComplete articleCategoryComplete : innerRestore) {
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).restore((AMasterDataComplete)articleCategoryComplete);
            }
            cat = cat.getId() == null ? (ProductCategoryComplete)((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).create((AMasterDataComplete)cat).getValue() : (cat.getIsDeleted() != false && cat.getDeleteUser() == null ? (ProductCategoryComplete)((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).delete((AMasterDataComplete)cat).getValue() : (cat.getIsDeleted() == false && cat.getDeleteUser() != null ? (ProductCategoryComplete)((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).restore((AMasterDataComplete)cat).getValue() : (ProductCategoryComplete)((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).update((AMasterDataComplete)cat).getValue()));
            n.setValue((Object)cat, 0L);
            n.updateNode();
        }
        return node;
    }

    @Override
    public Converter getTopTitleConverter() {
        return ConverterRegistry.getConverter(ProductCategoryConverter.class);
    }

    @Override
    public Node loadDataImpl(Node<?> node) throws ClientServerCallException {
        return INodeCreator.getDefaultImpl().createNodes(((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperProductCategoriesWithDeleted().getList(), false);
    }

    @Override
    public ProductCategoryComplete createNewCategory() {
        ProductCategoryComplete c = new ProductCategoryComplete();
        c.setClientOId(Long.valueOf(ADTO.getNextId()));
        c.setDisplay(Boolean.valueOf(true));
        return c;
    }
}

