/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete_;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class TaxZoneConfig
extends MasterDataInsert<TaxZoneComplete> {
    private static final long serialVersionUID = 1L;

    public TaxZoneConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public TaxZoneComplete getNewObject() {
        TaxZoneComplete z = new TaxZoneComplete();
        z.setClientOId(Long.valueOf(ADTO.getNextId()));
        return z;
    }

    @Override
    public Class<? extends TaxZoneComplete> getMasterDataClass() {
        return TaxZoneComplete.class;
    }

    @Override
    public String getInsertName() {
        return "Tax Zones";
    }

    @Override
    public DetailsPanel getDetails() {
        return new TaxZoneConfigPanel();
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        boolean nameSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(TaxZoneComplete_.name).getValue() == null) {
                nameSet = false;
            }
            if (n.getChildNamed(TaxZoneComplete_.code).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(TaxZoneComplete_.code).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Code " + n.getChildNamed(TaxZoneComplete_.code).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(TaxZoneComplete_.code).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Codes are set"));
        }
        if (!nameSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Name are set"));
        }
        return a;
    }

    class TaxZoneConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> code;
        private TitledItem<TextField> name;

        public TaxZoneConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.code = new TitledItem<TextField>(new TextField(), "Code", TitledItem.TitledItemOrientation.NORTH);
            this.name = new TitledItem<TextField>(new TextField(), "Name", TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.code);
            this.add(this.name);
        }

        @Override
        public DtoField getAttributeName() {
            return TaxZoneComplete_.code;
        }

        @Override
        public void setNode(Node<?> n) {
            super.setNode(n);
            this.code.getElement().setNode(n.getChildNamed(TaxZoneComplete_.code));
            this.name.getElement().setNode(n.getChildNamed(TaxZoneComplete_.name));
            this.setEnabled(true);
            TaxZoneConfig.this.setEnabled(true);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.code.getFocusComponents();
            a.addAll(this.name.getFocusComponents());
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.code.setVisibleContainer(pane);
            this.name.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.name.kill();
            this.code = null;
            this.name = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.code.setEnabled(b);
            this.name.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                TaxZoneConfigPanel.this.code.setLocation(TaxZoneConfig.this.masterDataTable.getCellPadding(), TaxZoneConfig.this.masterDataTable.getCellPadding());
                TaxZoneConfigPanel.this.code.setSize(200, (int)TaxZoneConfigPanel.this.code.getPreferredSize().getHeight());
                TaxZoneConfigPanel.this.name.setLocation(TaxZoneConfig.this.masterDataTable.getCellPadding(), TaxZoneConfigPanel.this.code.getY() + TaxZoneConfigPanel.this.code.getHeight() + TaxZoneConfig.this.masterDataTable.getCellPadding());
                TaxZoneConfigPanel.this.name.setSize(200, (int)TaxZoneConfigPanel.this.name.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

