/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.matdispo.details;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.PaxFigureStringConverter;
import ch.icit.pegasus.client.converter.PaxFigureTypeConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.matdispo.MatDispoOldModule;
import ch.icit.pegasus.client.gui.screentemplates.splitscreen.SplitView;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledDateTimePeriodChooser;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.flightschedule.AlaCarteMealOrderComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.PaxFigureComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SpecialMealOrderComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.Tuple;
import ch.icit.utils.ExcelRow;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FlightDetailsPanel
extends SplitView
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<SearchTextField> numberSearch;
    private TitledItem<SearchComboBox> customerSearch;
    private TitledItem<CheckBox> includePlannedFlights;
    private TitledDateTimePeriodChooser periodEditor;
    private TextButton search;
    private TextButton clearAll;
    private HorizontalSeparator sep1;
    private MatDispoOldModule matDispo;
    private TitledItem<CheckBox> excludeCancelledFlights;
    private boolean includeSPMLS = true;
    private CheckBox activateDefaultLoad;
    private TitledItem<TitledItem<NumberTextField>> defaultLoad;
    private Table2 table;

    public FlightDetailsPanel(MatDispoOldModule matDispo) {
        this.matDispo = matDispo;
        this.numberSearch = new TitledItem<SearchTextField>(new SearchTextField(), "Flight NO", TitledItem.TitledItemOrientation.NORTH);
        this.customerSearch = new TitledItem<SearchComboBox>(SearchComboBoxFactory.getCustomerSearchField(true), "Customer", TitledItem.TitledItemOrientation.NORTH);
        long aMonth = 2592000000L;
        TimestampPeriodComplete p = new TimestampPeriodComplete(new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis() + aMonth));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, false, false);
        this.periodEditor = new TitledDateTimePeriodChooser((Node<TimestampPeriodComplete>)n);
        this.search = new TextButton("Add");
        this.clearAll = new TextButton("Clear All");
        this.sep1 = new HorizontalSeparator();
        this.activateDefaultLoad = new CheckBox();
        this.activateDefaultLoad.addButtonListener(this);
        this.defaultLoad = new TitledItem<TitledItem<NumberTextField>>(new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.DOUBLE), "%", TitledItem.TitledItemOrientation.EAST), "Default Load", TitledItem.TitledItemOrientation.NORTH);
        this.defaultLoad.getElement().getElement().setText("100");
        this.excludeCancelledFlights = new TitledItem<CheckBox>(new CheckBox(), Words.EXCLUDE_CANCELED_FLIGHTS, TitledItem.TitledItemOrientation.EAST);
        this.excludeCancelledFlights.getElement().setChecked(true);
        this.table = new Table2(false, "", false, false);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.FLIGHT_NUMBER, null, null, null, "", 80, 80, 80));
        int tw = TableColumnInfo.dateTimeColumnWidth + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(Words.DATE, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.PAX_TYPE, null, null, null, "", 90, 90, 90));
        columns.add(new TableColumnInfo(Words.PAX, null, null, null, "", 30, 30, 30));
        tw = 2 * this.table.getCellPadding() + this.table.getInnerCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.table.getModel().setNode((Node)new ViewNode("flights"));
        this.search.addButtonListener(this);
        this.clearAll.addButtonListener(this);
        this.setLayout(new Layout());
        this.add(this.numberSearch);
        this.add(this.excludeCancelledFlights);
        this.add(this.customerSearch);
        this.add(this.activateDefaultLoad);
        this.add(this.defaultLoad);
        this.add(this.periodEditor);
        this.add(this.search);
        this.add(this.clearAll);
        this.add(this.sep1);
        this.add(this.table);
    }

    @Override
    public void resetData() {
    }

    public List<FlightLight> getFlightList() {
        ArrayList<FlightLight> flights = new ArrayList<FlightLight>();
        Iterator it = this.table.getModel().getNode().getChilds();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            FlightLight l = (FlightLight)n.getValue(FlightLight.class);
            flights.add(l);
        }
        return flights;
    }

    public List<ExcelRow> getFlightRows() throws ClientServerCallException {
        Map<CabinClassComplete, Integer> m;
        boolean found;
        int max;
        FlightLight l;
        ArrayList<ExcelRow> flights = new ArrayList<ExcelRow>();
        ExcelRow h = new ExcelRow();
        h.setHeader(true);
        h.addCell((Object)"Flight Parameters", new String[0]);
        flights.add(h);
        if (this.customerSearch.getElement().isItemSelected()) {
            ExcelRow custeomer = new ExcelRow();
            custeomer.addCell((Object)"Customer", new String[0]);
            custeomer.addCell((Object)((CustomerLight)this.customerSearch.getElement().getNode().getValue()).getName(), new String[0]);
            flights.add(custeomer);
        }
        DateTimeConverter c = (DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class);
        ExcelRow time = new ExcelRow();
        time.addCell((Object)"Period from", new String[0]);
        time.addCell((Object)c.convert((Object)this.periodEditor.getTimePeriod().getStartTime(), null, new Object[0]), new String[0]);
        flights.add(time);
        ExcelRow time2 = new ExcelRow();
        time2.addCell((Object)"Period to", new String[0]);
        time2.addCell((Object)c.convert((Object)this.periodEditor.getTimePeriod().getEndTime(), null, new Object[0]), new String[0]);
        flights.add(time2);
        ExcelRow excludeFlights = new ExcelRow();
        excludeFlights.addCell((Object)Words.EXCLUDE_CANCELED_FLIGHTS, new String[0]);
        excludeFlights.addCell((Object)this.excludeCancelledFlights.getElement().isChecked(), new String[0]);
        flights.add(excludeFlights);
        ExcelRow f = new ExcelRow();
        f.setHeader(true);
        f.addCell((Object)"Outbound Code", new String[0]);
        f.addCell((Object)"Inbound Code", new String[0]);
        f.addCell((Object)"Std", new String[0]);
        f.addCell((Object)"Sta", new String[0]);
        f.addCell((Object)"Stowing", new String[0]);
        flights.add(f);
        HashMap index = new HashMap();
        HashMap indexSPML = new HashMap();
        ArrayList cabinClasses = new ArrayList();
        ArrayList spmlClasses = new ArrayList();
        HashSet<CabinClassComplete> ic = new HashSet<CabinClassComplete>();
        HashSet<Tuple> spmlIndex = new HashSet<Tuple>();
        Iterator it = this.table.getModel().getNode().getChilds();
        while (it.hasNext()) {
            Object leg2;
            Node n = (Node)it.next();
            FlightLight l2 = (FlightLight)n.getValue(FlightLight.class);
            for (Object leg2 : l2.getLegs()) {
                if (!leg2.getCateringLeg().booleanValue()) continue;
                for (PaxFigureComplete fig : leg2.getPaxFigures()) {
                    if (fig.getPaxFigureType() != null) continue;
                    ic.add(fig.getCabinClass());
                }
            }
            if (!this.includeSPMLS) continue;
            FlightComplete flightComplete = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(l2.getId())).getValue();
            n.setValue((Object)flightComplete, 0L);
            for (SpecialMealOrderComplete o : flightComplete.getSpmlOrders()) {
                spmlIndex.add(new Tuple((Object)o.getCabinClass(), (Object)o.getMenuType()));
            }
            leg2 = flightComplete.getAlaCarteOrders().iterator();
            while (leg2.hasNext()) {
                AlaCarteMealOrderComplete a = (AlaCarteMealOrderComplete)leg2.next();
                spmlIndex.add(new Tuple((Object)a.getCabinClass(), (Object)a.getMenuType()));
            }
        }
        cabinClasses.addAll(ic);
        Collections.sort(cabinClasses);
        spmlClasses.addAll(spmlIndex);
        int lc = 5;
        for (CabinClassComplete cc : cabinClasses) {
            int maxLeg = 0;
            it = this.table.getModel().getNode().getChilds();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                l = (FlightLight)n.getValue(FlightLight.class);
                max = 0;
                for (FlightLegComplete leg : l.getLegs()) {
                    if (!leg.getCateringLeg().booleanValue()) continue;
                    found = false;
                    for (PaxFigureComplete px : leg.getPaxFigures()) {
                        if (px.getPaxFigureType() != null || !px.getCabinClass().equals((Object)cc)) continue;
                        found = true;
                    }
                    if (!found) continue;
                    ++max;
                }
                if (max <= maxLeg) continue;
                maxLeg = max;
            }
            for (int i = 0; i < maxLeg; ++i) {
                m = (HashMap<CabinClassComplete, Integer>)index.get(i);
                if (m == null) {
                    m = new HashMap<CabinClassComplete, Integer>();
                    index.put(i, m);
                }
                m.put(cc, lc);
                f.fillRow(lc + 2, (Object)"");
                f.getCells().set(lc, "Leg " + (i + 1) + " " + cc.getCode());
                f.getCells().set(lc + 1, "Leg " + (i + 1) + " Max " + cc.getCode());
                ++lc;
                ++lc;
            }
        }
        for (CabinClassComplete cc : spmlClasses) {
            int maxLeg = 0;
            it = this.table.getModel().getNode().getChilds();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                l = (FlightComplete)n.getValue(FlightComplete.class);
                max = 0;
                for (FlightLegComplete leg : l.getLegs()) {
                    if (!leg.getCateringLeg().booleanValue()) continue;
                    found = false;
                    for (PaxFigureComplete px : leg.getPaxFigures()) {
                        if (px.getPaxFigureType() != null || !px.getCabinClass().equals(cc.getS())) continue;
                        found = true;
                    }
                    if (!found) continue;
                    ++max;
                }
                if (max <= maxLeg) continue;
                maxLeg = max;
            }
            for (int i = 0; i < maxLeg; ++i) {
                m = (Map)indexSPML.get(i);
                if (m == null) {
                    m = new HashMap();
                    indexSPML.put(i, m);
                }
                m.put(cc, lc);
                f.fillRow(lc + 1, (Object)"");
                f.getCells().set(lc, "Leg " + (i + 1) + " " + ((CabinClassComplete)cc.getS()).getCode() + " " + ((AMenuTypeComplete)cc.getT()).getCode());
                ++lc;
            }
        }
        it = this.table.getModel().getNode().getChilds();
        while (it.hasNext()) {
            Integer ai;
            Map i;
            Node n = (Node)it.next();
            FlightComplete l3 = (FlightComplete)n.getValue(FlightComplete.class);
            ExcelRow r = new ExcelRow();
            r.addCell((Object)l3.getOutboundCode(), new String[0]);
            r.addCell((Object)l3.getInboundCode(), new String[0]);
            r.addCell((Object)l3.getStd(), new String[0]);
            r.addCell((Object)l3.getSta(), new String[0]);
            r.addCell((Object)l3.getActiveStowingList().getName(), new String[0]);
            Collections.sort(l3.getLegs());
            int clc = 0;
            for (FlightLegComplete leg : l3.getLegs()) {
                if (!leg.getCateringLeg().booleanValue()) continue;
                for (PaxFigureComplete px : leg.getPaxFigures()) {
                    Integer ci;
                    if (px.getPaxFigureType() != null) continue;
                    HashMap ti = (HashMap)index.get(clc);
                    if (ti == null) {
                        ti = new HashMap();
                        index.put(clc, ti);
                    }
                    if ((ci = (Integer)ti.get(px.getCabinClass())) == null) continue;
                    r.fillRow(ci + 2, (Object)"");
                    r.getCells().set(ci, px.getNumber());
                    r.getCells().set(ci + 1, this.getMaxPax((FlightLight)l3, px.getCabinClass()));
                }
                ++clc;
            }
            for (SpecialMealOrderComplete spml : l3.getSpmlOrders()) {
                for (FlightLegComplete leg : spml.getLegs()) {
                    i = (Map)indexSPML.get(this.getLegNo(leg, l3));
                    if (i == null || (ai = (Integer)i.get(new Tuple((Object)spml.getCabinClass(), (Object)spml.getMenuType()))) == null) continue;
                    r.fillRow(ai + 1, (Object)"");
                    r.getCells().set(ai, spml.getCount());
                }
            }
            for (SpecialMealOrderComplete spml : l3.getAlaCarteOrders()) {
                for (FlightLegComplete leg : spml.getLegs()) {
                    i = (Map)indexSPML.get(leg.getNumber());
                    if (i == null || (ai = (Integer)i.get(new Tuple((Object)spml.getCabinClass(), (Object)spml.getMenuType()))) == null) continue;
                    r.fillRow(ai + 1, (Object)"");
                    r.getCells().set(ai, spml.getCount());
                }
            }
            flights.add(r);
        }
        return flights;
    }

    private Integer getLegNo(FlightLegComplete leg, FlightComplete l) {
        int i = 0;
        for (FlightLegComplete legg : l.getLegs()) {
            if (legg.equals((Object)leg)) {
                return i;
            }
            if (!Boolean.TRUE.equals(legg.getCateringLeg())) continue;
            ++i;
        }
        return i;
    }

    private int getMaxPax(FlightLight flight, CabinClassComplete cc) {
        for (SeatConfigurationComplete sc : flight.getActiveStowingList().getSeatConfigurations()) {
            if (!sc.getCabinClass().equals((Object)cc)) continue;
            return sc.getNumber();
        }
        return 0;
    }

    public double getDefaultLoad() {
        if (this.activateDefaultLoad.isChecked()) {
            String d = this.defaultLoad.getElement().getElement().getText();
            Double dd = null;
            try {
                dd = Double.valueOf(d);
            }
            catch (NumberFormatException e) {
                dd = 100.0;
            }
            return dd;
        }
        return -1.0;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.numberSearch.setEnabled(isEnabled);
        this.excludeCancelledFlights.setEnabled(isEnabled);
        this.customerSearch.setEnabled(isEnabled);
        if (isEnabled) {
            // empty if block
        }
        this.activateDefaultLoad.setEnabled(false);
        if (!isEnabled || this.activateDefaultLoad.isChecked()) {
            // empty if block
        }
        this.defaultLoad.setEnabled(false);
        this.periodEditor.setEnabled(isEnabled);
        this.search.setEnabled(isEnabled);
        this.clearAll.setEnabled(isEnabled);
        this.sep1.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.numberSearch.kill();
        this.numberSearch = null;
        this.excludeCancelledFlights.kill();
        this.excludeCancelledFlights = null;
        this.customerSearch.kill();
        this.customerSearch = null;
        this.activateDefaultLoad.kill();
        this.activateDefaultLoad = null;
        this.defaultLoad.kill();
        this.defaultLoad = null;
        this.periodEditor.kill();
        this.periodEditor = null;
        this.search.kill();
        this.search = null;
        this.clearAll.kill();
        this.clearAll = null;
        this.sep1.kill();
        this.sep1 = null;
        this.table.kill();
        this.table = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.numberSearch);
        CheckedListAdder.addToList(a, this.customerSearch);
        CheckedListAdder.addToList(a, this.defaultLoad);
        CheckedListAdder.addToList(a, this.activateDefaultLoad);
        CheckedListAdder.addToList(a, this.periodEditor);
        CheckedListAdder.addToList(a, this.excludeCancelledFlights);
        CheckedListAdder.addToList(a, this.search);
        CheckedListAdder.addToList(a, this.clearAll);
        CheckedListAdder.addToList(a, this.table);
        return a;
    }

    private boolean containsFlight(FlightLight l) {
        for (Table2RowPanel p : this.table.getRows()) {
            if (!p.getModel().getNode().getValue().equals(l)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.clearAll) {
            this.table.getModel().getNode().removeAllChilds();
            this.table.getModel().setNode((Node)new ViewNode("flights"));
        } else if (source == this.search) {
            final FlightSearchConfiguration c = new FlightSearchConfiguration();
            c.setCustomer((CustomerLight)this.customerSearch.getElement().getNode().getValue());
            c.setFlightNumber(this.numberSearch.getElement().getText());
            TimestampPeriodComplete stamp = this.periodEditor.getTimePeriod();
            c.setDayTimePeriod(stamp);
            c.setFlightStdSta(FlightSearchConfiguration.FLIGHT_STD_STA.stdOnly);
            this.matDispo.showAnimation(true);
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    SearchResultIterator sri = new SearchResultIterator((ASearchConfiguration)c);
                    ViewNode n = new ViewNode("");
                    ArrayList<FlightLight> r = new ArrayList<FlightLight>();
                    for (FlightLight f : sri) {
                        if (((CheckBox)FlightDetailsPanel.this.excludeCancelledFlights.getElement()).isChecked()) {
                            if (f.getFlightState() == FlightStateE.CANCELLED) continue;
                            r.add(f);
                            continue;
                        }
                        r.add(f);
                    }
                    n.setValue(r, 0L);
                    return n;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            List r = (List)node.getValue();
                            if (r.isEmpty()) {
                                InnerPopupFactory.showErrorDialog("No Flight found for this configuration", "No Flight found", (Component)FlightDetailsPanel.this.search);
                            } else {
                                TimestampPeriodComplete stamp2 = FlightDetailsPanel.this.periodEditor.getTimePeriod();
                                for (FlightLight f : r) {
                                    if (f.getFlightState() == FlightStateE.PLANNED || FlightDetailsPanel.this.containsFlight(f) || f.getStd().getTime() < stamp2.getStartTime().getTime() || f.getStd().getTime() > stamp2.getEndTime().getTime()) continue;
                                    Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)f, true, false);
                                    FlightDetailsPanel.this.table.getModel().getNode().addChild(n, 0L);
                                }
                                FlightDetailsPanel.this.revalidate();
                            }
                            FlightDetailsPanel.this.matDispo.showAnimation(false);
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog((Exception)exception, (Component)FlightDetailsPanel.this.search);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else if (source == this.activateDefaultLoad) {
            this.setEnabled(this.isEnabled());
        }
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel flightNo;
        private TextLabel flightDate;
        private TextLabel paxType;
        private TextLabel paxFigures;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.flightNo = new TextLabel(m.getNode().getChildNamed(new String[]{"outboundCode"}), ConverterRegistry.getConverter(StringConverter.class));
            this.flightDate = new TextLabel(m.getNode().getChildNamed(new String[]{"std"}), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.paxType = new TextLabel(m.getNode().getChildNamed(FlightLight_.selectedPaxType), ConverterRegistry.getConverter(PaxFigureTypeConverter.class));
            this.paxFigures = new TextLabel(m.getNode().getChildNamed(new String[]{"legs"}), ConverterRegistry.getConverter(PaxFigureStringConverter.class));
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.flightDate);
            this.add(this.flightNo);
            this.add(this.paxType);
            this.add(this.paxFigures);
            this.add(this.delete);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.flightDate.kill();
            this.flightNo.kill();
            this.paxFigures.kill();
            this.delete.kill();
            this.paxType.kill();
            this.flightDate = null;
            this.flightNo = null;
            this.paxFigures = null;
            this.delete = null;
            this.paxType = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return this.delete.getFocusComponents();
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new String[]{"outboundCode"}).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(new String[]{"std"}).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(FlightLight_.selectedPaxType).getValue();
                }
                case 3: {
                    return this.paxFigures.getText();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.flightDate.setEnabled(isEnabled);
            this.flightNo.setEnabled(isEnabled);
            this.paxFigures.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
            this.paxType.setEnabled(isEnabled);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (this.delete == source) {
                FlightDetailsPanel.this.table.getModel().getNode().removeChild(this.model.getNode(), 0L);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.flightNo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.flightNo.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.flightNo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.flightNo.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.flightDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.flightDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.flightDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.flightDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.paxType.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.paxType.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.paxType.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.paxType.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.paxFigures.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.paxFigures.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.paxFigures.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.paxFigures.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            FlightDetailsPanel.this.numberSearch.setLocation(10, 10);
            FlightDetailsPanel.this.numberSearch.setSize(150, (int)FlightDetailsPanel.this.numberSearch.getPreferredSize().getHeight());
            FlightDetailsPanel.this.customerSearch.setLocation(FlightDetailsPanel.this.numberSearch.getX() + FlightDetailsPanel.this.numberSearch.getWidth() + 10, FlightDetailsPanel.this.numberSearch.getY());
            FlightDetailsPanel.this.customerSearch.setSize(150, (int)FlightDetailsPanel.this.customerSearch.getPreferredSize().getHeight());
            FlightDetailsPanel.this.activateDefaultLoad.setLocation(FlightDetailsPanel.this.customerSearch.getX() + FlightDetailsPanel.this.customerSearch.getWidth() + 10, (int)((double)(FlightDetailsPanel.this.customerSearch.getY() + FlightDetailsPanel.this.customerSearch.getHeight()) - (FlightDetailsPanel.this.activateDefaultLoad.getPreferredSize().getHeight() + 2.0)));
            FlightDetailsPanel.this.activateDefaultLoad.setSize(FlightDetailsPanel.this.activateDefaultLoad.getPreferredSize());
            FlightDetailsPanel.this.defaultLoad.setLocation(FlightDetailsPanel.this.activateDefaultLoad.getX() + FlightDetailsPanel.this.activateDefaultLoad.getWidth() + 3, FlightDetailsPanel.this.customerSearch.getY());
            FlightDetailsPanel.this.defaultLoad.setSize(100, (int)FlightDetailsPanel.this.defaultLoad.getPreferredSize().getHeight());
            FlightDetailsPanel.this.periodEditor.setLocation(10, FlightDetailsPanel.this.numberSearch.getY() + FlightDetailsPanel.this.numberSearch.getHeight() + 10);
            FlightDetailsPanel.this.periodEditor.setSize(FlightDetailsPanel.this.periodEditor.getPreferredSize());
            FlightDetailsPanel.this.excludeCancelledFlights.setLocation(FlightDetailsPanel.this.periodEditor.getX() + FlightDetailsPanel.this.periodEditor.getWidth() + 10, (int)((double)(FlightDetailsPanel.this.periodEditor.getY() + FlightDetailsPanel.this.periodEditor.getHeight()) - FlightDetailsPanel.this.excludeCancelledFlights.getPreferredSize().getHeight()));
            FlightDetailsPanel.this.excludeCancelledFlights.setSize(FlightDetailsPanel.this.excludeCancelledFlights.getPreferredSize());
            FlightDetailsPanel.this.search.setLocation(10, FlightDetailsPanel.this.periodEditor.getY() + FlightDetailsPanel.this.periodEditor.getHeight() + 10);
            FlightDetailsPanel.this.search.setSize(FlightDetailsPanel.this.search.getPreferredSize());
            FlightDetailsPanel.this.clearAll.setLocation(FlightDetailsPanel.this.search.getX() + FlightDetailsPanel.this.search.getWidth() + 10, FlightDetailsPanel.this.search.getY());
            FlightDetailsPanel.this.clearAll.setSize(FlightDetailsPanel.this.clearAll.getPreferredSize());
            FlightDetailsPanel.this.sep1.setLocation(1, FlightDetailsPanel.this.search.getY() + FlightDetailsPanel.this.search.getHeight() + 10);
            FlightDetailsPanel.this.sep1.setSize(parent.getWidth() - 2, (int)FlightDetailsPanel.this.sep1.getPreferredSize().getHeight());
            FlightDetailsPanel.this.table.setLocation(1, FlightDetailsPanel.this.sep1.getY() + 1);
            FlightDetailsPanel.this.table.setSize(parent.getWidth() - 2, parent.getHeight() - (FlightDetailsPanel.this.table.getY() + 3));
        }
    }
}

