/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.product.details;

import ch.icit.pegasus.client.converter.DiscountTypeConverter;
import ch.icit.pegasus.client.converter.PriceConverter1;
import ch.icit.pegasus.client.converter.TaxRateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.formatter.FormatterRegistry;
import ch.icit.pegasus.client.gui.modules.product.details.SalePriceDetailsPanel;
import ch.icit.pegasus.client.gui.modules.product.details.utils.GroupedLoader;
import ch.icit.pegasus.client.gui.modules.product.details.utils.TaxAmountConverter;
import ch.icit.pegasus.client.gui.modules.product.details.utils.TotalDiscountConverter;
import ch.icit.pegasus.client.gui.modules.product.details.utils.TotalSalesPriceConverter;
import ch.icit.pegasus.client.gui.modules.product.details.utils.TotalTaxesConverter;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.popup.inserts.ProductCustomerDiscountPopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.ProductCustomerPricePopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.ProductCustomerTaxRatesPopupInsert;
import ch.icit.pegasus.client.gui.utils.priceanimation.CalculationRunnable;
import ch.icit.pegasus.client.gui.utils.priceanimation.LoadingGroup;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDInputComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.BackgroundFadeSkin;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.toolkits.PriceToolkit;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.DiscountTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.DiscountTypeComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductCustomerDiscountsComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductCustomerPriceComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductCustomerTaxRatesComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.dtos.product.TaxRateComplete;
import ch.icit.pegasus.server.core.dtos.product.TaxRateComplete_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.StringUtil;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class TaxDetailsPanel
extends StateDependantDetailsPanel<ProductComplete>
implements NodeListener,
ButtonListener {
    private static final long serialVersionUID = 1L;
    private BackgroundFadeSkin bSkin = SkinRegistry.getSkin(BackgroundFadeSkin.class);
    private ReloadablePriceView totalTaxes;
    private ReloadablePriceView totalDiscount;
    private ReloadablePriceView calculatedProductPrice;
    private GroupedLoader loader;
    private SalePriceDetailsPanel netPricePanel;
    private Table2 taxesTable;
    private Table2 discountTable;
    private boolean addedToPrice = false;
    private TitledItem<EditButton> editPriceByCustomer = new TitledItem<EditButton>(new EditButton(), Words.CUSTOMER_PRICE, TitledItem.TitledItemOrientation.EAST);
    private TitledItem<EditButton> editCustomerDiscounts;
    private TitledItem<EditButton> editCustomerTaxRates;
    private TitledItem<RDCheckBox> strategy;
    private TitledItem<RDInputComboBox> userDefinedPriceInput;
    private TitledItem<RDTextField> priceComment;
    private int currentPriceState = 11;
    private boolean isCalculation;
    private boolean isTaxesDeletable;
    private boolean isTaxesWritable;
    private boolean isDiscountsDeletable;
    private boolean isDiscountsWritable;
    private Node<?> currentNode;

    public TaxDetailsPanel(RowEditor<ProductComplete> editor, RDProvider provider, LoadingGroup loader) {
        super(editor, provider);
        this.editPriceByCustomer.getElement().addButtonListener((source, x, y) -> this.showCustomerPricePopup(x, y));
        this.editCustomerDiscounts = new TitledItem<EditButton>(new EditButton(), Words.CUSTOMER_DISCOUNT, TitledItem.TitledItemOrientation.EAST);
        this.editCustomerDiscounts.getElement().addButtonListener((source, x, y) -> this.showCustomerDiscountPopup(x, y));
        this.editCustomerTaxRates = new TitledItem<EditButton>(new EditButton(), Words.CUSTOMER_TAX_RATE, TitledItem.TitledItemOrientation.EAST);
        this.editCustomerTaxRates.getElement().addButtonListener((source, x, y) -> this.showCustomerTaxRatePopup(x, y));
        this.loader = (GroupedLoader)loader;
        this.isTaxesDeletable = provider.isDeletable(ProductVariantComplete_.taxRates);
        this.isTaxesWritable = provider.isWritable(ProductVariantComplete_.taxRates);
        this.isDiscountsDeletable = provider.isDeletable(ProductVariantComplete_.discounts);
        this.isDiscountsWritable = provider.isWritable(ProductVariantComplete_.discounts);
        this.setTitleText(Words.TAXES);
        this.strategy = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.USE_A_FIXED_PRICE, TitledItem.TitledItemOrientation.EAST);
        this.userDefinedPriceInput = new TitledItem<RDInputComboBox>(new RDInputComboBox(provider, FormatterRegistry.getDecimalFormat(Words.EXTENDED_PRICE_PATTERN), InputComboBox.InputComboBoxType.PRICE_DOUBLE), "", TitledItem.TitledItemOrientation.WEST);
        this.userDefinedPriceInput.getElement().setMaxKommaStellen(CompanyUtil.isFPB((SystemSettingsComplete)this.settings) ? 6 : 3);
        this.createTaxTable(provider);
        if (Boolean.TRUE.equals(this.viewSettings.getShowProductPriceComment())) {
            this.priceComment = new TitledItem<RDTextField>(new RDTextField(provider), Words.PRICE_COMMENT, TitledItem.TitledItemOrientation.WEST);
            this.priceComment.setIgnorePrefWidth(true);
        }
        Font font = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("productoverview_pricetext_font_type"));
        this.totalDiscount = new ReloadablePriceView(loader, ConverterRegistry.getConverter(TotalDiscountConverter.class));
        this.totalDiscount.setFont(font);
        this.totalDiscount.setProgress(1.0f);
        this.createDiscountTable(provider);
        this.totalTaxes = new ReloadablePriceView(loader, ConverterRegistry.getConverter(TotalTaxesConverter.class));
        this.totalTaxes.setFont(font);
        this.totalTaxes.setProgress(1.0f);
        this.calculatedProductPrice = new ReloadablePriceView(loader, ConverterRegistry.getConverter(TotalSalesPriceConverter.class));
        this.calculatedProductPrice.setProgress(1.0f);
        this.calculatedProductPrice.setFont(font);
        this.loader.setTaxesPriceView(this.totalTaxes);
        this.loader.setTotalSalesPriceView(this.calculatedProductPrice);
        this.loader.setTotalDiscountPriceView(this.totalDiscount);
        this.setCustomLayouter(new Layout());
        this.strategy.getElement().addButtonListener(this);
        this.addToView(this.strategy);
        this.addToView(this.userDefinedPriceInput);
        if (this.priceComment != null) {
            this.addToView(this.priceComment);
        }
        this.addToView(this.discountTable);
        this.addToView(this.totalDiscount);
        this.addToView(this.taxesTable);
        this.addToView(this.totalTaxes);
        this.addToView(this.editPriceByCustomer);
        this.addToView(this.editCustomerDiscounts);
        this.addToView(this.editCustomerTaxRates);
        this.addToView(this.calculatedProductPrice);
    }

    private void updateCustomerPriceTitle() {
        Iterator it = this.node.getChildNamed(ProductVariantLight_.customerPrice).getFailSafeChildIterator();
        String t = Words.CUSTOMER_PRICE;
        String customerText = "";
        PriceConverter1 priceConverter = (PriceConverter1)ConverterRegistry.getConverter(PriceConverter1.class);
        while (it.hasNext()) {
            Node node = (Node)it.next();
            CustomerLight customer = (CustomerLight)node.getChildNamed(ProductCustomerPriceComplete_.customer).getValue();
            Node price = node.getChildNamed(ProductCustomerPriceComplete_.price);
            if (customer != null) {
                customerText = customerText + customer.getCode();
            }
            customerText = customerText + ": " + priceConverter.convert((PriceComplete)price.getValue(), price, new Object[0]) + ", ";
        }
        if (!StringUtil.isBlank((String)customerText)) {
            customerText = customerText.substring(0, customerText.length() - 2);
            t = t + " (" + customerText + ")";
        }
        this.editPriceByCustomer.setTitleText(t);
    }

    private void updateCustomerDiscountTitle() {
        Iterator it = this.node.getChildNamed(ProductVariantComplete_.customerDiscounts).getFailSafeChildIterator();
        String t = Words.CUSTOMER_DISCOUNT;
        String customerText = "";
        while (it.hasNext()) {
            Node node = (Node)it.next();
            CustomerLight customer = (CustomerLight)node.getChildNamed(ProductCustomerDiscountsComplete_.customer).getValue();
            Node discount = node.getChildNamed(ProductCustomerDiscountsComplete_.discount);
            if (discount.getValue() == null || customer == null) continue;
            customerText = customerText + customer.getCode() + ": " + ((DiscountTypeComplete)discount.getValue()).getName() + " " + ((DiscountTypeComplete)discount.getValue()).getRate() + "%, ";
        }
        if (!StringUtil.isBlank((String)customerText)) {
            customerText = customerText.substring(0, customerText.length() - 2);
            t = t + " (" + customerText + ")";
        }
        this.editCustomerDiscounts.setTitleText(t);
    }

    private void updateCustomerTaxTitle() {
        Iterator it = this.node.getChildNamed(ProductVariantComplete_.customerTaxRates).getFailSafeChildIterator();
        String t = Words.CUSTOMER_TAX_RATE;
        String customerText = "";
        while (it.hasNext()) {
            Node node = (Node)it.next();
            CustomerLight customer = (CustomerLight)node.getChildNamed(ProductCustomerTaxRatesComplete_.customer).getValue();
            Node taxRate = node.getChildNamed(ProductCustomerTaxRatesComplete_.taxRate);
            customerText = customer != null ? customerText + customer.getCode() : customerText + "no customer set";
            if (taxRate.getValue() != null) {
                customerText = customerText + ": " + ((TaxRateComplete)taxRate.getValue()).getName() + " " + ((TaxRateComplete)taxRate.getValue()).getRate() + "%, ";
                continue;
            }
            customerText = customerText + ": no tax rate set, ";
        }
        if (!StringUtil.isBlank((String)customerText)) {
            customerText = customerText.substring(0, customerText.length() - 2);
            t = t + " (" + customerText + ")";
        }
        this.editCustomerTaxRates.setTitleText(t);
    }

    private void showCustomerPricePopup(int x, int y) {
        InnerPopUp2 popup = InnerPopUp2.getInnerPopUp(PopupType.NORMAL);
        popup.setAttributes(this, true, true, Words.CUSTOMER_PRICE);
        popup.setView(new ProductCustomerPricePopupInsert(this.currentNode));
        popup.showPopUp(x, y, 600, 400, (source, xargs) -> this.updateCustomerPriceTitle(), this);
    }

    private void showCustomerDiscountPopup(int x, int y) {
        InnerPopUp2 popup = InnerPopUp2.getInnerPopUp(PopupType.NORMAL);
        popup.setAttributes(this, true, true, Words.CUSTOMER_DISCOUNT);
        popup.setView(new ProductCustomerDiscountPopupInsert(this.currentNode));
        popup.showPopUp(x, y, 600, 400, (source, xargs) -> this.updateCustomerDiscountTitle(), this);
    }

    private void showCustomerTaxRatePopup(int x, int y) {
        InnerPopUp2 popup = InnerPopUp2.getInnerPopUp(PopupType.NORMAL);
        popup.setAttributes(this, true, true, Words.CUSTOMER_TAX_RATE);
        popup.setView(new ProductCustomerTaxRatesPopupInsert(this.currentNode));
        popup.showPopUp(x, y, 600, 400, (source, xargs) -> this.updateCustomerTaxTitle(), this);
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return ProductVariantLight_.state;
    }

    private void createDiscountTable(RDProvider provider) {
        this.discountTable = new Table2(true, Words.ADD);
        this.discountTable.setProvider(provider);
        this.discountTable.setDontUseScrollBar(15);
        this.discountTable.setTableBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
        this.discountTable.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                TaxDetailsPanel.this.discountTable.enableAddButton(TaxDetailsPanel.this.hasFreeDiscountTypes());
                TaxDetailsPanel.this.totalDiscount.load(true);
                TaxDetailsPanel.this.editor.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                DiscountTypeComplete p = TaxDetailsPanel.this.getFreeDiscountType();
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, true, true);
                TaxDetailsPanel.this.discountTable.getModel().getNode().addChild(n, System.currentTimeMillis());
                TaxDetailsPanel.this.discountTable.enableAddButton(TaxDetailsPanel.this.hasFreeDiscountTypes());
                TaxDetailsPanel.this.editor.revalidate();
            }
        });
        ArrayList<TableColumnInfo> columns2 = new ArrayList<TableColumnInfo>();
        columns2.add(new TableColumnInfo(Words.DISCOUNT, null, null, null, "", 30, 30, 30));
        columns2.add(new TableColumnInfo(Words.COST, null, null, null, "", 30, 30, 30));
        int dw2 = this.discountTable.getCellPadding() * 2 + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns2.add(new TableColumnInfo("", null, null, null, "", dw2, dw2, dw2));
        ((TableColumnInfo)columns2.get(0)).setxExpand(0.7);
        ((TableColumnInfo)columns2.get(1)).setxExpand(0.3);
        ((TableColumnInfo)columns2.get(2)).setxExpand(0.0);
        this.discountTable.setModel(new Table2Model(columns2, model -> new DiscountTableRowImpl(model)));
    }

    private void createTaxTable(RDProvider provider) {
        this.taxesTable = new Table2(true, Words.ADD);
        this.taxesTable.setProvider(provider);
        this.taxesTable.setDontUseScrollBar(15);
        this.taxesTable.setTableBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
        this.taxesTable.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                TaxDetailsPanel.this.taxesTable.enableAddButton(TaxDetailsPanel.this.hasFreeTaxRates());
                TaxDetailsPanel.this.totalTaxes.load(true);
                TaxDetailsPanel.this.editor.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                TaxRateComplete p = TaxDetailsPanel.this.getFreeTaxRate();
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, true, true);
                TaxDetailsPanel.this.taxesTable.getModel().getNode().addChild(n, System.currentTimeMillis());
                TaxDetailsPanel.this.taxesTable.enableAddButton(TaxDetailsPanel.this.hasFreeTaxRates());
                TaxDetailsPanel.this.editor.revalidate();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.TAX_TYPE, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.VALUE, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.COST, null, null, null, "", 30, 30, 30));
        int dw = this.taxesTable.getCellPadding() * 2 + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", dw, dw, dw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.25);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.25);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        this.taxesTable.setModel(new Table2Model(columns, model -> new TaxTableRowImpl(model)));
    }

    public void setNetPricePanel(SalePriceDetailsPanel p) {
        this.netPricePanel = p;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.currentNode = node;
        node.getChildNamed(ProductVariantComplete_.salesPrice).removeNodeListener((NodeListener)this);
        if (this.addedToPrice && node.getChildNamed(new DtoField[]{ProductVariantComplete_.salesPrice, PriceComplete_.price}) != null) {
            node.getChildNamed(new DtoField[]{ProductVariantComplete_.salesPrice, PriceComplete_.price}).removeNodeListener((NodeListener)this);
        }
        this.calculatedProductPrice.setCommitInto(null);
        if (node.getChildNamed(ProductVariantComplete_.salesPrice).getValue() == null) {
            node.getChildNamed(ProductVariantComplete_.salesPrice).setValue((Object)new PriceComplete(null, Double.valueOf(0.0)), 0L);
        }
        if (node.getChildNamed(new DtoField[]{ProductVariantComplete_.salesPrice, PriceComplete_.currency}).getValue() == null) {
            Node<?> n = node;
            n.getChildNamed(new DtoField[]{ProductVariantComplete_.salesPrice, PriceComplete_.currency}).setValue((Object)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency(), 0L);
        }
        if (this.priceComment != null) {
            this.priceComment.getElement().setNode(node.getChildNamed(ProductVariantComplete_.priceComment));
        }
        node.getChildNamed(ProductVariantComplete_.salesPrice).addNodeListener((NodeListener)this);
        if (node.getChildNamed(new DtoField[]{ProductVariantComplete_.salesPrice, PriceComplete_.price}) != null) {
            node.getChildNamed(new DtoField[]{ProductVariantComplete_.salesPrice, PriceComplete_.price}).addNodeListener((NodeListener)this);
            this.addedToPrice = true;
        }
        this.userDefinedPriceInput.getElement().setNode(node.getChildNamed(ProductVariantComplete_.salesPrice));
        this.strategy.getElement().setNode(node.getChildNamed(ProductVariantComplete_.fixedPrice));
        this.loadIsCalculationState();
        this.setTotalTaxesAlgorithm();
        this.setTotalSalePriceAlgorithm();
        this.setTotalDiscountAlgorithm();
        this.taxesTable.getModel().setNode(node.getChildNamed(ProductVariantComplete_.taxRates));
        this.taxesTable.enableAddButton(this.hasFreeTaxRates());
        this.discountTable.getModel().setNode(node.getChildNamed(ProductVariantComplete_.discounts));
        this.discountTable.enableAddButton(this.hasFreeDiscountTypes());
        if (node.getChildNamed(ProductVariantComplete_.fixedPrice).getValue() == null || !((Boolean)node.getChildNamed(ProductVariantComplete_.fixedPrice).getValue()).booleanValue()) {
            this.calculatedProductPrice.setCommitInto(node.getChildNamed(ProductVariantComplete_.salesPrice));
        } else {
            this.calculatedProductPrice.setCommitInto(null);
        }
        this.totalTaxes.load(true);
        this.totalDiscount.load(true);
        this.calculatedProductPrice.load(true);
        this.ensureCurrentPriceState();
        this.setEnabled(this.isEnabled());
        this.updateCustomerPriceTitle();
        this.updateCustomerDiscountTitle();
        this.updateCustomerTaxTitle();
    }

    private void loadIsCalculationState() {
        this.isCalculation = false;
        if (this.node != null && this.node.getChildNamed(ProductVariantComplete_.fixedPrice) != null && this.node.getChildNamed(ProductVariantComplete_.fixedPrice).getValue() != null) {
            boolean bl = this.isCalculation = (Boolean)this.node.getChildNamed(ProductVariantComplete_.fixedPrice).getValue() == false;
        }
        if (this.isCalculation) {
            this.userDefinedPriceInput.setEnabled(true);
        } else {
            this.userDefinedPriceInput.setEnabled(false);
        }
    }

    private void ensureCurrentPriceState() {
        if (this.isCalculation) {
            int newState = 11;
            if (newState != this.currentPriceState) {
                this.currentPriceState = newState;
                this.repaint(32L);
            }
        } else if (this.userDefinedPriceInput != null && this.userDefinedPriceInput.getElement().getValueNode() != null && this.userDefinedPriceInput.getElement().getValueNode().getValue() != null) {
            Double d = (Double)this.userDefinedPriceInput.getElement().getValueNode().getValue();
            if (this.calculatedProductPrice.getNode() != null && this.calculatedProductPrice.getNode().getValue() != null) {
                Double p = ((PriceComplete)this.calculatedProductPrice.getNode().getValue()).getPrice();
                if (p > d) {
                    int newState = 5;
                    if (newState != this.currentPriceState) {
                        this.currentPriceState = newState;
                        this.repaint(32L);
                    }
                } else {
                    int newState = 3;
                    if (newState != this.currentPriceState) {
                        this.currentPriceState = newState;
                        this.repaint(32L);
                    }
                }
            }
        }
    }

    private boolean hasFreeTaxRates() {
        Node n = NodeToolkit.getAffixList(TaxRateComplete.class);
        return n.getChildCount() != this.taxesTable.getRowCount();
    }

    private boolean hasFreeDiscountTypes() {
        Node n = NodeToolkit.getAffixList(DiscountTypeComplete.class);
        return n.getChildCount() != this.discountTable.getRowCount();
    }

    private TaxRateComplete getFreeTaxRate() {
        Node n = NodeToolkit.getAffixList(TaxRateComplete.class);
        Iterator it = n.getChilds();
        while (it.hasNext()) {
            Node nn = (Node)it.next();
            Iterator<Table2RowPanel> it2 = this.taxesTable.getRows().iterator();
            boolean found = false;
            while (it2.hasNext() && !found) {
                Node nnn = it2.next().getModel().getNode();
                if (!((TaxRateComplete)nn.getValue()).equals(nnn.getValue())) continue;
                found = true;
            }
            if (found) continue;
            return (TaxRateComplete)nn.getValue();
        }
        return null;
    }

    private DiscountTypeComplete getFreeDiscountType() {
        Node n = NodeToolkit.getAffixList(DiscountTypeComplete.class);
        Iterator it = n.getChilds();
        while (it.hasNext()) {
            Node nn = (Node)it.next();
            Iterator<Table2RowPanel> it2 = this.discountTable.getRows().iterator();
            boolean found = false;
            while (it2.hasNext() && !found) {
                Node nnn = it2.next().getModel().getNode();
                if (!((DiscountTypeComplete)nn.getValue()).equals(nnn.getValue())) continue;
                found = true;
            }
            if (found) continue;
            return (DiscountTypeComplete)nn.getValue();
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.hasBackground) {
            g2.setColor(this.innerBackground);
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.arcW, this.arcH);
        }
        if (this.hasSkin) {
            this.skin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
        }
        if (this.useCliping) {
            g2.clip(this.getClipingArea());
        }
        int buttonSkinHeight = this.bSkin.getImage(11).getHeight();
        this.bSkin.paint(g2, 0, this.getHeight() - buttonSkinHeight, this.getWidth(), 11);
        int h = this.discountTable.getY() + this.discountTable.getHeight();
        h -= buttonSkinHeight;
        this.bSkin.paint(g2, 0, (int)((double)this.getHeight() - ((double)buttonSkinHeight + this.taxesTable.getPreferredSize().getHeight() + (double)buttonSkinHeight)), this.getWidth(), 11);
        this.bSkin.paint(g2, 0, this.getTitleHeight(), this.getWidth(), this.currentPriceState);
        this.paintChildren(g2);
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.node != null && this.node.getChildNamed(ProductVariantComplete_.salesPrice) != null) {
            this.node.getChildNamed(ProductVariantComplete_.salesPrice).removeNodeListener((NodeListener)this);
        }
        if (this.addedToPrice && this.node != null && this.node.getChildNamed(ProductVariantComplete_.salesPrice) != null && this.node.getChildNamed(new DtoField[]{ProductVariantComplete_.salesPrice, PriceComplete_.price}) != null) {
            this.node.getChildNamed(new DtoField[]{ProductVariantComplete_.salesPrice, PriceComplete_.price}).removeNodeListener((NodeListener)this);
        }
        if (this.node != null && this.node.getChildNamed(ProductVariantComplete_.state) != null) {
            this.node.getChildNamed(ProductVariantComplete_.state).removeNodeListener((NodeListener)this);
        }
        this.loader.setTaxesPriceView(null);
        this.loader.setTotalSalesPriceView(null);
        this.editPriceByCustomer.kill();
        this.editPriceByCustomer = null;
        this.editCustomerDiscounts.kill();
        this.editCustomerDiscounts = null;
        this.editCustomerTaxRates.kill();
        this.editCustomerTaxRates = null;
        this.discountTable.kill();
        this.discountTable = null;
        this.taxesTable.kill();
        this.taxesTable = null;
        if (this.priceComment != null) {
            this.priceComment.kill();
        }
        this.priceComment = null;
        this.calculatedProductPrice.kill();
        this.calculatedProductPrice = null;
        this.totalTaxes.kill();
        this.totalTaxes = null;
    }

    private void setTotalSalePriceAlgorithm() {
        if (this.calculatedProductPrice != null) {
            CalculationRunnable run = new CalculationRunnable(){

                @Override
                public void run() {
                    Node pn;
                    Double fact;
                    if (TaxDetailsPanel.this.totalTaxes == null || TaxDetailsPanel.this.totalTaxes.getNode() == null || TaxDetailsPanel.this.totalTaxes.getNode().getValue() == null || TaxDetailsPanel.this.calculatedProductPrice == null || !TaxDetailsPanel.this.isEnabled()) {
                        return;
                    }
                    PriceComplete p1 = TaxDetailsPanel.this.netPricePanel.getNettoPrice();
                    PriceComplete p3 = new PriceComplete();
                    p3.setPrice(Double.valueOf(0.0));
                    if (p1 != null) {
                        p3.setCurrency(p1.getCurrency());
                        p3.setPrice(Double.valueOf(p1.getPrice() + p3.getPrice()));
                    }
                    p3.setPrice(PriceToolkit.convertPrice(p3.getPrice()));
                    SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                    if (p3.getCurrency() == null) {
                        p3.setCurrency(settings.getCurrency());
                    }
                    if ((fact = settings.getProductSalesPriceFactor()) != null) {
                        double d = p3.getPrice();
                        p3.setPrice(Double.valueOf(d *= fact.doubleValue()));
                    }
                    if ((pn = TaxDetailsPanel.this.calculatedProductPrice.getNode()) == null) {
                        pn = new EmbeddedDTONode();
                        TaxDetailsPanel.this.calculatedProductPrice.setNode(pn);
                    }
                    pn.setValue((Object)p3, 0L);
                    TaxDetailsPanel.this.ensureCurrentPriceState();
                }

                @Override
                public boolean isAlive() {
                    if (TaxDetailsPanel.this.calculatedProductPrice != null) {
                        return !TaxDetailsPanel.this.calculatedProductPrice.isKilled();
                    }
                    return false;
                }
            };
            this.calculatedProductPrice.setRunnable(run);
        }
    }

    private void setTotalTaxesAlgorithm() {
        if (this.totalTaxes != null) {
            CalculationRunnable run = new CalculationRunnable(){

                @Override
                public void run() {
                    Node pn;
                    Iterator it;
                    if (TaxDetailsPanel.this.netPricePanel == null || !TaxDetailsPanel.this.isEnabled()) {
                        return;
                    }
                    PriceComplete p1 = TaxDetailsPanel.this.netPricePanel.getNettoPrice();
                    PriceComplete p3 = new PriceComplete();
                    if (((RDCheckBox)TaxDetailsPanel.this.strategy.getElement()).isChecked()) {
                        p1 = new PriceComplete();
                        p1.setPrice((Double)((RDInputComboBox)TaxDetailsPanel.this.userDefinedPriceInput.getElement()).getValueNode().getValue());
                        p1.setCurrency((CurrencyComplete)((RDInputComboBox)TaxDetailsPanel.this.userDefinedPriceInput.getElement()).getUnitNode().getValue());
                    } else if (TaxDetailsPanel.this.calculatedProductPrice.getNode() != null) {
                        p1 = (PriceComplete)TaxDetailsPanel.this.calculatedProductPrice.getNode().getValue();
                    }
                    if (TaxDetailsPanel.this.totalDiscount != null && TaxDetailsPanel.this.totalDiscount.getNode() != null) {
                        PriceComplete discountPrice = (PriceComplete)TaxDetailsPanel.this.totalDiscount.getNode().getValue();
                        if (discountPrice != null && discountPrice.getPrice() != null) {
                            p1 = new PriceComplete(p1);
                            p1.setPrice(Double.valueOf(p1.getPrice() - discountPrice.getPrice()));
                        }
                    } else if (TaxDetailsPanel.this.node != null) {
                        Node n = TaxDetailsPanel.this.node;
                        it = n.getChildNamed(ProductVariantComplete_.discounts).getFailSafeChildIterator();
                        double factor = 0.0;
                        while (it.hasNext()) {
                            Node d = (Node)it.next();
                            factor += ((DiscountTypeComplete)d.getValue()).getRate().doubleValue();
                        }
                        double p = (Double)TaxDetailsPanel.this.node.getChildNamed(new DtoField[]{ProductVariantLight_.salesPrice, PriceComplete_.price}).getValue();
                        double d = p * (factor / 100.0);
                        p1 = new PriceComplete((CurrencyComplete)TaxDetailsPanel.this.node.getChildNamed(new DtoField[]{ProductVariantLight_.salesPrice, PriceComplete_.currency}).getValue(), Double.valueOf(p - d));
                    }
                    if (p1 != null) {
                        Node list;
                        p3.setCurrency(p1.getCurrency());
                        p3.setPrice(p1.getPrice());
                        if (TaxDetailsPanel.this.node != null && (list = TaxDetailsPanel.this.node.getChildNamed(ProductVariantComplete_.taxRates)) != null) {
                            it = list.getChilds();
                            double additional = 0.0;
                            while (it.hasNext()) {
                                Node nn = (Node)it.next();
                                double d = (Double)nn.getChildNamed(TaxRateComplete_.rate).getValue();
                                d *= p1.getPrice().doubleValue();
                                additional += (d /= 100.0);
                            }
                            p3.setPrice(Double.valueOf(additional));
                        }
                    } else {
                        p3.setPrice(Double.valueOf(0.0));
                        if (p3.getCurrency() == null) {
                            p3.setCurrency(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency());
                        }
                    }
                    if ((pn = TaxDetailsPanel.this.totalTaxes.getNode()) == null) {
                        pn = new EmbeddedDTONode();
                        TaxDetailsPanel.this.totalTaxes.setNode(pn);
                    }
                    pn.setValue((Object)p3, 0L);
                }

                @Override
                public boolean isAlive() {
                    if (TaxDetailsPanel.this.totalTaxes != null) {
                        return !TaxDetailsPanel.this.totalTaxes.isKilled();
                    }
                    return false;
                }
            };
            this.totalTaxes.setRunnable(run);
        }
    }

    private void setTotalDiscountAlgorithm() {
        if (this.totalDiscount != null) {
            CalculationRunnable run = new CalculationRunnable(){

                @Override
                public void run() {
                    if (TaxDetailsPanel.this.netPricePanel == null || !TaxDetailsPanel.this.isEnabled()) {
                        return;
                    }
                    PriceComplete p1 = TaxDetailsPanel.this.netPricePanel.getNettoPrice();
                    PriceComplete p3 = new PriceComplete();
                    if (((RDCheckBox)TaxDetailsPanel.this.strategy.getElement()).isChecked()) {
                        p1 = new PriceComplete();
                        p1.setPrice((Double)((RDInputComboBox)TaxDetailsPanel.this.userDefinedPriceInput.getElement()).getValueNode().getValue());
                        p1.setCurrency((CurrencyComplete)((RDInputComboBox)TaxDetailsPanel.this.userDefinedPriceInput.getElement()).getUnitNode().getValue());
                    } else if (TaxDetailsPanel.this.calculatedProductPrice != null && TaxDetailsPanel.this.calculatedProductPrice.getNode() != null) {
                        p1 = (PriceComplete)TaxDetailsPanel.this.calculatedProductPrice.getNode().getValue();
                    }
                    if (p1 != null) {
                        p3.setCurrency(p1.getCurrency());
                        p3.setPrice(p1.getPrice());
                        Node list = TaxDetailsPanel.this.node.getChildNamed(ProductVariantComplete_.discounts);
                        double additional = 0.0;
                        if (list != null) {
                            Iterator it = list.getChilds();
                            while (it.hasNext()) {
                                Node nn = (Node)it.next();
                                if (nn.getChildNamed(DiscountTypeComplete_.rate) == null) continue;
                                double d = (Double)nn.getChildNamed(DiscountTypeComplete_.rate).getValue();
                                d *= p1.getPrice().doubleValue();
                                additional += (d /= 100.0);
                            }
                        }
                        p3.setPrice(Double.valueOf(additional));
                    } else {
                        p3.setPrice(Double.valueOf(0.0));
                        if (p3.getCurrency() == null) {
                            p3.setCurrency(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency());
                        }
                    }
                    Node pn = TaxDetailsPanel.this.totalDiscount.getNode();
                    if (pn == null) {
                        pn = new EmbeddedDTONode();
                        TaxDetailsPanel.this.totalDiscount.setNode(pn);
                    }
                    pn.setValue((Object)p3, 0L);
                }

                @Override
                public boolean isAlive() {
                    if (TaxDetailsPanel.this.totalDiscount != null) {
                        return !TaxDetailsPanel.this.totalDiscount.isKilled();
                    }
                    return false;
                }
            };
            this.totalDiscount.setRunnable(run);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.strategy);
        if (this.strategy != null && this.strategy.getElement().isChecked()) {
            CheckedListAdder.addToList(focusList, this.userDefinedPriceInput);
        }
        CheckedListAdder.addToList(focusList, this.priceComment);
        CheckedListAdder.addToList(focusList, this.editPriceByCustomer);
        CheckedListAdder.addToList(focusList, this.editCustomerDiscounts);
        CheckedListAdder.addToList(focusList, this.editCustomerTaxRates);
        CheckedListAdder.addToList(focusList, this.discountTable);
        CheckedListAdder.addToList(focusList, this.taxesTable);
        return focusList;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isDraft = this.isStateDraft();
        boolean enabled = isEnabled && isDraft;
        super.setEnabled(enabled);
        this.discountTable.setEnabled(isEnabled);
        if (isEnabled) {
            this.discountTable.setEditable(enabled);
        }
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        boolean autoTax = Boolean.TRUE.equals(settings.getRetailAutoTax());
        boolean canEditPriceForCustomer = this.provider.isWritable(ProductVariantLight_.customerPrice);
        boolean canEditDiscountForCustomer = this.provider.isWritable(ProductVariantComplete_.customerDiscounts);
        boolean canEditTaxRateForCustomer = this.provider.isWritable(ProductVariantComplete_.customerTaxRates);
        this.editPriceByCustomer.setEnabled(enabled && canEditPriceForCustomer);
        this.editCustomerDiscounts.setEnabled(enabled && canEditDiscountForCustomer);
        this.editCustomerTaxRates.setEnabled(enabled && canEditTaxRateForCustomer && !autoTax);
        this.totalDiscount.setEnabled(enabled);
        this.taxesTable.setEnabled(isEnabled && !autoTax);
        if (isEnabled && !autoTax) {
            this.taxesTable.setEditable(enabled);
        }
        if (this.priceComment != null) {
            this.priceComment.setEnabled(enabled);
        }
        this.calculatedProductPrice.setEnabled(enabled);
        this.totalTaxes.setEnabled(enabled);
        this.strategy.setEnabled(enabled);
        this.userDefinedPriceInput.setEnabled(!this.isCalculation && enabled);
    }

    @Override
    public void childAdded(Node<?> source, Node<?> child) {
        if (!this.addedToPrice && child.getName().equals(PriceComplete_.price.getFieldName())) {
            child.addNodeListener((NodeListener)this);
            this.addedToPrice = true;
        }
    }

    @Override
    public void childRemoved(Node<?> source, Node<?> child) {
    }

    @Override
    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public void valueChanged(Node<?> node) {
        if (node.getName().equals(ProductVariantComplete_.state.getFieldName())) {
            this.loadIsCalculationState();
            this.setEnabled(this.isEnabled());
        } else {
            this.ensureCurrentPriceState();
            this.loader.updateMe(this.totalTaxes);
        }
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> l = new ArrayList<ScreenValidationObject>();
        if (this.node == null || this.node.getChildNamed(ProductVariantComplete_.state).getValue() == null) {
            return l;
        }
        if (this.node.getChildNamed(ProductVariantComplete_.state).getValue() == ModificationStateE.ACCEPTED && this.strategy.getElement().isWritable() && !this.strategy.getElement().isChecked()) {
            l.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, Words.SALES_PRICE_IS_NOT_SET));
        }
        boolean vatFound = false;
        Node n = this.node;
        Iterator it = n.getChildNamed(ProductVariantComplete_.taxRates).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node tr = (Node)it.next();
            if (((TaxRateComplete)tr.getValue()).getIsVATTaxRate().booleanValue() && vatFound) {
                l.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.MULTIPLE_TAXES_MARKED_AS_VAT_ARE_SELECTED));
            }
            if (!((TaxRateComplete)tr.getValue()).getIsVATTaxRate().booleanValue()) continue;
            vatFound = true;
        }
        Iterator it2 = n.getChildNamed(ProductVariantComplete_.discounts).getFailSafeChildIterator();
        ArrayList<Object> discounts = new ArrayList<Object>();
        while (it2.hasNext()) {
            Node tr = (Node)it2.next();
            if (discounts.contains(tr.getValue())) {
                l.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.DISCOUNT_HAS_MULTIPLE_ENTRIES_WITH_SAME_TYPE));
                return l;
            }
            discounts.add(tr.getValue());
        }
        HashSet<CustomerLight> customerSet = new HashSet<CustomerLight>();
        customerSet.add((CustomerLight)this.editor.getModel().getNode().getChildNamed(ProductComplete_.customer).getValue());
        Iterator it3 = this.currentNode.getChildNamed(ProductVariantLight_.customerPrice).getFailSafeChildIterator();
        while (it3.hasNext()) {
            Node price = (Node)it3.next();
            CustomerLight selectedCustomer = (CustomerLight)price.getChildNamed(ProductCustomerPriceComplete_.customer).getValue();
            if (selectedCustomer == null) {
                l.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_EVERY_CUSTOMER_PRICE_HAS_A_CUSTOMER));
                continue;
            }
            if (customerSet.contains(selectedCustomer)) {
                l.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ENSURE_PRICE_FOR_CUSTOMER_IS_ONLY_DEFINED_ONCE, (Object[])new Object[]{selectedCustomer.getCode()})));
                continue;
            }
            customerSet.add(selectedCustomer);
        }
        return l;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
        this.taxesTable.getModel().addFocusCycleChangeListener(listener);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (!this.strategy.getElement().isChecked()) {
            this.userDefinedPriceInput.setEnabled(false);
            this.calculatedProductPrice.setCommitInto(null);
            this.isCalculation = true;
            this.currentPriceState = 11;
            this.ensureCurrentPriceState();
            this.loader.updateMe(this.totalTaxes);
            this.loader.updateMe(this.totalDiscount);
            this.repaint(32L);
        } else {
            this.userDefinedPriceInput.setEnabled(true);
            Node n = this.node;
            PriceComplete p = new PriceComplete();
            p.setPrice(Double.valueOf(0.0));
            p.setCurrency(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency());
            n.getChildNamed(ProductVariantComplete_.salesPrice).setValue((Object)p, 0L);
            this.calculatedProductPrice.setCommitInto(n.getChildNamed(ProductVariantComplete_.salesPrice));
            this.isCalculation = false;
            this.ensureCurrentPriceState();
            this.loader.updateMe(this.totalTaxes);
            this.loader.updateMe(this.totalDiscount);
        }
        this.editor.createFocusCycle();
    }

    @Override
    public boolean isSwingOnly() {
        return true;
    }

    private class DiscountTableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private ComboBox discountType;
        private ReloadablePriceView discountValue;
        private DeleteButton deleteButton;

        public DiscountTableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new InnerLayout());
            this.discountType = new ComboBox(m.getNode(), NodeToolkit.getAffixList(DiscountTypeComplete.class), ConverterRegistry.getConverter(DiscountTypeConverter.class));
            this.discountValue = new ReloadablePriceView((LoadingGroup)TaxDetailsPanel.this.loader, ConverterRegistry.getConverter(PriceConverter1.class));
            m.getNode().addNodeListener((NodeListener)this);
            if (TaxDetailsPanel.this.isDiscountsDeletable) {
                this.deleteButton = new DeleteButton();
                this.deleteButton.addButtonListener(this);
                this.deleteButton.setProgress(1.0f);
                this.add(this.deleteButton);
            }
            TaxDetailsPanel.this.loader.addDiscountCost(this.discountValue);
            this.discountValue.load(true);
            this.add(this.discountType);
            this.add(this.discountValue);
            this.setDiscountCostAlgorithm();
            this.discountType.setProgress(1.0f);
            this.discountValue.setProgress(1.0f);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.discountType.getStringValue();
                }
                case 1: {
                    return this.discountValue.getText();
                }
            }
            return null;
        }

        private void setDiscountCostAlgorithm() {
            if (this.discountValue != null) {
                CalculationRunnable run = new CalculationRunnable(){

                    @Override
                    public void run() {
                        if (TaxDetailsPanel.this.netPricePanel == null || !DiscountTableRowImpl.this.isEnabled()) {
                            return;
                        }
                        PriceComplete p1 = TaxDetailsPanel.this.netPricePanel.getNettoPrice();
                        if (((RDCheckBox)TaxDetailsPanel.this.strategy.getElement()).isChecked()) {
                            p1 = new PriceComplete();
                            p1.setPrice((Double)((RDInputComboBox)TaxDetailsPanel.this.userDefinedPriceInput.getElement()).getValueNode().getValue());
                            p1.setCurrency((CurrencyComplete)((RDInputComboBox)TaxDetailsPanel.this.userDefinedPriceInput.getElement()).getUnitNode().getValue());
                        }
                        if (p1 != null) {
                            PriceComplete p3 = new PriceComplete();
                            p3.setClientOId(Long.valueOf(p3.getNextId()));
                            p3.setCurrency(p1.getCurrency());
                            p3.setPrice(p1.getPrice());
                            if (DiscountTableRowImpl.this.model.getNode().getChildNamed(DiscountTypeComplete_.rate) != null) {
                                Double d = (Double)DiscountTableRowImpl.this.model.getNode().getChildNamed(DiscountTypeComplete_.rate).getValue();
                                d = d / 100.0;
                                p3.setPrice(Double.valueOf(p3.getPrice() * d));
                                p3.setPrice(PriceToolkit.ensureDoubleFinite(p3.getPrice()));
                                Node pn = DiscountTableRowImpl.this.discountValue.getNode();
                                if (pn == null) {
                                    pn = new EmbeddedDTONode();
                                    DiscountTableRowImpl.this.discountValue.setNode(pn);
                                }
                                if (pn.getChildNamed(PriceComplete_.price) == null) {
                                    Node pp = new Node();
                                    pp.setName(PriceComplete_.price);
                                    pn.addChild(pp, 0L);
                                }
                                pn.getChildNamed(new String[]{"price"}).setValue((Object)p3.getPrice(), 0L);
                                pn.setValue((Object)p3, 0L);
                            }
                        }
                    }

                    @Override
                    public boolean isAlive() {
                        if (DiscountTableRowImpl.this.discountValue != null) {
                            return !DiscountTableRowImpl.this.discountValue.isKilled();
                        }
                        return false;
                    }
                };
                this.discountValue.setRunnable(run);
            }
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.discountType.setEnabled(isEnabled && TaxDetailsPanel.this.isDiscountsWritable);
            this.discountValue.setEnabled(isEnabled);
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(isEnabled);
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            focusList.addAll(this.discountType.getFocusComponents());
            CheckedListAdder.addToList(focusList, this.deleteButton);
            return focusList;
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.discountType != null) {
                this.discountType.requestFocusInWindowNow();
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            TaxDetailsPanel.this.loader.removeDiscountCost(this.discountValue);
            this.model.getNode().removeNodeListener((NodeListener)this);
            this.discountType.kill();
            this.discountType = null;
            this.discountValue.kill();
            this.discountValue = null;
            if (this.deleteButton != null) {
                this.deleteButton.kill();
            }
            this.deleteButton = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public void valueChanged(Node<?> node) {
            this.discountValue.load(true);
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = DiscountTableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                DiscountTableRowImpl.this.discountType.setLocation(currentX + DiscountTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - DiscountTableRowImpl.this.discountType.getPreferredSize().getHeight()) / 2.0));
                DiscountTableRowImpl.this.discountType.setSize(w - 2 * DiscountTableRowImpl.this.getCellPadding(), (int)DiscountTableRowImpl.this.discountType.getPreferredSize().getHeight());
                currentX += w;
                w = DiscountTableRowImpl.this.model.getParentModel().getColumnWidth(1);
                DiscountTableRowImpl.this.discountValue.setLocation(currentX + DiscountTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - DiscountTableRowImpl.this.discountValue.getPreferredSize().getHeight()) / 2.0));
                DiscountTableRowImpl.this.discountValue.setSize(w - 2 * DiscountTableRowImpl.this.getCellPadding(), (int)DiscountTableRowImpl.this.discountValue.getPreferredSize().getHeight());
                currentX += w;
                w = DiscountTableRowImpl.this.model.getParentModel().getColumnWidth(2);
                if (DiscountTableRowImpl.this.deleteButton != null) {
                    DiscountTableRowImpl.this.deleteButton.setLocation(currentX + DiscountTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - DiscountTableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                    DiscountTableRowImpl.this.deleteButton.setSize(DiscountTableRowImpl.this.deleteButton.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, DiscountTableRowImpl.this.getDefaultRowHeight());
            }
        }
    }

    private class TaxTableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private ComboBox taxType;
        private TextLabel value;
        private ReloadablePriceView taxCost;
        private DeleteButton deleteButton;

        public TaxTableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new InnerLayout());
            this.taxType = new ComboBox(m.getNode(), NodeToolkit.getAffixList(TaxRateComplete.class), ConverterRegistry.getConverter(TaxRateConverter.class));
            this.value = new TextLabel(m.getNode().getChildNamed(TaxRateComplete_.rate), ConverterRegistry.getConverter(TaxAmountConverter.class));
            m.getNode().addNodeListener((NodeListener)this);
            this.taxCost = new ReloadablePriceView((LoadingGroup)TaxDetailsPanel.this.loader, ConverterRegistry.getConverter(PriceConverter1.class));
            if (TaxDetailsPanel.this.isTaxesDeletable) {
                this.deleteButton = new DeleteButton();
                this.deleteButton.addButtonListener(this);
                this.deleteButton.setProgress(1.0f);
                this.add(this.deleteButton);
            }
            TaxDetailsPanel.this.loader.addTaxCost(this.taxCost);
            this.setTaxCostAlgorithm();
            this.taxType.setProgress(1.0f);
            this.value.setProgress(1.0f);
            this.taxCost.setProgress(1.0f);
            this.add(this.taxType);
            this.add(this.value);
            this.add(this.taxCost);
            this.taxCost.load(true);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.taxType.getStringValue();
                }
                case 1: {
                    return this.value.getText();
                }
                case 2: {
                    return this.taxCost.getTextLabel().getText();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.taxType.setEnabled(isEnabled && TaxDetailsPanel.this.isTaxesWritable);
            this.value.setEnabled(isEnabled);
            this.taxCost.setEnabled(isEnabled);
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(isEnabled);
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            focusList.addAll(this.taxType.getFocusComponents());
            CheckedListAdder.addToList(focusList, this.deleteButton);
            return focusList;
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.taxType != null) {
                this.taxType.requestFocusInWindowNow();
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.model.getNode().removeNodeListener((NodeListener)this);
            TaxDetailsPanel.this.loader.removeTaxCost(this.taxCost);
            this.taxType.kill();
            this.taxType = null;
            this.value.kill();
            this.value = null;
            this.taxCost.kill();
            this.taxCost = null;
            if (this.deleteButton != null) {
                this.deleteButton.kill();
            }
            this.deleteButton = null;
        }

        private void setTaxCostAlgorithm() {
            if (this.taxCost != null) {
                CalculationRunnable run = new CalculationRunnable(){

                    @Override
                    public void run() {
                        try {
                            if (TaxDetailsPanel.this.netPricePanel == null || !TaxTableRowImpl.this.isEnabled()) {
                                return;
                            }
                            PriceComplete p1 = TaxDetailsPanel.this.netPricePanel.getNettoPrice();
                            if (((RDCheckBox)TaxDetailsPanel.this.strategy.getElement()).isChecked()) {
                                p1 = new PriceComplete();
                                p1.setPrice((Double)((RDInputComboBox)TaxDetailsPanel.this.userDefinedPriceInput.getElement()).getValueNode().getValue());
                                p1.setCurrency((CurrencyComplete)((RDInputComboBox)TaxDetailsPanel.this.userDefinedPriceInput.getElement()).getUnitNode().getValue());
                            }
                            if (TaxDetailsPanel.this.totalDiscount != null && TaxDetailsPanel.this.totalDiscount.getNode() != null) {
                                PriceComplete discountPrice = (PriceComplete)TaxDetailsPanel.this.totalDiscount.getNode().getValue();
                                if (discountPrice != null) {
                                    p1 = new PriceComplete(p1);
                                    p1.setPrice(Double.valueOf(p1.getPrice() - discountPrice.getPrice()));
                                }
                            } else if (TaxDetailsPanel.this.node != null) {
                                Node n = TaxDetailsPanel.this.node;
                                Iterator it = n.getChildNamed(ProductVariantComplete_.discounts).getFailSafeChildIterator();
                                double factor = 0.0;
                                while (it.hasNext()) {
                                    Node d = (Node)it.next();
                                    factor += ((DiscountTypeComplete)d.getValue()).getRate().doubleValue();
                                }
                                double p = (Double)TaxDetailsPanel.this.node.getChildNamed(new DtoField[]{ProductVariantLight_.salesPrice, PriceComplete_.price}).getValue();
                                double d = p * (factor / 100.0);
                                p1 = new PriceComplete((CurrencyComplete)TaxDetailsPanel.this.node.getChildNamed(new DtoField[]{ProductVariantLight_.salesPrice, PriceComplete_.currency}).getValue(), Double.valueOf(p - d));
                            }
                            if (p1 != null) {
                                PriceComplete p3 = new PriceComplete();
                                p3.setClientOId(Long.valueOf(p3.getNextId()));
                                p3.setCurrency(p1.getCurrency());
                                p3.setPrice(p1.getPrice());
                                Double d = (Double)TaxTableRowImpl.this.model.getNode().getChildNamed(TaxRateComplete_.rate).getValue();
                                d = d / 100.0;
                                p3.setPrice(Double.valueOf(p3.getPrice() * d));
                                p3.setPrice(PriceToolkit.ensureDoubleFinite(p3.getPrice()));
                                Node pn = TaxTableRowImpl.this.taxCost.getNode();
                                if (pn == null) {
                                    pn = new EmbeddedDTONode();
                                    TaxTableRowImpl.this.taxCost.setNode(pn);
                                }
                                if (pn.getChildNamed(PriceComplete_.price) == null) {
                                    Node pp = new Node();
                                    pp.setName(PriceComplete_.price);
                                    pn.addChild(pp, 0L);
                                }
                                pn.getChildNamed(new String[]{"price"}).setValue((Object)p3.getPrice(), 0L);
                                pn.setValue((Object)p3, 0L);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public boolean isAlive() {
                        if (TaxTableRowImpl.this.taxCost != null) {
                            return !TaxTableRowImpl.this.taxCost.isKilled();
                        }
                        return false;
                    }
                };
                this.taxCost.setRunnable(run);
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public void valueChanged(Node<?> node) {
            if (this.value != null) {
                this.value.setNode(this.model.getNode().getChildNamed(TaxRateComplete_.rate));
                this.taxCost.load(true);
            }
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TaxTableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TaxTableRowImpl.this.taxType.setLocation(currentX + TaxTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TaxTableRowImpl.this.taxType.getPreferredSize().getHeight()) / 2.0));
                TaxTableRowImpl.this.taxType.setSize(w - 2 * TaxTableRowImpl.this.getCellPadding(), (int)TaxTableRowImpl.this.taxType.getPreferredSize().getHeight());
                currentX += w;
                w = TaxTableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TaxTableRowImpl.this.value.setLocation(currentX + TaxTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TaxTableRowImpl.this.value.getPreferredSize().getHeight()) / 2.0));
                TaxTableRowImpl.this.value.setSize(w - 2 * TaxTableRowImpl.this.getCellPadding(), (int)TaxTableRowImpl.this.value.getPreferredSize().getHeight());
                currentX += w;
                w = TaxTableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TaxTableRowImpl.this.taxCost.setLocation(currentX + TaxTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TaxTableRowImpl.this.taxCost.getPreferredSize().getHeight()) / 2.0));
                TaxTableRowImpl.this.taxCost.setSize(w - 2 * TaxTableRowImpl.this.getCellPadding(), (int)TaxTableRowImpl.this.taxCost.getPreferredSize().getHeight());
                currentX += w;
                w = TaxTableRowImpl.this.model.getParentModel().getColumnWidth(3);
                if (TaxTableRowImpl.this.deleteButton != null) {
                    TaxTableRowImpl.this.deleteButton.setLocation(currentX + TaxTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TaxTableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                    TaxTableRowImpl.this.deleteButton.setSize(TaxTableRowImpl.this.deleteButton.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TaxTableRowImpl.this.getDefaultRowHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int buttonSkinHeight = TaxDetailsPanel.this.bSkin.getImage(11).getHeight();
            int bottomOffSet = (int)(((double)buttonSkinHeight - TaxDetailsPanel.this.calculatedProductPrice.getPreferredSize().getHeight()) / 2.0);
            int border = 7;
            TaxDetailsPanel.this.calculatedProductPrice.setLocation(TaxDetailsPanel.this.horizontalBorder, bottomOffSet);
            TaxDetailsPanel.this.calculatedProductPrice.setSize(parent.getWidth() - 2 * TaxDetailsPanel.this.horizontalBorder, (int)TaxDetailsPanel.this.calculatedProductPrice.getPreferredSize().getHeight());
            TaxDetailsPanel.this.strategy.setLocation(TaxDetailsPanel.this.discountTable.getCellPadding(), TaxDetailsPanel.this.calculatedProductPrice.getY() + TaxDetailsPanel.this.calculatedProductPrice.getHeight() + bottomOffSet + border + 3);
            TaxDetailsPanel.this.strategy.setSize(TaxDetailsPanel.this.strategy.getPreferredSize());
            TaxDetailsPanel.this.userDefinedPriceInput.setLocation(TaxDetailsPanel.this.strategy.getX() + TaxDetailsPanel.this.strategy.getWidth() + 10, TaxDetailsPanel.this.calculatedProductPrice.getY() + TaxDetailsPanel.this.calculatedProductPrice.getHeight() + bottomOffSet + border);
            TaxDetailsPanel.this.userDefinedPriceInput.setSize(130, (int)TaxDetailsPanel.this.userDefinedPriceInput.getPreferredSize().getHeight());
            if (TaxDetailsPanel.this.priceComment != null) {
                TaxDetailsPanel.this.priceComment.setLocation(TaxDetailsPanel.this.userDefinedPriceInput.getX() + TaxDetailsPanel.this.userDefinedPriceInput.getWidth() + 10, TaxDetailsPanel.this.userDefinedPriceInput.getY());
                TaxDetailsPanel.this.priceComment.setSize(parent.getWidth() - (TaxDetailsPanel.this.priceComment.getX() + TaxDetailsPanel.this.horizontalBorder), (int)TaxDetailsPanel.this.priceComment.getPreferredSize().getHeight());
            }
            TaxDetailsPanel.this.editPriceByCustomer.setLocation(TaxDetailsPanel.this.horizontalBorder, TaxDetailsPanel.this.userDefinedPriceInput.getY() + TaxDetailsPanel.this.userDefinedPriceInput.getHeight() + TaxDetailsPanel.this.inner_verticalBorder);
            TaxDetailsPanel.this.editPriceByCustomer.setSize(parent.getWidth() - 2 * TaxDetailsPanel.this.horizontalBorder, (int)TaxDetailsPanel.this.editPriceByCustomer.getPreferredSize().getHeight());
            TaxDetailsPanel.this.editCustomerDiscounts.setLocation(TaxDetailsPanel.this.horizontalBorder, TaxDetailsPanel.this.editPriceByCustomer.getY() + TaxDetailsPanel.this.editPriceByCustomer.getHeight() + TaxDetailsPanel.this.inner_verticalBorder);
            TaxDetailsPanel.this.editCustomerDiscounts.setSize(parent.getWidth() - 2 * TaxDetailsPanel.this.horizontalBorder, (int)TaxDetailsPanel.this.editCustomerDiscounts.getPreferredSize().getHeight());
            TaxDetailsPanel.this.editCustomerTaxRates.setLocation(TaxDetailsPanel.this.horizontalBorder, TaxDetailsPanel.this.editCustomerDiscounts.getY() + TaxDetailsPanel.this.editCustomerDiscounts.getHeight() + TaxDetailsPanel.this.inner_verticalBorder);
            TaxDetailsPanel.this.editCustomerTaxRates.setSize(parent.getWidth() - 2 * TaxDetailsPanel.this.horizontalBorder, (int)TaxDetailsPanel.this.editCustomerTaxRates.getPreferredSize().getHeight());
            TaxDetailsPanel.this.discountTable.setLocation(0, TaxDetailsPanel.this.editCustomerTaxRates.getY() + TaxDetailsPanel.this.editCustomerTaxRates.getHeight() + TaxDetailsPanel.this.inner_verticalBorder);
            TaxDetailsPanel.this.discountTable.setSize(parent.getWidth(), ((TaxDetailsPanel)TaxDetailsPanel.this).discountTable.getPreferredSize().height);
            TaxDetailsPanel.this.totalDiscount.setLocation(TaxDetailsPanel.this.horizontalBorder, TaxDetailsPanel.this.discountTable.getY() + TaxDetailsPanel.this.discountTable.getHeight() + bottomOffSet);
            TaxDetailsPanel.this.totalDiscount.setSize(parent.getWidth() - 2 * TaxDetailsPanel.this.horizontalBorder, (int)TaxDetailsPanel.this.totalTaxes.getPreferredSize().getHeight());
            TaxDetailsPanel.this.taxesTable.setLocation(0, TaxDetailsPanel.this.totalDiscount.getY() + TaxDetailsPanel.this.totalDiscount.getHeight() + bottomOffSet);
            TaxDetailsPanel.this.taxesTable.setSize(parent.getWidth(), ((TaxDetailsPanel)TaxDetailsPanel.this).taxesTable.getPreferredSize().height);
            TaxDetailsPanel.this.totalTaxes.setLocation(TaxDetailsPanel.this.horizontalBorder, parent.getHeight() - buttonSkinHeight + bottomOffSet);
            TaxDetailsPanel.this.totalTaxes.setSize(parent.getWidth() - 2 * TaxDetailsPanel.this.horizontalBorder, (int)TaxDetailsPanel.this.totalTaxes.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int buttonSkinHeight = TaxDetailsPanel.this.bSkin.getImage(11).getHeight();
            int bottomOffSet = (int)(((double)buttonSkinHeight - TaxDetailsPanel.this.calculatedProductPrice.getPreferredSize().getHeight()) / 2.0);
            int border = 7;
            int h = bottomOffSet;
            h = (int)((double)h + TaxDetailsPanel.this.calculatedProductPrice.getPreferredSize().getHeight());
            h += bottomOffSet;
            h += border;
            h = (int)((double)h + TaxDetailsPanel.this.userDefinedPriceInput.getPreferredSize().getHeight());
            h += TaxDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + TaxDetailsPanel.this.editCustomerDiscounts.getPreferredSize().getHeight());
            h += TaxDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + TaxDetailsPanel.this.editCustomerTaxRates.getPreferredSize().getHeight());
            h += TaxDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + TaxDetailsPanel.this.editPriceByCustomer.getPreferredSize().getHeight());
            h += TaxDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + TaxDetailsPanel.this.discountTable.getPreferredSize().getHeight());
            h += bottomOffSet;
            h = (int)((double)h + TaxDetailsPanel.this.totalDiscount.getPreferredSize().getHeight());
            h += bottomOffSet;
            h = (int)((double)h + TaxDetailsPanel.this.taxesTable.getPreferredSize().getHeight());
            h += bottomOffSet;
            h = (int)((double)h + TaxDetailsPanel.this.totalTaxes.getPreferredSize().getHeight());
            return new Dimension(0, h += bottomOffSet);
        }
    }
}

