/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.product.details;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.ProductVariantConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.AVariantTemplateDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.FileCommitter;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.copy.CopyTemplateToolkit;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.product.ComplexProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductComponentGroupComplete;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductComponentGroupComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductAccess;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TemplateDetailsPanel
extends AVariantTemplateDetailsPanel<ProductComplete, ProductVariantLight> {
    private static final long serialVersionUID = 1L;

    public TemplateDetailsPanel(RowEditor<ProductComplete> editor, RDProvider provider) {
        super(editor, provider);
        provider.addAccessRightToUseItAnyway(ProductAccess.COPY_FROM_TEMPLATE);
    }

    @Override
    public boolean isAccessible() {
        return this.provider.isWritable(ProductAccess.COPY_FROM_TEMPLATE);
    }

    @Override
    public Converter<?, String> getVariantViewConverter() {
        return ConverterRegistry.getConverter(ProductVariantConverter.class);
    }

    @Override
    public SearchTextField2<ProductComplete> createSearchField() {
        return SearchTextField2Factory.getProductSearchField(false, new DTOProxyNode());
    }

    @Override
    public String getSearchFieldTitle() {
        return Words.TEMPLATE_PRODUCT;
    }

    @Override
    public ProductComplete reloadItem(ProductComplete item) throws ClientServerCallException {
        return (ProductComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductByReference((ProductReference)item).getValue();
    }

    @Override
    public Class<ProductComplete> getVariantMasterClass() {
        return ProductComplete.class;
    }

    @Override
    public List<ProductVariantLight> reloadVariants(List<ProductVariantLight> variants) throws ClientServerCallException {
        ArrayList<ProductVariantLight> refs = new ArrayList<ProductVariantLight>();
        refs.addAll(variants);
        List returns = ((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductVariantsByReferences(new ListWrapper(refs)).getList();
        Collections.sort(returns, (o1, o2) -> o2.compareTo(o1));
        return returns;
    }

    @Override
    public ProductComplete copyItem(ProductComplete master, ProductVariantLight variant, boolean upload, boolean copyAllVariants) throws ClientServerCallException {
        ProductComplete p = CopyTemplateToolkit.copyProduct(master, copyAllVariants ? null : variant, false);
        p.getCurrentVariant().setSalesPrice(new PriceComplete());
        return p;
    }

    @Override
    public Class<ProductVariantLight> getVariantClass() {
        return ProductVariantLight.class;
    }

    @Override
    public void initNewVariant(ProductComplete newVariant) {
        newVariant.getCurrentVariant().setName("");
        newVariant.getCurrentVariant().setState(ModificationStateE.DRAFT);
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        ArrayList<RemoteCommitter> a = new ArrayList<RemoteCommitter>();
        if (this.editor.getModel().getNode().getChildNamed(ProductComplete_.variants).getChildCount() > 0) {
            ProductVariantComplete pvl = (ProductVariantComplete)this.editor.getModel().getNode().getChildNamed(ProductComplete_.variants).getChildAt(0).getValue(ProductVariantComplete.class);
            Node img = this.editor.getModel().getNode().getChildNamed(ProductComplete_.variants).getChildAt(0).getChildNamed(ProductVariantComplete_.imageReference);
            PegasusFileComplete r = (PegasusFileComplete)img.getValue();
            if (r != null && r.getId() == null) {
                FileCommitter c = new FileCommitter(r.getLocalFile());
                c.setWriteBackAlgorithm(reference -> {
                    img.setValue((Object)reference, 0L);
                    pvl.setImageReference(reference);
                });
                a.add(c);
            }
            if (pvl instanceof ComplexProductVariantComplete) {
                Node v = this.editor.getModel().getNode().getChildNamed(ProductComplete_.variants).getChildAt(0);
                Iterator it = v.getChildNamed(new String[]{"productComponentGroups"}).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    SimpleProductComponentGroupComplete pg = (SimpleProductComponentGroupComplete)n.getValue(SimpleProductComponentGroupComplete.class);
                    Node gImg = n.getChildNamed(SimpleProductComponentGroupComplete_.image);
                    PegasusFileComplete gr = (PegasusFileComplete)gImg.getValue(PegasusFileComplete.class);
                    if (gr == null || gr.getId() != null) continue;
                    FileCommitter c = new FileCommitter(gr.getLocalFile());
                    c.setWriteBackAlgorithm(reference -> {
                        gImg.setValue((Object)reference, 0L);
                        pg.setImage(reference);
                    });
                    a.add(c);
                }
            }
        }
        return a;
    }
}

