/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.radar.view;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.modules.radar.view.RadarPanelHour;
import ch.icit.pegasus.client.gui.modules.radar.view.utils.RadarAirlineIcon;
import ch.icit.pegasus.client.gui.modules.radar.view.utils.RadarDetailsPopupInsert;
import ch.icit.pegasus.client.gui.modules.radar.view.utils.RadarFlightStateRenderer;
import ch.icit.pegasus.client.gui.modules.radar.view.utils.RadarWidgetInboundSkin;
import ch.icit.pegasus.client.gui.modules.radar.view.utils.RadarWidgetOutboundSkin;
import ch.icit.pegasus.client.gui.modules.radar.view.utils.tools.ToolListPopupInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.skins.Skin9Field;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.TimeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.File;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;

public class RadarFlightWidget
extends Button
implements Comparable<RadarFlightWidget>,
ButtonListener {
    private static final long serialVersionUID = 1L;
    public static final int RADAR_FLIGHT_WIDGET_WIDTH = 175;
    private Skin9Field skin;
    private Node<FlightLight> flight;
    private boolean isOutbound;
    private TextLabel flightNo;
    private TextLabel timeDest;
    private TextLabel aircraft;
    private RadarAirlineIcon icon;
    private RadarFlightStateRenderer state;
    private final Color backgroundOutbound = new Color(45, 45, 45);
    private final Color lineColorOutbound = new Color(215, 215, 215);
    private final Color backgroundInbound = new Color(193, 193, 193);
    private final Color lineColorInbound = new Color(0, 0, 0);
    private final Font flightNoFont = new Font("Verdana", 1, 9);
    private final Font flightTimeFont = new Font("Verdana", 0, 9);
    private final Font flightStwFont = new Font("Verdana", 0, 9);
    private final int roundness = 10;
    private RadarPanelHour hourPanel;
    private FlightLegComplete leg;
    private Timestamp flightDate;
    private boolean selected;

    public RadarFlightWidget(Node<FlightLight> flight, FlightLegComplete leg, Timestamp flightDate, String flightCode, boolean isOutbound, RadarPanelHour hourPanel) {
        super(false);
        int hour;
        Calendar cal;
        this.addButtonListener(this);
        this.flightDate = flightDate;
        this.leg = leg;
        this.hourPanel = hourPanel;
        this.flight = flight;
        this.isOutbound = isOutbound;
        this.getFader().setProgress(0.0f);
        this.setState(Button.ButtonState.STATE_NOTSELECTED);
        this.skin = this.isOutbound ? (Skin9Field)SkinRegistry.getSkin(RadarWidgetOutboundSkin.class) : (Skin9Field)SkinRegistry.getSkin(RadarWidgetInboundSkin.class);
        this.flightNo = new TextLabel();
        this.timeDest = new TextLabel();
        this.aircraft = new TextLabel();
        this.flightNo.setFont(this.flightNoFont);
        this.timeDest.setFont(this.flightTimeFont);
        this.aircraft.setFont(this.flightStwFont);
        this.icon = new RadarAirlineIcon(isOutbound);
        if (isOutbound) {
            AirportComplete a;
            this.flightNo.setText(flightCode);
            if (this.flightNo.getText().isEmpty()) {
                this.flightNo.setText(Words.NA);
            }
            cal = TimeUtil.createCalendar();
            cal.setTimeInMillis(this.flightDate.getTime());
            hour = cal.get(11);
            int minute = cal.get(12);
            String h = "" + hour;
            String m = "" + minute;
            if (h.length() == 1) {
                h = "0" + h;
            }
            if (m.length() == 1) {
                m = "0" + m;
            }
            String d = (a = leg.getArrivalAirport()) != null ? "to " + a.getCode() : Words.NA;
            this.timeDest.setText(h + ":" + m + " " + d);
            this.icon.setLineColor(this.lineColorOutbound);
            this.flightNo.setForeground(this.lineColorOutbound);
            this.timeDest.setForeground(this.lineColorOutbound);
            this.aircraft.setForeground(this.lineColorOutbound);
        } else {
            AirportComplete a;
            this.flightNo.setText(flightCode);
            if (this.flightNo.getText().isEmpty()) {
                this.flightNo.setText(Words.NA);
            }
            cal = TimeUtil.createCalendar();
            cal.setTimeInMillis(this.flightDate.getTime());
            hour = cal.get(11);
            int minute = cal.get(12);
            String h = "" + hour;
            String m = "" + minute;
            if (h.length() == 1) {
                h = "0" + h;
            }
            if (m.length() == 1) {
                m = "0" + m;
            }
            String d = (a = leg.getDepartureAirport()) != null ? "from " + a.getCode() : Words.NA;
            this.timeDest.setText(h + ":" + m + " " + d);
            this.icon.setLineColor(this.lineColorOutbound);
            this.flightNo.setForeground(this.lineColorInbound);
            this.timeDest.setForeground(this.lineColorInbound);
            this.aircraft.setForeground(this.lineColorInbound);
        }
        if (((FlightLight)flight.getValue()).getActiveStowingList() != null) {
            this.aircraft.setText(((FlightLight)flight.getValue()).getActiveStowingList().getMatriculation());
        } else {
            this.aircraft.setText(Words.NO_STW_SELECTED);
        }
        this.state = new RadarFlightStateRenderer(flight, isOutbound);
        this.setLayout(new Layout());
        final PegasusFileComplete r = ((FlightLight)flight.getValue()).getCustomer().getImageIcon();
        if (r != null) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    Node n = null;
                    File f = FileTransferUtil.download((PegasusFileComplete)r, (FileTransferListener[])new FileTransferListener[0]);
                    n = new Node();
                    n.setValue((Object)f, 0L);
                    return n;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            if (node != null && node.getValue() instanceof File && RadarFlightWidget.this.icon != null) {
                                RadarFlightWidget.this.icon.setImageFile((File)node.getValue(), (Node<FlightLight>)RadarFlightWidget.this.flight);
                            }
                        }

                        public void errorOccurred(ClientException exception) {
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            this.icon.setImageFile(null, this.flight);
        }
        this.icon.addButtonListener(this);
        this.add(this.flightNo);
        this.add(this.timeDest);
        this.add(this.aircraft);
        this.add(this.icon);
        this.add(this.state);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        this.hourPanel.removeFromList(this);
        super.kill();
        this.flightNo.kill();
        this.timeDest.kill();
        this.aircraft.kill();
        this.icon.kill();
        this.state.kill();
        this.flightNo = null;
        this.timeDest = null;
        this.aircraft = null;
        this.icon = null;
        this.state = null;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        if (this.skin != null) {
            Button.ButtonState state = Button.ButtonState.STATE_NOTSELECTED;
            if (this.hourPanel.getRadarPanel().getSelectedFlight() == this) {
                state = Button.ButtonState.STATE_SELECTED;
            }
            this.skin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), state);
        }
        this.paintChildren(g2);
    }

    public Timestamp getOperationTime() {
        return this.flightDate;
    }

    public boolean isOutbound() {
        return this.isOutbound;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    public Node<FlightLight> getNode() {
        return this.flight;
    }

    @Override
    public int compareTo(RadarFlightWidget o) {
        if (this.isOutbound) {
            return ((FlightLight)this.flight.getValue()).getStd().compareTo(((FlightLight)o.flight.getValue()).getStd());
        }
        return ((FlightLight)this.flight.getValue()).getSta().compareTo(((FlightLight)o.flight.getValue()).getSta());
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this) {
            this.hourPanel.getRadarPanel().selectFlight(this, this.hourPanel, x, y);
        } else if (source == this.icon) {
            this.showDetailsPanel(x, y);
        }
    }

    private void showDetailsPanel(int x, int y) {
        Node<FlightLight> f = this.flight;
        BatchJob<FlightLight> b = this.hourPanel.getRadarPanel().getRadarPanel().getBatchList().isBlocked(f);
        if (b != null) {
            InnerPopupFactory.showBatchJobInfo(x, y, this, null, b);
        } else {
            InnerPopUp2 popUp = null;
            popUp = InnerPopUp2.getInnerPopUp();
            DateTimeConverter ct = (DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class);
            String t = "";
            if (this.isOutbound) {
                t = ((FlightLight)this.flight.getValue()).getOutboundCode();
                t = t + " " + ct.convert((Object)((FlightLight)this.flight.getValue()).getSta(), null, new Object[0]);
            } else {
                t = ((FlightLight)this.flight.getValue()).getInboundCode();
                t = t + " " + ct.convert((Object)((FlightLight)this.flight.getValue()).getStd(), null, new Object[0]);
            }
            popUp.setAttributes(null, true, true, "Flight " + t);
            popUp.setView(new RadarDetailsPopupInsert(this.hourPanel.getRadarPanel().getRadarPanel().getMainFrame(), this.flight), this.hourPanel.getRadarPanel().getRadarPanel().getBatchList());
            popUp.showPopUpWithinScreenMiddle(950, 400, this, this);
        }
    }

    public FlightLegComplete getLeg() {
        return this.leg;
    }

    public void setSelected(boolean selected, int x, int y) {
        if (this.selected != selected) {
            this.selected = selected;
            if (selected) {
                this.showShortCuts(x, y);
            } else {
                this.hideShortCuts();
            }
        }
    }

    private void hideShortCuts() {
    }

    public void layoutButtons(Container parent, int middleX, int middleY) {
        int radius = 150;
    }

    private void doLayoutButtons(Container parent, double middleX, double middleY, double distance, double angle, Button layoutItem) {
        int nx = (int)(Math.sin(angle) * distance);
        int ny = (int)(Math.cos(angle) * distance);
        nx = (int)((double)nx - layoutItem.getPreferredSize().getWidth() / 2.0);
        ny = (int)((double)ny - layoutItem.getPreferredSize().getHeight() / 2.0);
        int lx = (int)(middleX - (double)nx);
        int ly = (int)(middleY + (double)ny);
        layoutItem.setLocation(lx, ly);
        layoutItem.setSize(layoutItem.getPreferredSize());
    }

    private void showShortCuts(int x, int y) {
        InnerPopUp2 pop = InnerPopUp2.getInnerPopUp();
        pop.setAttributes(this, false, false, "");
        pop.setView(new ToolListPopupInsert());
        pop.showPopUp(x, y, -1, -1, null, this.hourPanel.getRadarPanel().getRadarPanel(), PopupType.NORMAL);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = 7;
            h = (int)((double)h + RadarFlightWidget.this.flightNo.getPreferredSize().getHeight());
            h += 3;
            h = (int)((double)h + RadarFlightWidget.this.aircraft.getPreferredSize().getHeight());
            h += 3;
            h = (int)((double)h + RadarFlightWidget.this.state.getPreferredSize().getHeight());
            return new Dimension(175, (h -= 5) + 25);
        }

        @Override
        public void layoutContainer(Container parent) {
            int xOff = 13;
            int yOff = 13;
            int eOff = 18;
            RadarFlightWidget.this.flightNo.setLocation(xOff + 24, xOff + 7);
            RadarFlightWidget.this.flightNo.setSize(RadarFlightWidget.this.flightNo.getPreferredSize());
            RadarFlightWidget.this.timeDest.setLocation(RadarFlightWidget.this.flightNo.getX() + RadarFlightWidget.this.flightNo.getWidth() + 2, yOff + 7);
            RadarFlightWidget.this.timeDest.setSize(parent.getWidth() - (RadarFlightWidget.this.timeDest.getX() + eOff), (int)RadarFlightWidget.this.timeDest.getPreferredSize().getHeight());
            RadarFlightWidget.this.aircraft.setLocation(RadarFlightWidget.this.flightNo.getX(), RadarFlightWidget.this.flightNo.getY() + RadarFlightWidget.this.flightNo.getHeight() - 5);
            RadarFlightWidget.this.aircraft.setSize(parent.getWidth() - (RadarFlightWidget.this.aircraft.getX() + eOff), (int)RadarFlightWidget.this.aircraft.getPreferredSize().getHeight());
            RadarFlightWidget.this.icon.setLocation(xOff, yOff);
            RadarFlightWidget.this.icon.setSize(21, 21);
            RadarFlightWidget.this.state.setLocation(xOff + 21, RadarFlightWidget.this.aircraft.getY() + RadarFlightWidget.this.aircraft.getHeight());
            RadarFlightWidget.this.state.setSize(parent.getWidth() - (RadarFlightWidget.this.state.getX() + eOff), (int)RadarFlightWidget.this.state.getPreferredSize().getHeight());
        }
    }
}

