/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.radar.view.utils;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.List;

public class RadarHeader
extends DefaultPanel {
    private static final long serialVersionUID = 1L;
    private int[] widths;
    private Color lineColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("leg_table_line_color"));
    private Color fontColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_table_header_foreground"));
    private Font font = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_table_header_font"), LafLoader.getLafLoader().getAttribute("table_header_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
    private int headerHeight = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_header_rowheight"));

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    public void setColumnWidths(int[] widths) {
        assert (widths.length == 7);
        this.widths = widths;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        g2.setColor(Color.black);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setFont(this.font);
        int cx = 0;
        if (this.widths != null) {
            for (int i = 0; i < this.widths.length; ++i) {
                g2.setColor(this.fontColor);
                switch (i) {
                    case 0: {
                        g2.drawString(Words.HOUR, cx + 5, this.getHeight() - 3);
                        break;
                    }
                    case 1: {
                        int sw = g2.getFontMetrics().stringWidth(Words.TIME_10) + 3;
                        g2.drawString(Words.TIME_10, cx + this.widths[i] - sw, this.getHeight() - 3);
                        break;
                    }
                    case 2: {
                        int sw = g2.getFontMetrics().stringWidth(Words.TIME_20) + 3;
                        g2.drawString(Words.TIME_20, cx + this.widths[i] - sw, this.getHeight() - 3);
                        break;
                    }
                    case 3: {
                        int sw = g2.getFontMetrics().stringWidth(Words.TIME_30) + 3;
                        g2.drawString(Words.TIME_30, cx + this.widths[i] - sw, this.getHeight() - 3);
                        break;
                    }
                    case 4: {
                        int sw = g2.getFontMetrics().stringWidth(Words.TIME_40) + 3;
                        g2.drawString(Words.TIME_40, cx + this.widths[i] - sw, this.getHeight() - 3);
                        break;
                    }
                    case 5: {
                        int sw = g2.getFontMetrics().stringWidth(Words.TIME_50) + 3;
                        g2.drawString(Words.TIME_50, cx + this.widths[i] - sw, this.getHeight() - 3);
                        break;
                    }
                    case 6: {
                        int sw = g2.getFontMetrics().stringWidth(Words.TIME_60) + 3 + 15;
                        g2.drawString(Words.TIME_60, cx + this.widths[i] - sw, this.getHeight() - 3);
                    }
                }
                cx += this.widths[i];
                if (i == 6) continue;
                g2.setColor(this.lineColor);
                g2.drawLine(cx, 0, cx, this.getHeight());
            }
        }
        this.paintChildren(g2);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(0, this.headerHeight);
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }
}

