/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.reporting.insert.util;

import ch.icit.pegasus.client.converter.FlightCategoryConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.reporting.ReportingModule;
import ch.icit.pegasus.client.gui.modules.reporting.insert.flight.FlightReportInsert;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiHaulTypeSelectionComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiSelectionPanel;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.layout.simple.FilterChainLayout;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.OrderInvoiceReportConfiguration;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.TradeGoodsSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.general.IUniversal;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ReportingFilterChainTable
extends BorderedInletPanel
implements ButtonListener {
    private TitledPeriodEditor period;
    private TitledItem<SearchTextField2> customer;
    private TitledItem<SearchTextField2> supplier;
    private TitledItem<SearchTextField> number;
    private TitledItem<ComboBox> state;
    private TitledItem<ComboBox> flightCategory;
    private TitledItem<MultiSelectionPanel<MultiHaulTypeSelectionComboBox>> haulType;
    private TitledItem<SearchTextField2<AirportComplete>> deliveryAirport;
    private TitledItem<CheckBox> flights;
    private TitledItem<CheckBox> tradeGoods;
    private TitledItem<CheckBox> requisitions;
    private TitledItem<CheckBox> purchase;
    private TextButton search;
    private TextButton clear;
    private List<Component> components;
    private ReportingModule module;
    private FlightReportInsert reportInsert;
    private Node<FlightSearchConfiguration> node;

    public ReportingFilterChainTable(ReportingModule module, FlightReportInsert flightReportInsert, Node<FlightSearchConfiguration> node) {
        super(false);
        this.module = module;
        this.reportInsert = flightReportInsert;
        this.node = node;
        this.components = new ArrayList<Component>();
        this.setLayout(new Layout());
        this.period = new TitledPeriodEditor((Node<Date>)node.getChildNamed(new String[]{"dayPeriod-startDate"}), (Node<Date>)node.getChildNamed(new String[]{"dayPeriod-endDate"}), true, null);
        this.customer = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, node.getChildNamed(new String[]{"customer"})), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.supplier = new TitledItem<SearchTextField2<SupplierLight>>(SearchTextField2Factory.getSupplierSearchField(true, new DTOProxyNode()), Words.SUPPLIER, TitledItem.TitledItemOrientation.NORTH);
        this.flightCategory = new TitledItem<ComboBox>(new ComboBox(null, NodeToolkit.getAffixList(FlightCategoryComplete.class), ConverterRegistry.getConverter(FlightCategoryConverter.class), true), Words.CATEGORY, TitledItem.TitledItemOrientation.NORTH);
        this.flightCategory.getElement().addItem(Words.ALL);
        this.flightCategory.getElement().setSelectedItem(Words.ALL);
        this.deliveryAirport = new TitledItem<SearchTextField2<AirportComplete>>(SearchTextField2Factory.getAirportSearchField(true, new DTOProxyNode()), Words.DELIVERY_AIRPORT, TitledItem.TitledItemOrientation.NORTH);
        this.number = new TitledItem<SearchTextField>(new SearchTextField(), Words.FLIGHT_NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.flights = new TitledItem<CheckBox>(new CheckBox(), Words.FLIGHTS, TitledItem.TitledItemOrientation.EAST);
        this.flights.getElement().setChecked(true);
        this.tradeGoods = new TitledItem<CheckBox>(new CheckBox(), Words.TRADE_GOODS, TitledItem.TitledItemOrientation.EAST);
        this.requisitions = new TitledItem<CheckBox>(new CheckBox(), Words.REQUISITION_ORDER, TitledItem.TitledItemOrientation.EAST);
        this.purchase = new TitledItem<CheckBox>(new CheckBox(), Words.PURCHASE_ORDER, TitledItem.TitledItemOrientation.EAST);
        this.state = new TitledItem<ComboBox>(ComboBoxFactory.getFlightStateComboBoxWithoutPlanned(), "State", TitledItem.TitledItemOrientation.NORTH);
        this.state.getElement().setSelectedIndex(0);
        MultiHaulTypeSelectionComboBox haulCombo = new MultiHaulTypeSelectionComboBox(INodeCreator.getDefaultImpl().createNodes(new ArrayList(), false));
        this.haulType = new TitledItem<MultiSelectionPanel<MultiHaulTypeSelectionComboBox>>(new MultiSelectionPanel<MultiHaulTypeSelectionComboBox>(haulCombo), Words.HAUL_TYPE, TitledItem.TitledItemOrientation.NORTH);
        this.search = new TextButton(Words.SEARCH);
        this.search.addButtonListener(this);
        this.clear = new TextButton(Words.CLEAR);
        this.clear.addButtonListener(this);
        this.components.add(this.number);
        this.components.add(this.state);
        this.components.add(this.period);
        this.components.add(this.haulType);
        this.components.add(this.flightCategory);
        this.components.add(this.customer);
        this.components.add(this.deliveryAirport);
        this.components.add(this.supplier);
        this.components.add(this.flights);
        this.components.add(this.tradeGoods);
        this.components.add(this.requisitions);
        this.components.add(this.purchase);
        this.components.add(this.search);
        this.components.add(this.clear);
        for (Component component : this.components) {
            this.add(component);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.search.setEnabled(isEnabled);
        this.clear.setEnabled(isEnabled);
        this.period.setEnabled(isEnabled);
        this.customer.setEnabled(isEnabled);
        this.deliveryAirport.setEnabled(isEnabled);
        this.supplier.setEnabled(isEnabled);
        this.flightCategory.setEnabled(isEnabled);
        this.number.setEnabled(isEnabled);
        this.state.setEnabled(isEnabled);
        this.flights.setEnabled(isEnabled);
        this.requisitions.setEnabled(isEnabled);
        this.purchase.setEnabled(isEnabled);
        this.tradeGoods.setEnabled(isEnabled);
        this.haulType.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        super.kill();
        if (this.customer != null) {
            this.customer.kill();
        }
        if (this.supplier != null) {
            this.supplier.kill();
        }
        if (this.flightCategory != null) {
            this.flightCategory.kill();
        }
        if (this.number != null) {
            this.number.kill();
        }
        if (this.state != null) {
            this.state.kill();
        }
        if (this.haulType != null) {
            this.haulType.kill();
        }
        if (this.deliveryAirport != null) {
            this.deliveryAirport.kill();
        }
        if (this.search != null) {
            this.search.kill();
        }
        if (this.flights != null) {
            this.flights.kill();
        }
        if (this.requisitions != null) {
            this.requisitions.kill();
        }
        if (this.purchase != null) {
            this.purchase.kill();
        }
        if (this.tradeGoods != null) {
            this.tradeGoods.kill();
        }
        if (this.clear != null) {
            this.clear.kill();
        }
        this.deliveryAirport = null;
        this.customer = null;
        this.deliveryAirport = null;
        this.supplier = null;
        this.flightCategory = null;
        this.number = null;
        this.state = null;
        this.period = null;
        this.search = null;
        this.clear = null;
        this.flights = null;
        this.tradeGoods = null;
        this.requisitions = null;
        this.purchase = null;
        this.haulType = null;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.search) {
            List<ScreenValidationObject> r = this.period.validateContent();
            if (r != null && !r.isEmpty()) {
                InnerPopupFactory.showErrorDialog(r, "Unable to search Flights", (Component)this);
                return;
            }
            this.module.started();
            this.setEnabled(false);
            this.reportInsert.ensureAnimation("Search Flights");
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    OrderInvoiceReportConfiguration configuration;
                    SearchResultIterator sri;
                    ReportingFilterChainTable.this.node.commit();
                    ViewNode rets = new ViewNode("");
                    ArrayList<IUniversal> results = new ArrayList<IUniversal>();
                    FlightSearchConfiguration f = (FlightSearchConfiguration)ReportingFilterChainTable.this.node.getValue();
                    if (((ComboBox)ReportingFilterChainTable.this.state.getElement()).getSelectedItem() instanceof FlightStateE) {
                        f.setFlightState((FlightStateE)((ComboBox)ReportingFilterChainTable.this.state.getElement()).getSelectedItem());
                        f.setOnlyOpenFlights(Boolean.valueOf(false));
                        f.setIgnoreCancelledFlights(Boolean.valueOf(false));
                    } else if (Words.ALL.equals(((ComboBox)ReportingFilterChainTable.this.state.getElement()).getSelectedItem())) {
                        f.setFlightState(null);
                        f.setOnlyOpenFlights(Boolean.valueOf(false));
                    } else if (Words.ALL_EXCEPT_PLANNED.equals(((ComboBox)ReportingFilterChainTable.this.state.getElement()).getSelectedItem())) {
                        f.setFlightState(null);
                        f.setOnlyOpenFlights(Boolean.valueOf(true));
                        f.setIgnoreCancelledFlights(Boolean.valueOf(false));
                    } else if (Words.ALL_EXCEPT_PLANNED_AND_CANCELLED.equals(((ComboBox)ReportingFilterChainTable.this.state.getElement()).getSelectedItem())) {
                        f.setFlightState(null);
                        f.setOnlyOpenFlights(Boolean.valueOf(true));
                        f.setIgnoreCancelledFlights(Boolean.valueOf(true));
                    }
                    f.setDeliveryAirport((AirportComplete)((SearchTextField2)ReportingFilterChainTable.this.deliveryAirport.getElement()).getNode().getValue());
                    f.setDayTimePeriod(new TimestampPeriodComplete(new Timestamp(f.getDayPeriod().getStartDate().getTime()), new Timestamp(f.getDayPeriod().getEndDate().getTime())));
                    if (((CheckBox)ReportingFilterChainTable.this.flights.getElement()).isChecked()) {
                        if (((MultiSelectionPanel)ReportingFilterChainTable.this.haulType.getElement()).isActivated()) {
                            ArrayList<HaulTypeComplete> types = new ArrayList<HaulTypeComplete>();
                            Object[] oo = ((MultiSelectionPanel)ReportingFilterChainTable.this.haulType.getElement()).getSelectedObjects();
                            if (oo != null) {
                                for (Object o : ((MultiSelectionPanel)ReportingFilterChainTable.this.haulType.getElement()).getSelectedObjects()) {
                                    types.add((HaulTypeComplete)o);
                                }
                            }
                            f.setHaulTypeList(types);
                            f.setShowNullHaulTypes(Boolean.valueOf(true));
                            f.setHaulType(null);
                        } else {
                            f.setHaulTypeList(null);
                            f.setShowNullHaulTypes(Boolean.valueOf(false));
                        }
                        FlightCategoryComplete cat = null;
                        if (((ComboBox)ReportingFilterChainTable.this.flightCategory.getElement()).getSelectedItem() instanceof Node) {
                            cat = (FlightCategoryComplete)((Node)((ComboBox)ReportingFilterChainTable.this.flightCategory.getElement()).getSelectedItem()).getValue();
                        } else if (((ComboBox)ReportingFilterChainTable.this.flightCategory.getElement()).getSelectedItem() instanceof FlightCategoryComplete) {
                            cat = (FlightCategoryComplete)((ComboBox)ReportingFilterChainTable.this.flightCategory.getElement()).getSelectedItem();
                        }
                        f.setCategory(cat);
                        f.setFlightStdSta(FlightSearchConfiguration.FLIGHT_STD_STA.staStd);
                        f.setFlightNumber(((SearchTextField)ReportingFilterChainTable.this.number.getElement()).getText());
                        sri = new SearchResultIterator((ASearchConfiguration)f);
                        while (sri.hasNext()) {
                            results.add(sri.next());
                        }
                    }
                    if (((CheckBox)ReportingFilterChainTable.this.tradeGoods.getElement()).isChecked()) {
                        TradeGoodsSearchConfiguration t = new TradeGoodsSearchConfiguration();
                        try {
                            t.setNumber(Integer.valueOf(((SearchTextField)ReportingFilterChainTable.this.number.getElement()).getText()));
                        }
                        catch (NumberFormatException e) {
                            t.setNumber(null);
                            t.setName(((SearchTextField)ReportingFilterChainTable.this.number.getElement()).getText());
                        }
                        t.setCustomer((CustomerReference)f.getCustomer());
                        t.setNumResults(Integer.MAX_VALUE);
                        t.setPeriod(f.getDayPeriod());
                        sri = new SearchResultIterator((ASearchConfiguration)t);
                        while (sri.hasNext()) {
                            results.add(sri.next());
                        }
                    }
                    if (((CheckBox)ReportingFilterChainTable.this.purchase.getElement()).isChecked()) {
                        configuration = new OrderInvoiceReportConfiguration();
                        configuration.setPeriod(f.getDayPeriod());
                        configuration.setUseScheduleDeliveryDate(false);
                        configuration.setOnlyClosed(false);
                        List requisitions = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).findPurchaseOrders(configuration).getList();
                        SupplierLight supplierSearch = ReportingFilterChainTable.this.getSearchSupplier();
                        requisitions.removeIf(o1 -> supplierSearch != null && !supplierSearch.equals((Object)o1.getSupplier()));
                        results.addAll(requisitions);
                    }
                    if (((CheckBox)ReportingFilterChainTable.this.requisitions.getElement()).isChecked()) {
                        configuration = new OrderInvoiceReportConfiguration();
                        configuration.setPeriod(f.getDayPeriod());
                        configuration.setOnlyClosed(false);
                        configuration.setUseScheduleDeliveryDate(false);
                        List purchaseOrders = ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).findRequisitionOrders(configuration).getList();
                        results.addAll(purchaseOrders);
                    }
                    rets.setValue(results, 0L);
                    return rets;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            List flights = (List)node.getValue();
                            for (ADTO f : flights) {
                                ReportingFilterChainTable.this.reportInsert.getFlightTable().getElement().getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)f, false, false), 0L);
                            }
                            ReportingFilterChainTable.this.module.ended();
                            ReportingFilterChainTable.this.searchDone();
                            ReportingFilterChainTable.this.setEnabled(ReportingFilterChainTable.this.isEnabled());
                        }

                        public void errorOccurred(ClientException exception) {
                            ReportingFilterChainTable.this.reportInsert.errorOccurred(exception);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else if (source == this.clear) {
            Iterator it = this.reportInsert.getFlightTable().getElement().getModel().getNode().getFailSafeChildIterator();
            while (it.hasNext()) {
                this.reportInsert.getFlightTable().getElement().getModel().getNode().removeChild((Node)it.next(), 0L);
            }
        }
    }

    private void searchDone() {
        this.reportInsert.hideAnimation();
        this.setEnabled(true);
    }

    public SupplierLight getSearchSupplier() {
        return (SupplierLight)this.supplier.getElement().getNode().getValue();
    }

    private class Layout
    extends FilterChainLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return super.preferredLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            this.setComponents(ReportingFilterChainTable.this.components);
            super.layoutContainer(parent);
        }
    }
}

