/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.requisitionorder.manager.addrow;

import ch.icit.pegasus.client.actions.impl.PrintRequisitionOrderForDeliver;
import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextArea;
import ch.icit.pegasus.client.gui.utils.textfield.DateTimeTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.company.ExternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.TimeUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class ConfigurationDetailsPanel
extends DefaultDetailsPanel<RequisitionOrderLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<Component> halalOnly;
    private TitledItem<DateChooser> requiredDate;
    private TitledItem<ComboBox> requiredBy;
    private TitledItem<ComboBox> orderedFor;
    private TitledItem<TextField> requiredTime;
    private TitledItem<CheckBox> printRequisitionOrder;
    private boolean canPrint = true;
    private TitledItem<RDMultiLocationComboBox> locations;
    private TitledItem<CheckBox> kanbanOrder;
    private TitledItem<CheckBox> secondScannerConfig;
    private TitledItem<RDTextArea> commentField;

    public ConfigurationDetailsPanel(RowEditor<RequisitionOrderLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.CONFIGURATION);
        this.setCustomLayouter(new Layout());
        this.requiredBy = new TitledItem<ComboBox>(new ComboBox(null, null, ConverterRegistry.getConverter(CostCenterConverter.class)), Words.REQUIRED_BY_DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
        this.orderedFor = new TitledItem<ComboBox>(new ComboBox(null, null, ConverterRegistry.getConverter(CostCenterConverter.class), true), Words.ORDERED_FOR_DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
        boolean withAll = Boolean.TRUE.equals(this.viewSettings.getUseHalalOnlyOrders());
        if (editor.getModel().isAddRow()) {
            this.halalOnly = new TitledItem<ComboBox>(ComboBoxFactory.getHalal(!withAll), Words.HALAL_ORDER, TitledItem.TitledItemOrientation.NORTH);
            if (!withAll) {
                ((ComboBox)this.halalOnly.getElement()).setSelectedItem(Words.ALL);
                editor.getModel().getNode().getChildNamed(RequisitionOrderComplete_.halalOrder).setValue(null, 0L);
            } else {
                ((ComboBox)this.halalOnly.getElement()).setSelectedItem(Words.NOT_HALAL_ONLY);
                editor.getModel().getNode().getChildNamed(RequisitionOrderComplete_.halalOrder).setValue((Object)false, 0L);
            }
            ((ComboBox)this.halalOnly.getElement()).addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    if (e.getItem().equals(Words.ALL)) {
                        editor.getModel().getNode().getChildNamed(RequisitionOrderComplete_.halalOrder).setValue(null, 0L);
                    } else if (e.getItem().equals(Words.HALAL_ONLY)) {
                        editor.getModel().getNode().getChildNamed(RequisitionOrderComplete_.halalOrder).setValue((Object)true, 0L);
                    } else if (e.getItem().equals(Words.NOT_HALAL_ONLY)) {
                        editor.getModel().getNode().getChildNamed(RequisitionOrderComplete_.halalOrder).setValue((Object)false, 0L);
                    }
                }
            });
        } else {
            this.halalOnly = new TitledItem<TextLabel>(new TextLabel(), Words.HALAL_ORDER, TitledItem.TitledItemOrientation.NORTH);
        }
        this.commentField = new TitledItem<RDTextArea>(new RDTextArea(provider), Words.COMMENT, TitledItem.TitledItemOrientation.NORTH);
        this.commentField.setIgnorePrefHeight(true);
        if (editor.getModel().isAddRow()) {
            if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
                this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
            }
            this.printRequisitionOrder = new TitledItem<CheckBox>(new CheckBox(), Words.PRINT_REQUISITION_ORDER, TitledItem.TitledItemOrientation.EAST);
            SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            if (Boolean.TRUE.equals(s.getSendRequisitionOrderAfterCreation()) && !Boolean.TRUE.equals(s.getPrintRequisitionDeliveryGlobally())) {
                this.printRequisitionOrder.getElement().setChecked(true);
            }
            this.printRequisitionOrder.setProgress(1.0f);
            if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
                this.addToView(this.locations);
            }
            this.addToView(this.printRequisitionOrder);
        }
        this.requiredDate = new TitledItem<DateChooser>(new DateChooser(), Words.DELIVERY, TitledItem.TitledItemOrientation.NORTH);
        this.requiredTime = new TitledItem<DateTimeTextField>(new DateTimeTextField(null, TextFieldType.DAYTIME), Words.TIME, TitledItem.TitledItemOrientation.NORTH);
        this.requiredBy.setProgress(1.0f);
        this.requiredDate.setProgress(1.0f);
        this.requiredTime.setProgress(1.0f);
        this.addToView(this.requiredBy);
        this.addToView(this.requiredDate);
        this.addToView(this.requiredTime);
        this.addToView(this.commentField);
        this.addToView(this.orderedFor);
        this.addToView(this.halalOnly);
        if (Boolean.TRUE.equals(this.settings.getUseKanbanOrderSystem())) {
            this.addToView(this.kanbanOrder);
            this.addToView(this.secondScannerConfig);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.requiredBy);
        CheckedListAdder.addToList(focusList, this.requiredDate);
        CheckedListAdder.addToList(focusList, this.requiredTime);
        if (this.editor.getModel().isAddRow()) {
            CheckedListAdder.addToList(focusList, this.printRequisitionOrder);
            CheckedListAdder.addToList(focusList, this.locations);
        }
        CheckedListAdder.addToList(focusList, this.orderedFor);
        CheckedListAdder.addToList(focusList, this.kanbanOrder);
        CheckedListAdder.addToList(focusList, this.secondScannerConfig);
        CheckedListAdder.addToList(focusList, this.halalOnly);
        CheckedListAdder.addToList(focusList, this.commentField);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        if (node == null) {
            return;
        }
        if (this.editor.getModel().isAddRow()) {
            RequisitionOrderComplete dto = (RequisitionOrderComplete)node.getValue(RequisitionOrderComplete.class);
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        if (this.requiredBy != null && node != null) {
            this.requiredBy.getElement().setNode(node.getChildNamed(RequisitionOrderComplete_.requiredBy));
            this.requiredBy.getElement().refreshPossibleValues(NodeToolkit.getAffixList(InternalCostCenterComplete.class));
            this.orderedFor.getElement().setNode(node.getChildNamed(RequisitionOrderComplete_.orderedFor));
            this.orderedFor.getElement().refreshPossibleValues(NodeToolkit.getAffixList(ExternalCostCenterComplete.class));
            if (this.locations != null) {
                this.locations.getElement().setNode(node.getChildNamed(RequisitionOrderComplete_.eligibleLocations));
            }
            if (node.getChildNamed(RequisitionOrderComplete_.requiredOn).getValue() == null) {
                Calendar c = TimeUtil.createCalendar();
                c.setTimeInMillis(System.currentTimeMillis());
                c.add(6, 1);
                node.getChildNamed(RequisitionOrderComplete_.requiredOn).setValue((Object)new Date(c.getTimeInMillis()), 0L);
            }
            this.requiredDate.getElement().setNode(node.getChildNamed(RequisitionOrderComplete_.requiredOn));
            if (node.getChildNamed(RequisitionOrderComplete_.requiredTime).getValue() == null) {
                node.getChildNamed(RequisitionOrderComplete_.requiredTime).setValue((Object)new Time(System.currentTimeMillis()), 0L);
            }
            this.requiredTime.getElement().setNode(node.getChildNamed(RequisitionOrderComplete_.requiredTime));
            this.commentField.getElement().setNode(node.getChildNamed(RequisitionOrderComplete_.remark));
            Boolean halal = (Boolean)node.getChildNamed(RequisitionOrderComplete_.halalOrder).getValue();
            if (this.editor.getModel().isAddRow()) {
                if (halal == null) {
                    ((ComboBox)this.halalOnly.getElement()).setSelectedItem(Words.ALL);
                } else if (Boolean.TRUE.equals(halal)) {
                    ((ComboBox)this.halalOnly.getElement()).setSelectedItem(Words.HALAL_ONLY);
                } else {
                    ((ComboBox)this.halalOnly.getElement()).setSelectedItem(Words.NOT_HALAL_ONLY);
                }
            } else if (Boolean.TRUE.equals(node.getChildNamed(PurchaseOrderLight_.halalOrder).getValue())) {
                ((TextLabel)this.halalOnly.getElement()).setText(Words.HALAL_ONLY);
            } else if (Boolean.FALSE.equals(node.getChildNamed(PurchaseOrderLight_.halalOrder).getValue())) {
                ((TextLabel)this.halalOnly.getElement()).setText(Words.NOT_HALAL_ONLY);
            } else {
                ((TextLabel)this.halalOnly.getElement()).setText(Words.ALL);
            }
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.requiredDate.kill();
        this.requiredDate = null;
        this.orderedFor.kill();
        this.orderedFor = null;
        this.requiredTime.kill();
        this.requiredTime = null;
        this.requiredBy.kill();
        this.commentField.kill();
        this.commentField = null;
        this.requiredBy = null;
        this.halalOnly.kill();
        this.halalOnly = null;
        this.kanbanOrder = null;
        this.secondScannerConfig = null;
        if (this.printRequisitionOrder != null) {
            this.printRequisitionOrder.kill();
        }
        this.printRequisitionOrder = null;
        if (this.locations != null) {
            this.locations.kill();
        }
        this.locations = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.requiredDate.setEnabled(isEnabled);
        this.requiredTime.setEnabled(isEnabled);
        this.requiredBy.setEnabled(isEnabled);
        this.halalOnly.setEnabled(isEnabled);
        if (this.printRequisitionOrder != null) {
            Boolean printGlobal = this.settings.getPrintRequisitionDeliveryGlobally();
            if (Boolean.TRUE.equals(printGlobal)) {
                this.printRequisitionOrder.setEnabled(false);
            } else {
                this.printRequisitionOrder.setEnabled(isEnabled);
            }
        }
        if (this.locations != null) {
            this.locations.setEnabled(isEnabled);
        }
        this.commentField.setEnabled(isEnabled);
        this.orderedFor.setEnabled(isEnabled);
    }

    @Override
    public boolean grabsFocus() {
        return true;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.canPrint && this.printRequisitionOrder != null && this.printRequisitionOrder.getElement().isChecked() && !this.editor.getModel().hasActionType(PrintRequisitionOrderForDeliver.class)) {
            this.editor.getModel().addClientAction(new PrintRequisitionOrderForDeliver());
        }
        if (this.locations != null && this.locations.getElement().isWritable() && this.locations.getElement().getNode().getChildCount() < 1) {
            this.locations.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_EXCALTY_ONE_LOCATION_IS_SET));
        }
        Date requiredDate = (Date)this.editor.getModel().getNode().getChildNamed(RequisitionOrderComplete_.requiredOn).getValue();
        Time requiredTime = (Time)this.editor.getModel().getNode().getChildNamed(RequisitionOrderComplete_.requiredTime).getValue();
        Timestamp required = DateUtil.getTimestamp((java.util.Date)requiredDate, (Time)requiredTime);
        Timestamp placedDate = (Timestamp)this.editor.getModel().getNode().getChildNamed(RequisitionOrderComplete_.placeDate).getValue();
        if (placedDate == null) {
            placedDate = new Timestamp(System.currentTimeMillis());
        }
        if (required.getTime() < placedDate.getTime()) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure required date is after placed date"));
        }
        return validationObjects;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.requiredDate != null) {
            this.requiredDate.requestFocusInWindowNow();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ConfigurationDetailsPanel.this.requiredBy.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.verticalBorder);
            ConfigurationDetailsPanel.this.requiredBy.setSize(200, (int)ConfigurationDetailsPanel.this.requiredBy.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.requiredDate.setLocation(ConfigurationDetailsPanel.this.requiredBy.getX() + ConfigurationDetailsPanel.this.requiredBy.getWidth() + ConfigurationDetailsPanel.this.inner_horizontalBorder, ConfigurationDetailsPanel.this.verticalBorder);
            ConfigurationDetailsPanel.this.requiredDate.setSize((int)ConfigurationDetailsPanel.this.requiredDate.getPreferredSize().getWidth(), (int)ConfigurationDetailsPanel.this.requiredDate.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.requiredTime.setLocation(ConfigurationDetailsPanel.this.requiredDate.getX() + ConfigurationDetailsPanel.this.requiredDate.getWidth() + ConfigurationDetailsPanel.this.inner_horizontalBorder, ConfigurationDetailsPanel.this.verticalBorder);
            ConfigurationDetailsPanel.this.requiredTime.setSize(60, ConfigurationDetailsPanel.this.requiredDate.getHeight());
            ConfigurationDetailsPanel.this.orderedFor.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.requiredBy.getY() + ConfigurationDetailsPanel.this.requiredBy.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.orderedFor.setSize(200, (int)ConfigurationDetailsPanel.this.orderedFor.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.halalOnly.setLocation(ConfigurationDetailsPanel.this.requiredDate.getX(), ConfigurationDetailsPanel.this.requiredDate.getY() + ConfigurationDetailsPanel.this.requiredDate.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.halalOnly.setSize(150, (int)ConfigurationDetailsPanel.this.halalOnly.getPreferredSize().getHeight());
            if (ConfigurationDetailsPanel.this.locations != null) {
                ConfigurationDetailsPanel.this.locations.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.orderedFor.getY() + ConfigurationDetailsPanel.this.orderedFor.getHeight() + ConfigurationDetailsPanel.this.verticalBorder);
                ConfigurationDetailsPanel.this.locations.setSize(ConfigurationDetailsPanel.this.locations.getPreferredSize());
                ConfigurationDetailsPanel.this.printRequisitionOrder.setLocation(ConfigurationDetailsPanel.this.locations.getX() + ConfigurationDetailsPanel.this.locations.getWidth() + ConfigurationDetailsPanel.this.inner_horizontalBorder, (int)((double)(ConfigurationDetailsPanel.this.locations.getY() + ConfigurationDetailsPanel.this.locations.getHeight()) - (ConfigurationDetailsPanel.this.printRequisitionOrder.getPreferredSize().getHeight() - 3.0)));
                ConfigurationDetailsPanel.this.printRequisitionOrder.setSize(ConfigurationDetailsPanel.this.printRequisitionOrder.getPreferredSize());
            }
            ConfigurationDetailsPanel.this.commentField.setLocation(ConfigurationDetailsPanel.this.requiredTime.getX() + ConfigurationDetailsPanel.this.requiredTime.getWidth() + ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.requiredDate.getY());
            ConfigurationDetailsPanel.this.commentField.setSize(300, parent.getHeight() - 2 * ConfigurationDetailsPanel.this.commentField.getY());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int lh = 0;
            if (ConfigurationDetailsPanel.this.locations != null) {
                lh = (int)ConfigurationDetailsPanel.this.locations.getPreferredSize().getHeight();
            }
            int height = (int)((double)ConfigurationDetailsPanel.this.verticalBorder + ConfigurationDetailsPanel.this.requiredDate.getPreferredSize().getHeight() + (double)ConfigurationDetailsPanel.this.inner_verticalBorder + ConfigurationDetailsPanel.this.orderedFor.getPreferredSize().getHeight() + (double)ConfigurationDetailsPanel.this.verticalBorder + (double)lh);
            return new Dimension(0, height += ConfigurationDetailsPanel.this.verticalBorder);
        }
    }
}

