/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.requisitionorder.manager.addrow;

import ch.icit.pegasus.client.comparators.DefaultIntegerTableRowComparator;
import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.gui.modules.requisitionorder.manager.addrow.utils.TableRowImpl;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.OrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CreateOrderDetailsPanel
extends TableDetailsPanel<RequisitionOrderLight>
implements InnerPopUpListener2,
NodeListener {
    private static final long serialVersionUID = 1L;

    public CreateOrderDetailsPanel(RowEditor<RequisitionOrderLight> editor, RDProvider provider) {
        super(editor, provider, true);
        this.setTitleText(Words.POSITIONS);
        editor.enableSaveButton(false);
        this.setOpaque(false);
        this.addToView(this.table);
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.table != null && this.table.getModel() != null && node != null) {
            this.table.getModel().setNode(node.getChildNamed(RequisitionOrderComplete_.orderPositions));
        }
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        boolean found = false;
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            List<ScreenValidationObject> a = pp.validateInputs();
            if ((a == null || a.isEmpty()) && (Long)pp.getModel().getNode().getChildNamed(new DtoField[]{OrderPositionComplete_.quantity, StoreQuantityComplete_.amount}).getValue() != 0L) {
                found = true;
            }
            validationObjects.addAll(pp.validateInputs());
        }
        if (!found) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_AT_LEAST_ONE_POSITION_HAS_A_QUANTITY_GREATER_THAN_ZERO));
        }
        validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, Words.ALL_ARTICLE_WITH_ZERO_AMOUNT_WILL_BE_REMOVED));
        return validationObjects;
    }

    private void clearRows() {
        long currentId = System.currentTimeMillis();
        Iterator it = this.table.getModel().getNode().getFailSafeChildIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            this.table.getModel().getNode().removeChild(n, currentId);
        }
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int tw = InputComboBox.getPreferredWidth(this, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG) + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(0.0, 0.0, Words.NO_NUMBER, "", null, null, "", 45, 45, 45));
        columns.add(new TableColumnInfo(0.5, 0.0, Words.ARTICLE, "", StringConverter.class, null, "", 30, Integer.MAX_VALUE, 30));
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (Boolean.TRUE.equals(this.viewSettings.getShowArticleDepartments())) {
            columns.add(new TableColumnInfo(0.0, 0.0, Words.DELIVER_DEPARTMENT, "", null, null, "", 90, 90, 90));
        }
        columns.add(new TableColumnInfo(0.0, 0.0, Words.ORDER_AMOUNT, "", StringConverter.class, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(0.0, 0.0, Words.AVAILABLE, "", null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(0.5, 0.0, Words.RECEIVING_STORE, "", StringConverter.class, null, "", 50, 50, 50));
        tw = TableColumnInfo.getSortableColumnWidth(this.table);
        columns.add(new TableColumnInfo(0.0, 0.0, "", "", StringConverter.class, null, "", tw, tw, tw));
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setDontUseScrollBar(15);
        table.setRequestFocusOnAdd(true);
        table.setComparator(ComparatorRegistry.getComparator(DefaultIntegerTableRowComparator.class));
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        RequisitionOrderPositionComplete pos = new RequisitionOrderPositionComplete();
        pos.setClientOId(Long.valueOf(ADTO.getNextId()));
        pos.setSequenceNumber(Integer.valueOf(this.table.getRowCount()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)pos, true, false);
        this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
        this.editor.enableSaveButton(true);
        this.editor.revalidate();
    }

    @Override
    public void childRemoved() {
        if (this.table.getRowCount() == 0) {
            this.editor.enableSaveButton(false);
        }
        this.table.writeNumber(RequisitionOrderPositionComplete_.sequenceNumber, 0);
        this.table.updateOrder();
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl row = new TableRowImpl(model, this.provider);
        row.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return row;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.table.setEnabled(enabled);
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (xargs != null) {
            this.clearRows();
        }
    }

    private void ensureAddButton() {
        int i = this.editor.getModel().getNode().getChildNamed(RequisitionOrderComplete_.orderPositions).getChildCount();
        if (i > 0) {
            this.editor.enableSaveButton(true);
        } else {
            this.editor.enableSaveButton(false);
        }
        this.editor.validate();
    }

    public void valueChanged(Node<?> node) {
    }

    public void childAdded(Node<?> source, Node<?> child) {
        this.ensureAddButton();
    }

    public void childRemoved(Node<?> source, Node<?> child) {
        this.ensureAddButton();
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    public void allLoaded() {
        this.table.updateOrder();
    }
}

