/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.requisitionorder.manager.details;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CustomsButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderDeliveryGroupComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DeliveryGroupDetailsPanel
extends TableDetailsPanel<RequisitionOrderLight> {
    private static final long serialVersionUID = 1L;

    public DeliveryGroupDetailsPanel(RowEditor<RequisitionOrderLight> editor, RDProvider provider) {
        super(editor, provider, false);
        this.setTitleText(Words.DELIVERIES);
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(RequisitionOrderComplete_.deliveryGroups));
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        boolean foundError = false;
        for (Table2RowPanel row : this.table.getRows()) {
            TableRowImpl imps = (TableRowImpl)row;
            if (imps.validateRow()) continue;
            foundError = true;
        }
        if (foundError) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_CUSTOMS_DOCS_ID_IS_SET));
        }
        return a;
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.DATE, 160));
        columns.add(new TableColumnInfo(Words.USER, 120));
        int tw = CustomsButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(Words.DOCS, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setOverrideName(RequisitionOrderDeliveryGroupComplete_.customsDocuments);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        CustomsDocumentComplete document = new CustomsDocumentComplete();
        document.setClientOId(Long.valueOf(ADTO.getNextId()));
        this.table.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)document, true, true), 0L);
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        return new TableRowImpl(model);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel date;
        private TextLabel user;
        private CustomsButton customs;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.date = new TextLabel(m.getNode().getChildNamed(RequisitionOrderDeliveryGroupComplete_.creationDate), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.user = new TextLabel(m.getNode().getChildNamed(RequisitionOrderDeliveryGroupComplete_.creationUser), ConverterRegistry.getConverter(UserConverter.class));
            this.customs = new CustomsButton();
            this.customs.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.date);
            this.add(this.user);
            this.add(this.customs);
        }

        public boolean validateRow() {
            Iterator it = this.model.getNode().getChildNamed(RequisitionOrderDeliveryGroupComplete_.customsDocuments).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                String docId = (String)n.getChildNamed(CustomsDocumentComplete_.customsDocumentId).getValue();
                if (docId == null || docId.isEmpty()) {
                    this.customs.setInvalid();
                    return false;
                }
                try {
                    Integer integer = Integer.valueOf(docId);
                    if (integer != 0) continue;
                    this.customs.setInvalid();
                    return false;
                }
                catch (Exception exception) {
                }
            }
            return true;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean editable = DeliveryGroupDetailsPanel.this.provider.isWritable(RequisitionOrderDeliveryGroupComplete_.customsDocuments);
            editable = editable && isEnabled;
            super.setEnabled(editable);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.customs) {
                InnerPopupFactory.showCustomsDocumentsEditPopup(source, this.getModel().getNode().getChildNamed(RequisitionOrderDeliveryGroupComplete_.customsDocuments), DeliveryGroupDetailsPanel.this.provider, true, x, y, RequisitionOrderDeliveryGroupComplete_.customsDocuments.getFieldName(), Words.ASSOCIATED_DOCUMENTS);
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            return new ArrayList<Component>();
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.date.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.date.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.date.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.date.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.user.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.user.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.user.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.user.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.customs.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customs.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.customs.setSize(TableRowImpl.this.user.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container arg0) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }
}

