/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.salesperson.details;

import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.panels.ContactPanel;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.supply.SalesPersonComplete;
import ch.icit.pegasus.server.core.dtos.supply.SalesPersonComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends DefaultDetailsPanel<SalesPersonComplete> {
    private ContactPanel contactPanel;

    public SpecificationDetailsPanel(RowEditor<SalesPersonComplete> editor, RDProvider provider) {
        super(editor, provider);
        this.contactPanel = new ContactPanel(null, false, false, provider, SalesPersonComplete_.contact.getFieldName());
        this.setTitleText(Words.CONTACT);
        this.setOpaque(false);
        this.setCustomLayouter(new Layout());
        this.contactPanel.setProgress(1.0f);
        this.addToView(this.contactPanel);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.contactPanel);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.contactPanel.kill();
        this.contactPanel = null;
    }

    @Override
    public void setNode(Node<?> node) {
        if (this.editor.getModel().isAddRow()) {
            SalesPersonComplete dto = (SalesPersonComplete)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        this.contactPanel.setNode(node.getChildNamed(SalesPersonComplete_.contact));
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.contactPanel.setEnabled(isEnabled);
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            SpecificationDetailsPanel.this.contactPanel.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.contactPanel.setSize(parent.getWidth() - 2 * SpecificationDetailsPanel.this.horizontalBorder, parent.getHeight() - SpecificationDetailsPanel.this.verticalBorder * 2);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.contactPanel.getPreferredSize().getHeight());
            return new Dimension(0, h += SpecificationDetailsPanel.this.verticalBorder);
        }
    }
}

