/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.spotcheck.allergens;

import ch.icit.pegasus.client.converter.BooleanConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.PeriodDateTimeConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.spotcheck.allergens.AllergenSpotCheckModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.spotcheck.allergens.details.AllergenDetails;
import ch.icit.pegasus.client.gui.modules.spotcheck.allergens.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.AllergenSpotCheckSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.AllergenSpotCheckAccess;
import ch.icit.pegasus.server.core.dtos.search.AllergenSpotCheckSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.spotcheck.allergen.AllergenSpotCheckReviewLight;
import ch.icit.pegasus.server.core.dtos.spotcheck.allergen.AllergenSpotCheckReviewLight_;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class AllergenSpotCheckModule
extends ScreenTableView<AllergenSpotCheckReviewLight, AllergenSpotCheckSearchConfiguration.ALLERGEN_SPOT_CHECK_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_NAME = "name_filter";
    private static final String FILTER_PERIOD = "period_filter";
    private static final String FILTER_STATE = "state_filter";
    private String searchFilter;
    private TitledPeriodEditor periodSearchFilter;
    private Boolean stateFilter;

    public AllergenSpotCheckModule() {
        super(AllergenSpotCheckReviewLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public boolean isDeletable(RowModel<AllergenSpotCheckReviewLight> model) {
        return false;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return AllergenSpotCheckAccess.MODULE_ALLERGEN_SPOT_CHECK;
    }

    public AllergenSpotCheckModuleDataHandler getDataHandler() {
        return (AllergenSpotCheckModuleDataHandler)this.getTable().getModel().getDataHandler();
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", AllergenSpotCheckSearchConfiguration.ALLERGEN_SPOT_CHECK_COLUMN.NAME + "<>" + true);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.addSearchField(FILTER_NAME, Words.NAME, "");
        PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
        TitledPeriodEditor periodEditor = this.filterChain.addPeriodSelection(FILTER_PERIOD, p.getStartDate(), p.getEndDate(), Words.CREATION_DATE, true);
        periodEditor.setCheckBoxEnabled();
        periodEditor.setCheckBoxChecked(false);
        periodEditor.setCommitOnFocusLost(true);
        ComboBox validationState = new ComboBox();
        validationState.addItem(Words.ALL);
        validationState.addItem(Words.VALID);
        validationState.addItem(Words.IN_REVIEW);
        this.filterChain.addSelectionComboBox(validationState, FILTER_STATE, Words.STATE, Words.ALL);
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<AllergenSpotCheckReviewLight, AllergenSpotCheckSearchConfiguration.ALLERGEN_SPOT_CHECK_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.searchFilter = "";
            this.stateFilter = null;
            this.periodSearchFilter = null;
        } else if (name == FILTER_NAME) {
            this.searchFilter = (String)value;
        } else if (name == FILTER_PERIOD) {
            this.periodSearchFilter = (TitledPeriodEditor)value;
        } else if (name == FILTER_STATE) {
            this.stateFilter = value.equals(Words.VALID) ? Boolean.valueOf(true) : (value.equals(Words.IN_REVIEW) ? Boolean.valueOf(false) : null);
        }
        AllergenSpotCheckSearchConfiguration c = new AllergenSpotCheckSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setName(this.searchFilter);
        if (this.periodSearchFilter != null) {
            PeriodComplete p = new PeriodComplete(this.periodSearchFilter.getStartDate(), this.periodSearchFilter.getEndDate());
            c.setPeriod(p);
        }
        c.setValid(this.stateFilter);
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public SearchAlgorithm<AllergenSpotCheckReviewLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(AllergenSpotCheckSearchAlgorithm.class);
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<AllergenSpotCheckReviewLight> model) {
        AllergenSpotCheckReviewLight ab = (AllergenSpotCheckReviewLight)model.getNode().getValue();
        return model != null;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.ONE;
    }

    @Override
    protected RowEditorFactory<AllergenSpotCheckReviewLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<AllergenSpotCheckReviewLight> rowEditor = new MessageProvidedRowEditor<AllergenSpotCheckReviewLight>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            if (model.isAddRow()) {
                SpecificationDetailsPanel d1 = new SpecificationDetailsPanel((RowEditor<AllergenSpotCheckReviewLight>)rowEditor, p);
                rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
                rowEditor.addToFocusQueue(d1);
            } else {
                SpecificationDetailsPanel d1 = new SpecificationDetailsPanel((RowEditor<AllergenSpotCheckReviewLight>)rowEditor, p);
                AllergenDetails d2 = new AllergenDetails((RowEditor<AllergenSpotCheckReviewLight>)rowEditor, p);
                rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
                rowEditor.add(d2, (Object)new TableLayoutConstraint(0, 1, 1.0, 1.0));
                rowEditor.addToFocusQueue(d1);
                rowEditor.addToFocusQueue(d2);
            }
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new AllergenSpotCheckModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> info = new ArrayList<TableColumnInfo>();
        info.add(new TableColumnInfo(Words.VALID, "", (Class)BooleanConverter.class, (Enum<?>)AllergenSpotCheckSearchConfiguration.ALLERGEN_SPOT_CHECK_COLUMN.VALID, AllergenSpotCheckReviewLight_.valid, TableColumnInfo.state2WithExpandWidth, TableColumnInfo.state2WithExpandWidth, TableColumnInfo.state2WithExpandWidth));
        info.add(new TableColumnInfo(Words.NAME, "", (Class)StringConverter.class, (Enum<?>)AllergenSpotCheckSearchConfiguration.ALLERGEN_SPOT_CHECK_COLUMN.NAME, AllergenSpotCheckReviewLight_.name, 200, Integer.MAX_VALUE, 200));
        info.add(new TableColumnInfo(Words.PERIOD, "", (Class)PeriodDateTimeConverter.class, (Enum<?>)AllergenSpotCheckSearchConfiguration.ALLERGEN_SPOT_CHECK_COLUMN.PERIOD, AllergenSpotCheckReviewLight_.timestampPeriod, TableColumnInfo.dateTimeColumnWidth * 2));
        info.add(new TableColumnInfo(Words.COUNT, "", (Class)IntegerConverter.class, null, AllergenSpotCheckReviewLight_.numberOfEntries, TableColumnInfo.dateColumnWidth));
        info.add(new TableColumnInfo(Words.CREATION_DATE, "", (Class)DateConverter.class, (Enum<?>)AllergenSpotCheckSearchConfiguration.ALLERGEN_SPOT_CHECK_COLUMN.CREATION_DATE, AllergenSpotCheckReviewLight_.creationDate, TableColumnInfo.dateColumnWidth));
        info.add(new TableColumnInfo(Words.REVIEW_DATE, "", (Class)DateConverter.class, (Enum<?>)AllergenSpotCheckSearchConfiguration.ALLERGEN_SPOT_CHECK_COLUMN.REVIEW_DATE, AllergenSpotCheckReviewLight_.reviewedDate, TableColumnInfo.dateColumnWidth));
        return info;
    }
}

