/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.stowinglist.details;

import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.validator.ValidationUtil;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class BaseDetailsPanel
extends StateDependantDetailsPanel<StowingListTemplateComplete> {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> no;
    private TitledItem<RDSearchTextField2> customer;
    private TitledPeriodEditor period;
    private TitledItem<RDMultiLocationComboBox> locations;
    private TitledItem<TextField> migrationCode;

    public BaseDetailsPanel(RowEditor<StowingListTemplateComplete> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        this.no = new TitledItem<TextLabel>(new TextLabel(), Words.NO_NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.no.getElement().setReadOnlyTextField(true);
        this.customer = new TitledItem<RDSearchTextField2<RDSearchTextField2>>(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.CUSTOMER), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.period = new TitledPeriodEditor(null, null, true, provider, StowingListTemplateComplete_.period);
        this.period.enableInfinity(false, true);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        this.migrationCode = new TitledItem<TextField>(new TextField(), Words.MIGRATION_CODE, TitledItem.TitledItemOrientation.NORTH);
        this.setCustomLayouter(new Layout());
        this.addToView(this.no);
        this.addToView(this.customer);
        this.addToView(this.period);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.locations);
        }
        this.addToView(this.migrationCode);
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return StowingListTemplateVariantLight_.state;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.customer.requestFocusInWindowNow();
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.customer.getElement().isWritable()) {
            if (this.editor.getModel().getNode().getChildNamed(StowingListTemplateComplete_.customer).getValue() == null) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_CUSTOMER_IS_SET));
                this.customer.getElement().setInvalid();
            } else {
                this.customer.getElement().setValid();
            }
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.locations.getElement().isWritable() && this.locations.getElement().getNode().getChildCount() < 1) {
            this.locations.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.AT_LEAST_ONE_LOCATION_MUST_BE_SET));
        }
        validationObjects.addAll(ValidationUtil.validatePeriod((Node<Date>)this.editor.getModel().getNode().getChildNamed(new DtoField[]{StowingListTemplateComplete_.period, PeriodComplete_.startDate}), (Node<Date>)this.editor.getModel().getNode().getChildNamed(new DtoField[]{StowingListTemplateComplete_.period, PeriodComplete_.endDate}), this.period));
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isDraft = this.isStateDraft();
        boolean b = isEnabled && isDraft;
        super.setEnabled(b);
        this.no.setEnabled(b);
        this.customer.setEnabled(b);
        this.period.setEnabled(b);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.setEnabled(b);
        }
        this.migrationCode.setEnabled(b);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.no.kill();
        this.customer.kill();
        this.period.kill();
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.kill();
        }
        this.migrationCode.kill();
        this.no = null;
        this.customer = null;
        this.period = null;
        this.locations = null;
        this.migrationCode = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.customer);
        CheckedListAdder.addToList(focusList, this.period);
        CheckedListAdder.addToList(focusList, this.locations);
        CheckedListAdder.addToList(focusList, this.migrationCode);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.editor.getModel().isAddRow()) {
            StowingListTemplateComplete dto = (StowingListTemplateComplete)this.editor.getModel().getNode().getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        this.customer.getElement().setNode(this.editor.getModel().getNode().getChildNamed(StowingListTemplateComplete_.customer));
        this.no.getElement().setNode(this.editor.getModel().getNode().getChildNamed(StowingListTemplateComplete_.number));
        this.period.setStartDateNode(this.editor.getModel().getNode().getChildNamed(new DtoField[]{StowingListTemplateComplete_.period, PeriodComplete_.startDate}));
        this.period.setEndDateNode(this.editor.getModel().getNode().getChildNamed(new DtoField[]{StowingListTemplateComplete_.period, PeriodComplete_.endDate}));
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.getElement().setNode(this.editor.getModel().getNode().getChildNamed(StowingListTemplateComplete_.eligibleLocations));
        }
        this.migrationCode.getElement().setNode(this.editor.getModel().getNode().getChildNamed(StowingListTemplateComplete_.migrationCode));
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = BaseDetailsPanel.this.verticalBorder;
            h = (int)((double)h + BaseDetailsPanel.this.customer.getPreferredSize().getHeight());
            h += BaseDetailsPanel.this.verticalBorder;
            h = (int)((double)h + BaseDetailsPanel.this.period.getPreferredSize().getHeight());
            h += BaseDetailsPanel.this.verticalBorder;
            if (Boolean.TRUE.equals(BaseDetailsPanel.this.viewSettings.getShowLocation())) {
                h = (int)((double)h + BaseDetailsPanel.this.locations.getPreferredSize().getHeight());
                h += BaseDetailsPanel.this.verticalBorder;
            }
            h = (int)((double)h + BaseDetailsPanel.this.migrationCode.getPreferredSize().getHeight());
            return new Dimension(0, h += BaseDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w3tl = (parent.getWidth() - 3 * BaseDetailsPanel.this.horizontalBorder) / 3;
            BaseDetailsPanel.this.no.setLocation(BaseDetailsPanel.this.horizontalBorder, BaseDetailsPanel.this.verticalBorder);
            BaseDetailsPanel.this.no.setSize(w3tl, (int)BaseDetailsPanel.this.no.getPreferredSize().getHeight());
            BaseDetailsPanel.this.customer.setLocation(BaseDetailsPanel.this.no.getX() + BaseDetailsPanel.this.no.getWidth() + BaseDetailsPanel.this.horizontalBorder, BaseDetailsPanel.this.no.getY());
            BaseDetailsPanel.this.customer.setSize(w3tl * 2, (int)BaseDetailsPanel.this.customer.getPreferredSize().getHeight());
            BaseDetailsPanel.this.period.setLocation(BaseDetailsPanel.this.horizontalBorder, BaseDetailsPanel.this.customer.getY() + BaseDetailsPanel.this.customer.getHeight() + BaseDetailsPanel.this.verticalBorder);
            BaseDetailsPanel.this.period.setSize(BaseDetailsPanel.this.period.getPreferredSize());
            int cy = BaseDetailsPanel.this.period.getY() + BaseDetailsPanel.this.period.getHeight();
            if (Boolean.TRUE.equals(BaseDetailsPanel.this.viewSettings.getShowLocation())) {
                BaseDetailsPanel.this.locations.setLocation(BaseDetailsPanel.this.horizontalBorder, BaseDetailsPanel.this.period.getY() + BaseDetailsPanel.this.period.getHeight() + BaseDetailsPanel.this.verticalBorder);
                BaseDetailsPanel.this.locations.setSize(BaseDetailsPanel.this.locations.getPreferredSize());
                cy = BaseDetailsPanel.this.locations.getY() + BaseDetailsPanel.this.locations.getHeight();
            }
            BaseDetailsPanel.this.migrationCode.setLocation(BaseDetailsPanel.this.horizontalBorder, cy + BaseDetailsPanel.this.verticalBorder);
            BaseDetailsPanel.this.migrationCode.setSize(BaseDetailsPanel.this.migrationCode.getPreferredSize());
        }
    }
}

