/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.threewaymatch.importer;

import ch.icit.pegasus.client.gui.modules.threewaymatch.importer.ExcelImporter;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.search.TWMInvoiceImportSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMInvoiceImportComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMInvoiceStateE;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.util.TimeUtil;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelToolkitException;
import java.io.File;
import java.io.FileNotFoundException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAPImporterLSGFC
extends ExcelImporter {
    public static final String SYMBOL_POSTEN_OFFEN_AUSG = "Symbol Posten offen ausg.";
    public static final String BELEGNUMMER = "Belegnummer";
    public static final String ZUORDNUNG = "Zuordnung";
    public static final String GESCHAEFTSBEREICH = "Gesch\u00e4ftsbereich";
    public static final String BELEGART = "Belegart";
    public static final String BELEGDATUM = "Belegdatum";
    public static final String BUCHUNGSSCHLUESSEL = "Buchungsschl\u00fcssel";
    public static final String BETRAG_IN_HAUSWAEHRUNG = "Betrag in Hausw\u00e4hrung";
    public static final String HAUSWAEHRUNG = "Hausw\u00e4hrung";
    public static final String STEURKENNZEICHEN = "Steuerkennzeichen";
    public static final String AUSGLEICHSBELEG = "Ausgleichsbeleg";
    public static final String TEXT = "Text";
    public static final String TEXT_ZU_PRIORITAET = "Text zur Priorit\u00e4t";
    public static final String AUSGLEICHSDATUM = "Ausgleichsdatum";
    public static final String BETRAG_IN_BELEGWAEHRUNG = "Betrag in Belegw\u00e4hrung";
    public static final String BELEGWAEHRUNG = "Belegw\u00e4hrung";
    public static final String EFF_UMRECHNUNGSKURS = "Eff. Umrechnungskurs";
    public static final String ERFASSUNGSDATUM = "Erfassungsdatum";
    public static final String HAUPTBUCHKONTO = "Hauptbuchkonto";
    public static final String KOSTENSTELLE = "Kostenstelle";
    public static final String KONTO_GEGENBUCHUNG = "Konto Gegenbuchung";
    public static final String MATERIAL = "Material";
    public static final String NETTOFAELLIG = Words.NET + "f\u00e4llig";
    public static final String NETTOFAELLIGKEIT = Words.NET + "f\u00e4lligkeit";
    public static final String REFERENZ = "Referenz";
    public static final String VALUTADATUM = "Valutadatum";
    public static final String ZAHLUNGSBEDIENUNG = "Zahlungsbedienung";
    static Logger log = LoggerFactory.getLogger(SAPImporterLSGFC.class);

    public List<TWMInvoiceImportComplete> getInvoices(File file) throws FileNotFoundException, ExcelToolkitException, InvalidFormatException {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        Timestamp importDate = new Timestamp(System.currentTimeMillis());
        List<ExcelRow> rs = this.getTableRows(file);
        ArrayList<TWMInvoiceImportComplete> invoices = new ArrayList<TWMInvoiceImportComplete>();
        HashMap<String, CurrencyComplete> currencyMap = new HashMap<String, CurrencyComplete>();
        List currencies = (List)NodeToolkit.getAffixList(CurrencyComplete.class).getValue();
        for (CurrencyComplete c : currencies) {
            currencyMap.put(c.getCode(), c);
        }
        int count = 1;
        for (ExcelRow row : rs) {
            Date docDate;
            ++count;
            if (row.getCells().get(0).equals("") && row.getCells().get(1).equals("")) continue;
            Map<String, Object> properties = this.readLine(row);
            String docNumber = this.readString(properties.get(BELEGNUMMER));
            PriceComplete price = this.readPrice(properties.get(BETRAG_IN_BELEGWAEHRUNG), properties.get(BELEGWAEHRUNG), currencyMap);
            if (price == null || price.getCurrency() == null) {
                throw new InvalidFormatException("SAP Invoice without valid currency found. Row " + count);
            }
            boolean alreadyInserted = false;
            if (docNumber != null) {
                TWMInvoiceImportSearchConfiguration sc = new TWMInvoiceImportSearchConfiguration();
                sc.setDocumentNumber(docNumber);
                try {
                    SearchResultIterator si = new SearchResultIterator((ASearchConfiguration)sc);
                    while (si.hasNext()) {
                        TWMInvoiceImportComplete next = (TWMInvoiceImportComplete)si.next();
                        if (next.getState() == TWMInvoiceStateE.CANCELLED || !next.getPrice().toString().equals(price.toString())) continue;
                        alreadyInserted = true;
                    }
                }
                catch (ServiceException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            } else {
                alreadyInserted = true;
            }
            if (Boolean.TRUE.equals(settings.getIgnoreAlreadyInvoicedSAPNumbers()) && alreadyInserted) continue;
            TWMInvoiceImportComplete invoice = new TWMInvoiceImportComplete();
            invoice.setState(TWMInvoiceStateE.NO_SUPPLIER_MATCHED);
            invoice.setClientOId(Long.valueOf(ADTO.getNextId()));
            if (alreadyInserted && !Boolean.TRUE.equals(settings.getIgnoreAlreadyInvoicedSAPNumbers())) {
                invoice.setState(TWMInvoiceStateE.CANCELLED);
            }
            if ((docDate = this.readDate(properties.get(BELEGDATUM))) == null) {
                throw new InvalidFormatException("SAP Invoice without valid Document Date found. Row " + count);
            }
            invoice.setDocumentNumber(docNumber);
            invoice.setDocumentDate(docDate);
            Date createDate = this.readDate(properties.get(ERFASSUNGSDATUM));
            Date nettoDate = this.readDate(properties.get(NETTOFAELLIGKEIT));
            invoice.setCreationDate(createDate);
            invoice.setNettoDate(nettoDate);
            String text = this.readString(properties.get(TEXT));
            String textPrio = this.readString(properties.get(TEXT_ZU_PRIORITAET));
            invoice.setName(text);
            invoice.setDescription(textPrio);
            String reference = this.readString(properties.get(REFERENZ));
            invoice.setReference(reference);
            invoice.setPrice(price);
            Double sapNo = this.readDouble(properties.get(KONTO_GEGENBUCHUNG));
            String t = null;
            if (sapNo != null) {
                t = "" + sapNo.intValue();
            }
            invoice.setSapSupplier(t);
            invoice.setImportDate(importDate);
            invoices.add(invoice);
        }
        return invoices;
    }

    private Date readDate(Object object) {
        if (object instanceof String) {
            String t = (String)object;
            if (t.isEmpty()) {
                return null;
            }
            String[] splits = ((String)object).split("\\.");
            int day = Integer.valueOf(splits[0]);
            int month = Integer.valueOf(splits[1]);
            int year = Integer.valueOf(splits[2]);
            Calendar c = TimeUtil.createCalendar();
            c.set(5, day);
            c.set(2, month);
            c.set(1, year += 2000);
            return new Date(c.getTimeInMillis());
        }
        if (object instanceof Double) {
            java.util.Date d = DateUtil.getJavaDate((double)((Double)object));
            return new Date(d.getTime());
        }
        if (object instanceof java.util.Date) {
            return new Date(((java.util.Date)object).getTime());
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        return null;
    }

    private String readString(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Double || o instanceof Float || o instanceof Integer) {
            NumberFormat format = NumberFormat.getInstance();
            format.setGroupingUsed(false);
            return format.format(o);
        }
        if (o != null) {
            return o.toString();
        }
        return "";
    }

    private Double readDouble(Object price) {
        if (price != null) {
            if (price instanceof Integer) {
                return ((Integer)price).doubleValue();
            }
            if (price instanceof Double) {
                return (Double)price;
            }
            if (price instanceof Long) {
                return ((Long)price).doubleValue();
            }
            if (price instanceof String) {
                try {
                    String p = (String)price;
                    p = p.replace(',', '.');
                    return Double.valueOf(p);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private PriceComplete readPrice(Object price, Object currency, Map<String, CurrencyComplete> currencyMap) {
        PriceComplete p = new PriceComplete();
        p.setPrice(this.readDouble(price));
        if (currency instanceof String) {
            p.setCurrency(currencyMap.get(currency));
        }
        return p;
    }

    private Map<String, Object> readLine(ExcelRow row) {
        while (row.getCells().size() < 27) {
            row.getCells().add("");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(BELEGNUMMER, row.getCells().get(0));
        map.put(BELEGDATUM, row.getCells().get(1));
        map.put(TEXT, row.getCells().get(2));
        map.put(TEXT_ZU_PRIORITAET, row.getCells().get(3));
        map.put(BETRAG_IN_BELEGWAEHRUNG, row.getCells().get(4));
        map.put(BELEGWAEHRUNG, row.getCells().get(5));
        map.put(ERFASSUNGSDATUM, row.getCells().get(6));
        map.put(KONTO_GEGENBUCHUNG, row.getCells().get(7));
        map.put(NETTOFAELLIGKEIT, row.getCells().get(8));
        map.put(REFERENZ, row.getCells().get(9));
        return map;
    }

    public void printPropertiesList(Map<String, Object> list) {
        log.debug("=========== print properties list ==========");
        for (String key : list.keySet()) {
            log.debug(key + "\t->\t" + list.get(key));
        }
        log.debug("============================================");
    }
}

